<?php
/**
* WPPIZZA_GATEWAY_MYCOD UNINSTALL
*
* @package     WPPIZZA_GATEWAY_MYCOD
* @copyright   Copyright (c) 2023, Oliver Bach
* @license     http://opensource.org/licenses/gpl-2.0.php GNU Public License
* @version     1.0
**/
if(!defined('WP_UNINSTALL_PLUGIN') ){
    exit();
}
/****************************************
*
*	$optionSuffix should be the same as the last part of the gateway class name
*	i.e. 'mycod' (lowercase) for the gateway class of WPPIZZA_GATEWAY_MYCOD
*
****************************************/
	$optionSuffix = 'mycod';


/****************************************
*
*	------ STOP EDITING -------
*
****************************************/

/*	delete settings from options table	*/
if ( is_multisite() ) {
	global $wpdb;
	$blogs = $wpdb->get_results("SELECT blog_id FROM {$wpdb->blogs}", ARRAY_A);
	if ($blogs) {
		foreach($blogs as $blog) {
			switch_to_blog($blog['blog_id']);
			delete_option('wppizza_gateway_'.strtolower($optionSuffix).'');
		}
		restore_current_blog();
	}
}else{
	delete_option('wppizza_gateway_'.strtolower($optionSuffix).'');
}
?>