/*jslint browser: true, devel: true, for:true, this:true */
/*global jQuery, window, wp, wpWidgets, tinyMCE */

/**
 * WP Editor Widget object adapted from WP Editor Widget plugin V 0.5.5
 * Author: David M&aring;rtensson, Odd Alice
 * V3.0.0
 */
jQuery(document).ready(function ($) {
"use strict"; 
 
var WpB_Editor_Widget = {
	
	/** 
	 * @var string
	 */
	currentContentId: '',
	
	/**
	 * @var string
	 */
	currentEditorPage: '',
	 
	 /**
	  * @var int
	  */
	wpFullOverlayOriginalZIndex: 0,

	init: function() {
		var me = this;
		
		$(document).on( "click", ".app-open-editor", function () {
			var id = $(this).data("id");
			me.showEditor(id);
		});
		
		$(document).on( "click", ".app-close-editor", function () {
			me.hideEditor();
		});
		
		$(document).on( "click", ".app-save-editor", function () {
			me.updateWidgetAndCloseEditor();
		});
		
		// Widgets Pro - Show subtitles
		var divs = $(document).find(".app-widget-subtitles");
		if ( divs.size() > 0 ) {
			$.each(divs, function () {
				var div = $(this);
				var subtitles = div.data("subtitles");
				var idbase = div.data("idbase");
				$.each(subtitles, function(i,v) {
					var wTitle = $("div[id$='"+idbase+i+"']").find("h3");
					wTitle.append("["+i+"] "+v);
				});
			});
		}
	},
	
	/**
	 * Show the editor
	 * @param string contentId
	 */
	showEditor: function(contentId) {
		var me = this;
		$('#app-editor-widget-backdrop').show();
		$('#app-editor-widget-container').show();
		
		me.currentContentId = contentId;
		me.currentEditorPage = ( $('body').hasClass('wp-customizer') ? 'wp-customizer':'wp-widgets');
		
		if (me.currentEditorPage === "wp-customizer") {
			me.wpFullOverlayOriginalZIndex = parseInt($('.wp-full-overlay').css('zIndex'));
			$('.wp-full-overlay').css({ zIndex: 49000 });
		}
		
		me.setEditorContent(contentId);
	},
	
	/**
	 * Hide editor
	 */
	hideEditor: function() {
		var me = this;
		$('#app-editor-widget-backdrop').hide();
		$('#app-editor-widget-container').hide();
		
		if (me.currentEditorPage === "wp-customizer") {
			$('.wp-full-overlay').css({ zIndex: me.wpFullOverlayOriginalZIndex });
		}
	},
	
	/**
	 * Set editor content
	 */
	setEditorContent: function(contentId) {
		var editor = tinyMCE.EditorManager.get('WpB_Editor_Widget');
		var content = $('#'+ contentId).val();

		if (typeof editor === "object" && editor !== null) {
			editor.setContent(content);
		}
		$('#WpB_Editor_Widget').val(content);
	},
	
	/**
	 * Update widget and close the editor
	 */
	updateWidgetAndCloseEditor: function() {
		var me = this;
		var editor = tinyMCE.EditorManager.get('WpB_Editor_Widget');
		var content = "";
		if ( editor === undefined || editor === null || editor.isHidden()) {
			content = $('#WpB_Editor_Widget').val();
		}
		else {
			content = editor.getContent();
		}

		$('#'+ this.currentContentId).val(content);
		
		// customize.php
		if (me.currentEditorPage === "wp-customizer") {
			var widget_id = $('#'+ me.currentContentId).closest('div.form').find('input.widget-id').val();
			var widget_form_control = wp.customize.Widgets.getWidgetFormControlForWidget( widget_id );
			widget_form_control.updateWidget();
		}
		
		// widgets.php
		else {
			wpWidgets.save($('#'+ me.currentContentId).closest('div.widget'), 0, 1, 0);	
		}
		
		me.hideEditor();
	}
	
};

WpB_Editor_Widget.init();

});
