<?php
/**
 * WPB Admin Display Advanced Settings
 *
 * @author		Hakan Ozevin
 * @package     WP BASE
 * @license     http://opensource.org/licenses/gpl-2.0.php GNU Public License
 * @since       2.0
 */

if ( ! defined( 'ABSPATH' ) ) exit;

if ( ! class_exists( 'WpBDisplayAdvanced' ) ) {

class WpBDisplayAdvanced{

	/**
     * WP BASE Core + Front [+Admin] instance
     */
	protected $a = null;

	/**
     * Constructor
     */
	public function __construct(){
		$this->a = BASE();
	}

	/**
     * Add admin actions
     */
	public function add_hooks() {
		add_action( 'plugins_loaded', array( $this, 'plugins_loaded' ) );
	}

	/**
     * Check if an older version of Advanced Features addon is active
     */
	public function plugins_loaded() {
		if ( ! wpb_check_advanced_features() ) {
			return;
		}

		add_filter( 'appointments_display_tabs', array( $this, 'add_tab' ), 12 ); 							// Add tab to Display Settings page
		add_action( 'app_display_advanced_features_tab', array( $this, 'display_settings' ), 12 );			// Display HTML settings
		add_action( 'app_display_dialogs_tab', array( $this, 'dialogs' ), 12 );
		add_action( 'app_save_settings', array( $this, 'save_settings' ) );
	}

	/**
	 *	Add "Advanced Features" tab
	 */
	public function add_tab( $tabs ) {
		$tabs['advanced_features']	= __('Advanced', 'wp-base');
		$tabs['dialogs']			= __('Dialogs', 'wp-base');
		return $tabs;
	}

	/**
	 * Save settings
	 */
	public function save_settings() {
		$maybe_changed = $dialog_maybe_changed = false;
		$options = wpb_setting();

		if ( 'save_payment' == $_POST['action_app'] && isset( $_POST['action_if_price_mismatch'] ) ) {
			$maybe_changed = true;
			$options['action_if_price_mismatch']	= $_POST['action_if_price_mismatch'];
		}

		if ( 'save_advanced_features' == $_POST['action_app'] ) {
			$maybe_changed = true;
			/* Which fields will be hidden */
			$temp = array();
			foreach ( wpb_conf_form_fields() as $h ) {
				if ( isset( $_POST["conf_form_hide_field_".$h] ) ) {
					$temp[] = $h;
				}
			}
			$options['conf_form_hidden_fields']		= implode( ',', $temp );
			$options['conf_form_title_position']	= $_POST['conf_form_title_position'];
			$options['conf_form_hide_cancel']		= $_POST['conf_form_hide_cancel'];
			$options['addon_fields_position']		= $_POST['addon_fields_position'];
			$options['payment_method_position']		= $_POST['payment_method_position'];
			$options['hide_effect']					= $_POST['hide_effect'];
			$options['show_effect']					= $_POST['show_effect'];
			$options['spinner']						= $_POST['spinner'];
			$options['admin_theme']					= $_POST['admin_theme'];
			$options['disable_css']					= $_POST['disable_css'];
			$options['disable_css_admin']			= $_POST['disable_css_admin'];
			$options['additional_css']				= stripslashes( trim( $_POST['additional_css'] ) );
			$options['additional_css_admin']		= stripslashes( trim( $_POST['additional_css_admin'] ) );

		} else if ( 'save_dialogs' == $_POST['action_app'] ) {
			$maybe_changed = $dialog_maybe_changed = true;

			$options['confirmation_text']			= stripslashes( $_POST['confirmation_text'] );
			$options['confirmation_title']			= stripslashes( $_POST['confirmation_title'] );
			$options['pending_text']				= stripslashes( $_POST['pending_text'] );
			$options['pending_title']				= stripslashes( $_POST['pending_title'] );

		}

		if ( $maybe_changed ) {

			if ( $dialog_maybe_changed ) {
				do_action( 'app_advanced_features_maybe_updated', 'dialogs' );
			}

			if ( $this->a->update_options( $options ) ) {
				wpb_notice( 'saved' );
			}
		}
	}

	/**
	 * Admin Advanced Display settings HTML code
	 */
	public function display_settings() {

		wpb_admin_access_check( 'manage_display_settings' );

		$effects =	array( 'blind', 'bounce', 'clip', 'drop', 'explode', 'fade', 'fold', 'highlight', 'pulsate', 'scale', 'shake', 'slide' );

	?>
	<div id="poststuff" class="metabox-holder">

		<?php do_action( 'app_advanced_features_after_info', 'advanced' ); ?>

		<form class="app-form" method="post" action="<?php echo wpb_add_query_arg( null, null ) ?>">

			<div class="postbox">
				<div class="postbox-header">
					<h3 class="hndle"><span><?php _e('Advanced Display Settings', 'wp-base') ?></span></h3>
				</div>	
				<div class="inside">
					<table class="form-table fixed">

						<tr id="conf-form-hidden-fields">
							<th scope="row" ><?php WpBConstant::echo_setting_name('conf_form_hidden_fields') ?></th>
							<td class="has-checkbox">
							<?php
							$hidden_arr = explode( ',', wpb_setting("conf_form_hidden_fields") );
							foreach ( wpb_conf_form_fields() as $h ) { ?>
								<label>
								<input type="checkbox" name="conf_form_hide_field_<?php echo $h ?>" value="true" <?php if ( in_array( $h, $hidden_arr ) ) echo "checked='checked'"?>>
								<span><?php
									echo $this->a->get_text( $h );
								?></span>
								</label>
							 <?php } ?>
							<br />
							<span class="description app-btm"><?php WpBConstant::echo_setting_desc('conf_form_hidden_fields') ?></span>
							</td>
						</tr>

						<tr>
							<th scope="row" ><?php WpBConstant::echo_setting_name('conf_form_hide_cancel') ?></th>
							<td>
							<select name="conf_form_hide_cancel">
								<option value="no"><?php _e( 'No', 'wp-base' )?></option>
								<option value="without_cart" <?php if ( wpb_setting('conf_form_hide_cancel') == 'without_cart' ) echo "selected='selected'"?>><?php _e('Only when WP BASE Shopping Cart is not active', 'wp-base')?></option>
								<option value="yes" <?php if ( wpb_setting('conf_form_hide_cancel') == 'yes' ) echo "selected='selected'"?>><?php _e('Always (Not recommended)', 'wp-base')?></option>
							</select>
							<span class="description app-btm"><?php WpBConstant::echo_setting_desc('conf_form_hide_cancel') ?></span>
							</td>
						</tr>

						<tr>
							<th scope="row" ><?php WpBConstant::echo_setting_name('conf_form_title_position') ?></th>
							<td>
							<select name="conf_form_title_position">
								<option value="same" <?php if ( wpb_setting('conf_form_title_position') != 'above' ) echo "selected='selected'"?>><?php _e('Same line as input', 'wp-base')?></option>
								<option value="above" <?php if ( wpb_setting('conf_form_title_position') == 'above' ) echo "selected='selected'"?>><?php _e('Above input', 'wp-base')?></option>
							</select>
							<span class="description app-btm"><?php WpBConstant::echo_setting_desc('conf_form_title_position') ?></span>
							</td>
						</tr>

						<tr>
							<th scope="row" ><?php WpBConstant::echo_setting_name('addon_fields_position') ?></th>
							<td>
							<select name="addon_fields_position">
								<option value="before_user_fields" <?php if ( wpb_setting('before_user_fields') == 'before_user_fields' ) echo "selected='selected'"?>><?php _e('Before user fields', 'wp-base')?></option>
								<option value="after_user_fields" <?php if ( wpb_setting('addon_fields_position') == 'after_user_fields' ) echo "selected='selected'"?>><?php _e('After user fields', 'wp-base')?></option>
								<option value="after_booking_fields" <?php if ( wpb_setting('addon_fields_position') == 'after_booking_fields' ) echo "selected='selected'"?>><?php _e('After booking fields', 'wp-base')?></option>
							</select>
							<span class="description app-btm"><?php WpBConstant::echo_setting_desc('addon_fields_position') ?></span>
							</td>
						</tr>

						<tr>
							<th scope="row" ><?php WpBConstant::echo_setting_name('payment_method_position') ?></th>
							<td>
							<select name="payment_method_position">
								<option value="after_booking_fields" <?php if ( wpb_setting('payment_method_position') == 'after_booking_fields' ) echo "selected='selected'"?>><?php _e('After booking fields', 'wp-base')?></option>
								<option value="after_user_fields" <?php if ( wpb_setting('payment_method_position') == 'after_user_fields' ) echo "selected='selected'"?>><?php _e('After user fields', 'wp-base')?></option>
								<option value="after_user_fields_full" <?php if ( wpb_setting('payment_method_position') == 'after_user_fields_full' ) echo "selected='selected'"?>><?php _e('After user fields (full row)', 'wp-base')?></option>
							</select>
							<span class="description app-btm"><?php WpBConstant::echo_setting_desc('payment_method_position') ?></span>
							</td>
						</tr>

						<tr>
							<th scope="row" ><?php WpBConstant::echo_setting_name('show_effect') ?></th>
							<td>
							<select name="show_effect">
								<option value=""><?php _e('None','wp-base') ?></option><?php
								$show_effect = wpb_setting( 'show_effect' );
								foreach ( $effects as $e ) {
									echo '<option '.selected( $e, $show_effect, false ).' value="'.$e.'">'. ucwords( $e ) .'</option>';
								} ?>
							</select>
							<span class="description app-btm"><?php WpBConstant::echo_setting_desc('show_effect') ?></span>
							</td>
						</tr>

						<tr>
							<th scope="row" ><?php WpBConstant::echo_setting_name('hide_effect') ?></th>
							<td>
								<select name="hide_effect">
									<option value=""><?php _e('None','wp-base') ?></option><?php
									$hide_effect = wpb_setting( 'hide_effect' );
									foreach ( $effects as $e ) {
										echo '<option '.selected( $e, $hide_effect, false ).' value="'.$e.'">'. ucwords( $e ) .'</option>';
									} ?>
								</select>
								<span class="description app-btm"><?php WpBConstant::echo_setting_desc('hide_effect') ?></span>
							</td>
						</tr>

						<tr>
							<th scope="row" ><?php WpBConstant::echo_setting_name('spinner') ?></th>
							<td>
							<select name="spinner">
								<option value=""><?php _e('Spiral of circles', 'wp-base')?></option>
								<option value="clock" <?php if ( wpb_setting('spinner') == 'clock' ) echo "selected='selected'"?>><?php _e('Clock', 'wp-base')?></option>
								<option value="cell" <?php if ( wpb_setting('spinner') == 'cell' ) echo "selected='selected'"?>><?php _e('Cell movement', 'wp-base')?></option>
								<option value="window" <?php if ( wpb_setting('spinner') == 'window' ) echo "selected='selected'"?>><?php _e('Glistening window', 'wp-base')?></option>
								<option value="none" <?php if ( wpb_setting('spinner') == 'none' ) echo "selected='selected'"?>><?php _e('Disable Spinner', 'wp-base')?></option>
							</select>
							<span class="description app-btm"><?php WpBConstant::echo_setting_desc('spinner') ?></span>
							</td>
						</tr>

						<tr>
							<th scope="row" ><?php WpBConstant::echo_setting_name('admin_theme') ?></th>
							<td>
								<select name="admin_theme"><?php
								foreach ( $this->a->get_themes() as $theme ) {
									$theme_name = ucfirst( str_replace( "-", " ", $theme ) );
									echo '<option '.selected(wpb_setting('admin_theme'),$theme, false).' value="'.$theme.'">'. $theme_name . '</option>';
								}
								?>
								</select>
								<span class="description app-btm"><?php WpBConstant::echo_setting_desc('admin_theme') ?></span>
							</td>
						</tr>

						<?php wpb_setting_yn( 'disable_css' ) ?>

						<tr>
							<th scope="row"><?php WpBConstant::echo_setting_name('additional_css') ?></th>
							<td>
							<textarea class="app-1 app-codemirror" name="additional_css"><?php echo esc_textarea( wpb_setting('additional_css')); ?></textarea>
							<span class="description app-btm"><?php WpBConstant::echo_setting_desc('additional_css') ?></span>
							</td>
						</tr>

						<?php wpb_setting_yn( 'disable_css_admin' ) ?>

						<tr>
							<th scope="row"><?php WpBConstant::echo_setting_name('additional_css_admin') ?></th>
							<td>
							<textarea class="app-1 app-codemirror" name="additional_css_admin"><?php echo esc_textarea( wpb_setting('additional_css_admin')); ?></textarea>
							<span class="description app-btm"><?php WpBConstant::echo_setting_desc('additional_css_admin') ?></span>
							</td>
						</tr>

					</table>
				</div>
			</div>
			<p class="submit">
				<input type="hidden" value="save_advanced_features" name="action_app" />
				<input type="submit" class="button-primary" value="<?php _e('Save Settings','wp-base'); ?>" />
			</p>
		</form>
	</div>
<?php
	}

	/**
	 * Admin Confirmation & Dialog settings HTML code
	 */
	public function dialogs() {

		wpb_admin_access_check( 'manage_display_settings' );

		$wp_editor_settings = wpb_editor_settings( __CLASS__ );
?>
	<div id="poststuff" class="metabox-holder">
	
		<?php wpb_infobox( __( 'A Dialog (popup) is opened when client makes a booking. You can configure different texts depending on whether booking is accepted as confirmed or pending.', 'wp-base' ) ); ?>

		<?php do_action( 'app_advanced_features_after_info', 'dialogs' ); ?>

		<form class="app-form" method="post" action="<?php echo wpb_add_query_arg( null, null ) ?>">
			<div class="postbox">
				<div class="postbox-header">
					<h3 class="hndle"><span><?php _e('Confirmation & Pending Dialogs', 'wp-base') ?></span></h3>
				</div>
				<div class="inside">
					<table class="form-table">

						<tr id="confirmation-dialog-title">
							<th scope="row" ><?php WpBConstant::echo_setting_name('confirmation_title') ?></th>
							<td>
								<input value="<?php echo esc_attr( wpb_setting('confirmation_title') ) ?>" class="app-1" name="confirmation_title" type="text" />
								<?php do_action( 'app_advanced_features_title', 'confirmation_title' ) ?>
								<span class="description app-btm"><?php WpBConstant::echo_setting_desc('confirmation_title') ?></span>
							</td>
						</tr>

						<tr id="confirmation-dialog-content">
							<th scope="row" ><?php WpBConstant::echo_setting_name('confirmation_text') ?></th>
							<td>
								<?php
								wp_editor( wpb_setting('confirmation_text'), 'confirmation_text', $wp_editor_settings );
								?>
								<?php do_action( 'app_advanced_features_text', 'confirmation_text' ) ?>
								<span class="description app-btm"><?php WpBConstant::echo_setting_desc('confirmation_text') ?></span>
							</td>
						</tr>

						<tr id="pending-dialog-title">
							<th scope="row" ><?php WpBConstant::echo_setting_name('pending_title') ?></th>
							<td>
								<input value="<?php echo esc_attr( wpb_setting('pending_title') ) ?>" class="app-1" name="pending_title" type="text" />
								<?php do_action( 'app_advanced_features_title', 'pending_title' ) ?>
								<span class="description app-btm"><?php WpBConstant::echo_setting_desc('pending_title') ?></span>
							</td>
						</tr>

						<tr id="pending-dialog-content">
							<th scope="row" ><?php WpBConstant::echo_setting_name('pending_text') ?></th>
							<td>
								<?php
								wp_editor( wpb_setting('pending_text'), 'pending_text', $wp_editor_settings );
								?>
								<?php do_action( 'app_advanced_features_text', 'pending_text' ) ?>
								<span class="description app-btm"><?php WpBConstant::echo_setting_desc('pending_text') ?></span>
							</td>
						</tr>

					</table>
				</div>
			</div>
			<p class="submit">
				<input type="hidden" value="save_dialogs" name="action_app" />
				<input type="submit" class="button-primary" value="<?php _e('Save Settings','wp-base'); ?>" />
			</p>
		</form>
	</div>
<?php
	}

}

	BASE('DisplayAdvanced')->add_hooks();
}