<?php

namespace CTXFeed\V5\API;

/**
 * Class RestConstants
 *
 * @package    CTXFeed
 * @subpackage CTXFeed\V5\API
 * @author     Azizul Hasan <azizulhasan.cr@gmail.com>
 * @link       https://azizulhasan.com
 * @license    https://opensource.org/licenses/gpl-license.php GNU Public License
 */
class RestConstants {

	/**
	 * Dynamic attribute rest base
	 *
	 * @since 6.1.1
	 * @var string
	 */
	const DYNAMIC_ATTRIBUTE_REST_BASE = 'dynamic_attributes';

	/**
	 * WP Option rest base
	 *
	 * @since 6.1.1
	 * @var string
	 */
	const WP_OPTION_REST_BASE = 'wp_options';

	/**
	 * Attribute Mapping rest base
	 *
	 * @since 6.1.1
	 * @var string
	 */
	const ATTRIBUTE_MAPPING_REST_BASE = 'attributes_mapping';

	/**
	 * Category Mapping rest base
	 *
	 * @since 6.1.1
	 * @var string
	 */
	const CATEGORY_MAPPING_REST_BASE = 'category_mapping';

	/**
	 * Settings rest base
	 *
	 * @since 6.1.1
	 * @var string
	 */
	const SETTINGS_REST_BASE = 'settings';

	/**
	 * Manage feeds rest base
	 *
	 * @since 6.5.0
	 * @var string
	 */
	const MANAGE_FEEDS_REST_BASE = 'manage_feeds';

}
