<?php
/** 
 * @package     VikWP - Libraries
 * @subpackage  adapter.toolbar
 * @author      E4J s.r.l.
 * @copyright   Copyright (C) 2021 E4J s.r.l. All Rights Reserved.
 * @license     http://www.gnu.org/licenses/gpl-2.0.html GNU/GPL
 * @link        https://vikwp.com
 */

// No direct access
defined('ABSPATH') or die('No script kiddies please!');

JLoader::import('adapter.toolbar.button.standard');

/**
 * Plugin link button toolbar handler.
 *
 * @since 10.0
 */
class JToolbarButtonLink extends JToolbarButtonStandard
{
	/**
	 * @override
	 * The name/type of the button.
	 *
	 * @var string
	 */
	protected $_name = 'Link';

	/**
	 * @override
	 * Method to setup the button.
	 *
	 * @param 	string 	 $icon 	 The button icon.
	 * @param 	string 	 $alt 	 The button text.
	 * @param 	string 	 $task 	 The form task to launch.
	 * @param 	boolean  $check  If true, it is mandatory the selection of the rows.
	 *
	 * @return 	void
	 */
	protected function setup($icon = '', $alt = '', $link = '', $check = false)
	{
		// do not enter task
		parent::setup($icon, $alt, '', $check);

		$this->options['action'] = "document.location.href='{$link}';";
	}
}
