<?php
/**
 * @package     VikBooking
 * @subpackage  com_vikbooking
 * @author      Alessio Gaggii - e4j - Extensionsforjoomla.com
 * @copyright   Copyright (C) 2018 e4j - Extensionsforjoomla.com. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE
 * @link        https://vikwp.com
 */

defined('ABSPATH') or die('No script kiddies please!');

/**
 * Helper Class to find the Italian province code given the city
 */
class VikBookingAgenziaEntrateComuni
{
	/**
	 * The singleton instance of the class.
	 *
	 * @var 	VikBookingAgenziaEntrateComuni
	 */
	protected static $instance = null;

	/**
	 * The map of provinces and cities
	 *
	 * @var 	array
	 */
	protected static $list;

	/**
	 * Returns the global object, either a new
	 * instance or the existing instance if
	 * the class was already instantiated.
	 *
	 * @return 	self 	A new instance of the class.
	 */
	public static function getInstance()
	{
		if (is_null(static::$instance)) {
			static::$instance = new static();
		}

		return static::$instance;
	}

	/**
	 * Returns the province for the given city (if any).
	 *
	 * @return 	string 		the name of the province or an empty string
	 */
	public static function findProvince($city)
	{
		$found = '';
		foreach (static::$list as $prov => $cities) {
			foreach ($cities as $pcity) {
				if (stripos($city, $pcity) !== false) {
					if (strlen($city) == strlen($pcity)) {
						return $prov;
					}
					$found = $prov;
				}
			}
		}

		return $found;
	}

	/**
	 * Class constructor is protected.
	 *
	 * @see 	getInstance()
	 */
	protected function __construct()
	{
		static::$list = array(
			'TO' => array(
				'AGLIE\'',
				'AIRASCA',
				'ALA DI STURA',
				'ALBIANO D\'IVREA',
				'ALICE SUPERIORE',
				'ALMESE',
				'ALPETTE',
				'ALPIGNANO',
				'ANDEZENO',
				'ANDRATE',
				'ANGROGNA',
				'ARIGNANO',
				'AVIGLIANA',
				'AZEGLIO',
				'BAIRO',
				'BALANGERO',
				'BALDISSERO CANAVESE',
				'BALDISSERO TORINESE',
				'BALME',
				'BANCHETTE',
				'BARBANIA',
				'BARDONECCHIA',
				'BARONE CANAVESE',
				'BEINASCO',
				'BIBIANA',
				'BOBBIO PELLICE',
				'BOLLENGO',
				'BORGARO TORINESE',
				'BORGIALLO',
				'BORGOFRANCO D\'IVREA',
				'BORGOMASINO',
				'BORGONE DI SUSA',
				'BOSCONERO',
				'BRANDIZZO',
				'BRICHERASIO',
				'BROSSO',
				'BROZOLO',
				'BRUINO',
				'BRUSASCO',
				'BRUZOLO',
				'BURIASCO',
				'BUROLO',
				'BUSANO',
				'BUSSOLENO',
				'BUTTIGLIERA ALTA',
				'CAFASSE',
				'CALUSO',
				'CAMBIANO',
				'CAMPIGLIONE FENILE',
				'CANDIA CANAVESE',
				'CANDIOLO',
				'CANISCHIO',
				'CANTALUPA',
				'CANTOIRA',
				'CAPRIE',
				'CARAVINO',
				'CAREMA',
				'CARIGNANO',
				'CARMAGNOLA',
				'CASALBORGONE',
				'CASCINETTE D\'IVREA',
				'CASELETTE',
				'CASELLE TORINESE',
				'CASTAGNETO PO',
				'CASTAGNOLE PIEMONTE',
				'CASTELLAMONTE',
				'CASTELNUOVO NIGRA',
				'CASTIGLIONE TORINESE',
				'CAVAGNOLO',
				'CAVOUR',
				'CERCENASCO',
				'CERES',
				'CERESOLE REALE',
				'CESANA TORINESE',
				'CHIALAMBERTO',
				'CHIANOCCO',
				'CHIAVERANO',
				'CHIERI',
				'CHIESANUOVA',
				'CHIOMONTE',
				'CHIUSA DI SAN MICHELE',
				'CHIVASSO',
				'CICONIO',
				'CINTANO',
				'CINZANO',
				'CIRIE\'',
				'CLAVIERE',
				'COASSOLO TORINESE',
				'COAZZE',
				'COLLEGNO',
				'COLLERETTO CASTELNUOVO',
				'COLLERETTO GIACOSA',
				'CONDOVE',
				'CORIO',
				'COSSANO CANAVESE',
				'CUCEGLIO',
				'CUMIANA',
				'CUORGNE\'',
				'DRUENTO',
				'EXILLES',
				'FAVRIA',
				'FELETTO',
				'FENESTRELLE',
				'FIANO',
				'FIORANO CANAVESE',
				'FOGLIZZO',
				'FORNO CANAVESE',
				'FRASSINETTO',
				'FRONT',
				'FROSSASCO',
				'GARZIGLIANA',
				'GASSINO TORINESE',
				'GERMAGNANO',
				'GIAGLIONE',
				'GIAVENO',
				'GIVOLETTO',
				'GRAVERE',
				'GROSCAVALLO',
				'GROSSO',
				'GRUGLIASCO',
				'INGRIA',
				'INVERSO PINASCA',
				'ISOLABELLA',
				'ISSIGLIO',
				'IVREA',
				'LA CASSA',
				'LA LOGGIA',
				'LANZO TORINESE',
				'LAURIANO',
				'LEINI',
				'LEMIE',
				'LESSOLO',
				'LEVONE',
				'LOCANA',
				'LOMBARDORE',
				'LOMBRIASCO',
				'LORANZE\'',
				'LUGNACCO',
				'LUSERNA SAN GIOVANNI',
				'LUSERNETTA',
				'LUSIGLIE\'',
				'MACELLO',
				'MAGLIONE',
				'MARENTINO',
				'MASSELLO',
				'MATHI',
				'MATTIE',
				'MAZZE\'',
				'MEANA DI SUSA',
				'MERCENASCO',
				'MEUGLIANO',
				'MEZZENILE',
				'MOMBELLO DI TORINO',
				'MOMPANTERO',
				'MONASTERO DI LANZO',
				'MONCALIERI',
				'MONCENISIO',
				'MONTALDO TORINESE',
				'MONTALENGHE',
				'MONTALTO DORA',
				'MONTANARO',
				'MONTEU DA PO',
				'MORIONDO TORINESE',
				'NICHELINO',
				'NOASCA',
				'NOLE',
				'NOMAGLIO',
				'NONE',
				'NOVALESA',
				'OGLIANICO',
				'ORBASSANO',
				'ORIO CANAVESE',
				'OSASCO',
				'OSASIO',
				'OULX',
				'OZEGNA',
				'PALAZZO CANAVESE',
				'PANCALIERI',
				'PARELLA',
				'PAVAROLO',
				'PAVONE CANAVESE',
				'PECCO',
				'PECETTO TORINESE',
				'PEROSA ARGENTINA',
				'PEROSA CANAVESE',
				'PERRERO',
				'PERTUSIO',
				'PESSINETTO',
				'PIANEZZA',
				'PINASCA',
				'PINEROLO',
				'PINO TORINESE',
				'PIOBESI TORINESE',
				'PIOSSASCO',
				'PISCINA',
				'PIVERONE',
				'POIRINO',
				'POMARETTO',
				'PONT CANAVESE',
				'PORTE',
				'PRAGELATO',
				'PRALI',
				'PRALORMO',
				'PRAMOLLO',
				'PRAROSTINO',
				'PRASCORSANO',
				'PRATIGLIONE',
				'QUAGLIUZZO',
				'QUASSOLO',
				'QUINCINETTO',
				'REANO',
				'RIBORDONE',
				'RIVALBA',
				'RIVALTA DI TORINO',
				'RIVA PRESSO CHIERI',
				'RIVARA',
				'RIVAROLO CANAVESE',
				'RIVAROSSA',
				'RIVOLI',
				'ROBASSOMERO',
				'ROCCA CANAVESE',
				'ROLETTO',
				'ROMANO CANAVESE',
				'RONCO CANAVESE',
				'RONDISSONE',
				'RORA\'',
				'RORETO CHISONE',
				'ROSTA',
				'RUBIANA',
				'RUEGLIO',
				'SALASSA',
				'SALBERTRAND',
				'SALERANO CANAVESE',
				'SALZA DI PINEROLO',
				'SAMONE',
				'SAN BENIGNO CANAVESE',
				'SAN CARLO CANAVESE',
				'SAN COLOMBANO BELMONTE',
				'SAN DIDERO',
				'SAN FRANCESCO AL CAMPO',
				'SANGANO',
				'SAN GERMANO CHISONE',
				'SAN GILLIO',
				'SAN GIORGIO CANAVESE',
				'SAN GIORIO DI SUSA',
				'SAN GIUSTO CANAVESE',
				'SAN MARTINO CANAVESE',
				'SAN MAURIZIO CANAVESE',
				'SAN MAURO TORINESE',
				'SAN PIETRO VAL LEMINA',
				'SAN PONSO',
				'SAN RAFFAELE CIMENA',
				'SAN SEBASTIANO DA PO',
				'SAN SECONDO DI PINEROLO',
				'SANT\'AMBROGIO DI TORINO',
				'SANT\'ANTONINO DI SUSA',
				'SANTENA',
				'SAUZE DI CESANA',
				'SAUZE D\'OULX',
				'SCALENGHE',
				'SCARMAGNO',
				'SCIOLZE',
				'SESTRIERE',
				'SETTIMO ROTTARO',
				'SETTIMO TORINESE',
				'SETTIMO VITTONE',
				'SPARONE',
				'STRAMBINELLO',
				'STRAMBINO',
				'SUSA',
				'TAVAGNASCO',
				'TORINO',
				'TORRAZZA PIEMONTE',
				'TORRE CANAVESE',
				'TORRE PELLICE',
				'TRANA',
				'TRAUSELLA',
				'TRAVERSELLA',
				'TRAVES',
				'TROFARELLO',
				'USSEAUX',
				'USSEGLIO',
				'VAIE',
				'VAL DELLA TORRE',
				'VALGIOIE',
				'VALLO TORINESE',
				'VALPERGA',
				'VALPRATO SOANA',
				'VARISELLA',
				'VAUDA CANAVESE',
				'VENAUS',
				'VENARIA REALE',
				'VEROLENGO',
				'VERRUA SAVOIA',
				'VESTIGNE\'',
				'VIALFRE\'',
				'VICO CANAVESE',
				'VIDRACCO',
				'VIGONE',
				'VILLAFRANCA PIEMONTE',
				'VILLANOVA CANAVESE',
				'VILLARBASSE',
				'VILLAR DORA',
				'VILLAREGGIA',
				'VILLAR FOCCHIARDO',
				'VILLAR PELLICE',
				'VILLAR PEROSA',
				'VILLASTELLONE',
				'VINOVO',
				'VIRLE PIEMONTE',
				'VISCHE',
				'VISTRORIO',
				'VIU\'',
				'VOLPIANO',
				'VOLVERA',
				'MAPPANO',
				'ABBADIA ALPINA',
				'AVUGLIONE E VERNONE',
				'BAIO DORA',
				'BAIRO TORRE',
				'BARATONIA',
				'BARDASSANO',
				'BEAULARD',
				'BONZO',
				'BOUSSON',
				'BOVILE',
				'BRUSASCO CAVAGNOLO',
				'BUSSOLINO GASSINESE',
				'CAMAGNA DI TORINO',
				'CAMPO CANAVESE',
				'CAVORETTO',
				'CESNOLA',
				'CHAMPLAS DU COL',
				'CHIABRANO',
				'COL SAN GIOVANNI',
				'DESERTES',
				'DRUSACCO',
				'FAETTO',
				'FAVRIA-OGLIANICO',
				'FENILE',
				'FENILS',
				'FORESTO DI SUSA',
				'FORNO ALPI GRAIE',
				'FRASSINERE',
				'GAUNA',
				'INVERSO PORTE',
				'LUSERNA',
				'MANIGLIA',
				'MARCORENGO',
				'MEANO',
				'MELEZET',
				'MENTOULLES',
				'MILLAURES',
				'MOCCHIE',
				'MOLLIERES',
				'MONASTEROLO TORINESE',
				'MONDRONE',
				'MONTESTRUTTO',
				'MURIAGLIO',
				'NOVAREGLIA',
				'TAVERNETTE',
				'PALAZZO PIVERONE',
				'PEDANEA',
				'PIAZZO',
				'PRIACCO',
				'REVIGLIASCO TORINESE',
				'RICLARETTO',
				'RIVERA',
				'ROCCAPIATTA',
				'ROCCHEMOLLES',
				'RODORETTO',
				'ROLLIERES',
				'SALE CANISCHIO',
				'SALE CASTELNUOVO',
				'SALTO',
				'SAN GILLIO TORINESE',
				'SAN GIOVANNI PELLICE',
				'SAN MARTINO DI PERRERO',
				'SAVOULX',
				'SOLOMIAC',
				'STRAMBINO ROMANO',
				'THURES',
				'TINA',
				'TRAVERSE',
				'VALCHIUSELLA',
				'VALPRATO',
				'ROURE',
			),
			'VC' => array(
				'ALAGNA VALSESIA',
				'ALBANO VERCELLESE',
				'ALICE CASTELLO',
				'ARBORIO',
				'ASIGLIANO VERCELLESE',
				'BALMUCCIA',
				'BALOCCO',
				'BIANZE\'',
				'BOCCIOLETO',
				'BORGO D\'ALE',
				'BORGOSESIA',
				'BORGO VERCELLI',
				'BREIA',
				'BURONZO',
				'CAMPERTOGNO',
				'CARCOFORO',
				'CARESANA',
				'CARESANABLOT',
				'CARISIO',
				'CASANOVA ELVO',
				'SAN GIACOMO VERCELLESE',
				'CELLIO',
				'CERVATTO',
				'CIGLIANO',
				'CIVIASCO',
				'COLLOBIANO',
				'COSTANZANA',
				'CRAVAGLIANA',
				'CRESCENTINO',
				'CROVA',
				'DESANA',
				'FOBELLO',
				'FONTANETTO PO',
				'FORMIGLIANA',
				'GATTINARA',
				'GHISLARENGO',
				'GREGGIO',
				'GUARDABOSONE',
				'LAMPORO',
				'LENTA',
				'LIGNANA',
				'LIVORNO FERRARIS',
				'LOZZOLO',
				'MOLLIA',
				'MONCRIVELLO',
				'MOTTA DEI CONTI',
				'OLCENENGO',
				'OLDENICO',
				'PALAZZOLO VERCELLESE',
				'PERTENGO',
				'PEZZANA',
				'PILA',
				'PIODE',
				'POSTUA',
				'PRAROLO',
				'QUARONA',
				'QUINTO VERCELLESE',
				'RASSA',
				'RIMA SAN GIUSEPPE',
				'RIMASCO',
				'RIMELLA',
				'RIVA VALDOBBIA',
				'RIVE',
				'ROASIO',
				'RONSECCO',
				'ROSSA',
				'ROVASENDA',
				'SABBIA',
				'SALASCO',
				'SALI VERCELLESE',
				'SALUGGIA',
				'SAN GERMANO VERCELLESE',
				'SANTHIA\'',
				'SCOPA',
				'SCOPELLO',
				'SERRAVALLE SESIA',
				'STROPPIANA',
				'TRICERRO',
				'TRINO',
				'TRONZANO VERCELLESE',
				'VALDUGGIA',
				'VARALLO',
				'VERCELLI',
				'VILLARBOIT',
				'VILLATA',
				'VOCCA',
				'AGNONA',
				'ANDORNO CACCIORNA',
				'ARANCO',
				'BORNATE',
				'CAMASCO',
				'CASCINE DI STRA',
				'CASTELLENGO',
				'CASTELLETTO VILLA',
				'CERVAROLO',
				'CHIAVAZZA',
				'COSSILA',
				'CREVOLA SESIA',
				'CROCE DI MOSSO',
				'DOCCIO',
				'FERRUTA',
				'FLECCHIA',
				'FORESTO SESIA',
				'ISOLELLA',
				'LOCARNO',
				'MORCA',
				'MORONDO',
				'PARONE',
				'PIANCERI',
				'SAN GIUSEPPE DI CASTO',
				'VALLE SUPERIORE MOSSO',
				'VALMAGGIA',
				'VINTEBBIO',
				'AILOCHE',
				'ANDORNO MICCA',
				'BENNA',
				'BIELLA',
				'BIOGLIO',
				'BORRIANA',
				'BRUSNENGO',
				'CALLABIANA',
				'CAMANDONA',
				'CAMBURZANO',
				'CAMPIGLIA CERVO',
				'CANDELO',
				'CAPRILE',
				'CASAPINTA',
				'CASTELLETTO CERVO',
				'CAVAGLIA\'',
				'CERRETO CASTELLO',
				'CERRIONE',
				'COGGIOLA',
				'COSSATO',
				'CREVACUORE',
				'CROSA',
				'CURINO',
				'DONATO',
				'DORZANO',
				'GAGLIANICO',
				'GIFFLENGA',
				'GRAGLIA',
				'LESSONA',
				'MAGNANO',
				'MASSAZZA',
				'MASSERANO',
				'MEZZANA MORTIGLIENGO',
				'MIAGLIANO',
				'MONGRANDO',
				'MOSSO SANTA MARIA',
				'MOTTALCIATA',
				'MUZZANO',
				'NETRO',
				'OCCHIEPPO INFERIORE',
				'OCCHIEPPO SUPERIORE',
				'PETTINENGO',
				'PIATTO',
				'PIEDICAVALLO',
				'PISTOLESA',
				'POLLONE',
				'PONDERANO',
				'PORTULA',
				'PRALUNGO',
				'QUAREGNA',
				'QUITTENGO',
				'RONCO BIELLESE',
				'ROPPOLO',
				'ROSAZZA',
				'SAGLIANO MICCA',
				'SALA BIELLESE',
				'SALUSSOLA',
				'SAN PAOLO CERVO',
				'SANDIGLIANO',
				'SELVE MARCONE',
				'SOPRANA',
				'SORDEVOLO',
				'SOSTEGNO',
				'STRONA',
				'TAVIGLIANO',
				'TERNENGO',
				'TOLLEGNO',
				'TORRAZZO',
				'TRIVERO',
				'VALDENGO',
				'VALLANZENGO',
				'VALLE MOSSO',
				'VALLE SAN NICOLAO',
				'VEGLIO',
				'VERRONE',
				'VIGLIANO BIELLESE',
				'VILLA DEL BOSCO',
				'VILLANOVA BIELLESE',
				'VIVERONE',
				'ZIMONE',
				'ZUBIENA',
				'ZUMAGLIA',
				'PRAY',
			),
			'NO' => array(
				'AGRATE CONTURBIA',
				'AMENO',
				'ARMENO',
				'ARONA',
				'BARENGO',
				'BELLINZAGO NOVARESE',
				'BIANDRATE',
				'BOCA',
				'BOGOGNO',
				'BOLZANO NOVARESE',
				'BORGOLAVEZZARO',
				'BORGOMANERO',
				'BORGO TICINO',
				'BRIGA NOVARESE',
				'BRIONA',
				'CALTIGNAGA',
				'CAMERI',
				'CARPIGNANO SESIA',
				'CASALBELTRAME',
				'CASALEGGIO NOVARA',
				'CASALINO',
				'CASALVOLONE',
				'CASTELLAZZO NOVARESE',
				'CASTELLETTO SOPRA TICINO',
				'CAVAGLIETTO',
				'CAVAGLIO D\'AGOGNA',
				'CAVALLIRIO',
				'CERANO',
				'COLAZZA',
				'COMIGNAGO',
				'CRESSA',
				'CUREGGIO',
				'DIVIGNANO',
				'DORMELLETTO',
				'FARA NOVARESE',
				'FONTANETO D\'AGOGNA',
				'GALLIATE',
				'GARBAGNA NOVARESE',
				'GARGALLO',
				'GATTICO',
				'GHEMME',
				'GOZZANO',
				'GRANOZZO CON MONTICELLO',
				'GRIGNASCO',
				'INVORIO',
				'LANDIONA',
				'LESA',
				'MAGGIORA',
				'MANDELLO VITTA',
				'MARANO TICINO',
				'MASSINO VISCONTI',
				'MEINA',
				'MEZZOMERICO',
				'MIASINO',
				'MOMO',
				'NEBBIUNO',
				'NIBBIOLA',
				'NOVARA',
				'OLEGGIO',
				'OLEGGIO CASTELLO',
				'ORTA SAN GIULIO',
				'PARUZZARO',
				'PELLA',
				'PETTENASCO',
				'PISANO',
				'POGNO',
				'POMBIA',
				'PRATO SESIA',
				'RECETTO',
				'ROMAGNANO SESIA',
				'ROMENTINO',
				'SAN MAURIZIO D\'OPAGLIO',
				'SAN NAZZARO SESIA',
				'SAN PIETRO MOSEZZO',
				'SILLAVENGO',
				'SIZZANO',
				'SORISO',
				'SOZZAGO',
				'SUNO',
				'TERDOBBIATE',
				'TORNACO',
				'TRECATE',
				'VAPRIO D\'AGOGNA',
				'VARALLO POMBIA',
				'VERUNO',
				'VESPOLATE',
				'VICOLUNGO',
				'VINZAGLIO',
				'AGARO',
				'AGNELLENGO',
				'AGRANO',
				'ALBOGNO',
				'ALZATE CON LINDUNO',
				'ANTRONAPIANA',
				'ANZINO',
				'ARA',
				'ARIZZANO INFERIORE',
				'ARIZZANO SUPERIORE',
				'ARTO',
				'AUZATE',
				'BEURA',
				'BIENO',
				'BOGNANCO DENTRO',
				'BOGNANCO FUORI',
				'BOLETO',
				'BORGONE D\'OSSOLA',
				'BRISINO',
				'BROVELLO',
				'MONTEBUGLIO',
				'BUGNATE',
				'BUTTOGNO',
				'CADDO',
				'CALICE OSSOLANO',
				'CALOGNA',
				'CAMPELLO MONTI',
				'CARDEZZA',
				'CARGIAGO',
				'CARPUGNINO',
				'CASALEGGIO CASTELLAZZO',
				'CASTELLI CUSIANI',
				'CASTIGLIONE D\'OSSOLA',
				'CAVAGLIO SAN DONNINO',
				'CAVANDONE',
				'CHIGNOLO VERBANO',
				'CIMAMULERA',
				'CIREGGIO',
				'CISORE',
				'COIMO',
				'COIROMONTE',
				'COMNAGO',
				'CORCIAGO',
				'CRANA',
				'CRANA CATTUGNO',
				'CRAVEGNA',
				'CRODO MOZZIO',
				'CRUSINALLO',
				'CURSOLO',
				'CUZZAGO',
				'DAGNENTE',
				'DISSIMO',
				'ESIO',
				'FINERO',
				'FOLSOGNO',
				'FOMARCO',
				'FORNERO',
				'FORNO',
				'FOSSENO',
				'GHEVIO',
				'GRAGLIA PIANA',
				'INTRA',
				'INVORIO INFERIORE',
				'INVORIO SUPERIORE',
				'ISOLA SAN GIULIO',
				'LESA-BELGIRATE',
				'LUZZOGNO',
				'MAGOGNINO',
				'MERCURAGO',
				'MIGIANDONE',
				'MONTE OSSOLANO',
				'MONTRIGIASCO',
				'MOZZIO',
				'NOCCO',
				'OLGIA',
				'ORASSO',
				'ORTA NOVARESE',
				'PALLANZA',
				'PIANE SESIA',
				'PREGLIA',
				'PREQUARTERA',
				'PRESTINONE',
				'QUARNA',
				'ROCCA PIETRA',
				'ROVEGRO',
				'RUMIANCA',
				'SALECCHIO',
				'SAMBUGHETTO',
				'SAN BARTOLOMEO VALMARA',
				'SAN CARLO D\'OSSOLA',
				'SANT\'AGATA SOPRA CANNOBIO',
				'SANTA MARIA MAGGIORE E CRANA',
				'SANTINO',
				'SCHIERANCO',
				'SOLOGNO',
				'SOVAZZA',
				'SPOCCIA',
				'STROPINO',
				'SUNA',
				'TAPIGLIANO',
				'TAPPIA',
				'TRAFFIUME',
				'TROBASO',
				'UNCHIO',
				'VAGNA',
				'VERGANO NOVARESE',
				'VEZZO',
				'VICENO',
				'VIGGIONA',
				'VOCOGNO E PRESTINONE',
				'ZORNASCO',
				'ZOVERALLO',
				'ANTRONA SCHIERANCO',
				'ANZOLA D\'OSSOLA',
				'ARIZZANO',
				'AROLA',
				'AURANO',
				'BACENO',
				'BANNIO ANZINO',
				'BAVENO',
				'BEE',
				'BELGIRATE',
				'BEURA-CARDEZZA',
				'BOGNANCO',
				'BROVELLO-CARPUGNINO',
				'CALASCA-CASTIGLIONE',
				'CAMBIASCA',
				'CANNERO RIVIERA',
				'CANNOBIO',
				'CAPREZZO',
				'CASALE CORTE CERRO',
				'CAVAGLIO-SPOCCIA',
				'CEPPO MORELLI',
				'CESARA',
				'COSSOGNO',
				'CRAVEGGIA',
				'CREVOLADOSSOLA',
				'CRODO',
				'CURSOLO-ORASSO',
				'DOMODOSSOLA',
				'DRUOGNO',
				'FALMENTA',
				'FORMAZZA',
				'GERMAGNO',
				'GHIFFA',
				'GIGNESE',
				'GRAVELLONA TOCE',
				'GURRO',
				'INTRAGNA',
				'LOREGLIA',
				'MACUGNAGA',
				'MADONNA DEL SASSO',
				'MALESCO',
				'MASERA',
				'MASSIOLA',
				'MERGOZZO',
				'MIAZZINA',
				'MONTECRESTESE',
				'MONTESCHENO',
				'NONIO',
				'OGGEBBIO',
				'OMEGNA',
				'ORNAVASSO',
				'PALLANZENO',
				'PIEDIMULERA',
				'PIEVE VERGONTE',
				'PREMENO',
				'PREMIA',
				'PREMOSELLO-CHIOVENDA',
				'QUARNA SOPRA',
				'QUARNA SOTTO',
				'RE',
				'SAN BERNARDINO VERBANO',
				'SANTA MARIA MAGGIORE',
				'SEPPIANA',
				'STRESA',
				'TOCENO',
				'TRASQUERA',
				'TRONTANO',
				'VALSTRONA',
				'VANZONE CON SAN CARLO',
				'VARZO',
				'VERBANIA',
				'VIGANELLA',
				'VIGNONE',
				'VILLADOSSOLA',
				'VILLETTE',
				'VOGOGNA',
			),
			'CN' => array(
				'ACCEGLIO',
				'AISONE',
				'ALBA',
				'ALBARETTO DELLA TORRE',
				'ALTO',
				'ARGENTERA',
				'ARGUELLO',
				'BAGNASCO',
				'BAGNOLO PIEMONTE',
				'BALDISSERO D\'ALBA',
				'BARBARESCO',
				'BARGE',
				'BAROLO',
				'BASTIA MONDOVI\'',
				'BATTIFOLLO',
				'BEINETTE',
				'BELLINO',
				'BELVEDERE LANGHE',
				'BENE VAGIENNA',
				'BENEVELLO',
				'BERGOLO',
				'BERNEZZO',
				'BONVICINO',
				'BORGOMALE',
				'BORGO SAN DALMAZZO',
				'BOSIA',
				'BOSSOLASCO',
				'BOVES',
				'BRA',
				'BRIAGLIA',
				'BRIGA ALTA',
				'BRONDELLO',
				'BROSSASCO',
				'BUSCA',
				'CAMERANA',
				'CAMO',
				'CANALE',
				'CANOSIO',
				'CAPRAUNA',
				'CARAGLIO',
				'CARAMAGNA PIEMONTE',
				'CARDE\'',
				'CARRU\'',
				'CARTIGNANO',
				'CASALGRASSO',
				'CASTAGNITO',
				'CASTELDELFINO',
				'CASTELLAR',
				'CASTELLETTO STURA',
				'CASTELLETTO UZZONE',
				'CASTELLINALDO',
				'CASTELLINO TANARO',
				'CASTELMAGNO',
				'CASTELNUOVO DI CEVA',
				'CASTIGLIONE FALLETTO',
				'CASTIGLIONE TINELLA',
				'CASTINO',
				'CAVALLERLEONE',
				'CAVALLERMAGGIORE',
				'CELLE DI MACRA',
				'CENTALLO',
				'CERESOLE ALBA',
				'CERRETTO LANGHE',
				'CERVASCA',
				'CERVERE',
				'CEVA',
				'CHERASCO',
				'CHIUSA DI PESIO',
				'CIGLIE\'',
				'CISSONE',
				'CLAVESANA',
				'CORNELIANO D\'ALBA',
				'CORTEMILIA',
				'COSSANO BELBO',
				'COSTIGLIOLE SALUZZO',
				'CRAVANZANA',
				'CRISSOLO',
				'CUNEO',
				'DEMONTE',
				'DIANO D\'ALBA',
				'DOGLIANI',
				'DRONERO',
				'ELVA',
				'ENTRACQUE',
				'ENVIE',
				'FARIGLIANO',
				'FAULE',
				'FEISOGLIO',
				'FOSSANO',
				'FRABOSA SOPRANA',
				'FRABOSA SOTTANA',
				'FRASSINO',
				'GAIOLA',
				'GAMBASCA',
				'GARESSIO',
				'GENOLA',
				'GORZEGNO',
				'GOTTASECCA',
				'GOVONE',
				'GRINZANE CAVOUR',
				'GUARENE',
				'IGLIANO',
				'ISASCA',
				'LAGNASCO',
				'LA MORRA',
				'LEQUIO BERRIA',
				'LEQUIO TANARO',
				'LESEGNO',
				'LEVICE',
				'LIMONE PIEMONTE',
				'LISIO',
				'MACRA',
				'MAGLIANO ALFIERI',
				'MAGLIANO ALPI',
				'MANGO',
				'MANTA',
				'MARENE',
				'MARGARITA',
				'MARMORA',
				'MARSAGLIA',
				'MARTINIANA PO',
				'MELLE',
				'MOIOLA',
				'MOMBARCARO',
				'MOMBASIGLIO',
				'MONASTERO DI VASCO',
				'MONASTEROLO CASOTTO',
				'MONASTEROLO DI SAVIGLIANO',
				'MONCHIERO',
				'MONDOVI\'',
				'MONESIGLIO',
				'MONFORTE D\'ALBA',
				'MONTA\'',
				'MONTALDO DI MONDOVI\'',
				'MONTALDO ROERO',
				'MONTANERA',
				'MONTELUPO ALBESE',
				'MONTEMALE DI CUNEO',
				'MONTEROSSO GRANA',
				'MONTEU ROERO',
				'MONTEZEMOLO',
				'MONTICELLO D\'ALBA',
				'MORETTA',
				'MOROZZO',
				'MURAZZANO',
				'MURELLO',
				'NARZOLE',
				'NEIVE',
				'NEVIGLIE',
				'NIELLA BELBO',
				'NIELLA TANARO',
				'NOVELLO',
				'NUCETTO',
				'ONCINO',
				'ORMEA',
				'OSTANA',
				'PAESANA',
				'PAGNO',
				'PAMPARATO',
				'PAROLDO',
				'PERLETTO',
				'PERLO',
				'PEVERAGNO',
				'PEZZOLO VALLE UZZONE',
				'PIANFEI',
				'PIASCO',
				'PIETRAPORZIO',
				'PIOBESI D\'ALBA',
				'PIOZZO',
				'POCAPAGLIA',
				'POLONGHERA',
				'PONTECHIANALE',
				'PRADLEVES',
				'PRAZZO',
				'PRIERO',
				'PRIOCCA',
				'PRIOLA',
				'PRUNETTO',
				'RACCONIGI',
				'REVELLO',
				'RIFREDDO',
				'RITTANA',
				'ROASCHIA',
				'ROASCIO',
				'ROBILANTE',
				'ROBURENT',
				'ROCCABRUNA',
				'ROCCA CIGLIE\'',
				'ROCCA DE\' BALDI',
				'ROCCAFORTE MONDOVI\'',
				'ROCCASPARVERA',
				'ROCCAVIONE',
				'ROCCHETTA BELBO',
				'RODDI',
				'RODDINO',
				'RODELLO',
				'ROSSANA',
				'RUFFIA',
				'SALE DELLE LANGHE',
				'SALE SAN GIOVANNI',
				'SALICETO',
				'SALMOUR',
				'SALUZZO',
				'SAMBUCO',
				'SAMPEYRE',
				'SAN BENEDETTO BELBO',
				'SAN DAMIANO MACRA',
				'SANFRE\'',
				'SANFRONT',
				'SAN MICHELE MONDOVI\'',
				'SANT\'ALBANO STURA',
				'SANTA VITTORIA D\'ALBA',
				'SANTO STEFANO BELBO',
				'SANTO STEFANO ROERO',
				'SAVIGLIANO',
				'SCAGNELLO',
				'SCARNAFIGI',
				'SERRALUNGA D\'ALBA',
				'SERRAVALLE LANGHE',
				'SINIO',
				'SOMANO',
				'SOMMARIVA DEL BOSCO',
				'SOMMARIVA PERNO',
				'STROPPO',
				'TARANTASCA',
				'TORRE BORMIDA',
				'TORRE MONDOVI\'',
				'TORRE SAN GIORGIO',
				'TORRESINA',
				'TREISO',
				'TREZZO TINELLA',
				'TRINITA\'',
				'VALDIERI',
				'VALGRANA',
				'VALLORIATE',
				'VALMALA',
				'VENASCA',
				'VERDUNO',
				'VERNANTE',
				'VERZUOLO',
				'VEZZA D\'ALBA',
				'VICOFORTE',
				'VIGNOLO',
				'VILLAFALLETTO',
				'VILLANOVA MONDOVI\'',
				'VILLANOVA SOLARO',
				'VILLAR SAN COSTANZO',
				'VINADIO',
				'VIOLA',
				'VOTTIGNASCO',
				'ALBARETTO VALLE DI MACRA',
				'ALMA',
				'ANDONNO',
				'BERSEZIO',
				'BRIGA MARITTIMA',
				'CASTELLETTO MONFORTE',
				'GAIOLA-MOIOLA',
				'GORRINO',
				'LOTTULO',
				'MALPOTREMO',
				'NOVELLO MONCHIERO',
				'PAGLIERES',
				'PERNO',
				'PRIERO-MONTEZEMOLO',
				'SAMBUCO PIETRAPORZIO',
				'SAN MICHELE PRAZZO',
				'SAN PIETRO DI MONTEROSSO',
				'SCALETTA UZZONE',
				'SCARNAFIGI-RUFFIA',
				'TENDA',
				'TORRE UZZONE',
				'USSOLO',
				'VILLANOVAVETTA',
				'CASTELLINALDO D\'ALBA',
			),
			'AT' => array(
				'AGLIANO TERME',
				'ALBUGNANO',
				'ANTIGNANO',
				'ARAMENGO',
				'ASTI',
				'AZZANO D\'ASTI',
				'BALDICHIERI D\'ASTI',
				'BELVEGLIO',
				'BERZANO DI SAN PIETRO',
				'BRUNO',
				'BUBBIO',
				'BUTTIGLIERA D\'ASTI',
				'CALAMANDRANA',
				'CALLIANO',
				'CALOSSO',
				'CAMERANO CASASCO',
				'CANELLI',
				'CANTARANA',
				'CAPRIGLIO',
				'CASORZO',
				'CASSINASCO',
				'CASTAGNOLE DELLE LANZE',
				'CASTAGNOLE MONFERRATO',
				'CASTEL BOGLIONE',
				'CASTELL\'ALFERO',
				'CASTELLERO',
				'CASTELLETTO MOLINA',
				'CASTELLO DI ANNONE',
				'CASTELNUOVO BELBO',
				'CASTELNUOVO CALCEA',
				'CASTELNUOVO DON BOSCO',
				'CASTEL ROCCHERO',
				'CELLARENGO',
				'CELLE ENOMONDO',
				'CERRETO D\'ASTI',
				'CERRO TANARO',
				'CESSOLE',
				'CHIUSANO D\'ASTI',
				'CINAGLIO',
				'CISTERNA D\'ASTI',
				'COAZZOLO',
				'COCCONATO',
				'COLCAVAGNO',
				'CORSIONE',
				'CORTANDONE',
				'CORTANZE',
				'CORTAZZONE',
				'CORTIGLIONE',
				'COSSOMBRATO',
				'COSTIGLIOLE D\'ASTI',
				'CUNICO',
				'DUSINO SAN MICHELE',
				'FERRERE',
				'FONTANILE',
				'FRINCO',
				'GRANA',
				'GRAZZANO BADOGLIO',
				'INCISA SCAPACCINO',
				'ISOLA D\'ASTI',
				'LOAZZOLO',
				'MARANZANA',
				'MARETTO',
				'MOASCA',
				'MOMBALDONE',
				'MOMBARUZZO',
				'MOMBERCELLI',
				'MONALE',
				'MONASTERO BORMIDA',
				'MONCALVO',
				'MONCUCCO TORINESE',
				'MONGARDINO',
				'MONTABONE',
				'MONTAFIA',
				'MONTALDO SCARAMPI',
				'MONTECHIARO D\'ASTI',
				'MONTEGROSSO D\'ASTI',
				'MONTEMAGNO',
				'MONTIGLIO',
				'MORANSENGO',
				'NIZZA MONFERRATO',
				'OLMO GENTILE',
				'PASSERANO MARMORITO',
				'PENANGO',
				'PIEA',
				'PINO D\'ASTI',
				'PIOVA\' MASSAIA',
				'PORTACOMARO',
				'QUARANTI',
				'REFRANCORE',
				'REVIGLIASCO D\'ASTI',
				'ROATTO',
				'ROBELLA',
				'ROCCA D\'ARAZZO',
				'ROCCAVERANO',
				'ROCCHETTA PALAFEA',
				'ROCCHETTA TANARO',
				'SAN DAMIANO D\'ASTI',
				'SAN GIORGIO SCARAMPI',
				'SAN MARTINO ALFIERI',
				'SAN MARZANO OLIVETO',
				'SAN PAOLO SOLBRITO',
				'SCANDELUZZA',
				'SCURZOLENGO',
				'SEROLE',
				'SESSAME',
				'SETTIME',
				'SOGLIO',
				'TIGLIOLE',
				'TONCO',
				'TONENGO',
				'VAGLIO SERRA',
				'VALFENERA',
				'VESIME',
				'VIALE D\'ASTI',
				'VIARIGI',
				'VIGLIANO D\'ASTI',
				'VILLAFRANCA D\'ASTI',
				'VILLANOVA D\'ASTI',
				'VILLA SAN SECONDO',
				'VINCHIO',
				'BAGNASCO D\'ASTI',
				'DUSINO',
				'MARMORITO',
				'PASSERANO',
				'PRIMEGLIO SCHIERANO',
				'RINCO',
				'SAN MARZANO MOASCA',
				'SAN MARZANOTTO',
				'SAN MICHELE D\'ASTI',
				'SAN PAOLO DELLA VALLE',
				'SERRAVALLE D\'ASTI',
				'SESSANT',
				'SOLBRITO',
				'VAGLIERANO',
				'VILLA CORSIONE',
				'MONTIGLIO MONFERRATO',
			),
			'AL' => array(
				'ACQUI TERME',
				'ALBERA LIGURE',
				'ALESSANDRIA',
				'ALFIANO NATTA',
				'ALICE BEL COLLE',
				'ALLUVIONI CAMBIO\'',
				'ALTAVILLA MONFERRATO',
				'ALZANO SCRIVIA',
				'ARQUATA SCRIVIA',
				'AVOLASCA',
				'BALZOLA',
				'BASALUZZO',
				'BASSIGNANA',
				'BELFORTE MONFERRATO',
				'BERGAMASCO',
				'BERZANO DI TORTONA',
				'BISTAGNO',
				'BORGHETTO DI BORBERA',
				'BORGORATTO ALESSANDRINO',
				'BORGO SAN MARTINO',
				'BOSCO MARENGO',
				'BOSIO',
				'BOZZOLE',
				'BRIGNANO-FRASCATA',
				'CABELLA LIGURE',
				'CAMAGNA MONFERRATO',
				'CAMINO',
				'CANTALUPO LIGURE',
				'CAPRIATA D\'ORBA',
				'CARBONARA SCRIVIA',
				'CARENTINO',
				'CAREZZANO',
				'CARPENETO',
				'CARREGA LIGURE',
				'CARROSIO',
				'CARTOSIO',
				'CASAL CERMELLI',
				'CASALEGGIO BOIRO',
				'CASALE MONFERRATO',
				'CASALNOCETO',
				'CASASCO',
				'CASSANO SPINOLA',
				'CASSINE',
				'CASSINELLE',
				'CASTELLANIA',
				'CASTELLAR GUIDOBONO',
				'CASTELLAZZO BORMIDA',
				'CASTELLETTO D\'ERRO',
				'CASTELLETTO D\'ORBA',
				'CASTELLETTO MERLI',
				'CASTELLETTO MONFERRATO',
				'CASTELNUOVO BORMIDA',
				'CASTELNUOVO SCRIVIA',
				'CASTELSPINA',
				'CAVATORE',
				'CELLA MONTE',
				'CERESETO',
				'CERRETO GRUE',
				'CERRINA MONFERRATO',
				'CONIOLO',
				'CONZANO',
				'COSTA VESCOVATO',
				'CREMOLINO',
				'CUCCARO MONFERRATO',
				'DENICE',
				'DERNICE',
				'FABBRICA CURONE',
				'FELIZZANO',
				'FRACONALTO',
				'FRANCAVILLA BISIO',
				'FRASCARO',
				'FRASSINELLO MONFERRATO',
				'FRASSINETO PO',
				'FRESONARA',
				'FRUGAROLO',
				'FUBINE',
				'GABIANO',
				'GAMALERO',
				'GARBAGNA',
				'GAVAZZANA',
				'GAVI',
				'GIAROLE',
				'GREMIASCO',
				'GROGNARDO',
				'GRONDONA',
				'GUAZZORA',
				'ISOLA SANT\'ANTONIO',
				'LERMA',
				'LU',
				'MALVICINO',
				'MASIO',
				'MELAZZO',
				'MERANA',
				'MIRABELLO MONFERRATO',
				'MOLARE',
				'MOLINO DEI TORTI',
				'MOMBELLO MONFERRATO',
				'MOMPERONE',
				'MONCESTINO',
				'MONGIARDINO LIGURE',
				'MONLEALE',
				'MONTACUTO',
				'MONTALDEO',
				'MONTALDO BORMIDA',
				'MONTECASTELLO',
				'MONTECHIARO D\'ACQUI',
				'MONTEGIOCO',
				'MONTEMARZINO',
				'MORANO SUL PO',
				'MORBELLO',
				'MORNESE',
				'MORSASCO',
				'MURISENGO',
				'NOVI LIGURE',
				'OCCIMIANO',
				'ODALENGO GRANDE',
				'ODALENGO PICCOLO',
				'OLIVOLA',
				'ORSARA BORMIDA',
				'OTTIGLIO',
				'OVADA',
				'OVIGLIO',
				'OZZANO MONFERRATO',
				'PADERNA',
				'PARETO',
				'PARODI LIGURE',
				'PASTURANA',
				'PECETTO DI VALENZA',
				'PIETRA MARAZZI',
				'PIOVERA',
				'POMARO MONFERRATO',
				'PONTECURONE',
				'PONTESTURA',
				'PONTI',
				'PONZANO MONFERRATO',
				'PONZONE',
				'POZZOL GROPPO',
				'POZZOLO FORMIGARO',
				'PRASCO',
				'PREDOSA',
				'QUARGNENTO',
				'QUATTORDIO',
				'RICALDONE',
				'RIVALTA BORMIDA',
				'RIVARONE',
				'ROCCAFORTE LIGURE',
				'ROCCA GRIMALDA',
				'ROCCHETTA LIGURE',
				'ROSIGNANO MONFERRATO',
				'SALA MONFERRATO',
				'SALE',
				'SAN CRISTOFORO',
				'SAN GIORGIO MONFERRATO',
				'SAN SALVATORE MONFERRATO',
				'SAN SEBASTIANO CURONE',
				'SANT\'AGATA FOSSILI',
				'SARDIGLIANO',
				'SAREZZANO',
				'SERRALUNGA DI CREA',
				'SERRAVALLE SCRIVIA',
				'SEZZADIO',
				'SILVANO D\'ORBA',
				'SOLERO',
				'SOLONGHELLO',
				'SPIGNO MONFERRATO',
				'SPINETO SCRIVIA',
				'STAZZANO',
				'STREVI',
				'TAGLIOLO MONFERRATO',
				'TASSAROLO',
				'TERRUGGIA',
				'TERZO',
				'TICINETO',
				'TORTONA',
				'TREVILLE',
				'TRISOBBIO',
				'VALENZA',
				'VALMACCA',
				'VIGNALE MONFERRATO',
				'VIGNOLE BORBERA',
				'VIGUZZOLO',
				'VILLADEATI',
				'VILLALVERNIA',
				'VILLAMIROGLIO',
				'VILLANOVA MONFERRATO',
				'VILLAROMAGNANO',
				'VISONE',
				'VOLPEDO',
				'VOLPEGLINO',
				'VOLTAGGIO',
				'BISIO',
				'BRIGNANO DEL CURONE',
				'BRUSASCHETTO',
				'CAREZZANO SUPERIORE',
				'CASTEL DE\' RATTI',
				'CASTEL SAN PIETRO MONFERRATO',
				'CASTELVERO D\'ASTI',
				'CASTIGLIONE D\'ASTI',
				'COCCONITO',
				'CORTERANZO',
				'CUQUELLO',
				'FOROTONDO',
				'FRASCATA',
				'FRASSINELLO-OLIVOLA',
				'GROPPO',
				'VILLABELLA',
				'MALVINO',
				'MOLINO ALZANO',
				'MOLO DI BORBERA',
				'MONDONIO',
				'MONTALERO',
				'MONTECHIARO DENICE',
				'PAVONE D\'ALESSANDRIA',
				'QUARTI',
				'QUARTO ASTESE',
				'ROSINGO',
				'SALABUE',
				'SORLI',
				'TAGLIOLO-BELFORTE',
				'TORRE DE\' RATTI',
				'VARENGO',
				'VARGO',
			),
			'BI' => array(
				'AILOCHE',
				'ANDORNO MICCA',
				'BENNA',
				'BIELLA',
				'BIOGLIO',
				'BORRIANA',
				'BRUSNENGO',
				'CALLABIANA',
				'CAMANDONA',
				'CAMBURZANO',
				'CAMPIGLIA CERVO',
				'CANDELO',
				'CAPRILE',
				'CASAPINTA',
				'CASTELLETTO CERVO',
				'CAVAGLIA\'',
				'CERRETO CASTELLO',
				'CERRIONE',
				'COGGIOLA',
				'COSSATO',
				'CREVACUORE',
				'CROSA',
				'CURINO',
				'DONATO',
				'DORZANO',
				'GAGLIANICO',
				'GIFFLENGA',
				'GRAGLIA',
				'LESSONA',
				'MAGNANO',
				'MASSAZZA',
				'MASSERANO',
				'MEZZANA MORTIGLIENGO',
				'MIAGLIANO',
				'MONGRANDO',
				'MOSSO SANTA MARIA',
				'MOTTALCIATA',
				'MUZZANO',
				'NETRO',
				'OCCHIEPPO INFERIORE',
				'OCCHIEPPO SUPERIORE',
				'PETTINENGO',
				'PIATTO',
				'PIEDICAVALLO',
				'PISTOLESA',
				'POLLONE',
				'PONDERANO',
				'PORTULA',
				'PRALUNGO',
				'PRAY',
				'QUAREGNA',
				'QUITTENGO',
				'RONCO BIELLESE',
				'ROPPOLO',
				'ROSAZZA',
				'SAGLIANO MICCA',
				'SALA BIELLESE',
				'SALUSSOLA',
				'SANDIGLIANO',
				'SAN PAOLO CERVO',
				'SELVE MARCONE',
				'SOPRANA',
				'SORDEVOLO',
				'SOSTEGNO',
				'STRONA',
				'TAVIGLIANO',
				'TERNENGO',
				'TOLLEGNO',
				'TORRAZZO',
				'TRIVERO',
				'VALDENGO',
				'VALLANZENGO',
				'VALLE MOSSO',
				'VALLE SAN NICOLAO',
				'VEGLIO',
				'VERRONE',
				'VIGLIANO BIELLESE',
				'VILLA DEL BOSCO',
				'VILLANOVA BIELLESE',
				'VIVERONE',
				'ZIMONE',
				'ZUBIENA',
				'ZUMAGLIA',
				'LESSONA',
				'CAMPIGLIA CERVO',
				'MOSSO',
			),
			'VB' => array(
				'ANTRONA SCHIERANCO',
				'ANZOLA D\'OSSOLA',
				'ARIZZANO',
				'AROLA',
				'AURANO',
				'BACENO',
				'BANNIO ANZINO',
				'BAVENO',
				'BEE',
				'BELGIRATE',
				'BEURA-CARDEZZA',
				'BOGNANCO',
				'BROVELLO-CARPUGNINO',
				'CALASCA-CASTIGLIONE',
				'CAMBIASCA',
				'CANNERO RIVIERA',
				'CANNOBIO',
				'CAPREZZO',
				'CASALE CORTE CERRO',
				'CAVAGLIO-SPOCCIA',
				'CEPPO MORELLI',
				'CESARA',
				'COSSOGNO',
				'CRAVEGGIA',
				'CREVOLADOSSOLA',
				'CRODO',
				'CURSOLO-ORASSO',
				'DOMODOSSOLA',
				'DRUOGNO',
				'FALMENTA',
				'FORMAZZA',
				'GERMAGNO',
				'GHIFFA',
				'GIGNESE',
				'GRAVELLONA TOCE',
				'GURRO',
				'INTRAGNA',
				'LOREGLIA',
				'MACUGNAGA',
				'MADONNA DEL SASSO',
				'MALESCO',
				'MASERA',
				'MASSIOLA',
				'MERGOZZO',
				'MIAZZINA',
				'MONTECRESTESE',
				'MONTESCHENO',
				'NONIO',
				'OGGEBBIO',
				'OMEGNA',
				'ORNAVASSO',
				'PALLANZENO',
				'PIEDIMULERA',
				'PIEVE VERGONTE',
				'PREMENO',
				'PREMIA',
				'PREMOSELLO-CHIOVENDA',
				'QUARNA SOPRA',
				'QUARNA SOTTO',
				'RE',
				'SAN BERNARDINO VERBANO',
				'SANTA MARIA MAGGIORE',
				'SEPPIANA',
				'STRESA',
				'TOCENO',
				'TRAREGO-VIGGIONA',
				'TRASQUERA',
				'TRONTANO',
				'VALSTRONA',
				'VANZONE CON SAN CARLO',
				'VARZO',
				'VERBANIA',
				'VIGANELLA',
				'VIGNONE',
				'VILLADOSSOLA',
				'VILLETTE',
				'VOGOGNA',
				'BORGOMEZZAVALLE',
			),
			'AO' => array(
				'ALLEIN',
				'ANTEY SAINT ANDRE\'',
				'AOSTA',
				'ARNAD',
				'ARVIER',
				'AVISE',
				'AYAS',
				'AYMAVILLES',
				'BARD',
				'BIONAZ',
				'BRISSOGNE',
				'BRUSSON',
				'CHALLAND SAINT ANSELME',
				'CHALLAND SAINT VICTOR',
				'CHAMBAVE',
				'CHAMOIS',
				'CHAMPDEPRAZ',
				'CHAMPORCHER',
				'CHARVENSOD',
				'CHATILLON',
				'COGNE',
				'COURMAYEUR',
				'DONNAS',
				'DOUES',
				'EMARESE',
				'ETROUBLES',
				'FENIS',
				'FONTAINEMORE',
				'GABY',
				'GIGNOD',
				'GRESSAN',
				'GRESSONEY LA TRINITE\'',
				'GRESSONEY SAINT JEAN',
				'HONE',
				'INTROD',
				'ISSIME',
				'ISSOGNE',
				'JOVENCAN',
				'LA MAGDELEINE',
				'LA SALLE',
				'LA THUILE',
				'LILLIANES',
				'MONTJOVET',
				'MORGEX',
				'NUS',
				'OLLOMONT',
				'OYACE',
				'PERLOZ',
				'POLLEIN',
				'PONTBOSET',
				'PONTEY',
				'PONT SAINT MARTIN',
				'PRE\' SAINT DIDIER',
				'QUART',
				'RHEMES NOTRE DAME',
				'RHEMES SAINT GEORGES',
				'ROISAN',
				'SAINT CHRISTOPHE',
				'SAINT DENIS',
				'SAINT MARCEL',
				'SAINT NICOLAS',
				'SAINT OYEN',
				'SAINT PIERRE',
				'SAINT RHEMY',
				'SAINT VINCENT',
				'SARRE',
				'TORGNON',
				'VALGRISENCHE',
				'VALPELLINE',
				'VALSAVARENCHE',
				'VALTOURNENCHE',
				'VERRAYES',
				'VERRES',
				'VILLENEUVE',
				'CHALLANT SAINT ANSELME ET CHALLANT SAI',
				'GRESSONEY',
				'RHEMES',
				'VALDIGNA D\'AOSTA',
				'VILLA CASTELNUOVO',
			),
			'VA' => array(
				'AGRA',
				'ALBIZZATE',
				'ANGERA',
				'ARCISATE',
				'ARSAGO SEPRIO',
				'AZZATE',
				'AZZIO',
				'BARASSO',
				'BARDELLO',
				'BEDERO VALCUVIA',
				'BESANO',
				'BESNATE',
				'BESOZZO',
				'BIANDRONNO',
				'BISUSCHIO',
				'BODIO LOMNAGO',
				'BREBBIA',
				'BREGANO',
				'BRENTA',
				'BREZZO DI BEDERO',
				'BRINZIO',
				'BRISSAGO-VALTRAVAGLIA',
				'BRUNELLO',
				'BRUSIMPIANO',
				'BUGUGGIATE',
				'BUSTO ARSIZIO',
				'CADEGLIANO-VICONAGO',
				'CADREZZATE',
				'CAIRATE',
				'CANTELLO',
				'CARAVATE',
				'CARDANO AL CAMPO',
				'CARNAGO',
				'CARONNO PERTUSELLA',
				'CARONNO VARESINO',
				'CASALE LITTA',
				'CASALZUIGNO',
				'CASCIAGO',
				'CASORATE SEMPIONE',
				'CASSANO MAGNAGO',
				'CASSANO VALCUVIA',
				'CASTELLANZA',
				'CASTELLO CABIAGLIO',
				'CASTELSEPRIO',
				'CASTELVECCANA',
				'CASTIGLIONE OLONA',
				'CASTRONNO',
				'CAVARIA CON PREMEZZO',
				'CAZZAGO BRABBIA',
				'CISLAGO',
				'CITTIGLIO',
				'CLIVIO',
				'COCQUIO-TREVISAGO',
				'COMABBIO',
				'COMERIO',
				'CREMENAGA',
				'CROSIO DELLA VALLE',
				'CUASSO AL MONTE',
				'CUGLIATE-FABIASCO',
				'CUNARDO',
				'CURIGLIA CON MONTEVIASCO',
				'CUVEGLIO',
				'CUVIO',
				'DAVERIO',
				'DUMENZA',
				'DUNO',
				'FAGNANO OLONA',
				'FERNO',
				'FERRERA DI VARESE',
				'GALLARATE',
				'GALLIATE LOMBARDO',
				'GAVIRATE',
				'GAZZADA SCHIANNO',
				'GEMONIO',
				'GERENZANO',
				'GERMIGNAGA',
				'GOLASECCA',
				'GORLA MAGGIORE',
				'GORLA MINORE',
				'GORNATE-OLONA',
				'GRANTOLA',
				'INARZO',
				'INDUNO OLONA',
				'ISPRA',
				'JERAGO CON ORAGO',
				'LAVENA-PONTE TRESA',
				'LAVENO-MOMBELLO',
				'LEGGIUNO',
				'LONATE CEPPINO',
				'LONATE POZZOLO',
				'LOZZA',
				'LUINO',
				'LUVINATE',
				'MACCAGNO',
				'MALGESSO',
				'MALNATE',
				'MARCHIROLO',
				'MARNATE',
				'MARZIO',
				'MASCIAGO PRIMO',
				'MERCALLO',
				'MESENZANA',
				'MONTEGRINO - VALTRAVAGLIA',
				'MONVALLE',
				'MORAZZONE',
				'MORNAGO',
				'OGGIONA CON SANTO STEFANO',
				'OLGIATE OLONA',
				'ORIGGIO',
				'ORINO',
				'OSMATE',
				'PINO SULLA SPONDA DEL LAGO MAGGIORE',
				'PORTO CERESIO',
				'PORTO VALTRAVAGLIA',
				'RANCIO VALCUVIA',
				'RANCO',
				'SALTRIO',
				'SAMARATE',
				'SARONNO',
				'SESTO CALENDE',
				'SOLBIATE ARNO',
				'SOLBIATE OLONA',
				'SOMMA LOMBARDO',
				'SUMIRAGO',
				'TAINO',
				'TERNATE',
				'TRADATE',
				'TRAVEDONA-MONATE',
				'TRONZANO LAGO MAGGIORE',
				'UBOLDO',
				'VALGANNA',
				'VARANO BORGHI',
				'VARESE',
				'VEDANO OLONA',
				'VEDDASCA',
				'VENEGONO INFERIORE',
				'VENEGONO SUPERIORE',
				'VERGIATE',
				'VIGGIU\'',
				'VIZZOLA TICINO',
				'SANGIANO',
				'MACCAGNO CON PINO E VEDDASCA',
				'ABBIATEGUAZZONE',
				'ALBUSCIAGO',
				'ARBIZZO',
				'ARCUMEGGIA',
				'ARDENA',
				'ARMIO',
				'ARNATE',
				'AROLO',
				'BALLARATE',
				'BARZA',
				'BARZOLA',
				'BIEGNO',
				'BIZZOZERO',
				'BOBBIATE',
				'BODIO',
				'BOGNO',
				'BOSCO VALTRAVAGLIA',
				'BRENNO USERIA',
				'BRISSAGO',
				'CADEGLIANO',
				'CADERO CON GRAGLIO',
				'CAIDATE',
				'CAMPAGNANO VEDASCA',
				'CAPOLAGO',
				'CAPRONNO',
				'CARDANA',
				'CARONNO CORBELLARO',
				'CASSINA FERRARA',
				'CASSINA PERTUSELLA',
				'CASSINA VERGHERA',
				'CASTAGNATE OLONA',
				'CASTELNOVATE',
				'CAVONA',
				'CELINA',
				'CERRO LAGO MAGGIORE',
				'CIMBRO',
				'COCQUIO',
				'CORGENO',
				'DUE COSSANI',
				'CRENNA',
				'CRUGNOLA',
				'FABIASCO',
				'GARABIOLO',
				'GAZZADA',
				'GORNATE SUPERIORE',
				'GURONE',
				'JERAGO',
				'JERAGO CON BESNATE',
				'JERAGO CON BESNATE ED ORAGO',
				'LAVENO',
				'LEGGIUNO-SANGIANO',
				'LISANZA',
				'LISSAGO',
				'LOZZO',
				'MACCAGNO INFERIORE',
				'MASNAGO',
				'MENZAGO',
				'MEZZANA SUPERIORE',
				'MOMBELLO LAGO MAGGIORE',
				'MONATE',
				'MONTEGRINO',
				'MONTENATE',
				'MONTEVIASCO',
				'MONTONATE',
				'MOROSOLO',
				'MUCENO',
				'MUSADINO',
				'MUSIGNANO',
				'NIZZOLINA',
				'OLGINASIO',
				'OLTRONA AL LAGO',
				'ORIANO SOPRA TICINO',
				'ORINO AZZIO',
				'PEVERANZA',
				'PREMEZZO',
				'QUINZANO SAN PIETRO',
				'ROGGIANO VALTRAVAGLIA',
				'ROVATE',
				'RUNO',
				'SACCONAGO',
				'SAN PANCRAZIO AL COLLE',
				'SANTA MARIA DEL MONTE',
				'SANT\'AMBROGIO-OLONA',
				'SCHIANNO',
				'SESONA',
				'TORBA',
				'TORNAVENTO',
				'TRAVEDONA',
				'TREVISAGO',
				'VAL MARCHIROLO',
				'VARARO',
				'VECCANA',
				'VELATE',
				'VENEGONO',
				'VERGOBBIO',
				'VICONAGO',
				'VILLA DOSIA',
				'VINAGO',
				'VOLDOMINO',
				'VOLTORRE',
			),
			'CO' => array(
				'ALBAVILLA',
				'ALBESE CON CASSANO',
				'ALBIOLO',
				'ALSERIO',
				'ALZATE BRIANZA',
				'ANZANO DEL PARCO',
				'APPIANO GENTILE',
				'ARGEGNO',
				'AROSIO',
				'ASSO',
				'BARNI',
				'BELLAGIO',
				'BENE LARIO',
				'BEREGAZZO CON FIGLIARO',
				'BINAGO',
				'BIZZARONE',
				'BLESSAGNO',
				'BLEVIO',
				'BREGNANO',
				'BRENNA',
				'BRIENNO',
				'BRUNATE',
				'BULGAROGRASSO',
				'CABIATE',
				'CADORAGO',
				'CAGLIO',
				'CAGNO',
				'CAMPIONE D\'ITALIA',
				'CANTU\'',
				'CANZO',
				'CAPIAGO INTIMIANO',
				'CARATE URIO',
				'CARBONATE',
				'CARIMATE',
				'CARLAZZO',
				'CARUGO',
				'CASASCO D\'INTELVI',
				'CASLINO D\'ERBA',
				'CASNATE CON BERNATE',
				'CASSINA RIZZARDI',
				'CASTELMARTE',
				'CASTELNUOVO BOZZENTE',
				'CASTIGLIONE D\'INTELVI',
				'CAVALLASCA',
				'CAVARGNA',
				'CERANO D\'INTELVI',
				'CERMENATE',
				'CERNOBBIO',
				'CIRIMIDO',
				'CIVENNA',
				'CLAINO CON OSTENO',
				'COLONNO',
				'COMO',
				'CONSIGLIO DI RUMO',
				'CORRIDO',
				'CREMIA',
				'CUCCIAGO',
				'CUSINO',
				'DIZZASCO',
				'DOMASO',
				'DONGO',
				'DOSSO DEL LIRO',
				'DREZZO',
				'ERBA',
				'EUPILIO',
				'FAGGETO LARIO',
				'FALOPPIO',
				'FENEGRO\'',
				'FIGINO SERENZA',
				'FINO MORNASCO',
				'GARZENO',
				'GERA LARIO',
				'GERMASINO',
				'GIRONICO',
				'GRANDATE',
				'GRANDOLA ED UNITI',
				'GRAVEDONA',
				'GRIANTE',
				'GUANZATE',
				'INVERIGO',
				'LAGLIO',
				'LAINO',
				'LAMBRUGO',
				'LANZO D\'INTELVI',
				'LASNIGO',
				'LENNO',
				'LEZZENO',
				'LIMIDO COMASCO',
				'LIPOMO',
				'LIVO',
				'LOCATE VARESINO',
				'LOMAZZO',
				'LONGONE AL SEGRINO',
				'LUISAGO',
				'LURAGO D\'ERBA',
				'LURAGO MARINONE',
				'LURATE CACCIVIO',
				'MAGREGLIO',
				'MARIANO COMENSE',
				'MASLIANICO',
				'MENAGGIO',
				'MERONE',
				'MEZZEGRA',
				'MOLTRASIO',
				'MONGUZZO',
				'MONTANO LUCINO',
				'MONTEMEZZO',
				'MONTICELLO BRIANZA',
				'MONTORFANO',
				'MOZZATE',
				'MUSSO',
				'NESSO',
				'NOVEDRATE',
				'OLGIATE COMASCO',
				'OLTRONA DI SAN MAMETTE',
				'ORSENIGO',
				'OSSUCCIO',
				'PARE\'',
				'PEGLIO',
				'PELLIO INTELVI',
				'PIANELLO DEL LARIO',
				'PIGRA',
				'PLESIO',
				'POGNANA LARIO',
				'PONNA',
				'PONTE LAMBRO',
				'PORLEZZA',
				'PROSERPIO',
				'PUSIANO',
				'RAMPONIO VERNA',
				'REZZAGO',
				'RODERO',
				'RONAGO',
				'ROVELLASCA',
				'ROVELLO PORRO',
				'SALA COMACINA',
				'SAN BARTOLOMEO VAL CAVARGNA',
				'SAN FEDELE INTELVI',
				'SAN FERMO DELLA BATTAGLIA',
				'SAN NAZZARO VAL CAVARGNA',
				'SANT\'ABBONDIO',
				'SANTA MARIA REZZONICO',
				'SCHIGNANO',
				'SENNA COMASCO',
				'SOLBIATE',
				'SORICO',
				'SORMANO',
				'STAZZONA',
				'TAVERNERIO',
				'TORNO',
				'TREMEZZO',
				'TREZZONE',
				'TURATE',
				'UGGIATE-TREVANO',
				'VALBRONA',
				'VALMOREA',
				'VAL REZZO',
				'VALSOLDA',
				'VELESO',
				'VENIANO',
				'VERCANA',
				'VERTEMATE CON MINOPRIO',
				'VILLA GUARDIA',
				'ZELBIO',
				'SAN SIRO',
				'GRAVEDONA ED UNITI',
				'BELLAGIO',
				'COLVERDE',
				'TREMEZZINA',
				'ABBADIA SOPRA ADDA',
				'ACQUATE',
				'AIZURRO',
				'ALBATE',
				'ALBESE',
				'ALBOGASIO',
				'ARCELLASCO',
				'ASNAGO',
				'BAGAGGERA',
				'BAIEDO',
				'BALLABIO INFERIORE',
				'BALLABIO SUPERIORE',
				'BARCONE',
				'BARTESATE',
				'BELLEDO',
				'BERNAGA',
				'BERNATE ROSALES',
				'BIGLIO',
				'BINDO',
				'BRECCIA',
				'BREGLIA',
				'BRENNO DELLA TORRE',
				'BRIANZOLA',
				'BUCCINIGO',
				'BUGGIOLO',
				'BUGIALLO',
				'BULGORELLO',
				'CAGLIANO',
				'CAMERLATA',
				'CAMNAGO VOLTA',
				'CAMNAGO FALOPPIA',
				'CAPIAGO',
				'CAPIATE',
				'CARATE LARIO',
				'CARCANO',
				'CARELLA CON MARIAGA',
				'CARENO',
				'CARLAZZO VALSOLDA',
				'CARUGO AROSIO',
				'CASANOVA LANZA',
				'CASIRAGO',
				'CASLETTO',
				'CASLINO AL PIANO',
				'CASNATE',
				'CASSAGO',
				'CASSANO ALBESE',
				'CASSINA DE\' BRACCHI',
				'CASSINA MARIAGA',
				'CASTELLO VALSOLDA',
				'CASTELLO SOPRA LECCO',
				'CAVERSACCIO',
				'CENTEMERO',
				'CEREDA',
				'CERNUSCO MONTEVECCHIA',
				'CESELLO BRIANZA',
				'CHIUSO',
				'CIMA',
				'CIVELLO',
				'CIVIGLIO',
				'COLCIAGO',
				'COLOGNA',
				'CONCENEDO',
				'CONSONNO',
				'CONTRA',
				'CORENNO PLINIO',
				'CORTABBIO',
				'CREMNAGO',
				'CRESSOGNO',
				'CREVENNA',
				'CROCE',
				'DASIO',
				'DOZIO',
				'DRANO',
				'ERBA INCINO',
				'ESINO INFERIORE',
				'ESINO SUPERIORE',
				'FABBRICA DURINI',
				'MIRABELLO COMASCO',
				'GAGGINO',
				'GERMANEDO',
				'GOTTRO',
				'GRANDOLA',
				'GRONA',
				'IMBERIDO',
				'INCINO',
				'INDOVERO',
				'INTIMIANO',
				'ISOLA COMACINA',
				'LAORCA',
				'LEMNA',
				'LEZZA',
				'LIETO COLLE',
				'LIMONTA',
				'LINZANICO',
				'LOMANIGA',
				'LOVENO SOPRA MENAGGIO',
				'LUCINO',
				'MACCIO',
				'MAGGIANICO',
				'MINOPRIO',
				'MOIANA',
				'MOLINA',
				'MONDONICO',
				'MONTANO COMASCO',
				'MONTE OLIMPINO',
				'NAVA',
				'NOVATE BRIANZA',
				'OLATE',
				'OLCIO',
				'OLGIATE CALCO',
				'ONNO',
				'ORIANO DI BRIANZA',
				'PAGNANO VALSASSINA',
				'PALANZO',
				'PARRAVICINO',
				'PENZANO',
				'PESSINA VALSASSINA',
				'PIANO PORLEZZA',
				'PIAZZA SANTO STEFANO',
				'PONTE',
				'PONZATE',
				'PURIA',
				'RAMPONIO',
				'RANCIO DI LECCO',
				'RAVELLINO',
				'REBBIO',
				'REZZONICO',
				'ROMANO BRIANZA',
				'RONGIO',
				'ROVENNA',
				'SABBIONCELLO',
				'SALA AL BARRO',
				'SAN BARTOLOMEO AL BOSCO',
				'SAN GIOVANNI ALLA CASTAGNA',
				'SAN SIRO',
				'SANTA MARIA DI ROVAGNATE',
				'SANTA VALERIA',
				'SARTIRANA BRIANTEA',
				'SCARENNA',
				'SCARIA',
				'SEGHEBBIA',
				'SEPRIO',
				'SOLZAGO',
				'SOMANA',
				'STAZZONA-GERMASINO',
				'TAVORDO',
				'TRAVERSA',
				'TREGOLO',
				'TREMEZZINA',
				'TREVANO',
				'UGGIATE',
				'URIO',
				'VASSENA',
				'VERDERIO',
				'VILLA VERGANO',
				'VERNA',
				'VERTEMATE',
				'VILL\'ALBESE',
				'VILLA ROMANO',
				'VIMOGNO',
				'VISINO',
				'ZELBIO VELESO',
				'ABBADIA LARIANA',
				'AIRUNO',
				'ANNONE DI BRIANZA',
				'BALLABIO',
				'BARZAGO',
				'BARZANO\'',
				'BARZIO',
				'BELLANO',
				'BOSISIO PARINI',
				'BRIVIO',
				'BULCIAGO',
				'CALCO',
				'CASARGO',
				'CASATENOVO',
				'CASSAGO BRIANZA',
				'CASSINA VALSASSINA',
				'CASTELLO DI BRIANZA',
				'CERNUSCO LOMBARDONE',
				'CESANA BRIANZA',
				'CIVATE',
				'COLICO',
				'COLLE BRIANZA',
				'CORTENOVA',
				'COSTA MASNAGA',
				'CRANDOLA VALSASSINA',
				'CREMELLA',
				'CREMENO',
				'DERVIO',
				'DOLZAGO',
				'DORIO',
				'ELLO',
				'ESINO LARIO',
				'GALBIATE',
				'GARBAGNATE MONASTERO',
				'GARLATE',
				'IMBERSAGO',
				'INTROBIO',
				'INTROZZO',
				'LECCO',
				'LIERNA',
				'LOMAGNA',
				'MALGRATE',
				'MANDELLO DEL LARIO',
				'MARGNO',
				'MERATE',
				'MISSAGLIA',
				'MOGGIO',
				'MOLTENO',
				'MONTEVECCHIA',
				'MORTERONE',
				'NIBIONNO',
				'OGGIONO',
				'OLGIATE MOLGORA',
				'OLGINATE',
				'OLIVETO LARIO',
				'OSNAGO',
				'PADERNO D\'ADDA',
				'PAGNONA',
				'PARLASCO',
				'PASTURO',
				'PEREGO',
				'PERLEDO',
				'PESCATE',
				'PREMANA',
				'PRIMALUNA',
				'ROBBIATE',
				'ROGENO',
				'ROVAGNATE',
				'SANTA MARIA HOE\'',
				'SIRONE',
				'SIRTORI',
				'SUEGLIO',
				'SUELLO',
				'TACENO',
				'TREMENICO',
				'VALGREGHENTINO',
				'VALMADRERA',
				'VARENNA',
				'VENDROGNO',
				'VERDERIO INFERIORE',
				'VERDERIO SUPERIORE',
				'VESTRENO',
				'VIGANO\'',
			),
			'SO' => array(
				'ALBAREDO PER SAN MARCO',
				'ALBOSAGGIA',
				'ANDALO VALTELLINO',
				'APRICA',
				'ARDENNO',
				'BEMA',
				'BERBENNO DI VALTELLINA',
				'BIANZONE',
				'BORMIO',
				'BUGLIO IN MONTE',
				'CAIOLO',
				'CAMPODOLCINO',
				'CASPOGGIO',
				'CASTELLO DELL\'ACQUA',
				'CASTIONE ANDEVENNO',
				'CEDRASCO',
				'CERCINO',
				'CHIAVENNA',
				'CHIESA IN VALMALENCO',
				'CHIURO',
				'CINO',
				'CIVO',
				'COLORINA',
				'COSIO VALTELLINO',
				'DAZIO',
				'DELEBIO',
				'DUBINO',
				'FAEDO VALTELLINO',
				'FORCOLA',
				'FUSINE',
				'GEROLA ALTA',
				'GORDONA',
				'GROSIO',
				'GROSOTTO',
				'MADESIMO',
				'LANZADA',
				'LIVIGNO',
				'LOVERO',
				'MANTELLO',
				'MAZZO DI VALTELLINA',
				'MELLO',
				'MENAROLA',
				'MESE',
				'MONTAGNA IN VALTELLINA',
				'MORBEGNO',
				'NOVATE MEZZOLA',
				'PEDESINA',
				'PIANTEDO',
				'PIATEDA',
				'PIURO',
				'POGGIRIDENTI',
				'PONTE IN VALTELLINA',
				'POSTALESIO',
				'PRATA CAMPORTACCIO',
				'RASURA',
				'ROGOLO',
				'SAMOLACO',
				'SAN GIACOMO FILIPPO',
				'SERNIO',
				'SONDALO',
				'SONDRIO',
				'SPRIANA',
				'TALAMONA',
				'TARTANO',
				'TEGLIO',
				'TIRANO',
				'TORRE DI SANTA MARIA',
				'TOVO DI SANT\'AGATA',
				'TRAONA',
				'TRESIVIO',
				'VALDIDENTRO',
				'VALDISOTTO',
				'VALFURVA',
				'VAL MASINO',
				'VERCEIA',
				'VERVIO',
				'VILLA DI CHIAVENNA',
				'VILLA DI TIRANO',
				'ACQUA',
				'BOFFETTO',
				'CAMPOVICO',
			),
			'MI' => array(
				'ABBIATEGRASSO',
				'AGRATE BRIANZA',
				'AICURZIO',
				'ALBAIRATE',
				'ALBIATE',
				'ARCONATE',
				'ARCORE',
				'ARESE',
				'ARLUNO',
				'ASSAGO',
				'BAREGGIO',
				'BARLASSINA',
				'BASIANO',
				'BASIGLIO',
				'BELLINZAGO LOMBARDO',
				'BELLUSCO',
				'BERNAREGGIO',
				'BERNATE TICINO',
				'BESANA IN BRIANZA',
				'BESATE',
				'BIASSONO',
				'BINASCO',
				'BOFFALORA SOPRA TICINO',
				'BOLLATE',
				'BOVISIO-MASCIAGO',
				'BRESSO',
				'BRIOSCO',
				'BRUGHERIO',
				'BUBBIANO',
				'BUCCINASCO',
				'BURAGO DI MOLGORA',
				'BUSCATE',
				'BUSNAGO',
				'BUSSERO',
				'BUSTO GAROLFO',
				'CALVIGNASCO',
				'CAMBIAGO',
				'CAMPARADA',
				'CANEGRATE',
				'CAPONAGO',
				'CARATE BRIANZA',
				'CARNATE',
				'CARPIANO',
				'CARUGATE',
				'CASARILE',
				'CASOREZZO',
				'CASSANO D\'ADDA',
				'CASSINA DE\' PECCHI',
				'CASSINETTA DI LUGAGNANO',
				'CASTANO PRIMO',
				'CAVENAGO DI BRIANZA',
				'CERIANO LAGHETTO',
				'CERNUSCO SUL NAVIGLIO',
				'CERRO AL LAMBRO',
				'CERRO MAGGIORE',
				'CESANO BOSCONE',
				'CESANO MADERNO',
				'CESATE',
				'CINISELLO BALSAMO',
				'CISLIANO',
				'COGLIATE',
				'COLOGNO MONZESE',
				'COLTURANO',
				'CONCOREZZO',
				'CORBETTA',
				'CORMANO',
				'CORNAREDO',
				'CORNATE D\'ADDA',
				'CORREZZANA',
				'CORSICO',
				'CUGGIONO',
				'CUSAGO',
				'CUSANO MILANINO',
				'DAIRAGO',
				'DESIO',
				'DRESANO',
				'GAGGIANO',
				'GARBAGNATE MILANESE',
				'GESSATE',
				'GIUSSANO',
				'GORGONZOLA',
				'GREZZAGO',
				'GUDO VISCONTI',
				'INVERUNO',
				'INZAGO',
				'LACCHIARELLA',
				'LAINATE',
				'LAZZATE',
				'LEGNANO',
				'LENTATE SUL SEVESO',
				'LESMO',
				'LIMBIATE',
				'LISCATE',
				'LISSONE',
				'LOCATE DI TRIULZI',
				'MACHERIO',
				'MAGENTA',
				'MAGNAGO',
				'MARCALLO CON CASONE',
				'MASATE',
				'MEDA',
				'MEDIGLIA',
				'MELEGNANO',
				'MELZO',
				'MESERO',
				'MEZZAGO',
				'MILANO',
				'MISINTO',
				'MORIMONDO',
				'MOTTA VISCONTI',
				'MUGGIO\'',
				'NERVIANO',
				'NOSATE',
				'NOVA MILANESE',
				'NOVATE MILANESE',
				'NOVIGLIO',
				'OPERA',
				'ORNAGO',
				'OSSONA',
				'OZZERO',
				'PADERNO DUGNANO',
				'PANTIGLIATE',
				'PARABIAGO',
				'PAULLO',
				'PERO',
				'PESCHIERA BORROMEO',
				'PESSANO CON BORNAGO',
				'PIEVE EMANUELE',
				'PIOLTELLO',
				'POGLIANO MILANESE',
				'POZZO D\'ADDA',
				'POZZUOLO MARTESANA',
				'PREGNANA MILANESE',
				'RENATE',
				'RESCALDINA',
				'RHO',
				'ROBECCHETTO CON INDUNO',
				'ROBECCO SUL NAVIGLIO',
				'RODANO',
				'RONCELLO',
				'RONCO BRIANTINO',
				'ROSATE',
				'ROZZANO',
				'SAN COLOMBANO AL LAMBRO',
				'SAN DONATO MILANESE',
				'SAN GIORGIO SU LEGNANO',
				'SAN GIULIANO MILANESE',
				'SANTO STEFANO TICINO',
				'SAN VITTORE OLONA',
				'SAN ZENONE AL LAMBRO',
				'SEDRIANO',
				'SEGRATE',
				'SENAGO',
				'SEREGNO',
				'SESTO SAN GIOVANNI',
				'SETTALA',
				'SETTIMO MILANESE',
				'SEVESO',
				'SOLARO',
				'SOVICO',
				'SULBIATE',
				'TREZZANO ROSA',
				'TREZZANO SUL NAVIGLIO',
				'TREZZO SULL\'ADDA',
				'TRIBIANO',
				'TRIUGGIO',
				'TRUCCAZZANO',
				'TURBIGO',
				'USMATE VELATE',
				'VANZAGO',
				'VAPRIO D\'ADDA',
				'VAREDO',
				'VEDANO AL LAMBRO',
				'VEDUGGIO CON COLZANO',
				'VERANO BRIANZA',
				'VERMEZZO',
				'VERNATE',
				'VIGNATE',
				'VILLASANTA',
				'VIMERCATE',
				'VIMODRONE',
				'VITTUONE',
				'VIZZOLO PREDABISSI',
				'ZELO SURRIGONE',
				'ZIBIDO SAN GIACOMO',
				'VILLA CORTESE',
				'VANZAGHELLO',
				'BARANZATE',
				'AFFORI',
				'AGLIATE',
				'ARCAGNA',
				'ARCAGNANO',
				'BAGGIO',
				'BALSAMO',
				'BARATE',
				'BARBAIANA',
				'BARGANO',
				'BESTAZZO',
				'BIENATE',
				'BINZAGO',
				'BIRAGO',
				'BISENTRATE',
				'BOLDINASCO',
				'BOLGIANO',
				'BOLLADELLO',
				'BONIROLA',
				'BORNAGO',
				'BORSANO',
				'BOTTEDO',
				'BRIAVACCA',
				'BRUSUGLIO',
				'BRUZZANO DEI DUE BORGHI',
				'BUSTIGHERA',
				'CA\' DEI BOLLI',
				'CA\' DELL\'ACQUA',
				'CA\' DE\' MAZZI',
				'CA\' DE\' ZECCHI',
				'CAJELLO',
				'CALO\'',
				'CAMPOLUNGO',
				'CANTONALE',
				'CAPRIANO DI BRIANZA',
				'CASELLE D\'OZERO',
				'CASIRATE OLONA',
				'CASOLATE',
				'CASONE',
				'CASSINA ALIPRANDI',
				'CASSINA AMATA',
				'CASSINA BARAGGIA',
				'CASSINA DE\' GATTI',
				'CASSINA NUOVA',
				'CASSINA POBBIA',
				'CASSINA SAVINA',
				'CASSINA TRIULZA',
				'CASSINO D\'ALBERI',
				'CASTEGNATE OLONA',
				'CASTELLAZZO DE\' BARZI',
				'CASTELLETTO MENDOSIO',
				'CASTIRAGA DA REGGIO',
				'CAVAIONE',
				'CAVIAGA',
				'CAZZANO BESANA',
				'CEDRATE',
				'CEPPEDA',
				'CERCHIATE',
				'CHIARAVALLE MILANESE',
				'CHIOSI D\'ADDA VIGADORE',
				'CHIOSI DI PORTA D\'ADDA',
				'CHIOSI PORTA CREMONESE',
				'CHIOSI PORTA REGALE',
				'CHIOSI UNITI CON BOTTEDO',
				'CINISELLO',
				'COAZZANO',
				'COLNAGO',
				'COLZANO',
				'CONCESA',
				'COPRENO',
				'CORNELIANO BERTARIO',
				'CORPI SANTI DI MILANO',
				'CORTE SANT\'ANDREA',
				'COSTA AL LAMBRO',
				'CRESCENZAGO',
				'CUVIRONE',
				'DERGANO',
				'DUGNANO',
				'FAGNANO SUL NAVIGLIO',
				'FIGINO DI MILANO',
				'FURATO',
				'GARBATOLA',
				'GAREGNANO',
				'GATTERA MAIOCCA',
				'GORLA PRECOTTO',
				'GRANCINO',
				'GRAZZANELLO',
				'GRECO MILANESE',
				'GROPPELLO D\'ADDA',
				'GUAZZINA',
				'GUGNANO',
				'INCIRANO',
				'INDUNO TICINO',
				'ISOLA BALBA',
				'LAMBRATE',
				'LARDERA',
				'LIMITO',
				'LINATE AL LAMBRO',
				'LUCERNATE',
				'MARCALLO',
				'MASCIAGO MILANESE',
				'MAZZO MILANESE',
				'MELEGNANELLO',
				'MERCUGNANO',
				'METTONE',
				'MEZZANA CASATI',
				'MEZZANO PASSONE',
				'MIGNETE',
				'MIRABELLO SAN BERNARDINO',
				'MONCUCCO VECCHIO',
				'MONCUCCO DI MONZA',
				'MONGIARDINO SILLARO',
				'MONTESIRO',
				'MORSENCHIO',
				'MOTTA VIGANA',
				'MUGGIANO',
				'MUSOCCO',
				'NIGUARDA',
				'NOSEDO',
				'NOVEGRO',
				'OMATE',
				'ORENO',
				'PAINA',
				'PALAZZOLO MILANESE',
				'PASSIRANA MILANESE',
				'PASTURAGO',
				'PEDRIANO',
				'PESSANO',
				'PEZZOLO DE\' CODAZZI',
				'PEZZOLO DI TAVAZZANO',
				'PINZANO',
				'PIZZOLANO',
				'PONTESESTO',
				'PORTO D\'ADDA',
				'PRECOTTO',
				'PREMENUGO',
				'PROSPIANO',
				'QUARTIANO',
				'QUARTO CAGNINO',
				'QUINTO ROMANO',
				'QUINTOSOLE',
				'REGINA FITTAREZZA',
				'RENATE VEDUGGIO',
				'RESCALDA',
				'RIOZZO',
				'ROBBIANO',
				'ROBECCHETTO',
				'ROBECCO LODIGIANO',
				'RONCHETTO',
				'ROSERIO',
				'ROVAGNASCO',
				'RUGINELLO',
				'SAN DAMIANO DI MONZA',
				'SAN GIULIANO',
				'SAN NOVO',
				'SAN PEDRINO',
				'SAN PIETRO BESTAZZO',
				'SAN PIETRO CUSICO',
				'SANT\'AGATA MARTESANA',
				'SANTA MARIA IN PRATO',
				'SANT\'ANTONINO TICINO',
				'SAN VITO E MARTA',
				'SELLANUOVA',
				'SESTO PERGOLA',
				'SESTO ULTERIANO',
				'SOLTARICO',
				'SULBIATE INFERIORE',
				'SULBIATE SUPERIORE',
				'TAINATE',
				'TAVAZZANO',
				'TERRAZZANO',
				'TORMO',
				'TRECELLA',
				'TREGASIO',
				'TRENNO',
				'TRIVULZA',
				'TRIVULZINA',
				'TURRO MILANESE',
				'USMATE',
				'VAIANO VALLE',
				'VALLE GUIDINO',
				'VEDUGGIO',
				'VERGO',
				'VIDARDO',
				'VIGADORE',
				'VIGANO CERTOSINO',
				'VIGENTINO',
				'VIGONZINO',
				'VILLANOVA VIMERCATE',
				'VILLA PIZZONE',
				'VILLA POMPEIANA',
				'VILLA RAVERIO',
				'VILLA ROSSA',
				'VITTADONE',
				'ZELO FORAMAGNO',
				'ZIVIDO',
				'ZORLESCO',
				'ZUNICO',
				'ABBADIA CERRETO',
				'BERTONICO',
				'BOFFALORA D\'ADDA',
				'BORGHETTO LODIGIANO',
				'BORGO SAN GIOVANNI',
				'BREMBIO',
				'CAMAIRAGO',
				'CASALETTO LODIGIANO',
				'CASALMAIOCCO',
				'CASALPUSTERLENGO',
				'CASELLE LANDI',
				'CASELLE LURANI',
				'CASTELNUOVO BOCCA D\'ADDA',
				'CASTIGLIONE D\'ADDA',
				'CASTIRAGA VIDARDO',
				'CAVACURTA',
				'CAVENAGO D\'ADDA',
				'CERVIGNANO D\'ADDA',
				'CODOGNO',
				'COMAZZO',
				'CORNEGLIANO LAUDENSE',
				'CORNO GIOVINE',
				'CORNOVECCHIO',
				'CORTE PALASIO',
				'CRESPIATICA',
				'FOMBIO',
				'GALGAGNANO',
				'GRAFFIGNANA',
				'GUARDAMIGLIO',
				'LIVRAGA',
				'LODI',
				'LODI VECCHIO',
				'MACCASTORNA',
				'MAIRAGO',
				'MALEO',
				'MARUDO',
				'MASSALENGO',
				'MELETI',
				'MERLINO',
				'MONTANASO LOMBARDO',
				'MULAZZANO',
				'ORIO LITTA',
				'OSPEDALETTO LODIGIANO',
				'OSSAGO LODIGIANO',
				'PIEVE FISSIRAGA',
				'SALERANO SUL LAMBRO',
				'SAN FIORANO',
				'SAN MARTINO IN STRADA',
				'SAN ROCCO AL PORTO',
				'SANT\'ANGELO LODIGIANO',
				'SANTO STEFANO LODIGIANO',
				'SECUGNAGO',
				'SENNA LODIGIANA',
				'SOMAGLIA',
				'SORDIO',
				'TAVAZZANO CON VILLAVESCO',
				'TERRANOVA DEI PASSERINI',
				'TURANO LODIGIANO',
				'VALERA FRATTA',
				'VILLANOVA DEL SILLARO',
				'ZELO BUON PERSICO',
			),
			'BG' => array(
				'ADRARA SAN MARTINO',
				'ADRARA SAN ROCCO',
				'ALBANO SANT\'ALESSANDRO',
				'ALBINO',
				'ALME\'',
				'ALMENNO SAN BARTOLOMEO',
				'ALMENNO SAN SALVATORE',
				'ALZANO LOMBARDO',
				'AMBIVERE',
				'ANTEGNATE',
				'ARCENE',
				'ARDESIO',
				'ARZAGO D\'ADDA',
				'AVERARA',
				'AVIATICO',
				'AZZANO SAN PAOLO',
				'AZZONE',
				'BAGNATICA',
				'BARBATA',
				'BARIANO',
				'BARZANA',
				'BEDULITA',
				'BERBENNO',
				'BERGAMO',
				'BERZO SAN FERMO',
				'BIANZANO',
				'BLELLO',
				'BOLGARE',
				'BOLTIERE',
				'BONATE SOPRA',
				'BONATE DI SOTTO',
				'BORGO DI TERZO',
				'BOSSICO',
				'BOTTANUCO',
				'BRACCA',
				'BRANZI',
				'BREMBATE',
				'BREMBATE DI SOPRA',
				'BREMBILLA',
				'BRIGNANO GERA D\'ADDA',
				'BRUMANO',
				'BRUSAPORTO',
				'CALCINATE',
				'CALCIO',
				'CALUSCO D\'ADDA',
				'CALVENZANO',
				'CAMERATA CORNELLO',
				'CANONICA D\'ADDA',
				'CAPIZZONE',
				'CAPRIATE SAN GERVASIO',
				'CAPRINO BERGAMASCO',
				'CARAVAGGIO',
				'CAROBBIO DEGLI ANGELI',
				'CARONA',
				'CARVICO',
				'CASAZZA',
				'CASIRATE D\'ADDA',
				'CASNIGO',
				'CASSIGLIO',
				'CASTELLI CALEPIO',
				'CASTEL ROZZONE',
				'CASTIONE DELLA PRESOLANA',
				'CASTRO',
				'CAVERNAGO',
				'CAZZANO SANT\'ANDREA',
				'CENATE SOPRA',
				'CENATE SOTTO',
				'CENE',
				'CERETE',
				'CHIGNOLO D\'ISOLA',
				'CHIUDUNO',
				'CISANO BERGAMASCO',
				'CISERANO',
				'CIVIDATE AL PIANO',
				'CLUSONE',
				'COLERE',
				'COLOGNO AL SERIO',
				'COLZATE',
				'COMUN NUOVO',
				'CORNA IMAGNA',
				'CORTENUOVA',
				'COSTA DI MEZZATE',
				'COSTA VALLE IMAGNA',
				'COSTA VOLPINO',
				'COVO',
				'CREDARO',
				'CURNO',
				'CUSIO',
				'DALMINE',
				'DOSSENA',
				'ENDINE GAIANO',
				'ENTRATICO',
				'FARA GERA D\'ADDA',
				'FARA OLIVANA CON SOLA',
				'FILAGO',
				'FINO DEL MONTE',
				'FIORANO AL SERIO',
				'FONTANELLA',
				'FONTENO',
				'FOPPOLO',
				'FORESTO SPARSO',
				'FORNOVO SAN GIOVANNI',
				'FUIPIANO VALLE IMAGNA',
				'GANDELLINO',
				'GANDINO',
				'GANDOSSO',
				'GAVERINA TERME',
				'GAZZANIGA',
				'GEROSA',
				'GHISALBA',
				'GORLAGO',
				'GORLE',
				'GORNO',
				'GRASSOBBIO',
				'GROMO',
				'GRONE',
				'GRUMELLO DEL MONTE',
				'ISOLA DI FONDRA',
				'ISSO',
				'LALLIO',
				'LEFFE',
				'LENNA',
				'LEVATE',
				'LOCATELLO',
				'LOVERE',
				'LURANO',
				'LUZZANA',
				'MADONE',
				'MAPELLO',
				'MARTINENGO',
				'MEZZOLDO',
				'MISANO DI GERA D\'ADDA',
				'MOIO DE\' CALVI',
				'MONASTEROLO DEL CASTELLO',
				'MONTELLO',
				'MORENGO',
				'MORNICO AL SERIO',
				'MOZZANICA',
				'MOZZO',
				'NEMBRO',
				'OLMO AL BREMBO',
				'OLTRE IL COLLE',
				'OLTRESSENDA ALTA',
				'ONETA',
				'ONORE',
				'ORIO AL SERIO',
				'ORNICA',
				'OSIO SOPRA',
				'OSIO SOTTO',
				'PAGAZZANO',
				'PALADINA',
				'PALAZZAGO',
				'PALOSCO',
				'PARRE',
				'PARZANICA',
				'PEDRENGO',
				'PEIA',
				'PIANICO',
				'PIARIO',
				'PIAZZA BREMBANA',
				'PIAZZATORRE',
				'PIAZZOLO',
				'POGNANO',
				'PONTE NOSSA',
				'PONTERANICA',
				'PONTE SAN PIETRO',
				'PONTIDA',
				'PONTIROLO NUOVO',
				'PRADALUNGA',
				'PREDORE',
				'PREMOLO',
				'PRESEZZO',
				'PUMENENGO',
				'RANICA',
				'RANZANICO',
				'RIVA DI SOLTO',
				'ROGNO',
				'ROMANO DI LOMBARDIA',
				'RONCOBELLO',
				'RONCOLA',
				'ROTA D\'IMAGNA',
				'ROVETTA',
				'SAN GIOVANNI BIANCO',
				'SAN PAOLO D\'ARGON',
				'SAN PELLEGRINO TERME',
				'SANTA BRIGIDA',
				'SANT\'OMOBONO IMAGNA',
				'SARNICO',
				'SCANZOROSCIATE',
				'SCHILPARIO',
				'SEDRINA',
				'SELVINO',
				'SERIATE',
				'SERINA',
				'SOLTO COLLINA',
				'SONGAVAZZO',
				'SORISOLE',
				'SOTTO IL MONTE GIOVANNI XXIII',
				'SOVERE',
				'SPINONE AL LAGO',
				'SPIRANO',
				'STEZZANO',
				'STROZZA',
				'SUISIO',
				'TALEGGIO',
				'TAVERNOLA BERGAMASCA',
				'TELGATE',
				'TERNO D\'ISOLA',
				'TORRE BOLDONE',
				'TORRE DE\' ROVERI',
				'TORRE PALLAVICINA',
				'TRESCORE BALNEARIO',
				'TREVIGLIO',
				'TREVIOLO',
				'UBIALE CLANEZZO',
				'URGNANO',
				'VALBONDIONE',
				'VALBREMBO',
				'VALGOGLIO',
				'VALLEVE',
				'VALNEGRA',
				'VALSECCA',
				'VALTORTA',
				'VEDESETA',
				'VERDELLINO',
				'VERDELLO',
				'VERTOVA',
				'VIADANICA',
				'VIGANO SAN MARTINO',
				'VIGOLO',
				'VILLA D\'ADDA',
				'VILLA D\'ALME\'',
				'VILLA DI SERIO',
				'VILLA D\'OGNA',
				'VILLONGO',
				'VILMINORE DI SCALVE',
				'ZANDOBBIO',
				'ZANICA',
				'ZOGNO',
				'COSTA SERINA',
				'ALGUA',
				'CORNALBA',
				'MEDOLAGO',
				'SOLZA',
				'VAL BREMBILLA',
				'ALBEGNO',
				'ALZANO MAGGIORE',
				'ALZANO SOPRA',
				'BARESI',
				'BARZIZZA',
				'BONDIONE',
				'BONDO PETELLO',
				'BORDOGNA',
				'BORGOUNITO',
				'BRACCA DI COSTA SERINA',
				'BREMBATE DI SOTTO',
				'SOMBRENO',
				'BRUNTINO',
				'CALEPIO',
				'CALOLZIO',
				'CAPRIATE D\'ADDA',
				'CAROBBIO',
				'CENATE',
				'CENATE D\'ARGON',
				'CENTRISOLA',
				'CEPINO',
				'COLOGNOLA DEL PIANO',
				'CORTE',
				'CURDOMO',
				'CURNASCO',
				'DESENZANO AL SERIO',
				'DEZZO DI SCALVE',
				'ENDENNA',
				'ENDINE',
				'ESMATE',
				'FIUMENERO',
				'FONDRA',
				'FREROLA',
				'FUIPIANO AL BREMBO',
				'GRIGNANO',
				'GRUMELLO DEI ZANCHI',
				'GRUMELLO DEL PIANO',
				'LIZZOLA',
				'LOCATE BERGAMASCO',
				'LORENTINO',
				'MARIANO AL BREMBO',
				'MASSARI-MELZI',
				'MAZZOLENI E FALGHERA',
				'MOLINI DI COLOGNOLA',
				'NESE',
				'OLTREPOVO',
				'OLTRESSENDA BASSA',
				'OREZZO',
				'OSSANESGA',
				'PIAN GAIANO',
				'PIAZZO ALTO',
				'PIAZZO BASSO',
				'PONTE DI NOSSA',
				'POSCANTE',
				'REDONA',
				'RIGOSA',
				'RIVIERA D\'ADDA',
				'ROCCA DEL COLLE',
				'ROSCIATE',
				'ROSSINO',
				'ROTA DENTRO',
				'ROTA FUORI',
				'ROVETTA CON FINO',
				'SABBIO BERGAMASCO',
				'SAN GALLO',
				'SAN GERVASIO D\'ADDA',
				'SAN MARTINO DE\' CALVI',
				'SAN PIETRO D\'ORZIO',
				'SANT\'ANTONIO D\'ADDA',
				'SANTO STEFANO DEL MONTE DEGLI ANGELI',
				'SCANO AL BREMBO',
				'SCANZO',
				'SELINO',
				'SELLERE',
				'SFORZATICA',
				'SOLTO',
				'SOMENDENNA',
				'SPINO AL BREMBO',
				'SPINONE',
				'STABELLO',
				'TAGLIUNO',
				'TRABUCHELLO',
				'VALL\'ALTA',
				'VALTESSE',
				'VILLONGO SAN FILASTRO',
				'VILLONGO SANT\'ALESSANDRO',
				'VILMINORE',
				'ZORZINO',
				'ALME\' CON VILLA',
				'CALOLZIOCORTE',
				'CARENNO',
				'ERVE',
				'MONTE MARENZO',
				'TORRE DE\' BUSI',
				'VERCURAGO',
				'SANT\'OMOBONO TERME',
			),
			'BS' => array(
				'ACQUAFREDDA',
				'ADRO',
				'AGNOSINE',
				'ALFIANELLO',
				'ANFO',
				'ANGOLO TERME',
				'ARTOGNE',
				'AZZANO MELLA',
				'BAGNOLO MELLA',
				'BAGOLINO',
				'BARBARIGA',
				'BARGHE',
				'BASSANO BRESCIANO',
				'BEDIZZOLE',
				'BERLINGO',
				'BERZO DEMO',
				'BERZO INFERIORE',
				'BIENNO',
				'BIONE',
				'BORGO SAN GIACOMO',
				'BORGOSATOLLO',
				'BORNO',
				'BOTTICINO',
				'BOVEGNO',
				'BOVEZZO',
				'BRANDICO',
				'BRAONE',
				'BRENO',
				'BRESCIA',
				'BRIONE',
				'CAINO',
				'CALCINATO',
				'CALVAGESE DELLA RIVIERA',
				'CALVISANO',
				'CAPO DI PONTE',
				'CAPOVALLE',
				'CAPRIANO DEL COLLE',
				'CAPRIOLO',
				'CARPENEDOLO',
				'CASTEGNATO',
				'CASTELCOVATI',
				'CASTEL MELLA',
				'CASTENEDOLO',
				'CASTO',
				'CASTREZZATO',
				'CAZZAGO SAN MARTINO',
				'CEDEGOLO',
				'CELLATICA',
				'CERVENO',
				'CETO',
				'CEVO',
				'CHIARI',
				'CIGOLE',
				'CIMBERGO',
				'CIVIDATE CAMUNO',
				'COCCAGLIO',
				'COLLEBEATO',
				'COLLIO',
				'COLOGNE',
				'COMEZZANO-CIZZAGO',
				'CONCESIO',
				'CORTE FRANCA',
				'CORTENO GOLGI',
				'CORZANO',
				'DARFO BOARIO TERME',
				'DELLO',
				'DESENZANO DEL GARDA',
				'EDOLO',
				'ERBUSCO',
				'ESINE',
				'FIESSE',
				'FLERO',
				'GAMBARA',
				'GARDONE RIVIERA',
				'GARDONE VAL TROMPIA',
				'GARGNANO',
				'GAVARDO',
				'GHEDI',
				'GIANICO',
				'GOTTOLENGO',
				'GUSSAGO',
				'IDRO',
				'INCUDINE',
				'IRMA',
				'ISEO',
				'ISORELLA',
				'LAVENONE',
				'LENO',
				'LIMONE SUL GARDA',
				'LODRINO',
				'LOGRATO',
				'LONATO',
				'LONGHENA',
				'LOSINE',
				'LOZIO',
				'LUMEZZANE',
				'MACLODIO',
				'MAGASA',
				'MAIRANO',
				'MALEGNO',
				'MALONNO',
				'MANERBA DEL GARDA',
				'MANERBIO',
				'MARCHENO',
				'MARMENTINO',
				'MARONE',
				'MAZZANO',
				'MILZANO',
				'MONIGA DEL GARDA',
				'MONNO',
				'MONTE ISOLA',
				'MONTICELLI BRUSATI',
				'MONTICHIARI',
				'MONTIRONE',
				'MURA',
				'MUSCOLINE',
				'NAVE',
				'NIARDO',
				'NUVOLENTO',
				'NUVOLERA',
				'ODOLO',
				'OFFLAGA',
				'OME',
				'ONO SAN PIETRO',
				'ORZINUOVI',
				'ORZIVECCHI',
				'OSPITALETTO BRESCIANO',
				'OSSIMO',
				'PADENGHE SUL GARDA',
				'PADERNO FRANCIACORTA',
				'PAISCO LOVENO',
				'PAITONE',
				'PALAZZOLO SULL\'OGLIO',
				'PARATICO',
				'PASPARDO',
				'PASSIRANO',
				'PAVONE DEL MELLA',
				'SAN PAOLO',
				'PERTICA ALTA',
				'PERTICA BASSA',
				'PEZZAZE',
				'PIAN CAMUNO',
				'PISOGNE',
				'POLAVENO',
				'POLPENAZZE',
				'POMPIANO',
				'PONCARALE',
				'PONTE DI LEGNO',
				'PONTEVICO',
				'PONTOGLIO',
				'POZZOLENGO',
				'PRALBOINO',
				'PRESEGLIE',
				'PRESTINE',
				'PREVALLE',
				'PROVAGLIO D\'ISEO',
				'PROVAGLIO VAL SABBIA',
				'PUEGNAGO SUL GARDA',
				'QUINZANO D\'OGLIO',
				'REMEDELLO',
				'REZZATO',
				'ROCCAFRANCA',
				'RODENGO-SAIANO',
				'ROE\' VOLCIANO',
				'RONCADELLE',
				'ROVATO',
				'RUDIANO',
				'SABBIO CHIESE',
				'SALE MARASINO',
				'SALO\'',
				'SAN FELICE DEL BENACO',
				'SAN GERVASIO BRESCIANO',
				'SAN ZENO NAVIGLIO',
				'SAREZZO',
				'SAVIORE DELL\'ADAMELLO',
				'SELLERO',
				'SENIGA',
				'SERLE',
				'SIRMIONE',
				'SOIANO DEL LAGO',
				'SONICO',
				'SULZANO',
				'TAVERNOLE SUL MELLA',
				'TEMU\'',
				'TIGNALE',
				'TORBOLE CASAGLIA',
				'TOSCOLANO MADERNO',
				'TRAVAGLIATO',
				'TREMOSINE',
				'TRENZANO',
				'TREVISO BRESCIANO',
				'URAGO D\'OGLIO',
				'VALLIO',
				'VALVESTINO',
				'VEROLANUOVA',
				'VEROLAVECCHIA',
				'VESTONE',
				'VEZZA D\'OGLIO',
				'VILLA CARCINA',
				'VILLACHIARA',
				'VILLANUOVA SUL CLISI',
				'VIONE',
				'VISANO',
				'VOBARNO',
				'ZONE',
				'PIANCOGNO',
				'ACQUALUNGA',
				'ALONE',
				'ANFURRO',
				'ARMO',
				'AVENONE',
				'BARCO',
				'BEL PRATO',
				'BORGONATO',
				'BORNATO',
				'BOTTICINO MATTINA',
				'BOTTICINO SERA',
				'BROZZO',
				'BURAGO RIVIERA',
				'CAMPOVERDE',
				'CADIGNANO',
				'CAJONVICO',
				'CALINO',
				'CAMIGNONE',
				'CAPRIANO-AZZANO',
				'CARCINA',
				'CARZAGO DELLA RIVIERA',
				'CASTREZZONE',
				'CETO-CERVENO',
				'CIGNANO',
				'CILIVERGHE',
				'CIMBERGO-PASPARDO',
				'CIVIDATE-MALEGNO',
				'CIZZAGO',
				'CLUSANE SUL LAGO',
				'COLOMBARO',
				'COMERO',
				'COMEZZANO',
				'CORTENEDOLO',
				'CORTICELLE PIEVE',
				'COSSIRANO',
				'CREMEZZANO',
				'DEGAGNA',
				'ERBANNO',
				'FARFENGO',
				'FAVERZANO',
				'FIUMICELLO URAGO',
				'FOLZANO',
				'FRONTIGNANO',
				'GEROLANUOVA',
				'GOGLIONE SOPRA',
				'GOGLIONE SOTTO',
				'GORZONE',
				'INZINO',
				'LEVRANGE',
				'LIVEMMO',
				'LOVENO GRUMELLO',
				'LUDRIANO',
				'LUMEZZANE PIEVE',
				'LUMEZZANE SAN SEBASTIANO',
				'LUMEZZANE SANT\'APOLLONIO',
				'MADERNO',
				'MAGNO SOPRA INZINO',
				'MAZZUNNO',
				'MILZANELLO',
				'MOMPIANO',
				'MU',
				'NAVONO',
				'NIGOLINE',
				'NOZZA',
				'ONO DEGNO',
				'ORIANO',
				'PADERNELLO',
				'PAISCO',
				'PESCHIERA MARAGLIO',
				'PEZZORO',
				'PIAN D\'ARTOGNE',
				'PILZONE',
				'PONCARALE FLERO',
				'PONTAGNA',
				'PORTESE',
				'PORZANO',
				'PRANDAGLIO',
				'PRESEGNO',
				'PROVAGLIO SOPRA',
				'PROVAGLIO SOTTO',
				'PROVEZZE',
				'QUINZANELLO',
				'RAFFA',
				'REMEDELLO SOPRA',
				'REMEDELLO SOTTO',
				'RIVOLTELLA SUL GARDA',
				'RODENGO',
				'SAIANO',
				'SAN BARTOLOMEO',
				'SAN FELICE DI SCOVOLO',
				'SAN NAZZARO MELLA',
				'SANT\'EUFEMIA DELLA FONTE',
				'SANT\'ALESSANDRO',
				'SANTICOLO',
				'SAN VIGILIO',
				'SCARPIZZOLO',
				'SIVIANO',
				'SOPRAPONTE',
				'SOPRAZOCCO',
				'TERZANO',
				'TIMOLINE',
				'TORBIATO',
				'TOSCOLANO',
				'URAGO MELLA',
				'VALSAVIORE',
				'VELLO',
				'VILLA COGOZZO',
				'VILLA D\'ALLEGNO',
				'VIRLE TRE PONTI',
				'LONATO DEL GARDA',
				'VALLIO TERME',
			),
			'PV' => array(
				'ALAGNA',
				'ALBAREDO ARNABOLDI',
				'ALBONESE',
				'ALBUZZANO',
				'ARENA PO',
				'BADIA PAVESE',
				'BAGNARIA',
				'BARBIANELLO',
				'BASCAPE\'',
				'BASTIDA DE\' DOSSI',
				'BASTIDA PANCARANA',
				'BATTUDA',
				'BELGIOIOSO',
				'BEREGUARDO',
				'BORGARELLO',
				'BORGO PRIOLO',
				'BORGORATTO MORMOROLO',
				'BORGO SAN SIRO',
				'BORNASCO',
				'BOSNASCO',
				'BRALLO DI PREGOLA',
				'BREME',
				'BRESSANA BOTTARONE',
				'BRONI',
				'CALVIGNANO',
				'CAMPOSPINOSO',
				'CANDIA LOMELLINA',
				'CANEVINO',
				'CANNETO PAVESE',
				'CARBONARA AL TICINO',
				'CASANOVA LONATI',
				'CASATISMA',
				'CASEI GEROLA',
				'CASORATE PRIMO',
				'CASSOLNOVO',
				'CASTANA',
				'CASTEGGIO',
				'CASTELLETTO DI BRANDUZZO',
				'CASTELLO D\'AGOGNA',
				'CASTELNOVETTO',
				'CAVA MANARA',
				'CECIMA',
				'CERANOVA',
				'CERETTO LOMELLINA',
				'CERGNAGO',
				'CERTOSA DI PAVIA',
				'CERVESINA',
				'CHIGNOLO PO',
				'CIGOGNOLA',
				'CILAVEGNA',
				'CODEVILLA',
				'CONFIENZA',
				'COPIANO',
				'CORANA',
				'CORNALE',
				'CORTEOLONA',
				'CORVINO SAN QUIRICO',
				'COSTA DE\' NOBILI',
				'COZZO',
				'CURA CARPIGNANO',
				'DORNO',
				'FERRERA ERBOGNONE',
				'FILIGHERA',
				'FORTUNAGO',
				'FRASCAROLO',
				'GALLIAVOLA',
				'GAMBARANA',
				'GAMBOLO\'',
				'GARLASCO',
				'GENZONE',
				'GERENZAGO',
				'GIUSSAGO',
				'GODIASCO',
				'GOLFERENZO',
				'GRAVELLONA LOMELLINA',
				'GROPELLO CAIROLI',
				'INVERNO E MONTELEONE',
				'LANDRIANO',
				'LANGOSCO',
				'LARDIRAGO',
				'LINAROLO',
				'LIRIO',
				'LOMELLO',
				'LUNGAVILLA',
				'MAGHERNO',
				'MARCIGNAGO',
				'MARZANO',
				'MEDE',
				'MENCONICO',
				'MEZZANA BIGLI',
				'MEZZANA RABATTONE',
				'MEZZANINO',
				'MIRADOLO TERME',
				'MONTALTO PAVESE',
				'MONTEBELLO DELLA BATTAGLIA',
				'MONTECALVO VERSIGGIA',
				'MONTESCANO',
				'MONTESEGALE',
				'MONTICELLI PAVESE',
				'MONTU\' BECCARIA',
				'MORNICO LOSANA',
				'MORTARA',
				'NICORVO',
				'OLEVANO DI LOMELLINA',
				'OLIVA GESSI',
				'OTTOBIANO',
				'PALESTRO',
				'PANCARANA',
				'PARONA',
				'PAVIA',
				'PIETRA DE\' GIORGI',
				'PIEVE ALBIGNOLA',
				'PIEVE DEL CAIRO',
				'PIEVE PORTO MORONE',
				'PINAROLO PO',
				'PIZZALE',
				'PONTE NIZZA',
				'PORTALBERA',
				'REA',
				'REDAVALLE',
				'RETORBIDO',
				'RIVANAZZANO',
				'ROBBIO',
				'ROBECCO PAVESE',
				'ROCCA DE\' GIORGI',
				'ROCCA SUSELLA',
				'ROGNANO',
				'ROMAGNESE',
				'RONCARO',
				'ROSASCO',
				'ROVESCALA',
				'RUINO',
				'SAN CIPRIANO PO',
				'SAN DAMIANO AL COLLE',
				'SAN GENESIO ED UNITI',
				'SAN GIORGIO DI LOMELLINA',
				'SAN MARTINO SICCOMARIO',
				'SANNAZZARO DE\' BURGONDI',
				'SANTA CRISTINA E BISSONE',
				'SANTA GIULETTA',
				'SANT\'ALESSIO CON VIALONE',
				'SANTA MARGHERITA DI STAFFORA',
				'SANTA MARIA DELLA VERSA',
				'SANT\'ANGELO LOMELLINA',
				'SAN ZENONE AL PO',
				'SARTIRANA LOMELLINA',
				'SCALDASOLE',
				'SEMIANA',
				'SILVANO PIETRA',
				'SIZIANO',
				'SOMMO',
				'SPESSA',
				'STRADELLA',
				'SUARDI',
				'TORRAZZA COSTE',
				'TORRE BERETTI E CASTELLARO',
				'TORRE D\'ARESE',
				'TORRE DEI NEGRI',
				'TORRE D\'ISOLA',
				'TORREVECCHIA PIA',
				'TORRICELLA VERZATE',
				'TRAVACO\' SICCOMARIO',
				'TRIVOLZIO',
				'TROMELLO',
				'TROVO',
				'VAL DI NIZZA',
				'VALEGGIO',
				'VALLE LOMELLINA',
				'VALLE SALIMBENE',
				'VALVERDE',
				'VARZI',
				'VELEZZO LOMELLINA',
				'VELLEZZO BELLINI',
				'VERRETTO',
				'VERRUA PO',
				'VIDIGULFO',
				'VIGEVANO',
				'VILLA BISCOSSI',
				'VILLANOVA D\'ARDENGHI',
				'VILLANTERIO',
				'VISTARINO',
				'VOGHERA',
				'VOLPARA',
				'ZAVATTARELLO',
				'ZECCONE',
				'ZEME',
				'ZENEVREDO',
				'ZERBO',
				'ZERBOLO\'',
				'ZINASCO',
				'CORNALE E BASTIDA',
				'CORTEOLONA E GENZONE',
				'ARGINE PO',
				'BARONA',
				'BASELICA BOLOGNA',
				'BELVEDERE AL PO',
				'BOTTARONE',
				'BRANDUZZO',
				'BUTTIRAGO',
				'CA\' DELLA TERRA',
				'CA\' DE\' TEDIOLI',
				'CAIRO LOMELLINO',
				'CALIGNANO',
				'CAMBIO\'',
				'CAMPOMORTO',
				'CAMPO RINALDO',
				'CAMPOSPINOSO ALBAREDO',
				'CARPIGNAGO',
				'CASATICO',
				'CASSINE CALDERARI',
				'CASSINE SIRIGARI',
				'CASSINE TOLENTINE',
				'CASSINO PO',
				'CASTEL LAMBRO',
				'CASTELLARO DE\' GIORGI',
				'CASTELLETTO PO',
				'CAVAGNERA',
				'CELLA DI BOBBIO',
				'CELPENCHIO',
				'COMAIRANO',
				'CORBESATE',
				'CORPI SANTI DI PAVIA',
				'DONELASCO',
				'FOPPA',
				'FOSSARMATO',
				'GERRE CHIOZZO',
				'GIOVENZANO',
				'GOIDO',
				'GUALDRASCO',
				'GUINZANO',
				'LICONASCO',
				'MANDRINO',
				'MANGIALUPO',
				'MEZZANO PARPANESE',
				'MEZZANO SICCOMARIO',
				'MIRABELLO ED UNITI DI PAVIA',
				'MISANO OLONA',
				'MONTE BOLOGNOLA',
				'MONTELEONE SUI COLLI PAVESI',
				'MONTESANO AL PIANO',
				'MONTU\' BERCHIELLI',
				'MOTTA SAN DAMIANO',
				'ORIGIOSO',
				'PAIRANA',
				'PAPIAGO',
				'PIETRA GAVINA',
				'PISSARELLO',
				'PIZZOCORNO',
				'POMETO',
				'PONTE CARATE',
				'PRADO',
				'SAGLIANO DI CRENNA',
				'SAN PERONE',
				'SAN PONZO SEMOLA',
				'SANT\'ALBANO DI BOBBIO',
				'SANTA MARGHERITA DI BOBBIO',
				'SANTA MARGHERITA PO',
				'SAN VARESE',
				'SAN ZENO E FOPPA',
				'SPIRAGO',
				'STAGHIGLIONE',
				'TERRASA',
				'TORRADELLO',
				'TORRE BERETTI',
				'TORRE DEL MANGANO',
				'TORRE DEL MONTE',
				'TORRE DE\' TORTI',
				'TORRIANO',
				'TORRINO',
				'TREBBIANO NIZZA',
				'TROGNANO',
				'TURAGO BORDONE',
				'VACCARIZZA',
				'VAIRANO PAVESE',
				'VERRUA SICCOMARIO',
				'VIGALFO',
				'VIGONZONE',
				'VILLALUNGA',
				'VILLAREGGIO',
				'VIMANONE',
				'VIVENTE',
				'ZAVATTARELLO VALVERDE',
				'ZELATA',
				'ZIBIDO AL LAMBRO',
				'GODIASCO SALICE TERME',
				'RIVANAZZANO TERME',
			),
			'CR' => array(
				'ACQUANEGRA CREMONESE',
				'AGNADELLO',
				'ANNICCO',
				'AZZANELLO',
				'BAGNOLO CREMASCO',
				'BONEMERSE',
				'BORDOLANO',
				'CA\' D\'ANDREA',
				'CALVATONE',
				'CAMISANO',
				'CAMPAGNOLA CREMASCA',
				'CAPERGNANICA',
				'CAPPELLA CANTONE',
				'CAPPELLA DE\' PICENARDI',
				'CAPRALBA',
				'CASALBUTTANO ED UNITI',
				'CASALE CREMASCO-VIDOLASCO',
				'CASALETTO CEREDANO',
				'CASALETTO DI SOPRA',
				'CASALETTO VAPRIO',
				'CASALMAGGIORE',
				'CASALMORANO',
				'CASTELDIDONE',
				'CASTEL GABBIANO',
				'CASTELLEONE',
				'CASTELVERDE',
				'CASTELVISCONTI',
				'CELLA DATI',
				'CHIEVE',
				'CICOGNOLO',
				'CINGIA DE\' BOTTI',
				'CORTE DE\' CORTESI CON CIGNONE',
				'CORTE DE\' FRATI',
				'CREDERA RUBBIANO',
				'CREMA',
				'CREMONA',
				'CREMOSANO',
				'CROTTA D\'ADDA',
				'CUMIGNANO SUL NAVIGLIO',
				'DEROVERE',
				'DOVERA',
				'DRIZZONA',
				'FIESCO',
				'FORMIGARA',
				'GABBIONETA BINANUOVA',
				'GADESCO PIEVE DELMONA',
				'GENIVOLTA',
				'GERRE DE\' CAPRIOLI',
				'GOMBITO',
				'GRONTARDO',
				'GRUMELLO CREMONESE ED UNITI',
				'GUSSOLA',
				'ISOLA DOVARESE',
				'IZANO',
				'MADIGNANO',
				'MALAGNINO',
				'MARTIGNANA DI PO',
				'MONTE CREMASCO',
				'MONTODINE',
				'MOSCAZZANO',
				'MOTTA BALUFFI',
				'OFFANENGO',
				'OLMENETA',
				'OSTIANO',
				'PADERNO PONCHIELLI',
				'PALAZZO PIGNANO',
				'PANDINO',
				'PERSICO DOSIMO',
				'PESCAROLO ED UNITI',
				'PESSINA CREMONESE',
				'PIADENA',
				'PIANENGO',
				'PIERANICA',
				'PIEVE D\'OLMI',
				'PIEVE SAN GIACOMO',
				'PIZZIGHETTONE',
				'POZZAGLIO ED UNITI',
				'QUINTANO',
				'RICENGO',
				'RIPALTA ARPINA',
				'RIPALTA CREMASCA',
				'RIPALTA GUERINA',
				'RIVAROLO DEL RE ED UNITI',
				'RIVOLTA D\'ADDA',
				'ROBECCO D\'OGLIO',
				'ROMANENGO',
				'SALVIROLA',
				'SAN BASSANO',
				'SAN DANIELE PO',
				'SAN GIOVANNI IN CROCE',
				'SAN MARTINO DEL LAGO',
				'SCANDOLARA RAVARA',
				'SCANDOLARA RIPA D\'OGLIO',
				'SERGNANO',
				'SESTO ED UNITI',
				'SOLAROLO RAINERIO',
				'SONCINO',
				'SORESINA',
				'SOSPIRO',
				'SPINADESCO',
				'SPINEDA',
				'SPINO D\'ADDA',
				'STAGNO LOMBARDO',
				'TICENGO',
				'TORLINO VIMERCATI',
				'TORNATA',
				'TORRE DE\' PICENARDI',
				'TORRICELLA DEL PIZZO',
				'TRESCORE CREMASCO',
				'TRIGOLO',
				'VAIANO CREMASCO',
				'VAILATE',
				'VESCOVATO',
				'VOLONGO',
				'VOLTIDO',
				'ACQUALUNGA BADONA',
				'TRIBURGO',
				'ALFIANO ED UNITI',
				'ARDOLE SAN MARINO',
				'BAGNAROLO',
				'BARBISELLE',
				'BARZANIGA',
				'BETTENESCO',
				'BINANUOVA',
				'BOTTAIANO',
				'BRANCERE',
				'BREDA GUAZZONE',
				'BROLPASINO',
				'CA\' DE\' BONAVOGLI',
				'CA\' DE\' CAGGI',
				'CA\' DE\' CORTI',
				'CA\' DE\' QUINZANI',
				'CA\' DE\' SFONDRATI',
				'CA\' DE\' SORESINI',
				'CA\' DE\' STAOLI',
				'CA\' DE\' STEFANI',
				'CANOVA DEL MORBASCO',
				'CANOVA OLZANO',
				'CANSERO',
				'CARPANETA CON DOSIMO',
				'CARUBERTO',
				'CASALE CREMASCO',
				'CASALORZO GEROLDI',
				'CASALSIGONE',
				'CASANUOVA OFFREDI',
				'CASCINE',
				'CASCINE GANDINI',
				'CASTELFRANCO D\'OGLIO',
				'CASTELNUOVO CREMASCO',
				'CASTELNUOVO DEL VESCOVO',
				'CASTELNUOVO DEL ZAPPA',
				'CASTELNUOVO GHERARDI',
				'CASTELPONZONE',
				'CAVALLARA',
				'CAVA TIGOZZI',
				'CELLA',
				'CIGNONE',
				'COLOMBAROLO',
				'CORPI SANTI DI CREMONA',
				'CORTE DE\' CORTESI',
				'CORTE MADAMA',
				'CORTETANO',
				'COSTA SANT\'ABRAMO',
				'CREDERA',
				'DOSSO BAROARDO',
				'DOSSO DE\' FRATI',
				'DUEMIGLIA',
				'FARINATE',
				'FENGO',
				'FORCELLO',
				'FOSSA GUAZZONA',
				'FRACCHIA',
				'GABBIONETA',
				'GADESCO',
				'GAMBINA BARCHETTI',
				'GANDINI',
				'GAZZO',
				'GERE DEL PESCE',
				'GRADELLA',
				'GRONTORTO',
				'ISOLA PESCAROLI',
				'ISOLELLO',
				'LEVATA',
				'LICENGO',
				'LONGARDORE',
				'LUIGNANO',
				'MARZALENGO',
				'MIRABELLO CIRIA',
				'MONTANARA',
				'MONTICELLI RIPA D\'OGLIO',
				'NOSADELLO',
				'OMBRIANO',
				'OSSALENGO',
				'OSSOLARO',
				'PADERNO CREMONESE',
				'PALVARETO',
				'PASSARERA',
				'PERSICO',
				'PIEVE DELMONA',
				'PIEVE SAN MAURIZIO',
				'PIEVE TERZAGNI',
				'POLENGO',
				'PONTIROLO CAPREDONI',
				'PORTA OMBRIANO',
				'POZZAGLIO',
				'POZZO BARONZIO',
				'PRATO MUZIO',
				'QUISTRO',
				'RECORFANO',
				'RIPALTA NUOVA',
				'RIPALTA VECCHIA',
				'ROMPREZZAGNO',
				'RONCA DE\' GOLFERANI',
				'RONCADELLO D\'ADDA',
				'RUBBIANO',
				'SAN BERNARDINO',
				'SAN LORENZO AROLDO',
				'SAN LORENZO DE\' PICENARDI',
				'SAN LORENZO GUAZZONE',
				'SAN LORENZO MONDINARI',
				'SAN MARTINO IN BELISETO',
				'SAN MICHELE CREMASCO',
				'SAN PAOLO RIPA D\'OGLIO',
				'SAN SALVATORE',
				'SAN SAVINO',
				'SAN SILLO',
				'SANTA MARIA DELLA CROCE',
				'SAN VITO E MODESTO',
				'SCANNABUE',
				'SILVELLA',
				'SOLAROLO DEL PERSICO',
				'SOLAROLO MONASTEROLO',
				'STILO DE\' MARIANI',
				'STRACONDOLO',
				'TORRE D\'ANGIOLINI',
				'TREDOSSI',
				'TREZZOLASCO',
				'VAIRANO CREMASCO',
				'VHO',
				'VIDICETO CON GURATA',
				'VIDOLASCO',
				'VIGHIZZOLO',
				'VILLAROCCA',
				'ZANENGO',
				'ZAPPELLO CON BOLZONE',
				'CASANOVA DEL MORBASCO',
				'CREDERA CON ROVERETO',
				'ROVERETO',
			),
			'MN' => array(
				'ACQUANEGRA SUL CHIESE',
				'ASOLA',
				'BAGNOLO SAN VITO',
				'BIGARELLO',
				'BORGOFORTE',
				'BORGOFRANCO SUL PO',
				'BOZZOLO',
				'CANNETO SULL\'OGLIO',
				'CARBONARA DI PO',
				'CASALMORO',
				'CASALOLDO',
				'CASALROMANO',
				'CASTELBELFORTE',
				'CASTEL D\'ARIO',
				'CASTEL GOFFREDO',
				'CASTELLUCCHIO',
				'CASTIGLIONE DELLE STIVIERE',
				'CAVRIANA',
				'CERESARA',
				'COMMESSAGGIO',
				'CURTATONE',
				'DOSOLO',
				'FELONICA',
				'GAZOLDO DEGLI IPPOLITI',
				'GAZZUOLO',
				'GOITO',
				'GONZAGA',
				'GUIDIZZOLO',
				'MAGNACAVALLO',
				'MANTOVA',
				'MARCARIA',
				'MARIANA MANTOVANA',
				'MARMIROLO',
				'MEDOLE',
				'MOGLIA',
				'MONZAMBANO',
				'MOTTEGGIANA',
				'OSTIGLIA',
				'PEGOGNAGA',
				'PIEVE DI CORIANO',
				'PIUBEGA',
				'POGGIO RUSCO',
				'POMPONESCO',
				'PONTI SUL MINCIO',
				'PORTO MANTOVANO',
				'QUINGENTOLE',
				'QUISTELLO',
				'REDONDESCO',
				'REVERE',
				'RIVAROLO MANTOVANO',
				'RODIGO',
				'RONCOFERRARO',
				'ROVERBELLA',
				'SABBIONETA',
				'SAN BENEDETTO PO',
				'SAN GIACOMO DELLE SEGNATE',
				'SAN GIORGIO DI MANTOVA',
				'SAN GIOVANNI DEL DOSSO',
				'SAN MARTINO DALL\'ARGINE',
				'SCHIVENOGLIA',
				'SERMIDE',
				'SERRAVALLE A PO',
				'SOLFERINO',
				'SUSTINENTE',
				'SUZZARA',
				'VIADANA',
				'VILLA POMA',
				'VILLIMPENTA',
				'VIRGILIO',
				'VOLTA MANTOVANA',
				'BORGO VIRGILIO',
				'CASALPOGLIO',
			),
			'LC' => array(
				'ABBADIA LARIANA',
				'AIRUNO',
				'ANNONE DI BRIANZA',
				'BALLABIO',
				'BARZAGO',
				'BARZANO\'',
				'BARZIO',
				'BELLANO',
				'BOSISIO PARINI',
				'BRIVIO',
				'BULCIAGO',
				'CALCO',
				'CALOLZIOCORTE',
				'CARENNO',
				'CASARGO',
				'CASATENOVO',
				'CASSAGO BRIANZA',
				'CASSINA VALSASSINA',
				'CASTELLO DI BRIANZA',
				'CERNUSCO LOMBARDONE',
				'CESANA BRIANZA',
				'CIVATE',
				'COLICO',
				'COLLE BRIANZA',
				'CORTENOVA',
				'COSTA MASNAGA',
				'CRANDOLA VALSASSINA',
				'CREMELLA',
				'CREMENO',
				'DERVIO',
				'DOLZAGO',
				'DORIO',
				'ELLO',
				'ERVE',
				'ESINO LARIO',
				'GALBIATE',
				'GARBAGNATE MONASTERO',
				'GARLATE',
				'IMBERSAGO',
				'INTROBIO',
				'INTROZZO',
				'LECCO',
				'LIERNA',
				'LOMAGNA',
				'MALGRATE',
				'MANDELLO DEL LARIO',
				'MARGNO',
				'MERATE',
				'MISSAGLIA',
				'MOGGIO',
				'MOLTENO',
				'MONTE MARENZO',
				'MONTEVECCHIA',
				'MONTICELLO BRIANZA',
				'MORTERONE',
				'NIBIONNO',
				'OGGIONO',
				'OLGIATE MOLGORA',
				'OLGINATE',
				'OLIVETO LARIO',
				'OSNAGO',
				'PADERNO D\'ADDA',
				'PAGNONA',
				'PARLASCO',
				'PASTURO',
				'PEREGO',
				'PERLEDO',
				'PESCATE',
				'PREMANA',
				'PRIMALUNA',
				'ROBBIATE',
				'ROGENO',
				'ROVAGNATE',
				'SANTA MARIA HOE\'',
				'SIRONE',
				'SIRTORI',
				'SUEGLIO',
				'SUELLO',
				'TACENO',
				'TORRE DE\' BUSI',
				'TREMENICO',
				'VALGREGHENTINO',
				'VALMADRERA',
				'VARENNA',
				'VENDROGNO',
				'VERCURAGO',
				'VERDERIO INFERIORE',
				'VERDERIO SUPERIORE',
				'VESTRENO',
				'VIGANO\'',
				'VERDERIO',
				'LA VALLETTA BRIANZA',
			),
			'LO' => array(
				'ABBADIA CERRETO',
				'BERTONICO',
				'BOFFALORA D\'ADDA',
				'BORGHETTO LODIGIANO',
				'BORGO SAN GIOVANNI',
				'BREMBIO',
				'CAMAIRAGO',
				'CASALETTO LODIGIANO',
				'CASALMAIOCCO',
				'CASALPUSTERLENGO',
				'CASELLE LANDI',
				'CASELLE LURANI',
				'CASTELNUOVO BOCCA D\'ADDA',
				'CASTIGLIONE D\'ADDA',
				'CASTIRAGA VIDARDO',
				'CAVACURTA',
				'CAVENAGO D\'ADDA',
				'CERVIGNANO D\'ADDA',
				'CODOGNO',
				'COMAZZO',
				'CORNEGLIANO LAUDENSE',
				'CORNO GIOVINE',
				'CORNOVECCHIO',
				'CORTE PALASIO',
				'CRESPIATICA',
				'FOMBIO',
				'GALGAGNANO',
				'GRAFFIGNANA',
				'GUARDAMIGLIO',
				'LIVRAGA',
				'LODI',
				'LODI VECCHIO',
				'MACCASTORNA',
				'MAIRAGO',
				'MALEO',
				'MARUDO',
				'MASSALENGO',
				'MELETI',
				'MERLINO',
				'MONTANASO LOMBARDO',
				'MULAZZANO',
				'ORIO LITTA',
				'OSPEDALETTO LODIGIANO',
				'OSSAGO LODIGIANO',
				'PIEVE FISSIRAGA',
				'SALERANO SUL LAMBRO',
				'SAN FIORANO',
				'SAN MARTINO IN STRADA',
				'SAN ROCCO AL PORTO',
				'SANT\'ANGELO LODIGIANO',
				'SANTO STEFANO LODIGIANO',
				'SECUGNAGO',
				'SENNA LODIGIANA',
				'SOMAGLIA',
				'SORDIO',
				'TAVAZZANO CON VILLAVESCO',
				'TERRANOVA DEI PASSERINI',
				'TURANO LODIGIANO',
				'VALERA FRATTA',
				'VILLANOVA DEL SILLARO',
				'ZELO BUON PERSICO',
			),
			'MB' => array(
				'AGRATE BRIANZA',
				'AICURZIO',
				'ALBIATE',
				'ARCORE',
				'BARLASSINA',
				'BELLUSCO',
				'BERNAREGGIO',
				'BESANA IN BRIANZA',
				'BIASSONO',
				'BOVISIO-MASCIAGO',
				'BRIOSCO',
				'BRUGHERIO',
				'BURAGO DI MOLGORA',
				'CAMPARADA',
				'CARATE BRIANZA',
				'CARNATE',
				'CAVENAGO DI BRIANZA',
				'CERIANO LAGHETTO',
				'CESANO MADERNO',
				'COGLIATE',
				'CONCOREZZO',
				'CORREZZANA',
				'DESIO',
				'GIUSSANO',
				'LAZZATE',
				'LESMO',
				'LIMBIATE',
				'LISSONE',
				'MACHERIO',
				'MEDA',
				'MEZZAGO',
				'MISINTO',
				'MONZA',
				'MUGGIO\'',
				'NOVA MILANESE',
				'ORNAGO',
				'RENATE',
				'RONCO BRIANTINO',
				'SEREGNO',
				'SEVESO',
				'SOVICO',
				'SULBIATE',
				'TRIUGGIO',
				'USMATE VELATE',
				'VAREDO',
				'VEDANO AL LAMBRO',
				'VEDUGGIO CON COLZANO',
				'VERANO BRIANZA',
				'VILLASANTA',
				'VIMERCATE',
				'BUSNAGO',
				'CAPONAGO',
				'CORNATE D\'ADDA',
				'LENTATE SUL SEVESO',
				'RONCELLO',
			),
			'BZ' => array(
				'ALDINO',
				'ANDRIANO',
				'ANTERIVO',
				'APPIANO SULLA STRADA DEL VINO',
				'AVELENGO',
				'BADIA',
				'BARBIANO',
				'BOLZANO',
				'BRAIES',
				'BRENNERO',
				'BRESSANONE',
				'BRONZOLO',
				'BRUNICO',
				'CAINES',
				'CALDARO SULLA STRADA DEL VINO',
				'CAMPO DI TRENS',
				'CAMPO TURES',
				'CASTELBELLO CIARDES',
				'CASTELROTTO',
				'CERMES',
				'CHIENES',
				'CHIUSA',
				'CORNEDO ALL\'ISARCO',
				'CORTACCIA SULLA STRADA DEL VINO',
				'CORTINA SULLA STRADA DEL VINO',
				'CORVARA IN BADIA',
				'CURON VENOSTA',
				'DOBBIACO',
				'EGNA',
				'FALZES',
				'FIE\' ALLO SCILIAR',
				'FORTEZZA',
				'FUNES',
				'GAIS',
				'GARGAZZONE',
				'GLORENZA',
				'LACES',
				'LAGUNDO',
				'LAION',
				'LAIVES',
				'LANA',
				'LASA',
				'LAUREGNO',
				'LUSON',
				'MAGRE\' SULLA STRADA DEL VINO',
				'MALLES VENOSTA',
				'MAREBBE',
				'MARLENGO',
				'MARTELLO',
				'MELTINA',
				'MERANO',
				'MONGUELFO',
				'MONTAGNA',
				'MOSO IN PASSIRIA',
				'NALLES',
				'NATURNO',
				'NAZ SCIAVES',
				'NOVA LEVANTE',
				'NOVA PONENTE',
				'ORA',
				'ORTISEI',
				'PARCINES',
				'PERCA',
				'PLAUS',
				'PONTE GARDENA',
				'POSTAL',
				'PRATO ALLO STELVIO',
				'PREDOI',
				'PROVES',
				'RACINES',
				'RASUN ANTERSELVA',
				'RENON',
				'RIFIANO',
				'RIO DI PUSTERIA',
				'RODENGO',
				'SALORNO',
				'SAN CANDIDO',
				'SAN GENESIO ATESINO',
				'SAN LEONARDO IN PASSIRIA',
				'SAN LORENZO DI SEBATO',
				'SAN MARTINO IN BADIA',
				'SAN MARTINO IN PASSIRIA',
				'SAN PANCRAZIO',
				'SANTA CRISTINA VALGARDENA',
				'SARENTINO',
				'SCENA',
				'SELVA DEI MOLINI',
				'SELVA DI VAL GARDENA',
				'SENALES',
				'SESTO',
				'SILANDRO',
				'SLUDERNO',
				'STELVIO',
				'TERENTO',
				'TERLANO',
				'TERMENO SULLA STRADA DEL VINO',
				'TESIMO',
				'TIRES',
				'TIROLO',
				'TRODENA',
				'TUBRE',
				'ULTIMO',
				'VADENA',
				'VALDAORA',
				'VAL DI VIZZE',
				'VALLE AURINA',
				'VALLE DI CASIES',
				'VANDOIES',
				'VARNA',
				'VERANO',
				'VILLABASSA',
				'VILLANDRO',
				'VIPITENO',
				'VELTURNO',
				'LA VALLE',
				'SENALE-SAN FELICE',
				'ACERETO',
				'ALBES',
				'ALLIZ',
				'ANTERSELVA',
				'BURGUSIO',
				'CAMINATA IN TURES',
				'CASTELBELLO',
				'CASTELDARNE',
				'COVELANO',
				'CENGLES',
				'CEVES',
				'CIARDES',
				'ISSENGO',
				'CLUSIO',
				'COLDRANO',
				'COLFOSCO',
				'COLLE IN CASIES',
				'COLLI IN PUSTERIA',
				'COLSANO',
				'CURON',
				'CORTI IN PUSTERIA',
				'CORVARA IN PASSIRIA',
				'CORZES',
				'QUARAZZE',
				'ELLE',
				'EORES',
				'FAOGNA DI SOTTO',
				'FLERES',
				'FOIANA',
				'FUNDRES',
				'GRIES',
				'GRIMALDO',
				'GUDON',
				'LACINIGO',
				'LAPPAGO',
				'LAUDES',
				'LAZFONS',
				'LONGIARU\'',
				'LUTAGO',
				'MAIA ALTA',
				'MAIA BASSA',
				'MALLES',
				'MANTANA',
				'MARANZA',
				'MARETA',
				'MAZIA',
				'MILLAN-SARNESS',
				'MOLINI DI TURES',
				'MONGHEZZO DI FUORI',
				'MONTASSILONE',
				'MONTE DI MEZZODI\'',
				'MONTE DI TRAMONTANA',
				'MONTECHIARO',
				'MONTEFONTANA',
				'MONTEPONENTE',
				'MONTE SAN CANDIDO',
				'MORTER',
				'MULES',
				'NAZ',
				'NOVACELLA',
				'ONIES',
				'ORIS',
				'PLANOL',
				'PLATA',
				'PRATI',
				'PRATO ALLA DRAVA',
				'RISCONE',
				'RASUN DI SOPRA',
				'RASUN DI SOTTO',
				'RESIA',
				'RIDANNA',
				'RINA',
				'RIOMOLINO',
				'RIVA DI TURES',
				'SAN FELICE',
				'SAN GIACOMO',
				'SAN GIORGIO',
				'SAN GIOVANNI',
				'SAN LEONARDO',
				'SAN MARTINO AL MONTE',
				'SAN MARTINO IN CASIES',
				'SAN PIETRO',
				'SAN SIGISMONDO',
				'SANTA MADDALENA IN CASIES',
				'SANT\'ANDREA IN MONTE',
				'SAN VALENTINO AL BRENNERO',
				'SAN VALENTINO ALLA MUTTA',
				'SCALERES',
				'SCIAVES',
				'SLINGIA',
				'SPINGA',
				'STAVA',
				'STILVES',
				'TABLA',
				'TANAS',
				'TARCES',
				'TARRES',
				'TELVES',
				'TEODONE',
				'TESIDO',
				'TISO',
				'TRENS',
				'TUNES',
				'VALAS',
				'VALGIOVO',
				'VALLARGA',
				'VALLELUNGA',
				'VALLES',
				'VALLE SAN SILVESTRO',
				'VANDOIES DI SOPRA',
				'VANDOIES DI SOTTO',
				'VANGA',
				'VERSCIAGO',
				'VEZZANO',
				'VILLA OTTONE',
				'VILLA SANTA CATERINA',
				'VIZZE',
				'RASUN VALDAORA',
			),
			'TN' => array(
				'ALA',
				'ALBIANO',
				'ALDENO',
				'AMBLAR',
				'ANDALO',
				'ARCO',
				'AVIO',
				'BASELGA DI PINE\'',
				'BEDOLLO',
				'BERSONE',
				'BESENELLO',
				'BEZZECCA',
				'BIENO',
				'BLEGGIO INFERIORE',
				'BLEGGIO SUPERIORE',
				'BOCENAGO',
				'BOLBENO',
				'BONDO',
				'BONDONE',
				'BORGO VALSUGANA',
				'BOSENTINO',
				'BREGUZZO',
				'BRENTONICO',
				'BRESIMO',
				'BREZ',
				'BRIONE',
				'CADERZONE',
				'CAGNO\'',
				'CALAVINO',
				'CALCERANICA AL LAGO',
				'CALDES',
				'CALDONAZZO',
				'CALLIANO',
				'CAMPITELLO DI FASSA',
				'CAMPODENNO',
				'CANAL SAN BOVO',
				'CANAZEI',
				'CAPRIANA',
				'CARANO',
				'CARISOLO',
				'CARZANO',
				'CASTEL CONDINO',
				'CASTELFONDO',
				'CASTELLO-MOLINA DI FIEMME',
				'CASTELLO TESINO',
				'CASTELNUOVO',
				'CAVALESE',
				'CAVARENO',
				'CAVEDAGO',
				'CAVEDINE',
				'CAVIZZANA',
				'CEMBRA',
				'CENTA SAN NICOLO\'',
				'CIMEGO',
				'CIMONE',
				'CINTE TESINO',
				'CIS',
				'CIVEZZANO',
				'CLES',
				'CLOZ',
				'COMMEZZADURA',
				'CONCEI',
				'CONDINO',
				'COREDO',
				'CROVIANA',
				'CUNEVO',
				'DAIANO',
				'DAMBEL',
				'DAONE',
				'DARE\'',
				'DENNO',
				'DIMARO',
				'DON',
				'DORSINO',
				'DRENA',
				'DRO\'',
				'FAEDO',
				'FAI DELLA PAGANELLA',
				'FAVER',
				'FIAVE\'',
				'FIERA DI PRIMIERO',
				'FIEROZZO',
				'FLAVON',
				'FOLGARIA',
				'FONDO',
				'FORNACE',
				'FRASSILONGO',
				'GARNIGA',
				'GIOVO',
				'GIUSTINO',
				'GRAUNO',
				'GRIGNO',
				'GRUMES',
				'IMER',
				'ISERA',
				'IVANO-FRACENA',
				'LARDARO',
				'LASINO',
				'LAVARONE',
				'LAVIS',
				'LEVICO TERME',
				'LISIGNAGO',
				'LIVO',
				'LOMASO',
				'LONA-LASES',
				'LUSERNA',
				'MALE\'',
				'MALOSCO',
				'MASSIMENO',
				'MAZZIN',
				'MEZZANA',
				'MEZZANO',
				'MEZZOCORONA',
				'MEZZOLOMBARDO',
				'MOENA',
				'MOLINA DI LEDRO',
				'MOLVENO',
				'MONCLASSICO',
				'MONTAGNE',
				'MORI',
				'NAGO-TORBOLE',
				'NANNO',
				'NAVE SAN ROCCO',
				'NOGAREDO',
				'NOMI',
				'NOVALEDO',
				'OSPEDALETTO',
				'OSSANA',
				'PADERGNONE',
				'PALU\' DEL FERSINA',
				'PANCHIA\'',
				'RONZO-CHIENIS',
				'PEIO',
				'PELLIZZANO',
				'PELUGO',
				'PERGINE VALSUGANA',
				'PIEVE DI BONO',
				'PIEVE DI LEDRO',
				'PIEVE TESINO',
				'PINZOLO',
				'POMAROLO',
				'POZZA DI FASSA',
				'PRASO',
				'PREDAZZO',
				'PREORE',
				'PREZZO',
				'RABBI',
				'RAGOLI',
				'REVO\'',
				'RIVA DEL GARDA',
				'ROMALLO',
				'ROMENO',
				'RONCEGNO',
				'RONCHI VALSUGANA',
				'RONCONE',
				'RONZONE',
				'ROVERE\' DELLA LUNA',
				'ROVERETO',
				'RUFFRE\'',
				'RUMO',
				'SAGRON MIS',
				'SAMONE',
				'SAN LORENZO IN BANALE',
				'SAN MICHELE ALL\'ADIGE',
				'SANT\'ORSOLA TERME',
				'SANZENO',
				'SARNONICO',
				'SCURELLE',
				'SEGONZANO',
				'SFRUZ',
				'SIROR',
				'SMARANO',
				'SORAGA',
				'SOVER',
				'SPERA',
				'SPIAZZO',
				'SPORMAGGIORE',
				'SPORMINORE',
				'STENICO',
				'STORO',
				'STREMBO',
				'STRIGNO',
				'TAIO',
				'TASSULLO',
				'TELVE',
				'TELVE DI SOPRA',
				'TENNA',
				'TENNO',
				'TERLAGO',
				'TERRAGNOLO',
				'TERRES',
				'TERZOLAS',
				'TESERO',
				'TIARNO DI SOPRA',
				'TIARNO DI SOTTO',
				'TIONE DI TRENTO',
				'TON',
				'TONADICO',
				'TORCEGNO',
				'TRAMBILENO',
				'TRANSACQUA',
				'TRENTO',
				'TRES',
				'TUENNO',
				'VALDA',
				'VALFLORIANA',
				'VALLARSA',
				'VARENA',
				'VATTARO',
				'VERMIGLIO',
				'VERVO\'',
				'VEZZANO',
				'VIGNOLA-FALESINA',
				'VIGO DI FASSA',
				'VIGOLO VATTARO',
				'VIGO RENDENA',
				'VILLA AGNEDO',
				'VILLA LAGARINA',
				'VILLA RENDENA',
				'VOLANO',
				'ZAMBANA',
				'ZIANO DI FIEMME',
				'ZUCLO',
				'COMANO TERME',
				'LEDRO',
				'PREDAIA',
				'SAN LORENZO DORSINO',
				'VALDAONE',
				'DIMARO FOLGARIDA',
				'PIEVE DI BONO-PREZZO',
				'ALTAVALLE',
				'ALTOPIANO DELLA VIGOLANA',
				'AMBLAR-DON',
				'BORGO CHIESE',
				'BORGO LARES',
				'CASTEL IVANO',
				'CEMBRA LISIGNAGO',
				'CONTA\'',
				'MADRUZZO',
				'PORTE DI RENDENA',
				'PRIMIERO SAN MARTINO DI CASTROZZA',
				'SELLA GIUDICARIE',
				'TRE VILLE',
				'VALLELAGHI',
				'VILLE D\'ANAUNIA',
				'AGRONE',
				'ALMAZZAGO',
				'ANDOGNO',
				'ARNAGO',
				'BONDO BREGUZZO',
				'BANCO',
				'BASELGA DI VEZZANO',
				'BESENO',
				'BIACESA',
				'BLEGGIO',
				'BOLENTINA',
				'BOLLONE',
				'BORGHETTO',
				'BORZAGO',
				'BOZZANA',
				'CADINE',
				'CAMPO',
				'CANEZZA',
				'CARCIATO',
				'CASEZ',
				'CASTAGNE\'',
				'CASTELLANO',
				'CASTELLO',
				'CAURIA',
				'CELENTINO',
				'CELLEDIZZO',
				'CHIENIS',
				'CHIZZOLA',
				'CIAGO',
				'COGNOCA',
				'COGOLO',
				'COLOGNA-CAVAZZO',
				'COLOGNA IN GIUDICARIE',
				'COMANO',
				'COMASINE',
				'COSTASAVINA',
				'COVELO',
				'CRETO',
				'DARDINE',
				'DARZO',
				'DEGGIANO',
				'DERCOLO',
				'DERMULO',
				'ENGUISO',
				'FALESINA',
				'FISTO',
				'FORNO',
				'FRAVEGGIO',
				'GARDOLO',
				'GRUMO',
				'IAVRE\'',
				'ISCHIA',
				'LEGOS',
				'LENZIMA',
				'LENZUMO',
				'LIZZANA',
				'LOCCA',
				'LODRONE',
				'LON',
				'LOVER',
				'LUNDO',
				'MADRANO',
				'MADRUZZO',
				'MAGRAS',
				'MAGRE\'',
				'MALGOLO',
				'MANZANO',
				'MARANO',
				'MARCO',
				'MARGONE',
				'MASI DI VIGO',
				'MASTELLINA',
				'MATTARELLO',
				'MEANO',
				'MECHEL',
				'MESTRIAGO',
				'MEZZANO IMER',
				'MEZZOLAGO',
				'MIOLA',
				'MOERNA',
				'MOLLARO',
				'MONTES',
				'MORTASO',
				'NOARNA',
				'NOGARE\'',
				'NOMESINO',
				'NORIGLIO',
				'OLTRESARCA',
				'PATONE',
				'PEDERZANO',
				'PERRA',
				'PERSONE',
				'PIANO',
				'PILCANTE',
				'POR',
				'POVO',
				'PRE',
				'PREGASINA',
				'PREGHENA',
				'PREMIONE',
				'PRESSON',
				'PRIMIERO',
				'PRIO\'',
				'QUETTA',
				'RANZO',
				'RAVINA',
				'FOLAS-REVIAN',
				'ROMAGNANO',
				'ROMARZOLLO',
				'RONCOGNO',
				'RONZO',
				'ROVER CARBONARE',
				'SAMOCLEVO',
				'SAN GIACOMO',
				'SAN LUGANO',
				'SANTA MARGHERITA',
				'SAONE',
				'SARDAGNA',
				'SASSO',
				'SCLEMO',
				'SEGNO',
				'SEIO',
				'SEO',
				'SERRAVALLE ALL\'ADIGE',
				'SERSO',
				'SEVIGNANO',
				'SOPRAMONTE',
				'STRADA',
				'STRAMENTIZZO',
				'STUMIAGA',
				'SUSA\'',
				'TAVODO',
				'TAVON',
				'TERMENAGO',
				'TERMON',
				'TIARNO',
				'TORRA',
				'TOSS',
				'TUENETTO',
				'VALLE SAN FELICE',
				'VASIO',
				'VERDESINA',
				'VIARAGO',
				'VIGALZANO',
				'VIGNOLA',
				'VIGO D\'ANAUNIA',
				'VIGOLO BASELGA',
				'VILLA BANALE',
				'VILLAZZANO',
				'VILLE DEL MONTE',
				'VION',
				'BALBIDO',
				'BALLINO',
				'BARCESINO',
				'BONDONE-STORO',
				'BONO',
				'BRANCOLINO',
				'BRUSINO',
				'CANALE',
				'CARES',
				'CASTELPIETRA',
				'CAVRASTO',
				'COMIGHELLO',
				'DASINDO',
				'DUVREDO',
				'FAVRIO',
				'GODENZO',
				'LAGUNA\'-MUSTE\'',
				'LARIDO',
				'LASES',
				'LONA',
				'MADICE',
				'MALA',
				'MENAS',
				'MONTEVACCINO',
				'ORTISE\'',
				'POIA',
				'RANGO',
				'RONCHI DI ALA',
				'SACCO',
				'SAVIGNANO',
				'STRAVINO',
				'TIGNERONE',
				'VARANO',
				'VIGO-CAVEDINE',
				'VIGO-LOMASO',
				'VILLAMONTAGNA',
				'PANNONE',
				'CADERZONE TERME',
				'RUFFRE\'-MENDOLA',
				'GARNIGA TERME',
			),
			'VR' => array(
				'AFFI',
				'ALBAREDO D\'ADIGE',
				'ANGIARI',
				'ARCOLE',
				'BADIA CALAVENA',
				'BARDOLINO',
				'BELFIORE',
				'BEVILACQUA',
				'BONAVIGO',
				'BOSCHI SANT\'ANNA',
				'BOSCO CHIESANUOVA',
				'BOVOLONE',
				'BRENTINO BELLUNO',
				'BRENZONE',
				'BUSSOLENGO',
				'BUTTAPIETRA',
				'CALDIERO',
				'CAPRINO VERONESE',
				'CASALEONE',
				'CASTAGNARO',
				'CASTEL D\'AZZANO',
				'CASTELNUOVO DI VERONA',
				'CAVAION VERONESE',
				'CAZZANO DI TRAMIGNA',
				'CEREA',
				'CERRO VERONESE',
				'COLOGNA VENETA',
				'COLOGNOLA AI COLLI',
				'CONCAMARISE',
				'COSTERMANO',
				'DOLCE\'',
				'ERBE\'',
				'ERBEZZO',
				'FERRARA DI MONTE BALDO',
				'FUMANE',
				'GARDA',
				'GAZZO VERONESE',
				'GREZZANA',
				'ILLASI',
				'ISOLA DELLA SCALA',
				'ISOLA RIZZA',
				'LAVAGNO',
				'LAZISE',
				'LEGNAGO',
				'MALCESINE',
				'MARANO DI VALPOLICELLA',
				'MEZZANE DI SOTTO',
				'MINERBE',
				'MONTECCHIA DI CROSARA',
				'MONTEFORTE D\'ALPONE',
				'MOZZECANE',
				'NEGRAR',
				'NOGARA',
				'NOGAROLE ROCCA',
				'OPPEANO',
				'PALU\'',
				'PASTRENGO',
				'PESCANTINA',
				'PESCHIERA DEL GARDA',
				'POVEGLIANO VERONESE',
				'PRESSANA',
				'RIVOLI VERONESE',
				'RONCA\'',
				'RONCO ALL\'ADIGE',
				'ROVERCHIARA',
				'ROVEREDO DI GUA\'',
				'ROVERE\' VERONESE',
				'SALIZZOLE',
				'SAN BONIFACIO',
				'SAN GIOVANNI ILARIONE',
				'SAN GIOVANNI LUPATOTO',
				'SANGUINETTO',
				'SAN MARTINO BUON ALBERGO',
				'SAN MAURO DI SALINE',
				'SAN PIETRO DI MORUBIO',
				'SAN PIETRO IN CARIANO',
				'SANT\'AMBROGIO DI VALPOLICELLA',
				'SANT\'ANNA D\'ALFAEDO',
				'SAN ZENO DI MONTAGNA',
				'SELVA DI PROGNO',
				'SOAVE',
				'SOMMACAMPAGNA',
				'SONA',
				'SORGA\'',
				'TERRAZZO',
				'TORRI DEL BENACO',
				'TREGNAGO',
				'TREVENZUOLO',
				'VALEGGIO SUL MINCIO',
				'VELO VERONESE',
				'VERONA',
				'VERONELLA',
				'VESTENANOVA',
				'VIGASIO',
				'VILLA BARTOLOMEA',
				'VILLAFRANCA DI VERONA',
				'ZEVIO',
				'ZIMELLA',
				'AVESA',
				'BELLUNO VERONESE',
				'BEVILACQUA BOSCHI',
				'BRENTINO',
				'BREONIO',
				'CA\' DI DAVID',
				'CASTIONE VERONESE',
				'CORREZZO',
				'MARCELLISE',
				'MIZZOLE',
				'MONTORIO VERONESE',
				'NEGARINE',
				'PARONA DI VALPOLICELLA',
				'PRUN',
				'QUINTO DI VALPANTENA',
				'QUINZANO VERONESE',
				'SAN MASSIMO ALL\'ADIGE',
				'SAN MICHELE EXTRA',
				'SANTA MARIA IN STELLE',
				'CASTELNUOVO DEL GARDA',
				'BRENZONE SUL GARDA',
			),
			'VI' => array(
				'AGUGLIARO',
				'ALBETTONE',
				'ALONTE',
				'ALTAVILLA VICENTINA',
				'ALTISSIMO',
				'ARCUGNANO',
				'ARSIERO',
				'ARZIGNANO',
				'ASIAGO',
				'ASIGLIANO VENETO',
				'BARBARANO VICENTINO',
				'BASSANO DEL GRAPPA',
				'BOLZANO VICENTINO',
				'BREGANZE',
				'BRENDOLA',
				'BRESSANVIDO',
				'BROGLIANO',
				'CALDOGNO',
				'CALTRANO',
				'CALVENE',
				'CAMISANO VICENTINO',
				'CAMPIGLIA DEI BERICI',
				'CAMPOLONGO SUL BRENTA',
				'CARRE\'',
				'CARTIGLIANO',
				'CASSOLA',
				'CASTEGNERO',
				'CASTELGOMBERTO',
				'CHIAMPO',
				'CHIUPPANO',
				'CISMON DEL GRAPPA',
				'COGOLLO DEL CENGIO',
				'CONCO',
				'CORNEDO VICENTINO',
				'COSTABISSARA',
				'CREAZZO',
				'CRESPADORO',
				'DUEVILLE',
				'ENEGO',
				'FARA VICENTINO',
				'FOZA',
				'GALLIO',
				'GAMBELLARA',
				'GAMBUGLIANO',
				'GRANCONA',
				'GRISIGNANO DI ZOCCO',
				'GRUMOLO DELLE ABBADESSE',
				'ISOLA VICENTINA',
				'LAGHI',
				'LASTEBASSE',
				'LONGARE',
				'LONIGO',
				'LUGO DI VICENZA',
				'LUSIANA',
				'MALO',
				'MARANO VICENTINO',
				'MAROSTICA',
				'MASON VICENTINO',
				'MOLVENA',
				'MONTEBELLO VICENTINO',
				'MONTECCHIO MAGGIORE',
				'MONTECCHIO PRECALCINO',
				'MONTE DI MALO',
				'MONTEGALDA',
				'MONTEGALDELLA',
				'MONTEVIALE',
				'MONTICELLO CONTE OTTO',
				'MONTORSO VICENTINO',
				'MOSSANO',
				'MUSSOLENTE',
				'NANTO',
				'NOGAROLE VICENTINO',
				'NOVE',
				'NOVENTA VICENTINA',
				'ORGIANO',
				'PEDEMONTE',
				'PIANEZZE',
				'PIOVENE ROCCHETTE',
				'POJANA MAGGIORE',
				'POSINA',
				'POVE DEL GRAPPA',
				'POZZOLEONE',
				'QUINTO VICENTINO',
				'RECOARO TERME',
				'ROANA',
				'ROMANO D\'EZZELINO',
				'ROSA\'',
				'ROSSANO VENETO',
				'ROTZO',
				'SALCEDO',
				'SANDRIGO',
				'SAN GERMANO DEI BERICI',
				'SAN NAZARIO',
				'SAN PIETRO MUSSOLINO',
				'SANTORSO',
				'SAN VITO DI LEGUZZANO',
				'SARCEDO',
				'SAREGO',
				'SCHIAVON',
				'SCHIO',
				'SOLAGNA',
				'SOSSANO',
				'SOVIZZO',
				'TEZZE SUL BRENTA',
				'THIENE',
				'TONEZZA DEL CIMONE',
				'TORREBELVICINO',
				'TORRI DI QUARTESOLO',
				'TRISSINO',
				'VALDAGNO',
				'VALDASTICO',
				'VALLI DEL PASUBIO',
				'VALSTAGNA',
				'VELO D\'ASTICO',
				'VICENZA',
				'VILLAGA',
				'VILLAVERLA',
				'ZANE\'',
				'ZERMEGHEDO',
				'ZOVENCEDO',
				'ZUGLIANO',
				'CASOTTO',
				'CROSARA',
				'FORNI IN VAL D\'ASTICO',
				'MAGRE VICENTINO',
				'NOVALE',
				'TRESCHE-CONCA',
				'TRETTO',
				'VALLONARA',
				'VALROVINA',
			),
			'BL' => array(
				'AGORDO',
				'ALANO DI PIAVE',
				'ALLEGHE',
				'ARSIE\'',
				'AURONZO DI CADORE',
				'BELLUNO',
				'BORCA DI CADORE',
				'CALALZO DI CADORE',
				'CASTELLAVAZZO',
				'CENCENIGHE AGORDINO',
				'CESIOMAGGIORE',
				'CHIES D\'ALPAGO',
				'CIBIANA DI CADORE',
				'COLLE SANTA LUCIA',
				'COMELICO SUPERIORE',
				'CORTINA D\'AMPEZZO',
				'DANTA DI CADORE',
				'DOMEGGE DI CADORE',
				'FALCADE',
				'FARRA D\'ALPAGO',
				'FELTRE',
				'FONZASO',
				'CANALE D\'AGORDO',
				'FORNO DI ZOLDO',
				'GOSALDO',
				'LAMON',
				'LA VALLE AGORDINA',
				'LENTIAI',
				'LIMANA',
				'LIVINALLONGO DEL COL DI LANA',
				'LONGARONE',
				'LORENZAGO DI CADORE',
				'LOZZO DI CADORE',
				'MEL',
				'OSPITALE DI CADORE',
				'PEDAVENA',
				'PERAROLO DI CADORE',
				'PIEVE D\'ALPAGO',
				'PIEVE DI CADORE',
				'PONTE NELLE ALPI',
				'PUOS D\'ALPAGO',
				'QUERO',
				'RIVAMONTE',
				'ROCCA PIETORE',
				'SAN GREGORIO NELLE ALPI',
				'SAN NICOLO\' DI COMELICO',
				'SAN PIETRO DI CADORE',
				'SANTA GIUSTINA',
				'SAN TOMASO AGORDINO',
				'SANTO STEFANO DI CADORE',
				'SAN VITO DI CADORE',
				'SAPPADA',
				'SEDICO',
				'SELVA DI CADORE',
				'SEREN DEL GRAPPA',
				'SOSPIROLO',
				'SOVERZENE',
				'SOVRAMONTE',
				'TAIBON AGORDINO',
				'TAMBRE',
				'TRICHIANA',
				'VALLADA AGORDINA',
				'VALLE DI CADORE',
				'VAS',
				'VIGO DI CADORE',
				'VODO DI CADORE',
				'VOLTAGO AGORDINO',
				'ZOLDO ALTO',
				'ZOPPE\' DI CADORE',
				'QUERO VAS',
				'LONGARONE',
				'ALPAGO',
				'VAL DI ZOLDO',
			),
			'TV' => array(
				'ALTIVOLE',
				'ARCADE',
				'ASOLO',
				'BORSO DEL GRAPPA',
				'BREDA DI PIAVE',
				'CAERANO DI SAN MARCO',
				'CAPPELLA MAGGIORE',
				'CARBONERA',
				'CASALE SUL SILE',
				'CASIER',
				'CASTELCUCCO',
				'CASTELFRANCO VENETO',
				'CASTELLO DI GODEGO',
				'CAVASO DEL TOMBA',
				'CESSALTO',
				'CHIARANO',
				'CIMADOLMO',
				'CISON DI VALMARINO',
				'CODOGNE\'',
				'COLLE UMBERTO',
				'CONEGLIANO',
				'CORDIGNANO',
				'CORNUDA',
				'CRESPANO DEL GRAPPA',
				'CROCETTA DEL MONTELLO',
				'FARRA DI SOLIGO',
				'FOLLINA',
				'FONTANELLE',
				'FONTE',
				'FREGONA',
				'GAIARINE',
				'GIAVERA DEL MONTELLO',
				'GODEGA DI SANT\'URBANO',
				'GORGO AL MONTICANO',
				'ISTRANA',
				'LORIA',
				'MANSUE\'',
				'MARENO DI PIAVE',
				'MASER',
				'MASERADA SUL PIAVE',
				'MEDUNA DI LIVENZA',
				'MIANE',
				'MOGLIANO VENETO',
				'MONASTIER DI TREVISO',
				'MONFUMO',
				'MONTEBELLUNA',
				'MORGANO',
				'MORIAGO DELLA BATTAGLIA',
				'MOTTA DI LIVENZA',
				'NERVESA DELLA BATTAGLIA',
				'ODERZO',
				'ORMELLE',
				'ORSAGO',
				'PADERNO DEL GRAPPA',
				'PAESE',
				'PEDEROBBA',
				'PIEVE DI SOLIGO',
				'PONTE DI PIAVE',
				'PONZANO VENETO',
				'PORTOBUFFOLE\'',
				'POSSAGNO',
				'POVEGLIANO',
				'PREGANZIOL',
				'QUINTO DI TREVISO',
				'REFRONTOLO',
				'RESANA',
				'REVINE LAGO',
				'RIESE PIO X',
				'RONCADE',
				'SALGAREDA',
				'SAN BIAGIO DI CALLALTA',
				'SAN FIOR',
				'SAN PIETRO DI FELETTO',
				'SAN POLO DI PIAVE',
				'SANTA LUCIA DI PIAVE',
				'SAN VENDEMIANO',
				'SAN ZENONE DEGLI EZZELINI',
				'SARMEDE',
				'SEGUSINO',
				'SERNAGLIA DELLA BATTAGLIA',
				'SILEA',
				'SPRESIANO',
				'SUSEGANA',
				'TARZO',
				'TREVIGNANO',
				'TREVISO',
				'VALDOBBIADENE',
				'VAZZOLA',
				'VEDELAGO',
				'VIDOR',
				'VILLORBA',
				'VITTORIO VENETO',
				'VOLPAGO DEL MONTELLO',
				'ZENSON DI PIAVE',
				'ZERO BRANCO',
				'SANT\'ANDREA DI CAVASAGRA',
				'CENEDA',
				'SAN GIORGIO DI LAGO',
				'PIAVON',
				'REVINE',
				'SAN PIETRO DI BARBOZZA',
				'SERRAVALLE',
				'SPERCENIGO',
			),
			'VE' => array(
				'ANNONE VENETO',
				'CAMPAGNA LUPIA',
				'CAMPOLONGO MAGGIORE',
				'CAMPONOGARA',
				'CAORLE',
				'CAVARZERE',
				'CEGGIA',
				'CHIOGGIA',
				'CINTO CAOMAGGIORE',
				'CONA',
				'CONCORDIA SAGITTARIA',
				'DOLO',
				'ERACLEA',
				'FIESSO D\'ARTICO',
				'FOSSALTA DI PIAVE',
				'FOSSALTA DI PORTOGRUARO',
				'FOSSO\'',
				'GRUARO',
				'JESOLO',
				'MARCON',
				'MARTELLAGO',
				'MEOLO',
				'MIRA',
				'MIRANO',
				'MUSILE DI PIAVE',
				'NOALE',
				'NOVENTA DI PIAVE',
				'PIANIGA',
				'PORTOGRUARO',
				'PRAMAGGIORE',
				'QUARTO D\'ALTINO',
				'SALZANO',
				'SAN DONA\' DI PIAVE',
				'SAN MICHELE AL TAGLIAMENTO',
				'SANTA MARIA DI SALA',
				'SANTO STINO DI LIVENZA',
				'SCORZE\'',
				'SPINEA',
				'STRA',
				'TEGLIO VENETO',
				'TORRE DI MOSTO',
				'VENEZIA',
				'VIGONOVO',
				'CAVALLINO-TREPORTI',
				'BURANO',
				'CHIRIGNAGO',
				'FAVARO VENETO',
				'GAMBARARE',
				'MALAMOCCO',
				'MESTRE',
				'MURANO',
				'PELLESTRINA',
				'ZELARINO',
				'SAN STINO DI LIVENZA',
			),
			'PD' => array(
				'ABANO TERME',
				'AGNA',
				'ALBIGNASEGO',
				'ANGUILLARA VENETA',
				'ARQUA\' PETRARCA',
				'ARRE',
				'ARZERGRANDE',
				'BAGNOLI DI SOPRA',
				'BAONE',
				'BARBONA',
				'BATTAGLIA TERME',
				'BOARA PISANI',
				'BORGORICCO',
				'BOVOLENTA',
				'BRUGINE',
				'CADONEGHE',
				'CAMPODARSEGO',
				'CAMPODORO',
				'CAMPOSAMPIERO',
				'CAMPO SAN MARTINO',
				'CANDIANA',
				'CARCERI',
				'CARMIGNANO DI BRENTA',
				'CARTURA',
				'CASALE DI SCODOSIA',
				'CASALSERUGO',
				'CASTELBALDO',
				'CERVARESE SANTA CROCE',
				'CINTO EUGANEO',
				'CITTADELLA',
				'CODEVIGO',
				'CONSELVE',
				'CORREZZOLA',
				'CURTAROLO',
				'ESTE',
				'FONTANIVA',
				'GALLIERA VENETA',
				'GALZIGNANO TERME',
				'GAZZO',
				'GRANTORTO',
				'GRANZE',
				'LEGNARO',
				'LIMENA',
				'LOREGGIA',
				'LOZZO ATESTINO',
				'MASERA\' DI PADOVA',
				'MASI',
				'MASSANZAGO',
				'MEGLIADINO SAN FIDENZIO',
				'MEGLIADINO SAN VITALE',
				'MERLARA',
				'MESTRINO',
				'MONSELICE',
				'MONTAGNANA',
				'MONTEGROTTO TERME',
				'NOVENTA PADOVANA',
				'OSPEDALETTO EUGANEO',
				'PADOVA',
				'PERNUMIA',
				'PIACENZA D\'ADIGE',
				'PIAZZOLA SUL BRENTA',
				'PIOMBINO DESE',
				'PIOVE DI SACCO',
				'POLVERARA',
				'PONSO',
				'PONTELONGO',
				'PONTE SAN NICOLO\'',
				'POZZONOVO',
				'ROVOLON',
				'RUBANO',
				'SACCOLONGO',
				'SALETTO',
				'SAN GIORGIO DELLE PERTICHE',
				'SAN GIORGIO IN BOSCO',
				'SAN MARTINO DI LUPARI',
				'SAN PIETRO IN GU',
				'SAN PIETRO VIMINARIO',
				'SANTA GIUSTINA IN COLLE',
				'SANTA MARGHERITA D\'ADIGE',
				'SANT\'ANGELO DI PIOVE DI SACCO',
				'SANT\'ELENA',
				'SANT\'URBANO',
				'SAONARA',
				'SELVAZZANO DENTRO',
				'SOLESINO',
				'STANGHELLA',
				'TEOLO',
				'TERRASSA PADOVANA',
				'TOMBOLO',
				'TORREGLIA',
				'TREBASELEGHE',
				'TRIBANO',
				'URBANA',
				'VEGGIANO',
				'VESCOVANA',
				'VIGHIZZOLO D\'ESTE',
				'VIGODARZERE',
				'VIGONZA',
				'VILLA DEL CONTE',
				'VILLA ESTENSE',
				'VILLAFRANCA PADOVANA',
				'VILLANOVA DI CAMPOSAMPIERO',
				'VO',
				'DUE CARRARE',
				'CARRARA SAN GIORGIO',
				'CARRARA SANTO STEFANO',
				'SAN MICHELE DELLE BADESSE',
			),
			'RO' => array(
				'ADRIA',
				'ARIANO NEL POLESINE',
				'ARQUA\' POLESINE',
				'BADIA POLESINE',
				'BAGNOLO DI PO',
				'BERGANTINO',
				'BOSARO',
				'CALTO',
				'CANARO',
				'CANDA',
				'CASTELGUGLIELMO',
				'CASTELMASSA',
				'CASTELNOVO BARIANO',
				'CENESELLI',
				'CEREGNANO',
				'CONTARINA',
				'CORBOLA',
				'COSTA DI ROVIGO',
				'CRESPINO',
				'DONADA',
				'FICAROLO',
				'FIESSO UMBERTIANO',
				'FRASSINELLE POLESINE',
				'FRATTA POLESINE',
				'GAIBA',
				'GAVELLO',
				'GIACCIANO CON BARUCHELLA',
				'GUARDA VENETA',
				'LENDINARA',
				'LOREO',
				'LUSIA',
				'MELARA',
				'OCCHIOBELLO',
				'PAPOZZE',
				'PETTORAZZA GRIMANI',
				'PINCARA',
				'POLESELLA',
				'PONTECCHIO POLESINE',
				'PORTO TOLLE',
				'ROSOLINA',
				'ROVIGO',
				'SALARA',
				'SAN BELLINO',
				'SAN MARTINO DI VENEZZE',
				'STIENTA',
				'TAGLIO DI PO',
				'TRECENTA',
				'VILLADOSE',
				'VILLAMARZANA',
				'VILLANOVA DEL GHEBBO',
				'VILLANOVA MARCHESANA',
				'PORTO VIRO',
				'BELLOMBRA',
				'BOARA POLESINE',
				'BORSEA',
				'BOTTRIGHE',
				'BUSO SARZANO',
				'CA\' EMO',
				'CONCADIRAME',
				'CROCETTA',
				'GRIGNANO DI POLESINE',
				'MASSA SUPERIORE',
				'RAMO DI PALO',
				'SAGUEDO',
				'SALVATERRA',
				'SANT\'APOLLINARE CON SELVA',
				'VILLA D\'ADIGE',
			),
			'UD' => array(
				'AIELLO DEL FRIULI',
				'AMARO',
				'AMPEZZO',
				'AQUILEIA',
				'ARTA TERME',
				'ARTEGNA',
				'ATTIMIS',
				'BAGNARIA ARSA',
				'BASILIANO',
				'BERTIOLO',
				'BICINICCO',
				'BORDANO',
				'BUJA',
				'BUTTRIO',
				'CAMINO AL TAGLIAMENTO',
				'CAMPOFORMIDO',
				'CAMPOLONGO AL TORRE',
				'CARLINO',
				'CASSACCO',
				'CASTIONS DI STRADA',
				'CAVAZZO CARNICO',
				'CERCIVENTO',
				'CERVIGNANO DEL FRIULI',
				'CHIOPRIS VISCONE',
				'CHIUSAFORTE',
				'CIVIDALE DEL FRIULI',
				'CODROIPO',
				'COLLOREDO DI MONTE ALBANO',
				'COMEGLIANS',
				'CORNO DI ROSAZZO',
				'COSEANO',
				'DIGNANO',
				'DOGNA',
				'DRENCHIA',
				'ENEMONZO',
				'FAEDIS',
				'FAGAGNA',
				'FIUMICELLO',
				'FLAIBANO',
				'FORNI AVOLTRI',
				'FORNI DI SOPRA',
				'FORNI DI SOTTO',
				'GEMONA DEL FRIULI',
				'GONARS',
				'GRIMACCO',
				'LATISANA',
				'LAUCO',
				'LESTIZZA',
				'LIGNANO-SABBIADORO',
				'LIGOSULLO',
				'LUSEVERA',
				'MAGNANO IN RIVIERA',
				'MAJANO',
				'MALBORGHETTO-VALBRUNA',
				'MANZANO',
				'MARANO LAGUNARE',
				'MARTIGNACCO',
				'MERETO DI TOMBA',
				'MOGGIO UDINESE',
				'MOIMACCO',
				'MONTENARS',
				'MORTEGLIANO',
				'MORUZZO',
				'MUZZANA DEL TURGNANO',
				'NIMIS',
				'OSOPPO',
				'OVARO',
				'PAGNACCO',
				'PALAZZOLO DELLO STELLA',
				'PALMANOVA',
				'PALUZZA',
				'PASIAN DI PRATO',
				'PAULARO',
				'PAVIA DI UDINE',
				'POCENIA',
				'PONTEBBA',
				'PORPETTO',
				'POVOLETTO',
				'POZZUOLO DEL FRIULI',
				'PRADAMANO',
				'PRATO CARNICO',
				'PRECENICCO',
				'PREMARIACCO',
				'PREONE',
				'PREPOTTO',
				'PULFERO',
				'RAGOGNA',
				'RAVASCLETTO',
				'RAVEO',
				'REANA DEL ROIALE',
				'REMANZACCO',
				'RESIA',
				'RESIUTTA',
				'RIGOLATO',
				'RIVE D\'ARCANO',
				'RIVIGNANO',
				'RONCHIS',
				'RUDA',
				'SAN DANIELE DEL FRIULI',
				'SAN GIORGIO DI NOGARO',
				'SAN GIOVANNI AL NATISONE',
				'SAN LEONARDO',
				'SAN PIETRO AL NATISONE',
				'SANTA MARIA LA LONGA',
				'SAN VITO AL TORRE',
				'SAN VITO DI FAGAGNA',
				'SAURIS',
				'SAVOGNA',
				'SEDEGLIANO',
				'SOCCHIEVE',
				'STREGNA',
				'SUTRIO',
				'TAIPANA',
				'TALMASSONS',
				'TAPOGLIANO',
				'TARCENTO',
				'TARVISIO',
				'TAVAGNACCO',
				'TEOR',
				'TERZO DI AQUILEIA',
				'TOLMEZZO',
				'TORREANO',
				'TORVISCOSA',
				'TRASAGHIS',
				'TREPPO CARNICO',
				'TREPPO GRANDE',
				'TRICESIMO',
				'TRIVIGNANO UDINESE',
				'UDINE',
				'VARMO',
				'VENZONE',
				'VERZEGNIS',
				'VILLA SANTINA',
				'VILLA VICENTINA',
				'VISCO',
				'ZUGLIO',
				'FORGARIA NEL FRIULI',
				'CAMPOLONGO TAPOGLIANO',
				'RIVIGNANO TEOR',
				'CAMPOROSSO IN VALCANALE',
				'CASTEL DEL MONTE UDINESE',
				'CESCLANS',
				'CISERIIS',
				'SEGNACCO',
				'FELETTO UMBERTO',
				'FUSINE IN VALROMANA',
				'IOANNIS',
				'IPPLIS',
				'LAGLESIE SAN LEOPOLDO',
				'MALBORGHETTO',
				'MIONE',
				'MUSCOLO-STRASSOLDO',
				'RIVOLTO',
				'PERTEOLE',
				'PONTEBBA NOVA',
				'RACCOLANA',
				'RODDA',
				'SCODAVACCA',
				'TARCETTA',
				'UGOVIZZA VALBRUNA',
				'ANDREIS',
				'ARBA',
				'ARZENE',
				'AVIANO',
				'AZZANO DECIMO',
				'BARCIS',
				'BRUGNERA',
				'BUDOIA',
				'CANEVA',
				'CASARSA DELLA DELIZIA',
				'CASTELNOVO DEL FRIULI',
				'CAVASSO NUOVO',
				'CHIONS',
				'CIMOLAIS',
				'CLAUT',
				'CLAUZETTO',
				'CORDENONS',
				'CORDOVADO',
				'ERTO E CASSO',
				'FANNA',
				'FIUME VENETO',
				'FONTANAFREDDA',
				'FRISANCO',
				'MANIAGO',
				'MEDUNO',
				'MONTEREALE VALCELLINA',
				'MORSANO AL TAGLIAMENTO',
				'PASIANO DI PORDENONE',
				'PINZANO AL TAGLIAMENTO',
				'POLCENIGO',
				'PORCIA',
				'PORDENONE',
				'PRATA DI PORDENONE',
				'PRAVISDOMINI',
				'ROVEREDO IN PIANO',
				'SACILE',
				'SAN GIORGIO DELLA RICHINVELDA',
				'SAN MARTINO AL TAGLIAMENTO',
				'SAN QUIRINO',
				'SAN VITO AL TAGLIAMENTO',
				'SEQUALS',
				'SESTO AL REGHENA',
				'SPILIMBERGO',
				'TRAMONTI DI SOPRA',
				'TRAMONTI DI SOTTO',
				'TRAVESIO',
				'VAJONT',
				'VALLENONCELLO',
				'VALVASONE',
				'VITO D\'ASIO',
				'VIVARO',
				'ZOPPOLA',
			),
			'GO' => array(
				'CAPRIVA DEL FRIULI',
				'CORMONS',
				'DOBERDO\' DEL LAGO',
				'DOLEGNA DEL COLLIO',
				'FARRA D\'ISONZO',
				'FOGLIANO REDIPUGLIA',
				'GORIZIA',
				'GRADISCA D\'ISONZO',
				'GRADO',
				'MARIANO DEL FRIULI',
				'MEDEA',
				'MONFALCONE',
				'MORARO',
				'MOSSA',
				'ROMANS D\'ISONZO',
				'RONCHI DEI LEGIONARI',
				'SAGRADO',
				'SAN CANZIAN D\'ISONZO',
				'SAN FLORIANO DEL COLLIO',
				'SAN LORENZO ISONTINO',
				'SAN PIER D\'ISONZO',
				'SAVOGNA D\'ISONZO',
				'STARANZANO',
				'TURRIACO',
				'VILLESSE',
				'AIBA',
				'AIDUSSINA',
				'ANICOVA CORADA',
				'AUZZA',
				'BATTAGLIA DELLA BAINSIZZA',
				'BERGOGNA',
				'BIGLIA',
				'BIGLIANA',
				'BORIANO',
				'BRAZZANO',
				'BRESTOVIZZA IN VALLE',
				'BRETTO',
				'BUDAGNE',
				'CAL DI CANALE',
				'CANALE D\'ISONZO',
				'CAPORETTO',
				'CAMIGNA',
				'CA\' SANTO SPIRITO DELLA BAINSIZZA',
				'CASTEL DOBRA',
				'CECONICO',
				'CERNIZZA GORIZIANA',
				'CHIAPOVANO',
				'CIRCHINA',
				'COBBIA',
				'COMENO',
				'CORONA',
				'COSBANA NEL COLLIO',
				'CREDA',
				'DESCLA',
				'DOLE',
				'DOL GRANDE',
				'DOL OTTELZA',
				'DRESENZA',
				'ERSEL IN MONTE',
				'GABRIA',
				'GABROVIZZA',
				'GARGARO',
				'GIOIACI',
				'GODOVICI',
				'GORIANO',
				'GOZZA',
				'GRACOVA SERRAVALLE',
				'IDRESCA D\'ISONZO',
				'IDRIA',
				'IDRIA DI SOTTO',
				'LEDINE',
				'LIBUSSINA',
				'LOCAVIZZA DI AIDUSSINA',
				'LOCAVIZZA DI CANALE',
				'LOSE',
				'LUCINICO',
				'LUICO',
				'MEDANA',
				'MERNA',
				'MONTENERO D\'IDRIA',
				'MONTE SAN VITO',
				'MONTESPINO',
				'MONTE URABICE',
				'OLTRESONZIA',
				'OPACCHIASELLA',
				'OSSECCA VITTUGLIA',
				'OSSEGLIANO SAN MICHELE',
				'PANIQUA',
				'PIEDIMONTE DEL CALVARIO',
				'PLANINA',
				'PLEZZO',
				'PLISCOVIZZA DELLA MADONNA',
				'POCRAI DEL PERO',
				'PODRAGA',
				'PREVACINA',
				'RANZIANO',
				'RIFEMBERGO',
				'ROMANS',
				'RONZINA',
				'SABLE GRANDE',
				'SAGA',
				'SALCANO',
				'SALONA D\'ISONZO',
				'SAMARIA',
				'SAMBASSO',
				'SAN DANIELE DEL CARSO',
				'SAN MARTINO QUISCA',
				'SAN PIETRO DI GORIZIA',
				'SANTA CROCE DI AIDUSSINA',
				'SANTA LUCIA D\'ISONZO',
				'SANT\'ANDREA DI GORIZIA',
				'SANTO SPIRITO DELLA BAINSIZZA',
				'SAN VITO DI VIPACCO',
				'SCHERBINA',
				'SCRILLA',
				'SEBREGLIE',
				'SEDULA',
				'SELLA DELLE TRINCEE',
				'SERPENIZZA',
				'SLAPPE-ZORZI',
				'SONZIA',
				'STURIA DELLE FUSINE',
				'TARNOVA DELLA SELVA',
				'TEMENIZZA',
				'TERNOVA D\'ISONZO',
				'TOLMINO',
				'TRENTA D\'ISONZO',
				'TRIBUSSA',
				'USTIE',
				'VERPOGLIANO',
				'VERSA',
				'VERTOIBA IN CAMPI',
				'VERTOVINO',
				'VILLE MONTEVECCHIO',
				'VIPACCO',
				'VOISSIZZA DI COMENO',
				'VOLZANA',
				'VOSCHIA',
				'ZOLLA',
			),
			'TS' => array(
				'DUINO AURISINA',
				'MONRUPINO',
				'MUGGIA',
				'SAN DORLIGO DELLA VALLE',
				'SGONICO',
				'TRIESTE',
				'ALBARO VESCOVA',
				'ALBER DI SESANA',
				'AUREMO DI SOPRA',
				'AURISINA',
				'BUCUIE',
				'VILLA CACCIA',
				'CAPRIVA DEL CARSO',
				'CAVE AUREMIANE',
				'CORGNALE',
				'COSSANA',
				'CRENOVIZZA',
				'DIVACCIA GROTTE DEL TIMAVO',
				'DIVACCIA SAN CANZIANO',
				'DUINO',
				'DUTTOGLIANO',
				'FAMIE',
				'LASE',
				'MALCHINA',
				'NACLA SAN MAURIZIO',
				'POSTUMIA GROTTE',
				'POVERIO',
				'RUPINGRANDE',
				'RODITTI',
				'SAN GIACOMO IN COLLE',
				'SAN MICHELE DI POSTUMIA',
				'SAN PELAGIO',
				'SAN PIETRO DEL CARSO',
				'SCOPPO',
				'SENOSECCHIA',
				'SESANA',
				'SINADOLE',
				'SLIVIA',
				'STORIE',
				'TOMADIO',
				'VILLABASSA',
				'VILLA SLAVINA',
			),
			'PN' => array(
				'ANDREIS',
				'ARBA',
				'ARZENE',
				'AVIANO',
				'AZZANO DECIMO',
				'BARCIS',
				'BRUGNERA',
				'BUDOIA',
				'CANEVA',
				'CASARSA DELLA DELIZIA',
				'CASTELNOVO DEL FRIULI',
				'CAVASSO NUOVO',
				'CHIONS',
				'CIMOLAIS',
				'CLAUT',
				'CLAUZETTO',
				'CORDENONS',
				'CORDOVADO',
				'ERTO E CASSO',
				'FANNA',
				'FIUME VENETO',
				'FONTANAFREDDA',
				'FRISANCO',
				'MANIAGO',
				'MEDUNO',
				'MONTEREALE VALCELLINA',
				'MORSANO AL TAGLIAMENTO',
				'PASIANO DI PORDENONE',
				'PINZANO AL TAGLIAMENTO',
				'POLCENIGO',
				'PORCIA',
				'PORDENONE',
				'PRATA DI PORDENONE',
				'PRAVISDOMINI',
				'ROVEREDO IN PIANO',
				'SACILE',
				'SAN GIORGIO DELLA RICHINVELDA',
				'SAN MARTINO AL TAGLIAMENTO',
				'SAN QUIRINO',
				'SAN VITO AL TAGLIAMENTO',
				'SEQUALS',
				'SESTO AL REGHENA',
				'SPILIMBERGO',
				'TRAMONTI DI SOPRA',
				'TRAMONTI DI SOTTO',
				'TRAVESIO',
				'VALVASONE',
				'VITO D\'ASIO',
				'VIVARO',
				'ZOPPOLA',
				'VAJONT',
				'VALVASONE ARZENE',
				'VALLENONCELLO',
			),
			'IM' => array(
				'AIROLE',
				'APRICALE',
				'AQUILA D\'ARROSCIA',
				'ARMO',
				'AURIGO',
				'BADALUCCO',
				'BAJARDO',
				'BORDIGHERA',
				'BORGHETTO D\'ARROSCIA',
				'BORGOMARO',
				'CAMPOROSSO',
				'CARAVONICA',
				'CARPASIO',
				'CASTELLARO',
				'CASTEL VITTORIO',
				'CERIANA',
				'CERVO',
				'CESIO',
				'CHIUSANICO',
				'CHIUSAVECCHIA',
				'CIPRESSA',
				'CIVEZZA',
				'COSIO D\'ARROSCIA',
				'COSTARAINERA',
				'DIANO ARENTINO',
				'DIANO CASTELLO',
				'DIANO MARINA',
				'DIANO SAN PIETRO',
				'DOLCEACQUA',
				'DOLCEDO',
				'IMPERIA',
				'ISOLABONA',
				'LUCINASCO',
				'MENDATICA',
				'MOLINI DI TRIORA',
				'MONTALTO LIGURE',
				'MONTEGROSSO PIAN LATTE',
				'OLIVETTA SAN MICHELE',
				'OSPEDALETTI',
				'PERINALDO',
				'PIETRABRUNA',
				'PIEVE DI TECO',
				'PIGNA',
				'POMPEIANA',
				'PONTEDASSIO',
				'PORNASSIO',
				'PRELA\'',
				'RANZO',
				'REZZO',
				'RIVA LIGURE',
				'ROCCHETTA NERVINA',
				'SAN BARTOLOMEO AL MARE',
				'SAN BIAGIO DELLA CIMA',
				'SAN LORENZO AL MARE',
				'SANREMO',
				'SANTO STEFANO AL MARE',
				'SEBORGA',
				'SOLDANO',
				'TAGGIA',
				'TERZORIO',
				'TRIORA',
				'VALLEBONA',
				'VALLECROSIA',
				'VASIA',
				'VENTIMIGLIA',
				'VESSALICO',
				'VILLA FARALDI',
				'ARZENO D\'ONEGLIA',
				'BESTAGNO',
				'BORGHETTO SAN NICOLO\'',
				'BORGO SANT\'AGATA',
				'BOSCOMARE',
				'BUSSANA',
				'CANDEASCO',
				'CARAMAGNA LIGURE',
				'CARTARI E CALDERARA',
				'CASTELVECCHIO DI SANTA MARIA MAGGIORE',
				'CENOVA',
				'COLDIRODI',
				'CONIO',
				'COSTA DI ONEGLIA',
				'DIANO BORELLO',
				'DIANO CALDERINA',
				'GAZZELLI',
				'LAVINA',
				'LINGUEGLIETTA',
				'MARO CASTELLO',
				'MENDATICA-MONTEGROSSO',
				'MOANO',
				'MONTEGRAZIE',
				'MOLTEDO SUPERIORE',
				'OLIVASTRI',
				'ONEGLIA',
				'PANTASINA',
				'PIANAVIA',
				'PIANI',
				'POGGI',
				'PORTO MAURIZIO',
				'RIVA SANTO STEFANO',
				'SAN LAZZARO REALE',
				'SANTO STEFANO AL MARE CON CASTELLAR',
				'SAROLA',
				'SASSO DI BORDIGHERA',
				'TAVOLE',
				'TORRAZZA',
				'TORRIA',
				'UBAGA',
				'VALLECROSIA CON SAN BIAGIO DELLA CIMA',
				'VALLORIA MARITTIMA',
				'VILLA GUARDIA',
				'VILLA TALLA',
				'VILLA VIANI',
				'VILLE SAN PIETRO',
				'VILLE SAN SEBASTIANO',
			),
			'SV' => array(
				'ALASSIO',
				'ALBENGA',
				'ALBISSOLA MARINA',
				'ALBISOLA SUPERIORE',
				'ALTARE',
				'ANDORA',
				'ARNASCO',
				'BALESTRINO',
				'BARDINETO',
				'BERGEGGI',
				'BOISSANO',
				'BORGHETTO SANTO SPIRITO',
				'BORGIO-VEREZZI',
				'BORMIDA',
				'CAIRO MONTENOTTE',
				'CALICE LIGURE',
				'CALIZZANO',
				'CARCARE',
				'CASANOVA LERRONE',
				'CASTELBIANCO',
				'CASTELVECCHIO DI ROCCA BARBENA',
				'CELLE LIGURE',
				'CENGIO',
				'CERIALE',
				'CISANO SUL NEVA',
				'COSSERIA',
				'DEGO',
				'ERLI',
				'FINALE LIGURE',
				'GARLENDA',
				'GIUSTENICE',
				'GIUSVALLA',
				'LAIGUEGLIA',
				'LOANO',
				'MAGLIOLO',
				'MALLARE',
				'MASSIMINO',
				'MILLESIMO',
				'MIOGLIA',
				'MURIALDO',
				'NASINO',
				'NOLI',
				'ONZO',
				'ORCO FEGLINO',
				'ORTOVERO',
				'OSIGLIA',
				'PALLARE',
				'PIANA CRIXIA',
				'PIETRA LIGURE',
				'PLODIO',
				'PONTINVREA',
				'QUILIANO',
				'RIALTO',
				'ROCCAVIGNALE',
				'SASSELLO',
				'SAVONA',
				'SPOTORNO',
				'STELLA',
				'STELLANELLO',
				'TESTICO',
				'TOIRANO',
				'TOVO SAN GIACOMO',
				'URBE',
				'VADO LIGURE',
				'VARAZZE',
				'VENDONE',
				'VEZZI PORTIO',
				'VILLANOVA D\'ALBENGA',
				'ZUCCARELLO',
				'BARDINO NUOVO',
				'BARDINO VECCHIO',
				'BIESTRO',
				'BORGIO',
				'BROVIDA',
				'CAGNA',
				'CALVISIO',
				'CAMPOCHIESA',
				'CARPE',
				'CARRETTO',
				'CENESI',
				'ELLERA',
				'FINALBORGO',
				'FINALMARINA',
				'FINALPIA',
				'GORRA',
				'LODISIO',
				'MARTINA OLBA',
				'OLBA',
				'ORCO',
				'PERTI',
				'RANZI PIETRA',
				'ROCCHETTA CAIRO',
				'ROCCHETTA CENGIO',
				'SANTA GIULIA',
				'SEGNO',
				'VARIGOTTI',
				'VELLEGO',
				'VEREZZI',
				'VERZI PIETRA',
				'VEZZI',
			),
			'GE' => array(
				'ARENZANO',
				'AVEGNO',
				'BARGAGLI',
				'BOGLIASCO',
				'BORZONASCA',
				'BUSALLA',
				'CAMOGLI',
				'CAMPO LIGURE',
				'CAMPOMORONE',
				'CARASCO',
				'CASARZA LIGURE',
				'CASELLA',
				'CASTIGLIONE CHIAVARESE',
				'CERANESI',
				'CHIAVARI',
				'CICAGNA',
				'COGOLETO',
				'COGORNO',
				'COREGLIA LIGURE',
				'CROCEFIESCHI',
				'DAVAGNA',
				'FASCIA',
				'FAVALE DI MALVARO',
				'FONTANIGORDA',
				'GENOVA',
				'GORRETO',
				'ISOLA DEL CANTONE',
				'LAVAGNA',
				'LEIVI',
				'LORSICA',
				'LUMARZO',
				'MASONE',
				'MELE',
				'MEZZANEGO',
				'MIGNANEGO',
				'MOCONESI',
				'MONEGLIA',
				'MONTEBRUNO',
				'MONTOGGIO',
				'NE',
				'NEIRONE',
				'ORERO',
				'PIEVE LIGURE',
				'PORTOFINO',
				'PROPATA',
				'RAPALLO',
				'RECCO',
				'REZZOAGLIO',
				'RONCO SCRIVIA',
				'RONDANINA',
				'ROSSIGLIONE',
				'ROVEGNO',
				'SAN COLOMBANO CERTENOLI',
				'SANTA MARGHERITA LIGURE',
				'SANT\'OLCESE',
				'SANTO STEFANO D\'AVETO',
				'SAVIGNONE',
				'SERRA RICCO\'',
				'SESTRI LEVANTE',
				'SORI',
				'TIGLIETO',
				'TORRIGLIA',
				'TRIBOGNA',
				'USCIO',
				'VALBREVENNA',
				'VOBBIA',
				'ZOAGLI',
				'APPARIZIONE',
				'BAVARI',
				'BOGLIASCO PIEVE',
				'BOLZANETO',
				'BORZOLI',
				'CANEPA',
				'GENOVA-CORNIGLIANO',
				'FOCE',
				'PORTIO',
				'MARASSI',
				'MOLASSANA',
				'MULTEDO',
				'NERVI',
				'GENOVA-PEGLI',
				'PONTEDECIMO',
				'GENOVA-PRA',
				'QUARTO DEI MILLE',
				'QUINTO AL MARE',
				'GENOVA-RIVAROLO',
				'SAN FRANCESCO D\'ALBARO',
				'SAN FRUTTUOSO',
				'SAN GIOVANNI BATTISTA',
				'SAN MARTINO D\'ALBARO',
				'SAN PIER D\'ARENA',
				'SAN QUIRICO IN VAL DI POLCEVERA',
				'SANT\'ILARIO LIGURE',
				'GENOVA-SESTRI PONENTE',
				'STAGLIENO',
				'STRUPPA',
				'TREBIANO MAGRA',
				'GENOVA-VOLTRI',
			),
			'SP' => array(
				'AMEGLIA',
				'ARCOLA',
				'BEVERINO',
				'BOLANO',
				'BONASSOLA',
				'BORGHETTO DI VARA',
				'BRUGNATO',
				'CALICE AL CORNOVIGLIO',
				'CARRO',
				'CARRODANO',
				'CASTELNUOVO MAGRA',
				'DEIVA MARINA',
				'FOLLO',
				'FRAMURA',
				'LA SPEZIA',
				'LERICI',
				'LEVANTO',
				'MAISSANA',
				'MONTEROSSO AL MARE',
				'ORTONOVO',
				'PIGNONE',
				'PORTOVENERE',
				'RICCO\' DEL GOLFO DI SPEZIA',
				'RIOMAGGIORE',
				'ROCCHETTA DI VARA',
				'SANTO STEFANO DI MAGRA',
				'SARZANA',
				'SESTA GODANO',
				'VARESE LIGURE',
				'VERNAZZA',
				'VEZZANO LIGURE',
				'ZIGNAGO',
			),
			'PC' => array(
				'AGAZZANO',
				'ALSENO',
				'BESENZONE',
				'BETTOLA',
				'BOBBIO',
				'BORGONOVO VAL TIDONE',
				'CADEO',
				'CALENDASCO',
				'CAMINATA',
				'CAORSO',
				'CARPANETO PIACENTINO',
				'CASTELL\'ARQUATO',
				'CASTEL SAN GIOVANNI',
				'CASTELVETRO PIACENTINO',
				'CERIGNALE',
				'COLI',
				'CORTE BRUGNATELLA',
				'CORTEMAGGIORE',
				'FARINI',
				'FERRIERE',
				'FIORENZUOLA D\'ARDA',
				'GAZZOLA',
				'GOSSOLENGO',
				'GRAGNANO TREBBIENSE',
				'GROPPARELLO',
				'LUGAGNANO VAL D\'ARDA',
				'MONTICELLI D\'ONGINA',
				'MORFASSO',
				'NIBBIANO',
				'OTTONE',
				'PECORARA',
				'PIACENZA',
				'PIANELLO VAL TIDONE',
				'PIOZZANO',
				'PODENZANO',
				'PONTE DELL\'OLIO',
				'PONTENURE',
				'RIVERGARO',
				'ROTTOFRENO',
				'SAN GIORGIO PIACENTINO',
				'SAN PIETRO IN CERRO',
				'SARMATO',
				'TRAVO',
				'VERNASCA',
				'VIGOLZONE',
				'VILLANOVA SULL\'ARDA',
				'ZERBA',
				'ZIANO PIACENTINO',
				'BORGO SAN BERNARDINO',
				'MORTIZZA',
				'SAN LAZZARO ALBERONI',
				'SANT\'ANTONIO A TREBBIA',
				'TREBECCO',
			),
			'PR' => array(
				'ALBARETO',
				'BARDI',
				'BEDONIA',
				'BERCETO',
				'BORE',
				'BORGO VAL DI TARO',
				'BUSSETO',
				'CALESTANO',
				'COLLECCHIO',
				'COLORNO',
				'COMPIANO',
				'CORNIGLIO',
				'FELINO',
				'FIDENZA',
				'FONTANELLATO',
				'FONTEVIVO',
				'FORNOVO DI TARO',
				'LANGHIRANO',
				'LESIGNANO DE\' BAGNI',
				'MEDESANO',
				'MEZZANI',
				'MONCHIO DELLE CORTI',
				'MONTECHIARUGOLO',
				'NEVIANO DEGLI ARDUINI',
				'NOCETO',
				'PALANZANO',
				'PARMA',
				'PELLEGRINO PARMENSE',
				'POLESINE PARMENSE',
				'ROCCABIANCA',
				'SALA BAGANZA',
				'SALSOMAGGIORE TERME',
				'SAN SECONDO PARMENSE',
				'SISSA',
				'SOLIGNANO',
				'SORAGNA',
				'SORBOLO',
				'TERENZO',
				'TIZZANO VAL PARMA',
				'TORNOLO',
				'TORRILE',
				'TRAVERSETOLO',
				'TRECASALI',
				'VALMOZZOLA',
				'VARANO DE\' MELEGARI',
				'VARSI',
				'ZIBELLO',
				'SISSA TRECASALI',
				'POLESINE ZIBELLO',
				'BOCCOLO DEI TASSI',
				'CORTILE SAN MARTINO',
				'GOLESE',
				'MARORE',
				'PIONE',
				'SAN DONATO D\'ENZA',
				'SAN LAZZARO PARMENSE',
				'SAN MARTINO SINZANO',
				'SAN PANCRAZIO PARMENSE',
				'VIGATTO',
			),
			'RE' => array(
				'ALBINEA',
				'BAGNOLO IN PIANO',
				'BAISO',
				'BIBBIANO',
				'BORETTO',
				'BRESCELLO',
				'BUSANA',
				'CADELBOSCO DI SOPRA',
				'CAMPAGNOLA EMILIA',
				'CAMPEGINE',
				'CARPINETI',
				'CASALGRANDE',
				'CASINA',
				'CASTELLARANO',
				'CASTELNOVO DI SOTTO',
				'CASTELNOVO NE\' MONTI',
				'CAVRIAGO',
				'CIANO D\'ENZA',
				'COLLAGNA',
				'CORREGGIO',
				'FABBRICO',
				'GATTATICO',
				'GUALTIERI',
				'GUASTALLA',
				'LIGONCHIO',
				'LUZZARA',
				'MONTECCHIO EMILIA',
				'NOVELLARA',
				'POVIGLIO',
				'QUATTRO CASTELLA',
				'RAMISETO',
				'REGGIOLO',
				'REGGIO EMILIA',
				'RIO SALICETO',
				'ROLO',
				'RUBIERA',
				'SAN MARTINO IN RIO',
				'SAN POLO D\'ENZA',
				'SANT\'ILARIO D\'ENZA',
				'SCANDIANO',
				'TOANO',
				'VETTO',
				'VEZZANO SUL CROSTOLO',
				'VIANO',
				'VILLA MINOZZO',
				'VENTASSO',
				'GAZZANO',
				'CANOSSA',
			),
			'MO' => array(
				'BASTIGLIA',
				'BOMPORTO',
				'CAMPOGALLIANO',
				'CAMPOSANTO',
				'CARPI',
				'CASTELFRANCO EMILIA',
				'CASTELNUOVO RANGONE',
				'CASTELVETRO DI MODENA',
				'CAVEZZO',
				'CONCORDIA SULLA SECCHIA',
				'FANANO',
				'FINALE EMILIA',
				'FIORANO MODENESE',
				'FIUMALBO',
				'FORMIGINE',
				'FRASSINORO',
				'GUIGLIA',
				'LAMA MOCOGNO',
				'MARANELLO',
				'MARANO SUL PANARO',
				'MEDOLLA',
				'MIRANDOLA',
				'MODENA',
				'MONTECRETO',
				'MONTEFIORINO',
				'MONTESE',
				'NONANTOLA',
				'NOVI DI MODENA',
				'PALAGANO',
				'PAVULLO NEL FRIGNANO',
				'PIEVEPELAGO',
				'POLINAGO',
				'PRIGNANO SULLA SECCHIA',
				'RAVARINO',
				'RIOLUNATO',
				'SAN CESARIO SUL PANARO',
				'SAN FELICE SUL PANARO',
				'SAN POSSIDONIO',
				'SAN PROSPERO',
				'SASSUOLO',
				'SAVIGNANO SUL PANARO',
				'SERRAMAZZONI',
				'SESTOLA',
				'SOLIERA',
				'SPILAMBERTO',
				'VIGNOLA',
				'ZOCCA',
			),
			'BO' => array(
				'ANZOLA DELL\'EMILIA',
				'ARGELATO',
				'BARICELLA',
				'BAZZANO',
				'BENTIVOGLIO',
				'BOLOGNA',
				'BORGO TOSSIGNANO',
				'BUDRIO',
				'CALDERARA DI RENO',
				'CAMUGNANO',
				'CASALECCHIO DI RENO',
				'CASALFIUMANESE',
				'CASTEL D\'AIANO',
				'CASTEL DEL RIO',
				'CASTEL DI CASIO',
				'CASTEL GUELFO DI BOLOGNA',
				'CASTELLO D\'ARGILE',
				'CASTELLO DI SERRAVALLE',
				'CASTEL MAGGIORE',
				'CASTEL SAN PIETRO TERME',
				'CASTENASO',
				'CASTIGLIONE DEI PEPOLI',
				'CRESPELLANO',
				'CREVALCORE',
				'DOZZA',
				'FONTANELICE',
				'GAGGIO MONTANO',
				'GALLIERA',
				'GRANAGLIONE',
				'GRANAROLO DELL\'EMILIA',
				'GRIZZANA MORANDI',
				'IMOLA',
				'LIZZANO IN BELVEDERE',
				'LOIANO',
				'MALALBERGO',
				'MARZABOTTO',
				'MEDICINA',
				'MINERBIO',
				'MOLINELLA',
				'MONGHIDORO',
				'MONTERENZIO',
				'MONTE SAN PIETRO',
				'MONTEVEGLIO',
				'MONZUNO',
				'MORDANO',
				'OZZANO DELL\'EMILIA',
				'PIANORO',
				'PIEVE DI CENTO',
				'PORRETTA TERME',
				'SALA BOLOGNESE',
				'SAN BENEDETTO VAL DI SAMBRO',
				'SAN GIORGIO DI PIANO',
				'SAN GIOVANNI IN PERSICETO',
				'SAN LAZZARO DI SAVENA',
				'SAN PIETRO IN CASALE',
				'SANT\'AGATA BOLOGNESE',
				'SASSO MARCONI',
				'SAVIGNO',
				'VERGATO',
				'ZOLA PREDOSA',
				'VALSAMOGGIA',
				'ALTO RENO TERME',
				'BORGO PANIGALE',
				'MUSIANO',
			),
			'FE' => array(
				'ARGENTA',
				'BERRA',
				'BONDENO',
				'CENTO',
				'CODIGORO',
				'COMACCHIO',
				'COPPARO',
				'FERRARA',
				'FORMIGNANA',
				'JOLANDA DI SAVOIA',
				'LAGOSANTO',
				'MASI TORELLO',
				'MASSAFISCAGLIA',
				'MESOLA',
				'MIGLIARINO',
				'MIRABELLO',
				'OSTELLATO',
				'POGGIO RENATICO',
				'PORTOMAGGIORE',
				'RO FERRARESE',
				'SANT\'AGOSTINO',
				'VIGARANO MAINARDA',
				'VOGHIERA',
				'TRESIGALLO',
				'GORO',
				'MIGLIARO',
				'FISCAGLIA',
			),
			'RA' => array(
				'ALFONSINE',
				'BAGNACAVALLO',
				'BAGNARA DI ROMAGNA',
				'BRISIGHELLA',
				'CASOLA VALSENIO',
				'CASTEL BOLOGNESE',
				'CERVIA',
				'CONSELICE',
				'COTIGNOLA',
				'FAENZA',
				'FUSIGNANO',
				'LUGO',
				'MASSA LOMBARDA',
				'RAVENNA',
				'RIOLO TERME',
				'RUSSI',
				'SANT\'AGATA SUL SANTERNO',
				'SOLAROLO',
			),
			'FO' => array(
				'BAGNO DI ROMAGNA',
				'BERTINORO',
				'BORGHI',
				'CASTROCARO TERME E TERRA DEL SOLE',
				'CESENA',
				'CESENATICO',
				'CIVITELLA DI ROMAGNA',
				'DOVADOLA',
				'FORLI\'',
				'FORLIMPOPOLI',
				'GALEATA',
				'GAMBETTOLA',
				'GATTEO',
				'LONGIANO',
				'MELDOLA',
				'MERCATO SARACENO',
				'MODIGLIANA',
				'MONTIANO',
				'PORTICO E SAN BENEDETTO',
				'PREDAPPIO',
				'PREMILCUORE',
				'ROCCA SAN CASCIANO',
				'RONCOFREDDO',
				'SAN MAURO PASCOLI',
				'SANTA SOFIA',
				'SARSINA',
				'SAVIGNANO SUL RUBICONE',
				'SOGLIANO AL RUBICONE',
				'TREDOZIO',
				'VERGHERETO',
				'FIUMANA',
				'MORTANO',
				'ROVERSANO',
				'SORBANO',
				'TEODORANO',
				'BELLARIA-IGEA MARINA',
				'CATTOLICA',
				'CORIANO',
				'GEMMANO',
				'MISANO ADRIATICO',
				'MONDAINO',
				'MONTE COLOMBO',
				'MONTEFIORE CONCA',
				'MONTEGRIDOLFO',
				'MONTESCUDO',
				'MORCIANO DI ROMAGNA',
				'POGGIO BERNI',
				'RICCIONE',
				'RIMINI',
				'SALUDECIO',
				'SAN CLEMENTE',
				'SAN GIOVANNI IN MARIGNANO',
				'SANTARCANGELO DI ROMAGNA',
				'TORRIANA',
				'VERUCCHIO',
			),
			'RN' => array(
				'BELLARIA-IGEA MARINA',
				'CATTOLICA',
				'CORIANO',
				'GEMMANO',
				'MISANO ADRIATICO',
				'MONDAINO',
				'MONTE COLOMBO',
				'MONTEFIORE CONCA',
				'MONTEGRIDOLFO',
				'MONTESCUDO',
				'MORCIANO DI ROMAGNA',
				'POGGIO BERNI',
				'RICCIONE',
				'RIMINI',
				'SALUDECIO',
				'SAN CLEMENTE',
				'SAN GIOVANNI IN MARIGNANO',
				'SANTARCANGELO DI ROMAGNA',
				'TORRIANA',
				'VERUCCHIO',
				'CASTELDELCI',
				'MAIOLO',
				'NOVAFELTRIA',
				'PENNABILLI',
				'SAN LEO',
				'SANT\'AGATA FELTRIA',
				'TALAMELLO',
				'POGGIO TORRIANA',
				'MONTESCUDO-MONTE COLOMBO',
			),
			'MS' => array(
				'AULLA',
				'BAGNONE',
				'CARRARA',
				'CASOLA IN LUNIGIANA',
				'COMANO',
				'FILATTIERA',
				'FIVIZZANO',
				'FOSDINOVO',
				'LICCIANA NARDI',
				'MASSA',
				'MONTIGNOSO',
				'MULAZZO',
				'PODENZANA',
				'PONTREMOLI',
				'TRESANA',
				'VILLAFRANCA IN LUNIGIANA',
				'ZERI',
				'ALBIANO MAGRA',
				'APUANIA',
				'TERRAROSSA',
			),
			'LU' => array(
				'ALTOPASCIO',
				'BAGNI DI LUCCA',
				'BARGA',
				'BORGO A MOZZANO',
				'CAMAIORE',
				'CAMPORGIANO',
				'CAPANNORI',
				'CAREGGINE',
				'CASTELNUOVO DI GARFAGNANA',
				'CASTIGLIONE DI GARFAGNANA',
				'COREGLIA ANTELMINELLI',
				'FABBRICHE DI VALLICO',
				'FORTE DEI MARMI',
				'FOSCIANDORA',
				'GALLICANO',
				'GIUNCUGNANO',
				'LUCCA',
				'MASSAROSA',
				'MINUCCIANO',
				'MOLAZZANA',
				'MONTECARLO',
				'PESCAGLIA',
				'PIAZZA AL SERCHIO',
				'PIETRASANTA',
				'PIEVE FOSCIANA',
				'PORCARI',
				'SAN ROMANO IN GARFAGNANA',
				'SERAVEZZA',
				'SILLANO',
				'STAZZEMA',
				'VAGLI SOTTO',
				'VERGEMOLI',
				'VIAREGGIO',
				'VILLA BASILICA',
				'VILLA COLLEMANDINA',
				'FABBRICHE DI VERGEMOLI',
				'SILLANO GIUNCUGNANO',
			),
			'PO' => array(
				'CANTAGALLO',
				'CARMIGNANO',
				'MONTEMURLO',
				'POGGIO A CAIANO',
				'PRATO',
				'VAIANO',
				'VERNIO',
			),
			'PT' => array(
				'ABETONE',
				'AGLIANA',
				'BUGGIANO',
				'CUTIGLIANO',
				'LAMPORECCHIO',
				'LARCIANO',
				'MARLIANA',
				'MASSA E COZZILE',
				'MONSUMMANO TERME',
				'MONTALE',
				'MONTECATINI-TERME',
				'PESCIA',
				'PIEVE A NIEVOLE',
				'PISTOIA',
				'PITEGLIO',
				'PONTE BUGGIANESE',
				'QUARRATA',
				'SAMBUCA PISTOIESE',
				'SAN MARCELLO PISTOIESE',
				'SERRAVALLE PISTOIESE',
				'UZZANO',
				'CHIESINA UZZANESE',
				'MONTECATINI VAL DI NIEVOLE',
				'PORTA AL BORGO',
				'PORTA CARRATICA',
				'VELLANO',
			),
			'FI' => array(
				'BAGNO A RIPOLI',
				'BARBERINO DI MUGELLO',
				'BARBERINO VAL D\'ELSA',
				'BORGO SAN LORENZO',
				'CALENZANO',
				'CAMPI BISENZIO',
				'CAPRAIA E LIMITE',
				'CASTELFIORENTINO',
				'CERRETO GUIDI',
				'CERTALDO',
				'DICOMANO',
				'EMPOLI',
				'FIESOLE',
				'FIGLINE VALDARNO',
				'FIRENZE',
				'FLORENCE',
				'FIRENZUOLA',
				'FUCECCHIO',
				'GAMBASSI TERME',
				'GREVE IN CHIANTI',
				'IMPRUNETA',
				'INCISA IN VAL D\'ARNO',
				'LASTRA A SIGNA',
				'LONDA',
				'MARRADI',
				'MONTAIONE',
				'MONTELUPO FIORENTINO',
				'MONTESPERTOLI',
				'PALAZZUOLO SUL SENIO',
				'PELAGO',
				'PONTASSIEVE',
				'REGGELLO',
				'RIGNANO SULL\'ARNO',
				'RUFINA',
				'SAN CASCIANO IN VAL DI PESA',
				'SAN GODENZO',
				'SAN PIERO A SIEVE',
				'SCANDICCI',
				'SCARPERIA',
				'SESTO FIORENTINO',
				'SIGNA',
				'TAVARNELLE VAL DI PESA',
				'VAGLIA',
				'VICCHIO',
				'VINCI',
				'FIGLINE E INCISA VALDARNO',
				'SCARPERIA E SAN PIERO',
				'BROZZI',
				'GALLUZZO',
				'LEGNAIA',
				'MONTECALVOLI',
				'PELLEGRINO DA CAREGGI',
				'PORTA LUCCHESE',
				'PORTA SAN MARCO',
				'ROVEZZANO',
			),
			'LI' => array(
				'BIBBONA',
				'CAMPIGLIA MARITTIMA',
				'CAMPO NELL\'ELBA',
				'CAPOLIVERI',
				'CAPRAIA ISOLA',
				'CASTAGNETO CARDUCCI',
				'CECINA',
				'COLLESALVETTI',
				'LIVORNO',
				'MARCIANA',
				'MARCIANA MARINA',
				'PIOMBINO',
				'PORTO AZZURRO',
				'PORTOFERRAIO',
				'RIO MARINA',
				'RIO NELL\'ELBA',
				'ROSIGNANO MARITTIMO',
				'SAN VINCENZO',
				'SASSETTA',
				'SUVERETO',
			),
			'PI' => array(
				'BIENTINA',
				'BUTI',
				'CALCI',
				'CALCINAIA',
				'CAPANNOLI',
				'CASALE MARITTIMO',
				'CASCIANA TERME',
				'CASCINA',
				'CASTELFRANCO DI SOTTO',
				'CASTELLINA MARITTIMA',
				'CASTELNUOVO DI VAL DI CECINA',
				'CHIANNI',
				'CRESPINA',
				'FAUGLIA',
				'GUARDISTALLO',
				'LAJATICO',
				'LARI',
				'LORENZANA',
				'MONTECATINI VAL DI CECINA',
				'MONTESCUDAIO',
				'MONTEVERDI MARITTIMO',
				'MONTOPOLI IN VAL D\'ARNO',
				'ORCIANO PISANO',
				'PALAIA',
				'PECCIOLI',
				'PISA',
				'POMARANCE',
				'PONSACCO',
				'PONTEDERA',
				'RIPARBELLA',
				'SAN GIULIANO TERME',
				'SAN MINIATO',
				'SANTA CROCE SULL\'ARNO',
				'SANTA LUCE',
				'SANTA MARIA A MONTE',
				'TERRICCIOLA',
				'VECCHIANO',
				'VICOPISANO',
				'VOLTERRA',
				'CASCIANA TERME LARI',
				'CRESPINA LORENZANA',
				'SANTA LUCE-ORCIANO',
			),
			'AR' => array(
				'ANGHIARI',
				'AREZZO',
				'BADIA TEDALDA',
				'BIBBIENA',
				'BUCINE',
				'CAPOLONA',
				'CAPRESE MICHELANGELO',
				'CASTEL FOCOGNANO',
				'CASTELFRANCO DI SOPRA',
				'CASTEL SAN NICCOLO\'',
				'CASTIGLION FIBOCCHI',
				'CASTIGLION FIORENTINO',
				'CAVRIGLIA',
				'CHITIGNANO',
				'CHIUSI DELLA VERNA',
				'CIVITELLA IN VAL DI CHIANA',
				'CORTONA',
				'FOIANO DELLA CHIANA',
				'LATERINA',
				'LORO CIUFFENNA',
				'LUCIGNANO',
				'MARCIANO DELLA CHIANA',
				'MONTEMIGNAIO',
				'MONTERCHI',
				'MONTE SAN SAVINO',
				'MONTEVARCHI',
				'ORTIGNANO RAGGIOLO',
				'PERGINE VALDARNO',
				'PIAN DI SCO',
				'PIEVE SANTO STEFANO',
				'POPPI',
				'PRATOVECCHIO',
				'SAN GIOVANNI VALDARNO',
				'SANSEPOLCRO',
				'SESTINO',
				'STIA',
				'SUBBIANO',
				'TALLA',
				'TERRANUOVA BRACCIOLINI',
				'CASTELFRANCO PIANDISCO\'',
				'PRATOVECCHIO STIA',
				'CASTIGLION UBERTINI',
				'PRATOVECCHIO-STIA',
				'RAGGIOLO',
			),
			'SI' => array(
				'ABBADIA SAN SALVATORE',
				'ASCIANO',
				'BUONCONVENTO',
				'CASOLE D\'ELSA',
				'CASTELLINA IN CHIANTI',
				'CASTELNUOVO BERARDENGA',
				'CASTIGLIONE D\'ORCIA',
				'CETONA',
				'CHIANCIANO TERME',
				'CHIUSDINO',
				'CHIUSI',
				'COLLE DI VAL D\'ELSA',
				'GAIOLE IN CHIANTI',
				'MONTALCINO',
				'MONTEPULCIANO',
				'MONTERIGGIONI',
				'MONTERONI D\'ARBIA',
				'MONTICIANO',
				'MURLO',
				'PIANCASTAGNAIO',
				'PIENZA',
				'POGGIBONSI',
				'RADDA IN CHIANTI',
				'RADICOFANI',
				'RADICONDOLI',
				'RAPOLANO TERME',
				'SAN CASCIANO DEI BAGNI',
				'SAN GIMIGNANO',
				'SAN GIOVANNI D\'ASSO',
				'SAN QUIRICO D\'ORCIA',
				'SARTEANO',
				'SIENA',
				'SINALUNGA',
				'SOVICILLE',
				'TORRITA DI SIENA',
				'TREQUANDA',
				'MASSE DI CITTA\'',
				'MASSE DI SAN MARTINO',
				'MASSE DI SIENA',
			),
			'GR' => array(
				'ARCIDOSSO',
				'CAMPAGNATICO',
				'CAPALBIO',
				'CASTEL DEL PIANO',
				'CASTELL\'AZZARA',
				'CASTIGLIONE DELLA PESCAIA',
				'CINIGIANO',
				'CIVITELLA PAGANICO',
				'FOLLONICA',
				'GAVORRANO',
				'GROSSETO',
				'ISOLA DEL GIGLIO',
				'MAGLIANO IN TOSCANA',
				'MANCIANO',
				'MASSA MARITTIMA',
				'MONTE ARGENTARIO',
				'MONTIERI',
				'ORBETELLO',
				'PITIGLIANO',
				'ROCCALBEGNA',
				'ROCCASTRADA',
				'SANTA FIORA',
				'SCANSANO',
				'SCARLINO',
				'SEGGIANO',
				'SORANO',
				'MONTEROTONDO MARITTIMO',
				'SEMPRONIANO',
			),
			'PO' => array(
				'CANTAGALLO',
				'CARMIGNANO',
				'MONTEMURLO',
				'POGGIO A CAIANO',
				'PRATO',
				'VAIANO',
				'VERNIO',
			),
			'PG' => array(
				'ASSISI',
				'BASTIA UMBRA',
				'BETTONA',
				'BEVAGNA',
				'CAMPELLO SUL CLITUNNO',
				'CANNARA',
				'CASCIA',
				'CASTEL RITALDI',
				'CASTIGLIONE DEL LAGO',
				'CERRETO DI SPOLETO',
				'CITERNA',
				'CITTA\' DELLA PIEVE',
				'CITTA\' DI CASTELLO',
				'COLLAZZONE',
				'CORCIANO',
				'COSTACCIARO',
				'DERUTA',
				'FOLIGNO',
				'FOSSATO DI VICO',
				'FRATTA TODINA',
				'GIANO DELL\'UMBRIA',
				'GUALDO CATTANEO',
				'GUALDO TADINO',
				'GUBBIO',
				'LISCIANO NICCONE',
				'MAGIONE',
				'MARSCIANO',
				'MASSA MARTANA',
				'MONTE CASTELLO DI VIBIO',
				'MONTEFALCO',
				'MONTELEONE DI SPOLETO',
				'MONTE SANTA MARIA TIBERINA',
				'MONTONE',
				'NOCERA UMBRA',
				'NORCIA',
				'PACIANO',
				'PANICALE',
				'PASSIGNANO SUL TRASIMENO',
				'PERUGIA',
				'PIEGARO',
				'PIETRALUNGA',
				'POGGIODOMO',
				'PRECI',
				'SAN GIUSTINO',
				'SANT\'ANATOLIA DI NARCO',
				'SCHEGGIA E PASCELUPO',
				'SCHEGGINO',
				'SELLANO',
				'SIGILLO',
				'SPELLO',
				'SPOLETO',
				'TODI',
				'TORGIANO',
				'TREVI',
				'TUORO SUL TRASIMENO',
				'UMBERTIDE',
				'VALFABBRICA',
				'VALLO DI NERA',
				'VALTOPINA',
				'BOCCHIGNANO',
				'CAPITONE',
				'CASTEL SAN FELICE',
				'CASTEL SAN GIOVANNI DI SPOLETO',
				'CESELLI',
				'COLLEMANCIO',
				'PIEDIPATERNO SUL NERA',
				'MONTE SANTA MARIA IN SABINA',
				'MONTESANTO VIGI',
				'OLIVETO IN SABINA',
				'PASCELUPO',
				'ROCCHETTE IN SABINA',
				'SCHEGGIA',
			),
			'TR' => array(
				'ACQUASPARTA',
				'ALLERONA',
				'ALVIANO',
				'AMELIA',
				'ARRONE',
				'ATTIGLIANO',
				'BASCHI',
				'CALVI DELL\'UMBRIA',
				'CASTEL GIORGIO',
				'CASTEL VISCARDO',
				'FABRO',
				'FERENTILLO',
				'FICULLE',
				'GIOVE',
				'GUARDEA',
				'LUGNANO IN TEVERINA',
				'MONTECASTRILLI',
				'MONTECCHIO',
				'MONTEFRANCO',
				'MONTEGABBIONE',
				'MONTELEONE D\'ORVIETO',
				'NARNI',
				'ORVIETO',
				'OTRICOLI',
				'PARRANO',
				'PENNA IN TEVERINA',
				'POLINO',
				'PORANO',
				'SAN GEMINI',
				'SAN VENANZO',
				'STRONCONE',
				'TERNI',
				'AVIGLIANO UMBRO',
				'CARNAIOLA',
				'CASTEL DI LAGO',
				'CESI',
				'COLLESCIPOLI',
				'COLLESTATTE',
				'MONTEGIOVE',
				'MONTERUBBIAGLIO',
				'PAPIGNO',
				'PIEDILUCO',
				'PORCHIANO DEL MONTE',
				'PORTARIA',
				'SAN VITO IN MONTE',
				'TORRE ORSINA',
			),
			'PS' => array(
				'ACQUALAGNA',
				'APECCHIO',
				'AUDITORE',
				'BARCHI',
				'BELFORTE ALL\'ISAURO',
				'BORGO PACE',
				'CAGLI',
				'CANTIANO',
				'CARPEGNA',
				'CARTOCETO',
				'CASTELDELCI',
				'COLBORDOLO',
				'FANO',
				'FERMIGNANO',
				'FOSSOMBRONE',
				'FRATTE ROSA',
				'FRONTINO',
				'FRONTONE',
				'GABICCE MARE',
				'GRADARA',
				'ISOLA DEL PIANO',
				'LUNANO',
				'MACERATA FELTRIA',
				'MAIOLO',
				'MERCATELLO SUL METAURO',
				'MERCATINO CONCA',
				'MOMBAROCCIO',
				'MONDAVIO',
				'MONDOLFO',
				'MONTECALVO IN FOGLIA',
				'MONTE CERIGNONE',
				'MONTECICCARDO',
				'MONTECOPIOLO',
				'MONTEFELCINO',
				'MONTE GRIMANO',
				'MONTELABBATE',
				'MONTEMAGGIORE AL METAURO',
				'MONTE PORZIO',
				'NOVAFELTRIA',
				'ORCIANO DI PESARO',
				'PEGLIO',
				'PENNABILLI',
				'PERGOLA',
				'PESARO',
				'PETRIANO',
				'PIAGGE',
				'PIANDIMELETO',
				'PIETRARUBBIA',
				'PIOBBICO',
				'SALTARA',
				'SAN COSTANZO',
				'SAN GIORGIO DI PESARO',
				'SAN LEO',
				'SAN LORENZO IN CAMPO',
				'SANT\'AGATA FELTRIA',
				'SANT\'ANGELO IN LIZZOLA',
				'SANT\'ANGELO IN VADO',
				'SANT\'IPPOLITO',
				'SASSOCORVARO',
				'SASSOFELTRIO',
				'SERRA SANT\'ABBONDIO',
				'SERRUNGARINA',
				'TALAMELLO',
				'TAVOLETO',
				'TAVULLIA',
				'URBANIA',
				'URBINO',
				'VALLEFOGLIA',
				'COLLI AL METAURO',
				'TERRE ROVERESCHE',
				'CANDELARA',
				'CASTELDIMEZZO',
				'FENIGLI',
				'FIORENZUOLA DI FOCARA',
				'FRONTONE-SERRA',
				'GINESTRETO',
				'ISOLA DI FANO',
				'MONTALFOGLIO',
				'MONTALTO TARUGO',
				'MONTEBELLO METAURENSE',
				'MONTEFABBRI',
				'MONTEGUIDUCCIO',
				'MONTEMAGGIORE',
				'MONTE MONTANARO',
				'MONTEROLO',
				'MONTESECCO ANTICO',
				'MONTEVECCHIO',
				'NOVILARA',
				'POZZO ALTO',
				'SANT\'ANDREA DI SUASA',
				'SAN VITO SUL CESANO',
				'SCAVOLINO',
				'SORBOLONGO',
				'TORRE SAN MARCO',
				'MONTE GRIMANO TERME',
			),
			'AN' => array(
				'AGUGLIANO',
				'ANCONA',
				'ARCEVIA',
				'BARBARA',
				'BELVEDERE OSTRENSE',
				'CAMERANO',
				'CAMERATA PICENA',
				'CASTELBELLINO',
				'CASTEL COLONNA',
				'CASTELFIDARDO',
				'CASTELLEONE DI SUASA',
				'CASTELPLANIO',
				'CERRETO D\'ESI',
				'CHIARAVALLE',
				'CORINALDO',
				'CUPRAMONTANA',
				'FABRIANO',
				'FALCONARA MARITTIMA',
				'FILOTTRANO',
				'GENGA',
				'JESI',
				'LORETO',
				'MAIOLATI SPONTINI',
				'MERGO',
				'MONSANO',
				'MONTECAROTTO',
				'MONTEMARCIANO',
				'MONTERADO',
				'MONTE ROBERTO',
				'MONTE SAN VITO',
				'MORRO D\'ALBA',
				'NUMANA',
				'OFFAGNA',
				'OSIMO',
				'OSTRA',
				'OSTRA VETERE',
				'POGGIO SAN MARCELLO',
				'POLVERIGI',
				'RIPE',
				'ROSORA',
				'SAN MARCELLO',
				'SAN PAOLO DI JESI',
				'SANTA MARIA NUOVA',
				'SASSOFERRATO',
				'SENIGALLIA',
				'SERRA DE\' CONTI',
				'SERRA SAN QUIRICO',
				'SIROLO',
				'STAFFOLO',
				'TRECASTELLI',
				'MONTESICURO',
				'PATERNO D\'ANCONA',
				'ROSORA MERGO',
			),
			'MC' => array(
				'ACQUACANINA',
				'APIRO',
				'APPIGNANO',
				'BELFORTE DEL CHIENTI',
				'BOLOGNOLA',
				'CALDAROLA',
				'CAMERINO',
				'CAMPOROTONDO DI FIASTRONE',
				'CASTELRAIMONDO',
				'CASTELSANTANGELO SUL NERA',
				'CESSAPALOMBO',
				'CINGOLI',
				'CIVITANOVA MARCHE',
				'COLMURANO',
				'CORRIDONIA',
				'ESANATOGLIA',
				'FIASTRA',
				'FIORDIMONTE',
				'FIUMINATA',
				'GAGLIOLE',
				'GUALDO',
				'LORO PICENO',
				'MACERATA',
				'MATELICA',
				'MOGLIANO',
				'MONTECASSIANO',
				'MONTE CAVALLO',
				'MONTECOSARO',
				'MONTEFANO',
				'MONTELUPONE',
				'MONTE SAN GIUSTO',
				'MONTE SAN MARTINO',
				'MORROVALLE',
				'MUCCIA',
				'PENNA SAN GIOVANNI',
				'PETRIOLO',
				'PIEVEBOVIGLIANA',
				'PIEVE TORINA',
				'PIORACO',
				'POGGIO SAN VICINO',
				'POLLENZA',
				'PORTO RECANATI',
				'POTENZA PICENA',
				'RECANATI',
				'RIPE SAN GINESIO',
				'SAN GINESIO',
				'SAN SEVERINO MARCHE',
				'SANT\'ANGELO IN PONTANO',
				'SARNANO',
				'SEFRO',
				'SERRAPETRONA',
				'SERRAVALLE DI CHIENTI',
				'TOLENTINO',
				'TREIA',
				'URBISAGLIA',
				'USSITA',
				'VISSO',
				'VALFORNACE',
				'PORTO CIVITANOVA',
			),
			'AP' => array(
				'ACQUASANTA TERME',
				'ACQUAVIVA PICENA',
				'ALTIDONA',
				'AMANDOLA',
				'APPIGNANO DEL TRONTO',
				'ARQUATA DEL TRONTO',
				'ASCOLI PICENO',
				'BELMONTE PICENO',
				'CAMPOFILONE',
				'CARASSAI',
				'CASTEL DI LAMA',
				'CASTIGNANO',
				'CASTORANO',
				'COLLI DEL TRONTO',
				'COMUNANZA',
				'COSSIGNANO',
				'CUPRA MARITTIMA',
				'FALERONE',
				'FERMO',
				'FOLIGNANO',
				'FORCE',
				'FRANCAVILLA D\'ETE',
				'GROTTAMMARE',
				'GROTTAZZOLINA',
				'LAPEDONA',
				'MAGLIANO DI TENNA',
				'MALTIGNANO',
				'MASSA FERMANA',
				'MASSIGNANO',
				'MONSAMPIETRO MORICO',
				'MONSAMPOLO DEL TRONTO',
				'MONTALTO DELLE MARCHE',
				'MONTAPPONE',
				'MONTEDINOVE',
				'MONTEFALCONE APPENNINO',
				'MONTEFIORE DELL\'ASO',
				'MONTEFORTINO',
				'MONTEGALLO',
				'MONTE GIBERTO',
				'MONTEGIORGIO',
				'MONTEGRANARO',
				'MONTELEONE DI FERMO',
				'MONTELPARO',
				'MONTEMONACO',
				'MONTEPRANDONE',
				'MONTE RINALDO',
				'MONTERUBBIANO',
				'MONTE SAN PIETRANGELI',
				'MONTE URANO',
				'MONTE VIDON COMBATTE',
				'MONTE VIDON CORRADO',
				'MONTOTTONE',
				'MORESCO',
				'OFFIDA',
				'ORTEZZANO',
				'PALMIANO',
				'PEDASO',
				'PETRITOLI',
				'PONZANO DI FERMO',
				'PORTO SAN GIORGIO',
				'PORTO SANT\'ELPIDIO',
				'RAPAGNANO',
				'RIPATRANSONE',
				'ROCCAFLUVIONE',
				'ROTELLA',
				'SAN BENEDETTO DEL TRONTO',
				'SANTA VITTORIA IN MATENANO',
				'SANT\'ELPIDIO A MARE',
				'SERVIGLIANO',
				'SMERILLO',
				'SPINETOLI',
				'TORRE SAN PATRIZIO',
				'VENAROTTA',
				'ALTETA',
				'CAPRADOSSO',
				'CASTEL DI CROCE',
				'LISCIANO DEL TRONTO',
				'MONTACUTO',
				'MONTADAMO',
				'MONTECALVO DEL CASTELLANO',
				'MOREGNANO',
				'MOZZANO',
				'OSOLI',
				'PAGLIARE',
				'PATRIGNONE',
				'PORCHIA',
				'PORCHIANO DELL\'ASCENSIONE',
				'QUINTODECIMO',
				'RIPABERARDA',
				'ROCCAREONILE',
				'SANTA MARIA DEL TRONTO',
				'SANT\'ELPIDIO MORICO',
				'TORRE DI PALME',
			),
			'FM' => array(
				'ALTIDONA',
				'AMANDOLA',
				'BELMONTE PICENO',
				'CAMPOFILONE',
				'FALERONE',
				'FERMO',
				'FRANCAVILLA D\'ETE',
				'GROTTAZZOLINA',
				'LAPEDONA',
				'MAGLIANO DI TENNA',
				'MASSA FERMANA',
				'MONSAMPIETRO MORICO',
				'MONTAPPONE',
				'MONTEFALCONE APPENNINO',
				'MONTEFORTINO',
				'MONTE GIBERTO',
				'MONTEGIORGIO',
				'MONTEGRANARO',
				'MONTELEONE DI FERMO',
				'MONTELPARO',
				'MONTE RINALDO',
				'MONTERUBBIANO',
				'MONTE SAN PIETRANGELI',
				'MONTE URANO',
				'MONTE VIDON COMBATTE',
				'MONTE VIDON CORRADO',
				'MONTOTTONE',
				'MORESCO',
				'ORTEZZANO',
				'PEDASO',
				'PETRITOLI',
				'PONZANO DI FERMO',
				'PORTO SAN GIORGIO',
				'PORTO SANT\'ELPIDIO',
				'RAPAGNANO',
				'SANTA VITTORIA IN MATENANO',
				'SANT\'ELPIDIO A MARE',
				'SERVIGLIANO',
				'SMERILLO',
				'TORRE SAN PATRIZIO',
			),
			'VT' => array(
				'ACQUAPENDENTE',
				'ARLENA DI CASTRO',
				'BAGNOREGIO',
				'BARBARANO ROMANO',
				'BASSANO ROMANO',
				'BASSANO IN TEVERINA',
				'BLERA',
				'BOLSENA',
				'BOMARZO',
				'CALCATA',
				'CANEPINA',
				'CANINO',
				'CAPODIMONTE',
				'CAPRANICA',
				'CAPRAROLA',
				'CARBOGNANO',
				'CASTEL SANT\'ELIA',
				'CASTIGLIONE IN TEVERINA',
				'CELLENO',
				'CELLERE',
				'CIVITA CASTELLANA',
				'CIVITELLA D\'AGLIANO',
				'CORCHIANO',
				'FABRICA DI ROMA',
				'FALERIA',
				'FARNESE',
				'GALLESE',
				'GRADOLI',
				'GRAFFIGNANO',
				'GROTTE DI CASTRO',
				'ISCHIA DI CASTRO',
				'LATERA',
				'LUBRIANO',
				'MARTA',
				'MONTALTO DI CASTRO',
				'MONTEFIASCONE',
				'MONTE ROMANO',
				'MONTEROSI',
				'NEPI',
				'ONANO',
				'ORIOLO ROMANO',
				'ORTE',
				'PIANSANO',
				'PROCENO',
				'RONCIGLIONE',
				'VILLA SAN GIOVANNI IN TUSCIA',
				'SAN LORENZO NUOVO',
				'SORIANO NEL CIMINO',
				'SUTRI',
				'TARQUINIA',
				'TESSENNANO',
				'TUSCANIA',
				'VALENTANO',
				'VALLERANO',
				'VASANELLO',
				'VEJANO',
				'VETRALLA',
				'VIGNANELLO',
				'VITERBO',
				'VITORCHIANO',
				'BAGNAIA',
				'CASTEL CELLESI',
				'GROTTE DI SANTO STEFANO',
				'ROCCALVECCE',
				'SAN MARTINO AL CIMINO',
				'SAN MICHELE IN TEVERINA',
			),
			'RI' => array(
				'ACCUMOLI',
				'AMATRICE',
				'ANTRODOCO',
				'ASCREA',
				'BELMONTE IN SABINA',
				'BORBONA',
				'BORGOROSE',
				'BORGO VELINO',
				'CANTALICE',
				'CANTALUPO IN SABINA',
				'CASAPROTA',
				'CASPERIA',
				'CASTEL DI TORA',
				'CASTELNUOVO DI FARFA',
				'CASTEL SANT\'ANGELO',
				'CITTADUCALE',
				'CITTAREALE',
				'COLLALTO SABINO',
				'COLLE DI TORA',
				'COLLEGIOVE',
				'COLLEVECCHIO',
				'COLLI SUL VELINO',
				'CONCERVIANO',
				'CONFIGNI',
				'CONTIGLIANO',
				'COTTANELLO',
				'FARA IN SABINA',
				'FIAMIGNANO',
				'FORANO',
				'FRASSO SABINO',
				'GRECCIO',
				'LABRO',
				'LEONESSA',
				'LONGONE SABINO',
				'MAGLIANO SABINA',
				'MARCETELLI',
				'MICIGLIANO',
				'MOMPEO',
				'MONTASOLA',
				'MONTEBUONO',
				'MONTELEONE SABINO',
				'MONTENERO SABINO',
				'MONTE SAN GIOVANNI IN SABINA',
				'MONTOPOLI DI SABINA',
				'MORRO REATINO',
				'NESPOLO',
				'ORVINIO',
				'PAGANICO SABINO',
				'PESCOROCCHIANO',
				'PETRELLA SALTO',
				'POGGIO BUSTONE',
				'POGGIO CATINO',
				'POGGIO MIRTETO',
				'POGGIO MOIANO',
				'POGGIO NATIVO',
				'POGGIO SAN LORENZO',
				'POSTA',
				'POZZAGLIA SABINO',
				'RIETI',
				'RIVODUTRI',
				'ROCCANTICA',
				'ROCCA SINIBALDA',
				'SALISANO',
				'SCANDRIGLIA',
				'SELCI',
				'STIMIGLIANO',
				'TARANO',
				'TOFFIA',
				'TORRICELLA IN SABINA',
				'TORRI IN SABINA',
				'TURANIA',
				'VACONE',
				'VARCO SABINO',
				'CASTEL SAN BENEDETTO REATINO',
				'CERCHIARA DI SABINA',
				'COLLEBACCARO',
				'VAZIA',
				'POGGIO FIDONI',
				'POSTICCIOLA',
				'SAN GIOVANNI REATINO',
				'SANT\'ELIA REATINO',
			),
			'RM' => array(
				'AFFILE',
				'AGOSTA',
				'ALBANO LAZIALE',
				'ALLUMIERE',
				'ANGUILLARA SABAZIA',
				'ANTICOLI CORRADO',
				'ANZIO',
				'ARCINAZZO ROMANO',
				'ARICCIA',
				'ARSOLI',
				'ARTENA',
				'BELLEGRA',
				'BRACCIANO',
				'CAMERATA NUOVA',
				'CAMPAGNANO DI ROMA',
				'CANALE MONTERANO',
				'CANTERANO',
				'CAPENA',
				'CAPRANICA PRENESTINA',
				'CARPINETO ROMANO',
				'CASAPE',
				'CASTEL GANDOLFO',
				'CASTEL MADAMA',
				'CASTELNUOVO DI PORTO',
				'CASTEL SAN PIETRO ROMANO',
				'CAVE',
				'CERRETO LAZIALE',
				'CERVARA DI ROMA',
				'CERVETERI',
				'CICILIANO',
				'CINETO ROMANO',
				'CIVITAVECCHIA',
				'CIVITELLA SAN PAOLO',
				'COLLEFERRO',
				'COLONNA',
				'FIANO ROMANO',
				'FILACCIANO',
				'FORMELLO',
				'FRASCATI',
				'GALLICANO NEL LAZIO',
				'GAVIGNANO',
				'GENAZZANO',
				'GENZANO DI ROMA',
				'GERANO',
				'GORGA',
				'GROTTAFERRATA',
				'GUIDONIA MONTECELIO',
				'JENNE',
				'LABICO',
				'LANUVIO',
				'LICENZA',
				'MAGLIANO ROMANO',
				'MANDELA',
				'MANZIANA',
				'MARANO EQUO',
				'MARCELLINA',
				'MARINO',
				'MAZZANO ROMANO',
				'MENTANA',
				'MONTECOMPATRI',
				'MONTEFLAVIO',
				'MONTELANICO',
				'MONTELIBRETTI',
				'MONTE PORZIO CATONE',
				'MONTEROTONDO',
				'MONTORIO ROMANO',
				'MORICONE',
				'MORLUPO',
				'NAZZANO',
				'NEMI',
				'NEROLA',
				'NETTUNO',
				'OLEVANO ROMANO',
				'PALESTRINA',
				'PALOMBARA SABINA',
				'PERCILE',
				'PISONIANO',
				'POLI',
				'POMEZIA',
				'PONZANO ROMANO',
				'RIANO',
				'RIGNANO FLAMINIO',
				'RIOFREDDO',
				'ROCCA CANTERANO',
				'ROCCA DI CAVE',
				'ROCCA DI PAPA',
				'ROCCAGIOVINE',
				'ROCCA PRIORA',
				'ROCCA SANTO STEFANO',
				'ROIATE',
				'ROMA',
				'ROVIANO',
				'SACROFANO',
				'SAMBUCI',
				'SAN GREGORIO DA SASSOLA',
				'SAN POLO DEI CAVALIERI',
				'SANTA MARINELLA',
				'SANT\'ANGELO ROMANO',
				'SANT\'ORESTE',
				'SAN VITO ROMANO',
				'SARACINESCO',
				'SEGNI',
				'SUBIACO',
				'TIVOLI',
				'TOLFA',
				'TORRITA TIBERINA',
				'TREVIGNANO ROMANO',
				'VALLEPIETRA',
				'VALLINFREDA',
				'VALMONTONE',
				'VELLETRI',
				'VICOVARO',
				'VIVARO ROMANO',
				'ZAGAROLO',
				'LARIANO',
				'LADISPOLI',
				'ARDEA',
				'CIAMPINO',
				'SAN CESAREO',
				'FIUMICINO',
				'BOVILLE',
				'FONTE NUOVA',
				'MONTECELIO',
				'NETTUNIA',
			),
			'LT' => array(
				'APRILIA',
				'BASSIANO',
				'CAMPODIMELE',
				'CASTELFORTE',
				'CISTERNA DI LATINA',
				'CORI',
				'FONDI',
				'FORMIA',
				'GAETA',
				'ITRI',
				'LATINA',
				'LENOLA',
				'MAENZA',
				'MINTURNO',
				'MONTE SAN BIAGIO',
				'NORMA',
				'PONTINIA',
				'PONZA',
				'PRIVERNO',
				'PROSSEDI',
				'ROCCAGORGA',
				'ROCCA MASSIMA',
				'ROCCASECCA DEI VOLSCI',
				'SABAUDIA',
				'SAN FELICE CIRCEO',
				'SANTI COSMA E DAMIANO',
				'SERMONETA',
				'SEZZE',
				'SONNINO',
				'SPERLONGA',
				'SPIGNO SATURNIA',
				'TERRACINA',
				'VENTOTENE',
				'CASTELLONORATO',
				'ELENA',
				'MARANOLA',
			),
			'FR' => array(
				'ACQUAFONDATA',
				'ACUTO',
				'ALATRI',
				'ALVITO',
				'AMASENO',
				'ANAGNI',
				'AQUINO',
				'ARCE',
				'ARNARA',
				'ARPINO',
				'ATINA',
				'AUSONIA',
				'BELMONTE CASTELLO',
				'BOVILLE ERNICA',
				'BROCCOSTELLA',
				'CAMPOLI APPENNINO',
				'CASALATTICO',
				'CASALVIERI',
				'CASSINO',
				'CASTELLIRI',
				'CASTELNUOVO PARANO',
				'CASTROCIELO',
				'CASTRO DEI VOLSCI',
				'CECCANO',
				'CEPRANO',
				'CERVARO',
				'COLFELICE',
				'COLLEPARDO',
				'COLLE SAN MAGNO',
				'CORENO AUSONIO',
				'ESPERIA',
				'FALVATERRA',
				'FERENTINO',
				'FILETTINO',
				'FIUGGI',
				'FONTANA LIRI',
				'FONTECHIARI',
				'FROSINONE',
				'FUMONE',
				'GALLINARO',
				'GIULIANO DI ROMA',
				'GUARCINO',
				'ISOLA DEL LIRI',
				'MONTE SAN GIOVANNI CAMPANO',
				'MOROLO',
				'PALIANO',
				'PASTENA',
				'PATRICA',
				'PESCOSOLIDO',
				'PICINISCO',
				'PICO',
				'PIEDIMONTE SAN GERMANO',
				'PIGLIO',
				'PIGNATARO INTERAMNA',
				'POFI',
				'PONTECORVO',
				'POSTA FIBRENO',
				'RIPI',
				'ROCCA D\'ARCE',
				'ROCCASECCA',
				'SAN BIAGIO SARACINISCO',
				'SAN DONATO VAL DI COMINO',
				'SAN GIORGIO A LIRI',
				'SAN GIOVANNI INCARICO',
				'SANT\'AMBROGIO SUL GARIGLIANO',
				'SANT\'ANDREA DEL GARIGLIANO',
				'SANT\'APOLLINARE',
				'SANT\'ELIA FIUMERAPIDO',
				'SANTOPADRE',
				'SAN VITTORE DEL LAZIO',
				'SERRONE',
				'SETTEFRATI',
				'SGURGOLA',
				'SORA',
				'STRANGOLAGALLI',
				'SUPINO',
				'TERELLE',
				'TORRE CAJETANI',
				'TORRICE',
				'TREVI NEL LAZIO',
				'TRIVIGLIANO',
				'VALLECORSA',
				'VALLEMAIO',
				'VALLEROTONDA',
				'VEROLI',
				'VICALVI',
				'VICO NEL LAZIO',
				'VILLA LATINA',
				'VILLA SANTA LUCIA',
				'VILLA SANTO STEFANO',
				'VITICUSO',
				'ROCCAGUGLIELMA',
				'SAN PIETRO IN CUROLIS',
				'SANT\'ANDREA DI VALLEFREDDA',
				'VITICUSO E ACQUAFONDATA',
			),
			'AQ' => array(
				'ACCIANO',
				'AIELLI',
				'ALFEDENA',
				'ANVERSA DEGLI ABRUZZI',
				'ATELETA',
				'AVEZZANO',
				'BALSORANO',
				'BARETE',
				'BARISCIANO',
				'BARREA',
				'BISEGNA',
				'BUGNARA',
				'CAGNANO AMITERNO',
				'CALASCIO',
				'CAMPO DI GIOVE',
				'CAMPOTOSTO',
				'CANISTRO',
				'CANSANO',
				'CAPESTRANO',
				'CAPISTRELLO',
				'CAPITIGNANO',
				'CAPORCIANO',
				'CAPPADOCIA',
				'CARAPELLE CALVISIO',
				'CARSOLI',
				'CASTEL DEL MONTE',
				'CASTEL DI IERI',
				'CASTEL DI SANGRO',
				'CASTELLAFIUME',
				'CASTELVECCHIO CALVISIO',
				'CASTELVECCHIO SUBEQUO',
				'CELANO',
				'CERCHIO',
				'CIVITA D\'ANTINO',
				'CIVITELLA ALFEDENA',
				'CIVITELLA ROVETO',
				'COCULLO',
				'COLLARMELE',
				'COLLELONGO',
				'COLLEPIETRO',
				'CORFINIO',
				'FAGNANO ALTO',
				'FONTECCHIO',
				'FOSSA',
				'GAGLIANO ATERNO',
				'GIOIA DEI MARSI',
				'GORIANO SICOLI',
				'INTRODACQUA',
				'L\'AQUILA',
				'LECCE NEI MARSI',
				'LUCO DEI MARSI',
				'LUCOLI',
				'MAGLIANO DE\' MARSI',
				'MASSA D\'ALBE',
				'MOLINA ATERNO',
				'MONTEREALE',
				'MORINO',
				'NAVELLI',
				'OCRE',
				'OFENA',
				'OPI',
				'ORICOLA',
				'ORTONA DEI MARSI',
				'ORTUCCHIO',
				'OVINDOLI',
				'PACENTRO',
				'PERETO',
				'PESCASSEROLI',
				'PESCINA',
				'PESCOCOSTANZO',
				'PETTORANO SUL GIZIO',
				'PIZZOLI',
				'POGGIO PICENZE',
				'PRATA D\'ANSIDONIA',
				'PRATOLA PELIGNA',
				'PREZZA',
				'RAIANO',
				'RIVISONDOLI',
				'ROCCACASALE',
				'ROCCA DI BOTTE',
				'ROCCA DI CAMBIO',
				'ROCCA DI MEZZO',
				'ROCCA PIA',
				'ROCCARASO',
				'SAN BENEDETTO DEI MARSI',
				'SAN BENEDETTO IN PERILLIS',
				'SAN DEMETRIO NE\' VESTINI',
				'SAN PIO DELLE CAMERE',
				'SANTE MARIE',
				'SANT\'EUSANIO FORCONESE',
				'SANTO STEFANO DI SESSANIO',
				'SAN VINCENZO VALLE ROVETO',
				'SCANNO',
				'SCONTRONE',
				'SCOPPITO',
				'SCURCOLA MARSICANA',
				'SECINARO',
				'SULMONA',
				'TAGLIACOZZO',
				'TIONE DEGLI ABRUZZI',
				'TORNIMPARTE',
				'TRASACCO',
				'VILLALAGO',
				'VILLA SANTA LUCIA DEGLI ABRUZZI',
				'VILLA SANT\'ANGELO',
				'VILLAVALLELONGA',
				'VILLETTA BARREA',
				'VITTORITO',
				'ARISCHIA',
				'BAGNO',
				'CAMARDA',
				'GORIANO VALLI',
				'PAGANICA',
				'PRETURO',
				'ROIO PIANO',
				'SAN NICANDRO D\'AQUILA',
				'SASSA',
			),
			'TE' => array(
				'ALBA ADRIATICA',
				'ANCARANO',
				'ARSITA',
				'ATRI',
				'BASCIANO',
				'BELLANTE',
				'BISENTI',
				'CAMPLI',
				'CANZANO',
				'CASTEL CASTAGNA',
				'CASTELLALTO',
				'CASTELLI',
				'CASTIGLIONE MESSER RAIMONDO',
				'CASTILENTI',
				'CELLINO ATTANASIO',
				'CERMIGNANO',
				'CIVITELLA DEL TRONTO',
				'COLLEDARA',
				'COLONNELLA',
				'CONTROGUERRA',
				'CORROPOLI',
				'CORTINO',
				'CROGNALETO',
				'FANO ADRIANO',
				'GIULIANOVA',
				'ISOLA DEL GRAN SASSO D\'ITALIA',
				'MONTEFINO',
				'MONTORIO AL VOMANO',
				'MORRO D\'ORO',
				'MOSCIANO SANT\'ANGELO',
				'NERETO',
				'NOTARESCO',
				'PENNA SANT\'ANDREA',
				'PIETRACAMELA',
				'PINETO',
				'ROCCA SANTA MARIA',
				'ROSETO DEGLI ABRUZZI',
				'SANT\'EGIDIO ALLA VIBRATA',
				'SANT\'OMERO',
				'SILVI',
				'TERAMO',
				'TORANO NUOVO',
				'TORRICELLA SICURA',
				'TORTORETO',
				'TOSSICIA',
				'VALLE CASTELLANA',
				'MARTINSICURO',
				'VALLE SAN GIOVANNI',
			),
			'PE' => array(
				'ABBATEGGIO',
				'ALANNO',
				'BOLOGNANO',
				'BRITTOLI',
				'BUSSI SUL TIRINO',
				'CAPPELLE SUL TAVO',
				'CARAMANICO TERME',
				'CARPINETO DELLA NORA',
				'CASTIGLIONE A CASAURIA',
				'CATIGNANO',
				'CEPAGATTI',
				'CITTA\' SANT\'ANGELO',
				'CIVITAQUANA',
				'CIVITELLA CASANOVA',
				'COLLECORVINO',
				'CORVARA',
				'CUGNOLI',
				'ELICE',
				'FARINDOLA',
				'LETTOMANOPPELLO',
				'LORETO APRUTINO',
				'MANOPPELLO',
				'MONTEBELLO DI BERTONA',
				'MONTESILVANO',
				'MOSCUFO',
				'NOCCIANO',
				'PENNE',
				'PESCARA',
				'PESCOSANSONESCO',
				'PIANELLA',
				'PICCIANO',
				'PIETRANICO',
				'POPOLI',
				'ROCCAMORICE',
				'ROSCIANO',
				'SALLE',
				'SANT\'EUFEMIA A MAIELLA',
				'SAN VALENTINO IN ABRUZZO CITERIORE',
				'SCAFA',
				'SERRAMONACESCA',
				'SPOLTORE',
				'TOCCO DA CASAURIA',
				'TORRE DE\' PASSERI',
				'TURRIVALIGNANI',
				'VICOLI',
				'VILLA CELIERA',
				'CASTELLAMMARE ADRIATICO',
				'MONTESILVANO MARINA',
				'MUSELLARO',
				'ROCCACARAMANICO',
			),
			'CH' => array(
				'ALTINO',
				'ARCHI',
				'ARI',
				'ARIELLI',
				'ATESSA',
				'BOMBA',
				'BORRELLO',
				'BUCCHIANICO',
				'MONTEBELLO SUL SANGRO',
				'CANOSA SANNITA',
				'CARPINETO SINELLO',
				'CARUNCHIO',
				'CASACANDITELLA',
				'CASALANGUIDA',
				'CASALBORDINO',
				'CASALINCONTRADA',
				'CASOLI',
				'CASTEL FRENTANO',
				'CASTELGUIDONE',
				'CASTIGLIONE MESSER MARINO',
				'CELENZA SUL TRIGNO',
				'CHIETI',
				'CIVITALUPARELLA',
				'CIVITELLA MESSER RAIMONDO',
				'COLLEDIMACINE',
				'COLLEDIMEZZO',
				'CRECCHIO',
				'CUPELLO',
				'DOGLIOLA',
				'FARA FILIORUM PETRI',
				'FARA SAN MARTINO',
				'FILETTO',
				'FOSSACESIA',
				'FRAINE',
				'FRANCAVILLA AL MARE',
				'FRESAGRANDINARIA',
				'FRISA',
				'FURCI',
				'GAMBERALE',
				'GESSOPALENA',
				'GISSI',
				'GIULIANO TEATINO',
				'GUARDIAGRELE',
				'GUILMI',
				'LAMA DEI PELIGNI',
				'LANCIANO',
				'LENTELLA',
				'LETTOPALENA',
				'LISCIA',
				'MIGLIANICO',
				'MONTAZZOLI',
				'MONTEFERRANTE',
				'MONTELAPIANO',
				'MONTENERODOMO',
				'MONTEODORISIO',
				'MOZZAGROGNA',
				'ORSOGNA',
				'ORTONA',
				'PAGLIETA',
				'PALENA',
				'PALMOLI',
				'PALOMBARO',
				'PENNADOMO',
				'PENNAPIEDIMONTE',
				'PERANO',
				'PIZZOFERRATO',
				'POGGIOFIORITO',
				'POLLUTRI',
				'PRETORO',
				'QUADRI',
				'RAPINO',
				'RIPA TEATINA',
				'ROCCAMONTEPIANO',
				'ROCCA SAN GIOVANNI',
				'ROCCASCALEGNA',
				'ROCCASPINALVETI',
				'ROIO DEL SANGRO',
				'ROSELLO',
				'SAN BUONO',
				'SAN GIOVANNI LIPIONI',
				'SAN GIOVANNI TEATINO',
				'SAN MARTINO SULLA MARRUCINA',
				'SAN SALVO',
				'SANTA MARIA IMBARO',
				'SANT\'EUSANIO DEL SANGRO',
				'SAN VITO CHIETINO',
				'SCERNI',
				'SCHIAVI DI ABRUZZO',
				'TARANTA PELIGNA',
				'TOLLO',
				'TORINO DI SANGRO',
				'TORNARECCIO',
				'TORREBRUNA',
				'TORREVECCHIA TEATINA',
				'TORRICELLA PELIGNA',
				'TREGLIO',
				'TUFILLO',
				'VACRI',
				'VASTO',
				'VILLALFONSINA',
				'VILLAMAGNA',
				'VILLA SANTA MARIA',
				'PIETRAFERRAZZANA',
				'FALLO',
				'FALLASCOSO',
				'SAN SILVESTRO',
			),
			'CB' => array(
				'ACQUAVIVA COLLECROCE',
				'BARANELLO',
				'BOJANO',
				'BONEFRO',
				'BUSSO',
				'CAMPOBASSO',
				'CAMPOCHIARO',
				'CAMPODIPIETRA',
				'CAMPOLIETO',
				'CAMPOMARINO',
				'CASACALENDA',
				'CASALCIPRANO',
				'CASTELBOTTACCIO',
				'CASTELLINO DEL BIFERNO',
				'CASTELMAURO',
				'CASTROPIGNANO',
				'CERCEMAGGIORE',
				'CERCEPICCOLA',
				'CIVITACAMPOMARANO',
				'COLLE D\'ANCHISE',
				'COLLETORTO',
				'DURONIA',
				'FERRAZZANO',
				'FOSSALTO',
				'GAMBATESA',
				'GILDONE',
				'GUARDIALFIERA',
				'GUARDIAREGIA',
				'GUGLIONESI',
				'JELSI',
				'LARINO',
				'LIMOSANO',
				'LUCITO',
				'LUPARA',
				'MACCHIA VALFORTORE',
				'MAFALDA',
				'MATRICE',
				'MIRABELLO SANNITICO',
				'MOLISE',
				'MONACILIONI',
				'MONTAGANO',
				'MONTECILFONE',
				'MONTEFALCONE NEL SANNIO',
				'MONTELONGO',
				'MONTEMITRO',
				'MONTENERO DI BISACCIA',
				'MONTORIO NEI FRENTANI',
				'MORRONE DEL SANNIO',
				'ORATINO',
				'PALATA',
				'PETACCIATO',
				'PETRELLA TIFERNINA',
				'PIETRACATELLA',
				'PIETRACUPA',
				'PORTOCANNONE',
				'PROVVIDENTI',
				'RICCIA',
				'RIPABOTTONI',
				'RIPALIMOSANI',
				'ROCCAVIVARA',
				'ROTELLO',
				'SALCITO',
				'SAN BIASE',
				'SAN FELICE DEL MOLISE',
				'SAN GIACOMO DEGLI SCHIAVONI',
				'SAN GIOVANNI IN GALDO',
				'SAN GIULIANO DEL SANNIO',
				'SAN GIULIANO DI PUGLIA',
				'SAN MARTINO IN PENSILIS',
				'SAN MASSIMO',
				'SAN POLO MATESE',
				'SANTA CROCE DI MAGLIANO',
				'SANT\'ANGELO LIMOSANO',
				'SANT\'ELIA A PIANISI',
				'SEPINO',
				'SPINETE',
				'TAVENNA',
				'TERMOLI',
				'TORELLA DEL SANNIO',
				'TORO',
				'TRIVENTO',
				'TUFARA',
				'URURI',
				'VINCHIATURO',
				'CASTELLONE AL VOLTURNO',
				'SAN VINCENZO A VOLTURNO',
				'ACQUAVIVA D\'ISERNIA',
				'AGNONE',
				'BAGNOLI DEL TRIGNO',
				'BELMONTE DEL SANNIO',
				'CANTALUPO NEL SANNIO',
				'CAPRACOTTA',
				'CAROVILLI',
				'CARPINONE',
				'CASTEL DEL GIUDICE',
				'CASTEL SAN VINCENZO',
				'CASTELPETROSO',
				'CASTELPIZZUTO',
				'CASTELVERRINO',
				'CERRO AL VOLTURNO',
				'CHIAUCI',
				'CIVITANOVA DEL SANNIO',
				'COLLI A VOLTURNO',
				'CONCA CASALE',
				'FILIGNANO',
				'FORNELLI',
				'FROSOLONE',
				'ISERNIA',
				'LONGANO',
				'MACCHIA D\'ISERNIA',
				'MACCHIAGODENA',
				'MIRANDA',
				'MONTAQUILA',
				'MONTERODUNI',
				'PESCHE',
				'PESCOLANCIANO',
				'PESCOPENNATARO',
				'PETTORANELLO DEL MOLISE',
				'PIETRABBONDANTE',
				'PIZZONE',
				'POGGIO SANNITA',
				'POZZILLI',
				'RIONERO SANNITICO',
				'ROCCAMANDOLFI',
				'ROCCASICURA',
				'ROCCHETTA A VOLTURNO',
				'SAN PIETRO AVELLANA',
				'SANT\'AGAPITO',
				'SANT\'ANGELO DEL PESCO',
				'SANT\'ELENA SANNITA',
				'SANTA MARIA DEL MOLISE',
				'SCAPOLI',
				'SESSANO DEL MOLISE',
				'SESTO CAMPANO',
				'VASTOGIRARDI',
				'VENAFRO',
			),
			'IS' => array(
				'ACQUAVIVA D\'ISERNIA',
				'AGNONE',
				'BAGNOLI DEL TRIGNO',
				'BELMONTE DEL SANNIO',
				'CANTALUPO NEL SANNIO',
				'CAPRACOTTA',
				'CAROVILLI',
				'CARPINONE',
				'CASTEL DEL GIUDICE',
				'CASTELPETROSO',
				'CASTELPIZZUTO',
				'CASTEL SAN VINCENZO',
				'CASTELVERRINO',
				'CERRO AL VOLTURNO',
				'CHIAUCI',
				'CIVITANOVA DEL SANNIO',
				'COLLI A VOLTURNO',
				'CONCA CASALE',
				'FILIGNANO',
				'FORLI\' DEL SANNIO',
				'FORNELLI',
				'FROSOLONE',
				'ISERNIA',
				'LONGANO',
				'MACCHIA D\'ISERNIA',
				'MACCHIAGODENA',
				'MIRANDA',
				'MONTAQUILA',
				'MONTENERO VALCOCCHIARA',
				'MONTERODUNI',
				'PESCHE',
				'PESCOLANCIANO',
				'PESCOPENNATARO',
				'PETTORANELLO DEL MOLISE',
				'PIETRABBONDANTE',
				'PIZZONE',
				'POGGIO SANNITA',
				'POZZILLI',
				'RIONERO SANNITICO',
				'ROCCAMANDOLFI',
				'ROCCASICURA',
				'ROCCHETTA A VOLTURNO',
				'SAN PIETRO AVELLANA',
				'SANT\'AGAPITO',
				'SANTA MARIA DEL MOLISE',
				'SANT\'ANGELO DEL PESCO',
				'SANT\'ELENA SANNITA',
				'SCAPOLI',
				'SESSANO DEL MOLISE',
				'SESTO CAMPANO',
				'VASTOGIRARDI',
				'VENAFRO',
			),
			'CE' => array(
				'AILANO',
				'ALIFE',
				'ALVIGNANO',
				'ARIENZO',
				'AVERSA',
				'BAIA E LATINA',
				'BELLONA',
				'CAIANELLO',
				'CAIAZZO',
				'CALVI RISORTA',
				'CAMIGLIANO',
				'CANCELLO ED ARNONE',
				'CAPODRISE',
				'CAPRIATI A VOLTURNO',
				'CAPUA',
				'CARINARO',
				'CARINOLA',
				'CASAGIOVE',
				'CASAL DI PRINCIPE',
				'CASALUCE',
				'CASAPULLA',
				'CASERTA',
				'CASTEL CAMPAGNANO',
				'CASTEL DI SASSO',
				'CASTELLO DEL MATESE',
				'CASTEL MORRONE',
				'CASTEL VOLTURNO',
				'CERVINO',
				'CESA',
				'CIORLANO',
				'CONCA DELLA CAMPANIA',
				'CURTI',
				'DRAGONI',
				'FONTEGRECA',
				'FORMICOLA',
				'FRANCOLISE',
				'FRIGNANO',
				'GALLO MATESE',
				'GALLUCCIO',
				'GIANO VETUSTO',
				'GIOIA SANNITICA',
				'GRAZZANISE',
				'GRICIGNANO DI AVERSA',
				'LETINO',
				'LIBERI',
				'LUSCIANO',
				'MACERATA CAMPANIA',
				'MADDALONI',
				'MARCIANISE',
				'MARZANO APPIO',
				'MIGNANO MONTE LUNGO',
				'MONDRAGONE',
				'ORTA DI ATELLA',
				'PARETE',
				'PASTORANO',
				'PIANA DI MONTE VERNA',
				'PIEDIMONTE MATESE',
				'PIETRAMELARA',
				'PIETRAVAIRANO',
				'PIGNATARO MAGGIORE',
				'PONTELATONE',
				'PORTICO DI CASERTA',
				'PRATA SANNITA',
				'PRATELLA',
				'PRESENZANO',
				'RAVISCANINA',
				'RECALE',
				'RIARDO',
				'ROCCA D\'EVANDRO',
				'ROCCAMONFINA',
				'ROCCAROMANA',
				'ROCCHETTA E CROCE',
				'RUVIANO',
				'SAN CIPRIANO D\'AVERSA',
				'SAN FELICE A CANCELLO',
				'SAN GREGORIO MATESE',
				'SAN MARCELLINO',
				'SAN NICOLA LA STRADA',
				'SAN PIETRO INFINE',
				'SAN POTITO SANNITICO',
				'SAN PRISCO',
				'SANTA MARIA A VICO',
				'SANTA MARIA CAPUA VETERE',
				'SANTA MARIA LA FOSSA',
				'SAN TAMMARO',
				'SANT\'ANGELO D\'ALIFE',
				'SANT\'ARPINO',
				'SESSA AURUNCA',
				'SPARANISE',
				'SUCCIVO',
				'TEANO',
				'TEVEROLA',
				'TORA E PICCILLI',
				'TRENTOLA-DUCENTA',
				'VAIRANO PATENORA',
				'VALLE AGRICOLA',
				'VALLE DI MADDALONI',
				'VILLA DI BRIANO',
				'VILLA LITERNO',
				'VITULAZIO',
				'FALCIANO DEL MASSICO',
				'CELLOLE',
				'CASAPESENNA',
				'SAN MARCO EVANGELISTA',
				'ALBANOVA',
				'ARIENZO SANFELICE',
				'ATELLA DI NAPOLI',
				'CASALBA',
				'FERTILIA',
				'FRIGNANO MAGGIORE',
				'LUSCIANO E DUCENTA',
				'SAN LEUCIO',
				'VILLA VOLTURNO',
			),
			'BN' => array(
				'AIROLA',
				'AMOROSI',
				'APICE',
				'APOLLOSA',
				'ARPAIA',
				'ARPAISE',
				'BASELICE',
				'BENEVENTO',
				'BONEA',
				'BUCCIANO',
				'BUONALBERGO',
				'CALVI',
				'CAMPOLATTARO',
				'CAMPOLI DEL MONTE TABURNO',
				'CASALDUNI',
				'CASTELFRANCO IN MISCANO',
				'CASTELPAGANO',
				'CASTELPOTO',
				'CASTELVENERE',
				'CASTELVETERE IN VAL FORTORE',
				'CAUTANO',
				'CEPPALONI',
				'CERRETO SANNITA',
				'CIRCELLO',
				'COLLE SANNITA',
				'CUSANO MUTRI',
				'DUGENTA',
				'DURAZZANO',
				'FAICCHIO',
				'FOGLIANISE',
				'FOIANO DI VAL FORTORE',
				'FORCHIA',
				'FRAGNETO L\'ABATE',
				'FRAGNETO MONFORTE',
				'FRASSO TELESINO',
				'GINESTRA DEGLI SCHIAVONI',
				'GUARDIA SANFRAMONDI',
				'LIMATOLA',
				'MELIZZANO',
				'MOIANO',
				'MOLINARA',
				'MONTEFALCONE DI VAL FORTORE',
				'MONTESARCHIO',
				'MORCONE',
				'PADULI',
				'PAGO VEIANO',
				'PANNARANO',
				'PAOLISI',
				'PAUPISI',
				'PESCO SANNITA',
				'PIETRAROIA',
				'PIETRELCINA',
				'PONTE',
				'PONTELANDOLFO',
				'PUGLIANELLO',
				'REINO',
				'SAN BARTOLOMEO IN GALDO',
				'SAN GIORGIO DEL SANNIO',
				'SAN GIORGIO LA MOLARA',
				'SAN LEUCIO DEL SANNIO',
				'SAN LORENZELLO',
				'SAN LORENZO MAGGIORE',
				'SAN LUPO',
				'SAN MARCO DEI CAVOTI',
				'SAN MARTINO SANNITA',
				'SAN NAZZARO',
				'SAN NICOLA MANFREDI',
				'SAN SALVATORE TELESINO',
				'SANTA CROCE DEL SANNIO',
				'SANT\'AGATA DE\' GOTI',
				'SANT\'ANGELO A CUPOLO',
				'SASSINORO',
				'SOLOPACA',
				'TELESE TERME',
				'TOCCO CAUDIO',
				'TORRECUSO',
				'VITULANO',
				'SANT\'ARCANGELO TRIMONTE',
				'BAGNARA DI BENEVENTO',
				'CALVI SAN NAZZARO',
				'CIVITELLA LICINIO',
				'LUZZANO',
				'MONTORSO',
				'PASTENE',
				'PERRILLO',
				'SAN MARCO A MONTI',
				'VARONI',
			),
			'NA' => array(
				'ACERRA',
				'AFRAGOLA',
				'AGEROLA',
				'ANACAPRI',
				'ARZANO',
				'BACOLI',
				'BARANO D\'ISCHIA',
				'BOSCOREALE',
				'BOSCOTRECASE',
				'BRUSCIANO',
				'CAIVANO',
				'CALVIZZANO',
				'CAMPOSANO',
				'CAPRI',
				'CARBONARA DI NOLA',
				'CARDITO',
				'CASALNUOVO DI NAPOLI',
				'CASAMARCIANO',
				'CASAMICCIOLA TERME',
				'CASANDRINO',
				'CASAVATORE',
				'CASOLA DI NAPOLI',
				'CASORIA',
				'CASTELLAMMARE DI STABIA',
				'CASTELLO DI CISTERNA',
				'CERCOLA',
				'CICCIANO',
				'CIMITILE',
				'COMIZIANO',
				'CRISPANO',
				'FORIO',
				'FRATTAMAGGIORE',
				'FRATTAMINORE',
				'GIUGLIANO IN CAMPANIA',
				'GRAGNANO',
				'GRUMO NEVANO',
				'ISCHIA',
				'LACCO AMENO',
				'LETTERE',
				'LIVERI',
				'MARANO DI NAPOLI',
				'MARIGLIANELLA',
				'MARIGLIANO',
				'MASSA LUBRENSE',
				'MELITO DI NAPOLI',
				'META',
				'MONTE DI PROCIDA',
				'MUGNANO DI NAPOLI',
				'NAPOLI',
				'NOLA',
				'OTTAVIANO',
				'PALMA CAMPANIA',
				'PIANO DI SORRENTO',
				'PIMONTE',
				'POGGIOMARINO',
				'POLLENA TROCCHIA',
				'POMIGLIANO D\'ARCO',
				'POMPEI',
				'PORTICI',
				'POZZUOLI',
				'PROCIDA',
				'QUALIANO',
				'QUARTO',
				'ERCOLANO',
				'ROCCARAINOLA',
				'SAN GENNARO VESUVIANO',
				'SAN GIORGIO A CREMANO',
				'SAN GIUSEPPE VESUVIANO',
				'SAN PAOLO BEL SITO',
				'SAN SEBASTIANO AL VESUVIO',
				'SANT\'AGNELLO',
				'SANT\'ANASTASIA',
				'SANT\'ANTIMO',
				'SANT\'ANTONIO ABATE',
				'SAN VITALIANO',
				'SAVIANO',
				'SCISCIANO',
				'SERRARA FONTANA',
				'SOMMA VESUVIANA',
				'SORRENTO',
				'STRIANO',
				'TERZIGNO',
				'TORRE ANNUNZIATA',
				'TORRE DEL GRECO',
				'TUFINO',
				'VICO EQUENSE',
				'VILLARICCA',
				'VISCIANO',
				'VOLLA',
				'SANTA MARIA LA CARITA\'',
				'TRECASE',
				'MASSA DI SOMMA',
				'BARRA',
				'CHIAIANO ED UNITI',
				'LICIGNANO DI NAPOLI',
				'PIANURA',
				'PISCINOLA',
				'PONTICELLI',
				'SAN GIOVANNI A TEDUCCIO',
				'SAN PIETRO A PATIERNO',
				'SANT\'ERASMO',
				'SECONDIGLIANO',
				'SIRICO',
				'SOCCAVO',
				'TESTACCIO D\'ISCHIA',
				'RESINA',
				'ATELLA DI NAPOLI',
			),
			'AV' => array(
				'AIELLO DEL SABATO',
				'ALTAVILLA IRPINA',
				'ANDRETTA',
				'AQUILONIA',
				'ARIANO IRPINO',
				'ATRIPALDA',
				'AVELLA',
				'AVELLINO',
				'BAGNOLI IRPINO',
				'BAIANO',
				'BISACCIA',
				'BONITO',
				'CAIRANO',
				'CALABRITTO',
				'CALITRI',
				'CANDIDA',
				'CAPOSELE',
				'CAPRIGLIA IRPINA',
				'CARIFE',
				'CASALBORE',
				'CASSANO IRPINO',
				'CASTEL BARONIA',
				'CASTELFRANCI',
				'CASTELVETERE SUL CALORE',
				'CERVINARA',
				'CESINALI',
				'CHIANCHE',
				'CHIUSANO DI SAN DOMENICO',
				'CONTRADA',
				'CONZA DELLA CAMPANIA',
				'DOMICELLA',
				'FLUMERI',
				'FONTANAROSA',
				'FORINO',
				'FRIGENTO',
				'GESUALDO',
				'GRECI',
				'GROTTAMINARDA',
				'GROTTOLELLA',
				'GUARDIA LOMBARDI',
				'LACEDONIA',
				'LAPIO',
				'LAURO',
				'LIONI',
				'LUOGOSANO',
				'MANOCALZATI',
				'MARZANO DI NOLA',
				'MELITO IRPINO',
				'MERCOGLIANO',
				'MIRABELLA ECLANO',
				'MONTAGUTO',
				'MONTECALVO IRPINO',
				'MONTEFALCIONE',
				'MONTEFORTE IRPINO',
				'MONTEFREDANE',
				'MONTEFUSCO',
				'MONTELLA',
				'MONTEMARANO',
				'MONTEMILETTO',
				'MONTEVERDE',
				'MONTORO INFERIORE',
				'MONTORO SUPERIORE',
				'MORRA DE SANCTIS',
				'MOSCHIANO',
				'MUGNANO DEL CARDINALE',
				'NUSCO',
				'OSPEDALETTO D\'ALPINOLO',
				'PAGO DEL VALLO DI LAURO',
				'PAROLISE',
				'PATERNOPOLI',
				'PETRURO IRPINO',
				'PIETRADEFUSI',
				'PIETRASTORNINA',
				'PRATA DI PRINCIPATO ULTRA',
				'PRATOLA SERRA',
				'QUADRELLE',
				'QUINDICI',
				'ROCCABASCERANA',
				'ROCCA SAN FELICE',
				'ROTONDI',
				'SALZA IRPINA',
				'SAN MANGO SUL CALORE',
				'SAN MARTINO VALLE CAUDINA',
				'SAN MICHELE DI SERINO',
				'SAN NICOLA BARONIA',
				'SAN POTITO ULTRA',
				'SAN SOSSIO BARONIA',
				'SANTA LUCIA DI SERINO',
				'SANT\'ANDREA DI CONZA',
				'SANT\'ANGELO ALL\'ESCA',
				'SANT\'ANGELO A SCALA',
				'SANT\'ANGELO DEI LOMBARDI',
				'SANTA PAOLINA',
				'SANTO STEFANO DEL SOLE',
				'SAVIGNANO IRPINO',
				'SCAMPITELLA',
				'SENERCHIA',
				'SERINO',
				'SIRIGNANO',
				'SOLOFRA',
				'SORBO SERPICO',
				'SPERONE',
				'STURNO',
				'SUMMONTE',
				'TAURANO',
				'TAURASI',
				'TEORA',
				'TORELLA DE\' LOMBARDI',
				'TORRE LE NOCELLE',
				'TORRIONI',
				'TREVICO',
				'TUFO',
				'VALLATA',
				'VALLESACCARDA',
				'VENTICANO',
				'VILLAMAINA',
				'VILLANOVA DEL BATTISTA',
				'VOLTURARA IRPINA',
				'ZUNGOLI',
				'MONTORO',
				'BELLIZZI IRPINO',
				'CHIANCHETELLE',
				'MIGLIANO',
				'QUAGLIETTA',
				'SAN BARBATO',
				'SAN PIETRO IRPINO',
				'SANT\'AGATA IRPINA',
				'TAVERNOLA SAN FELICE',
			),
			'SA' => array(
				'ACERNO',
				'AGROPOLI',
				'ALBANELLA',
				'ALFANO',
				'ALTAVILLA SILENTINA',
				'AMALFI',
				'ANGRI',
				'AQUARA',
				'ASCEA',
				'ATENA LUCANA',
				'ATRANI',
				'AULETTA',
				'BARONISSI',
				'BATTIPAGLIA',
				'BELLOSGUARDO',
				'BRACIGLIANO',
				'BUCCINO',
				'BUONABITACOLO',
				'CAGGIANO',
				'CALVANICO',
				'CAMEROTA',
				'CAMPAGNA',
				'CAMPORA',
				'CANNALONGA',
				'CAPACCIO',
				'CASALBUONO',
				'CASALETTO SPARTANO',
				'CASAL VELINO',
				'CASELLE IN PITTARI',
				'CASTELCIVITA',
				'CASTELLABATE',
				'CASTELNUOVO CILENTO',
				'CASTELNUOVO DI CONZA',
				'CASTEL SAN GIORGIO',
				'CASTEL SAN LORENZO',
				'CASTIGLIONE DEL GENOVESI',
				'CAVA DE\' TIRRENI',
				'CELLE DI BULGHERIA',
				'CENTOLA',
				'CERASO',
				'CETARA',
				'CICERALE',
				'COLLIANO',
				'CONCA DEI MARINI',
				'CONTRONE',
				'CONTURSI',
				'CORBARA',
				'CORLETO MONFORTE',
				'CUCCARO VETERE',
				'EBOLI',
				'FELITTO',
				'FISCIANO',
				'FURORE',
				'FUTANI',
				'GIFFONI SEI CASALI',
				'GIFFONI VALLE PIANA',
				'GIOI',
				'GIUNGANO',
				'ISPANI',
				'LAUREANA CILENTO',
				'LAURINO',
				'LAURITO',
				'LAVIANO',
				'LUSTRA',
				'MAGLIANO VETERE',
				'MAIORI',
				'MERCATO SAN SEVERINO',
				'MINORI',
				'MOIO DELLA CIVITELLA',
				'MONTANO ANTILIA',
				'MONTECORICE',
				'MONTECORVINO PUGLIANO',
				'MONTECORVINO ROVELLA',
				'MONTEFORTE CILENTO',
				'MONTE SAN GIACOMO',
				'MONTESANO SULLA MARCELLANA',
				'MORIGERATI',
				'NOCERA INFERIORE',
				'NOCERA SUPERIORE',
				'NOVI VELIA',
				'OGLIASTRO CILENTO',
				'OLEVANO SUL TUSCIANO',
				'OLIVETO CITRA',
				'OMIGNANO',
				'ORRIA',
				'OTTATI',
				'PADULA',
				'PAGANI',
				'PALOMONTE',
				'PELLEZZANO',
				'PERDIFUMO',
				'PERITO',
				'PERTOSA',
				'PETINA',
				'PIAGGINE',
				'PISCIOTTA',
				'POLLA',
				'POLLICA',
				'PONTECAGNANO FAIANO',
				'POSITANO',
				'POSTIGLIONE',
				'PRAIANO',
				'PRIGNANO CILENTO',
				'RAVELLO',
				'RICIGLIANO',
				'ROCCADASPIDE',
				'ROCCAGLORIOSA',
				'ROCCAPIEMONTE',
				'ROFRANO',
				'ROMAGNANO AL MONTE',
				'ROSCIGNO',
				'RUTINO',
				'SACCO',
				'SALA CONSILINA',
				'SALENTO',
				'SALERNO',
				'SALVITELLE',
				'SAN CIPRIANO PICENTINO',
				'SAN GIOVANNI A PIRO',
				'SAN GREGORIO MAGNO',
				'SAN MANGO PIEMONTE',
				'SAN MARZANO SUL SARNO',
				'SAN MAURO CILENTO',
				'SAN MAURO LA BRUCA',
				'SAN PIETRO AL TANAGRO',
				'SAN RUFO',
				'SANTA MARINA',
				'SANT\'ANGELO A FASANELLA',
				'SANT\'ARSENIO',
				'SANT\'EGIDIO DEL MONTE ALBINO',
				'SANTOMENNA',
				'SAN VALENTINO TORIO',
				'SANZA',
				'SAPRI',
				'SARNO',
				'SASSANO',
				'SCAFATI',
				'SCALA',
				'SERRAMEZZANA',
				'SERRE',
				'SESSA CILENTO',
				'SIANO',
				'SICIGNANO DEGLI ALBURNI',
				'STELLA CILENTO',
				'STIO',
				'TEGGIANO',
				'TORCHIARA',
				'TORRACA',
				'TORRE ORSAIA',
				'TORTORELLA',
				'TRAMONTI',
				'TRENTINARA',
				'VALLE DELL\'ANGELO',
				'VALLO DELLA LUCANIA',
				'VALVA',
				'VIBONATI',
				'VIETRI SUL MARE',
				'BELLIZZI',
				'CAPITELLO',
				'CASTEL RUGGERO',
				'FOGNA',
				'GALDO',
				'LICUSATI',
				'PIAGGINE SOPRANE',
			),
			'FG' => array(
				'ACCADIA',
				'ALBERONA',
				'ANZANO DI PUGLIA',
				'APRICENA',
				'ASCOLI SATRIANO',
				'BICCARI',
				'BOVINO',
				'CAGNANO VARANO',
				'CANDELA',
				'CARAPELLE',
				'CARLANTINO',
				'CARPINO',
				'CASALNUOVO MONTEROTARO',
				'CASALVECCHIO DI PUGLIA',
				'CASTELLUCCIO DE\' SAURI',
				'CASTELLUCCIO VALMAGGIORE',
				'CASTELNUOVO DELLA DAUNIA',
				'CELENZA VALFORTORE',
				'CELLE DI SAN VITO',
				'CERIGNOLA',
				'CHIEUTI',
				'DELICETO',
				'FAETO',
				'FOGGIA',
				'ISCHITELLA',
				'ISOLE TREMITI',
				'LESINA',
				'LUCERA',
				'MANFREDONIA',
				'MARGHERITA DI SAVOIA',
				'MATTINATA',
				'MONTELEONE DI PUGLIA',
				'MONTE SANT\'ANGELO',
				'MOTTA MONTECORVINO',
				'ORSARA DI PUGLIA',
				'ORTA NOVA',
				'PANNI',
				'PESCHICI',
				'PIETRAMONTECORVINO',
				'POGGIO IMPERIALE',
				'RIGNANO GARGANICO',
				'ROCCHETTA SANT\'ANTONIO',
				'RODI GARGANICO',
				'ROSETO VALFORTORE',
				'SAN FERDINANDO DI PUGLIA',
				'SAN GIOVANNI ROTONDO',
				'SAN MARCO IN LAMIS',
				'SAN MARCO LA CATOLA',
				'SAN NICANDRO GARGANICO',
				'SAN PAOLO DI CIVITATE',
				'SAN SEVERO',
				'SANT\'AGATA DI PUGLIA',
				'SERRACAPRIOLA',
				'STORNARA',
				'STORNARELLA',
				'TORREMAGGIORE',
				'TRINITAPOLI',
				'TROIA',
				'VICO DEL GARGANO',
				'VIESTE',
				'VOLTURARA APPULA',
				'VOLTURINO',
				'ORDONA',
				'ZAPPONETA',
			),
			'BA' => array(
				'ACQUAVIVA DELLE FONTI',
				'ADELFIA',
				'ALBEROBELLO',
				'ALTAMURA',
				'ANDRIA',
				'BARI',
				'BARLETTA',
				'BINETTO',
				'BISCEGLIE',
				'BITETTO',
				'BITONTO',
				'BITRITTO',
				'CANOSA DI PUGLIA',
				'CAPURSO',
				'CASAMASSIMA',
				'CASSANO DELLE MURGE',
				'CASTELLANA GROTTE',
				'CELLAMARE',
				'CONVERSANO',
				'CORATO',
				'GIOIA DEL COLLE',
				'GIOVINAZZO',
				'GRAVINA IN PUGLIA',
				'GRUMO APPULA',
				'LOCOROTONDO',
				'MINERVINO MURGE',
				'MODUGNO',
				'MOLA DI BARI',
				'MOLFETTA',
				'MONOPOLI',
				'NOCI',
				'NOICATTARO',
				'PALO DEL COLLE',
				'POGGIORSINI',
				'POLIGNANO A MARE',
				'PUTIGNANO',
				'RUTIGLIANO',
				'RUVO DI PUGLIA',
				'SAMMICHELE DI BARI',
				'SANNICANDRO DI BARI',
				'SANTERAMO IN COLLE',
				'SPINAZZOLA',
				'TERLIZZI',
				'TORITTO',
				'TRANI',
				'TRIGGIANO',
				'TURI',
				'VALENZANO',
				'CANNETO DI BARI',
				'CARBONARA DI BARI',
				'CEGLIE DEL CAMPO',
				'LOSETO',
				'MONTRONE',
			),
			'TA' => array(
				'AVETRANA',
				'CAROSINO',
				'CASTELLANETA',
				'CRISPIANO',
				'FAGGIANO',
				'FRAGAGNANO',
				'GINOSA',
				'GROTTAGLIE',
				'LATERZA',
				'LEPORANO',
				'LIZZANO',
				'MANDURIA',
				'MARTINA FRANCA',
				'MARUGGIO',
				'MASSAFRA',
				'MONTEIASI',
				'MONTEMESOLA',
				'MONTEPARANO',
				'MOTTOLA',
				'PALAGIANELLO',
				'PALAGIANO',
				'PULSANO',
				'ROCCAFORZATA',
				'SAN GIORGIO IONICO',
				'SAN MARZANO DI SAN GIUSEPPE',
				'SAVA',
				'TARANTO',
				'TORRICELLA',
				'STATTE',
			),
			'BR' => array(
				'BRINDISI',
				'CAROVIGNO',
				'CEGLIE MESSAPICA',
				'CELLINO SAN MARCO',
				'CISTERNINO',
				'ERCHIE',
				'FASANO',
				'FRANCAVILLA FONTANA',
				'LATIANO',
				'MESAGNE',
				'ORIA',
				'OSTUNI',
				'SAN DONACI',
				'SAN MICHELE SALENTINO',
				'SAN PANCRAZIO SALENTINO',
				'SAN PIETRO VERNOTICO',
				'SAN VITO DEI NORMANNI',
				'TORCHIAROLO',
				'TORRE SANTA SUSANNA',
				'VILLA CASTELLI',
			),
			'LE' => array(
				'ACQUARICA DEL CAPO',
				'ALESSANO',
				'ALEZIO',
				'ALLISTE',
				'ANDRANO',
				'ARADEO',
				'ARNESANO',
				'BAGNOLO DEL SALENTO',
				'BOTRUGNO',
				'CALIMERA',
				'CAMPI SALENTINA',
				'CANNOLE',
				'CAPRARICA DI LECCE',
				'CARMIANO',
				'CARPIGNANO SALENTINO',
				'CASARANO',
				'CASTRI DI LECCE',
				'CASTRIGNANO DE\' GRECI',
				'CASTRIGNANO DEL CAPO',
				'CAVALLINO',
				'COLLEPASSO',
				'COPERTINO',
				'CORIGLIANO D\'OTRANTO',
				'CORSANO',
				'CURSI',
				'CUTROFIANO',
				'DISO',
				'GAGLIANO DEL CAPO',
				'GALATINA',
				'GALATONE',
				'GALLIPOLI',
				'GIUGGIANELLO',
				'GIURDIGNANO',
				'GUAGNANO',
				'LECCE',
				'LEQUILE',
				'LEVERANO',
				'LIZZANELLO',
				'MAGLIE',
				'MARTANO',
				'MARTIGNANO',
				'MATINO',
				'MELENDUGNO',
				'MELISSANO',
				'MELPIGNANO',
				'MIGGIANO',
				'MINERVINO DI LECCE',
				'MONTERONI DI LECCE',
				'MONTESANO SALENTINO',
				'MORCIANO DI LEUCA',
				'MURO LECCESE',
				'NARDO\'',
				'NEVIANO',
				'NOCIGLIA',
				'NOVOLI',
				'ORTELLE',
				'OTRANTO',
				'PALMARIGGI',
				'PARABITA',
				'PATU\'',
				'POGGIARDO',
				'PRESICCE',
				'RACALE',
				'RUFFANO',
				'SALICE SALENTINO',
				'SALVE',
				'SANARICA',
				'SAN CESARIO DI LECCE',
				'SAN DONATO DI LECCE',
				'SANNICOLA',
				'SAN PIETRO IN LAMA',
				'SANTA CESAREA TERME',
				'SCORRANO',
				'SECLI\'',
				'SOGLIANO CAVOUR',
				'SOLETO',
				'SPECCHIA',
				'SPONGANO',
				'SQUINZANO',
				'STERNATIA',
				'SUPERSANO',
				'SURANO',
				'SURBO',
				'TAURISANO',
				'TAVIANO',
				'TIGGIANO',
				'TREPUZZI',
				'TRICASE',
				'TUGLIE',
				'UGENTO',
				'UGGIANO LA CHIESA',
				'VEGLIE',
				'VERNOLE',
				'ZOLLINO',
				'SAN CASSIANO',
				'CASTRO',
				'PORTO CESAREO',
			),
			'BT' => array(
				'ANDRIA',
				'BARLETTA',
				'BISCEGLIE',
				'CANOSA DI PUGLIA',
				'MARGHERITA DI SAVOIA',
				'MINERVINO MURGE',
				'SAN FERDINANDO DI PUGLIA',
				'SPINAZZOLA',
				'TRANI',
				'TRINITAPOLI',
			),
			'PZ' => array(
				'ABRIOLA',
				'ACERENZA',
				'ALBANO DI LUCANIA',
				'ANZI',
				'ARMENTO',
				'ATELLA',
				'AVIGLIANO',
				'BALVANO',
				'BANZI',
				'BARAGIANO',
				'BARILE',
				'BELLA',
				'BRIENZA',
				'BRINDISI DI MONTAGNA',
				'CALVELLO',
				'CALVERA',
				'CAMPOMAGGIORE',
				'CANCELLARA',
				'CARBONE',
				'SAN PAOLO ALBANESE',
				'CASTELGRANDE',
				'CASTELLUCCIO INFERIORE',
				'CASTELLUCCIO SUPERIORE',
				'CASTELMEZZANO',
				'CASTELSARACENO',
				'CASTRONUOVO DI SANT\'ANDREA',
				'CERSOSIMO',
				'CHIAROMONTE',
				'CORLETO PERTICARA',
				'EPISCOPIA',
				'FARDELLA',
				'FILIANO',
				'FORENZA',
				'FRANCAVILLA IN SINNI',
				'GALLICCHIO',
				'GENZANO DI LUCANIA',
				'GRUMENTO NOVA',
				'GUARDIA PERTICARA',
				'LAGONEGRO',
				'LATRONICO',
				'LAURENZANA',
				'LAURIA',
				'LAVELLO',
				'MARATEA',
				'MARSICO NUOVO',
				'MARSICOVETERE',
				'MASCHITO',
				'MELFI',
				'MISSANELLO',
				'MOLITERNO',
				'MONTEMILONE',
				'MONTEMURRO',
				'MURO LUCANO',
				'NEMOLI',
				'NOEPOLI',
				'OPPIDO LUCANO',
				'PALAZZO SAN GERVASIO',
				'PESCOPAGANO',
				'PICERNO',
				'PIETRAGALLA',
				'PIETRAPERTOSA',
				'PIGNOLA',
				'POTENZA',
				'RAPOLLA',
				'RAPONE',
				'RIONERO IN VULTURE',
				'RIPACANDIDA',
				'RIVELLO',
				'ROCCANOVA',
				'ROTONDA',
				'RUOTI',
				'RUVO DEL MONTE',
				'SAN CHIRICO NUOVO',
				'SAN CHIRICO RAPARO',
				'SAN COSTANTINO ALBANESE',
				'SAN FELE',
				'SAN MARTINO D\'AGRI',
				'SAN SEVERINO LUCANO',
				'SANT\'ANGELO LE FRATTE',
				'SANT\'ARCANGELO',
				'SARCONI',
				'SASSO DI CASTALDA',
				'SATRIANO DI LUCANIA',
				'SAVOIA DI LUCANIA',
				'SENISE',
				'SPINOSO',
				'TEANA',
				'TERRANOVA DI POLLINO',
				'TITO',
				'TOLVE',
				'TRAMUTOLA',
				'TRECCHINA',
				'TRIVIGNO',
				'VAGLIO BASILICATA',
				'VENOSA',
				'VIETRI DI POTENZA',
				'VIGGIANELLO',
				'VIGGIANO',
				'GINESTRA',
				'PATERNO',
				'CASTELLUCCIO',
			),
			'MT' => array(
				'ACCETTURA',
				'ALIANO',
				'BERNALDA',
				'CALCIANO',
				'CIRIGLIANO',
				'COLOBRARO',
				'CRACO',
				'FERRANDINA',
				'GARAGUSO',
				'GORGOGLIONE',
				'GRASSANO',
				'GROTTOLE',
				'IRSINA',
				'MATERA',
				'MIGLIONICO',
				'MONTALBANO IONICO',
				'MONTESCAGLIOSO',
				'NOVA SIRI',
				'OLIVETO LUCANO',
				'PISTICCI',
				'POLICORO',
				'POMARICO',
				'ROTONDELLA',
				'SALANDRA',
				'SAN GIORGIO LUCANO',
				'SAN MAURO FORTE',
				'STIGLIANO',
				'TRICARICO',
				'TURSI',
				'VALSINNI',
				'SCANZANO IONICO',
			),
			'CS' => array(
				'ACQUAFORMOSA',
				'ACQUAPPESA',
				'ACRI',
				'AIELLO CALABRO',
				'AIETA',
				'ALBIDONA',
				'ALESSANDRIA DEL CARRETTO',
				'ALTILIA',
				'ALTOMONTE',
				'AMANTEA',
				'AMENDOLARA',
				'APRIGLIANO',
				'BELMONTE CALABRO',
				'BELSITO',
				'BELVEDERE MARITTIMO',
				'BIANCHI',
				'BISIGNANO',
				'BOCCHIGLIERO',
				'BONIFATI',
				'BUONVICINO',
				'CALOPEZZATI',
				'CALOVETO',
				'CAMPANA',
				'CANNA',
				'CARIATI',
				'CAROLEI',
				'CARPANZANO',
				'CASOLE BRUZIO',
				'CASSANO ALL\'IONIO',
				'CASTIGLIONE COSENTINO',
				'CASTROLIBERO',
				'CASTROREGIO',
				'CASTROVILLARI',
				'CELICO',
				'CELLARA',
				'CERCHIARA DI CALABRIA',
				'CERISANO',
				'CERVICATI',
				'CERZETO',
				'CETRARO',
				'CIVITA',
				'CLETO',
				'COLOSIMI',
				'CORIGLIANO CALABRO',
				'COSENZA',
				'CROPALATI',
				'CROSIA',
				'DIAMANTE',
				'DIPIGNANO',
				'DOMANICO',
				'FAGNANO CASTELLO',
				'FALCONARA ALBANESE',
				'FIGLINE VEGLIATURO',
				'FIRMO',
				'FIUMEFREDDO BRUZIO',
				'FRANCAVILLA MARITTIMA',
				'FRASCINETO',
				'FUSCALDO',
				'GRIMALDI',
				'GRISOLIA',
				'GUARDIA PIEMONTESE',
				'LAGO',
				'LAINO BORGO',
				'LAINO CASTELLO',
				'LAPPANO',
				'LATTARICO',
				'LONGOBARDI',
				'LONGOBUCCO',
				'LUNGRO',
				'LUZZI',
				'MAIERA\'',
				'MALITO',
				'MALVITO',
				'MANDATORICCIO',
				'MANGONE',
				'MARANO MARCHESATO',
				'MARANO PRINCIPATO',
				'MARZI',
				'MENDICINO',
				'MONGRASSANO',
				'MONTALTO UFFUGO',
				'MONTEGIORDANO',
				'MORANO CALABRO',
				'MORMANNO',
				'MOTTAFOLLONE',
				'NOCARA',
				'ORIOLO',
				'ORSOMARSO',
				'PALUDI',
				'PANETTIERI',
				'PAOLA',
				'PAPASIDERO',
				'PARENTI',
				'PATERNO CALABRO',
				'PEDACE',
				'PEDIVIGLIANO',
				'PIANE CRATI',
				'PIETRAFITTA',
				'PIETRAPAOLA',
				'PLATACI',
				'PRAIA A MARE',
				'RENDE',
				'ROCCA IMPERIALE',
				'ROGGIANO GRAVINA',
				'ROGLIANO',
				'ROSE',
				'ROSETO CAPO SPULICO',
				'ROSSANO',
				'ROTA GRECA',
				'ROVITO',
				'SAN BASILE',
				'SAN BENEDETTO ULLANO',
				'SAN COSMO ALBANESE',
				'SAN DEMETRIO CORONE',
				'SAN DONATO DI NINEA',
				'SAN FILI',
				'SANGINETO',
				'SAN GIORGIO ALBANESE',
				'SAN GIOVANNI IN FIORE',
				'SAN LORENZO BELLIZZI',
				'SAN LORENZO DEL VALLO',
				'SAN LUCIDO',
				'SAN MARCO ARGENTANO',
				'SAN MARTINO DI FINITA',
				'SAN NICOLA ARCELLA',
				'SAN PIETRO IN AMANTEA',
				'SAN PIETRO IN GUARANO',
				'SAN SOSTI',
				'SANTA CATERINA ALBANESE',
				'SANTA DOMENICA TALAO',
				'SANT\'AGATA DI ESARO',
				'SANTA MARIA DEL CEDRO',
				'SANTA SOFIA D\'EPIRO',
				'SANTO STEFANO DI ROGLIANO',
				'SAN VINCENZO LA COSTA',
				'SARACENA',
				'SCALA COELI',
				'SCALEA',
				'SCIGLIANO',
				'SERRA D\'AIELLO',
				'SERRA PEDACE',
				'SPEZZANO ALBANESE',
				'SPEZZANO DELLA SILA',
				'SPEZZANO PICCOLO',
				'TARSIA',
				'TERRANOVA DA SIBARI',
				'TERRAVECCHIA',
				'TORANO CASTELLO',
				'TORTORA',
				'TREBISACCE',
				'TRENTA',
				'VACCARIZZO ALBANESE',
				'VERBICARO',
				'VILLAPIANA',
				'ZUMPANO',
				'AIELLO IN CALABRIA',
				'GRISOLIA CIPOLLINA',
				'GUARDIA PIEMONTESE TERME',
				'LAINO BRUZIO',
				'SPEZZANO GRANDE',
				'TERRATI',
			),
			'CZ' => array(
				'ALBI',
				'AMARONI',
				'AMATO',
				'ANDALI',
				'ARGUSTO',
				'BADOLATO',
				'BELCASTRO',
				'BORGIA',
				'BOTRICELLO',
				'CARAFFA DI CATANZARO',
				'CARDINALE',
				'CARLOPOLI',
				'CATANZARO',
				'CENADI',
				'CENTRACHE',
				'CERVA',
				'CHIARAVALLE CENTRALE',
				'CICALA',
				'CONFLENTI',
				'CORTALE',
				'CROPANI',
				'CURINGA',
				'DAVOLI',
				'DECOLLATURA',
				'FALERNA',
				'FEROLETO ANTICO',
				'FOSSATO SERRALTA',
				'GAGLIATO',
				'GASPERINA',
				'GIMIGLIANO',
				'GIRIFALCO',
				'GIZZERIA',
				'GUARDAVALLE',
				'ISCA SULLO IONIO',
				'JACURSO',
				'MAGISANO',
				'MAIDA',
				'MARCEDUSA',
				'MARCELLINARA',
				'MARTIRANO',
				'MARTIRANO LOMBARDO',
				'MIGLIERINA',
				'MONTAURO',
				'MONTEPAONE',
				'MOTTA SANTA LUCIA',
				'NOCERA TERINESE',
				'OLIVADI',
				'PALERMITI',
				'PENTONE',
				'PETRIZZI',
				'PETRONA\'',
				'PIANOPOLI',
				'PLATANIA',
				'SAN FLORO',
				'SAN MANGO D\'AQUINO',
				'SAN PIETRO A MAIDA',
				'SAN PIETRO APOSTOLO',
				'SAN SOSTENE',
				'SANTA CATERINA DELLO IONIO',
				'SANT\'ANDREA APOSTOLO DELLO IONIO',
				'SAN VITO SULLO IONIO',
				'SATRIANO',
				'SELLIA',
				'SELLIA MARINA',
				'SERRASTRETTA',
				'SERSALE',
				'SETTINGIANO',
				'SIMERI E CRICHI',
				'SORBO SAN BASILE',
				'SOVERATO',
				'SOVERIA MANNELLI',
				'SOVERIA SIMERI',
				'SQUILLACE',
				'STALETTI',
				'TAVERNA',
				'TIRIOLO',
				'TORRE DI RUGGIERO',
				'VALLEFIORITA',
				'ZAGARISE',
				'LAMEZIA TERME',
				'CASTAGNA',
				'NICASTRO',
				'PISCOPIO',
				'SAMBIASE',
				'SANT\'EUFEMIA LAMEZIA',
				'ACQUARO',
				'ARENA',
				'BELVEDERE DI SPINELLO',
				'BRIATICO',
				'BROGNATURO',
				'CACCURI',
				'CAPISTRANO',
				'CARFIZZI',
				'CASABONA',
				'CASTELSILANO',
				'CERENZIA',
				'CESSANITI',
				'CIRO\'',
				'CIRO\' MARINA',
				'COTRONEI',
				'CROTONE',
				'CRUCOLI',
				'CUTRO',
				'DASA\'',
				'DINAMI',
				'DRAPIA',
				'FABRIZIA',
				'FILADELFIA',
				'FILANDARI',
				'FILOGASO',
				'FRANCAVILLA ANGITOLA',
				'FRANCICA',
				'GEROCARNE',
				'IONADI',
				'ISOLA DI CAPO RIZZUTO',
				'JOPPOLO',
				'LIMBADI',
				'MAIERATO',
				'MELISSA',
				'MESORACA',
				'MILETO',
				'MONGIANA',
				'MONTEROSSO CALABRO',
				'NARDODIPACE',
				'NICOTERA',
				'PALLAGORIO',
				'PARGHELIA',
				'PETILIA POLICASTRO',
				'PIZZO',
				'PIZZONI',
				'POLIA',
				'RICADI',
				'ROCCA DI NETO',
				'ROCCABERNARDA',
				'ROMBIOLO',
				'SAN CALOGERO',
				'SAN COSTANTINO CALABRO',
				'SAN GREGORIO D\'IPPONA',
				'SAN MAURO MARCHESATO',
				'SAN NICOLA DA CRISSA',
				'SAN NICOLA DELL\'ALTO',
				'SANT\'ONOFRIO',
				'SANTA SEVERINA',
				'SAVELLI',
				'SCANDALE',
				'SERRA SAN BRUNO',
				'SIMBARIO',
				'SORIANELLO',
				'SORIANO CALABRO',
				'SPADOLA',
				'SPILINGA',
				'STEFANACONI',
				'STRONGOLI',
				'TROPEA',
				'UMBRIATICO',
				'VALLELONGA',
				'VAZZANO',
				'VERZINO',
				'VIBO VALENTIA',
				'ZACCANOPOLI',
				'ZAMBRONE',
				'ZUNGRI',
			),
			'RC' => array(
				'AFRICO',
				'AGNANA CALABRA',
				'ANOIA',
				'ANTONIMINA',
				'ARDORE',
				'BAGALADI',
				'BAGNARA CALABRA',
				'BENESTARE',
				'BIANCO',
				'BIVONGI',
				'BOVA',
				'BOVALINO',
				'BOVA MARINA',
				'BRANCALEONE',
				'BRUZZANO ZEFFIRIO',
				'CALANNA',
				'CAMINI',
				'CAMPO CALABRO',
				'CANDIDONI',
				'CANOLO',
				'CARAFFA DEL BIANCO',
				'CARDETO',
				'CARERI',
				'CASIGNANA',
				'CAULONIA',
				'CIMINA\'',
				'CINQUEFRONDI',
				'CITTANOVA',
				'CONDOFURI',
				'COSOLETO',
				'DELIANUOVA',
				'FEROLETO DELLA CHIESA',
				'FERRUZZANO',
				'FIUMARA',
				'GALATRO',
				'GERACE',
				'GIFFONE',
				'GIOIA TAURO',
				'GIOIOSA IONICA',
				'GROTTERIA',
				'LAGANADI',
				'LAUREANA DI BORRELLO',
				'LOCRI',
				'MAMMOLA',
				'MARINA DI GIOIOSA IONICA',
				'MAROPATI',
				'MARTONE',
				'MELICUCCA\'',
				'MELICUCCO',
				'MELITO DI PORTO SALVO',
				'MOLOCHIO',
				'MONASTERACE',
				'MONTEBELLO IONICO',
				'MOTTA SAN GIOVANNI',
				'OPPIDO MAMERTINA',
				'PALIZZI',
				'PALMI',
				'PAZZANO',
				'PLACANICA',
				'PLATI\'',
				'POLISTENA',
				'PORTIGLIOLA',
				'REGGIO CALABRIA',
				'RIACE',
				'RIZZICONI',
				'ROCCAFORTE DEL GRECO',
				'ROCCELLA IONICA',
				'ROGHUDI',
				'ROSARNO',
				'SAMO',
				'SAN GIORGIO MORGETO',
				'SAN GIOVANNI DI GERACE',
				'SAN LORENZO',
				'SAN LUCA',
				'SAN PIETRO DI CARIDA\'',
				'SAN PROCOPIO',
				'SAN ROBERTO',
				'SANTA CRISTINA D\'ASPROMONTE',
				'SANT\'AGATA DEL BIANCO',
				'SANT\'ALESSIO D\'ASPROMONTE',
				'SANT\'EUFEMIA D\'ASPROMONTE',
				'SANT\'ILARIO DELLO IONIO',
				'SANTO STEFANO IN ASPROMONTE',
				'SCIDO',
				'SCILLA',
				'SEMINARA',
				'SERRATA',
				'SIDERNO',
				'SINOPOLI',
				'STAITI',
				'STIGNANO',
				'STILO',
				'TAURIANOVA',
				'TERRANOVA SAPPO MINULIO',
				'VARAPODIO',
				'VILLA SAN GIOVANNI',
				'SAN FERDINANDO',
				'CANNITELLO',
				'CARIDA\'',
				'CATAFORIO',
				'CATONA',
				'GALLICO',
				'GALLINA',
				'IATRINOLI',
				'ORTI',
				'PARACORIO',
				'PEDAVOLI',
				'PELLARO',
				'PODARGONI',
				'RADICENA',
				'ROSALI',
				'SALICE CALABRO',
				'SAMBATELLO',
				'SAMO DI CALABRIA',
				'VILLA SAN GIUSEPPE',
				'SAN PIER FEDELE',
				'TRESILICO',
			),
			'KR' => array(
				'BELVEDERE DI SPINELLO',
				'CACCURI',
				'CARFIZZI',
				'CASABONA',
				'CASTELSILANO',
				'CERENZIA',
				'CIRO\'',
				'CIRO\' MARINA',
				'COTRONEI',
				'CROTONE',
				'CRUCOLI',
				'CUTRO',
				'ISOLA DI CAPO RIZZUTO',
				'MELISSA',
				'MESORACA',
				'PALLAGORIO',
				'PETILIA POLICASTRO',
				'ROCCABERNARDA',
				'ROCCA DI NETO',
				'SAN MAURO MARCHESATO',
				'SAN NICOLA DELL\'ALTO',
				'SANTA SEVERINA',
				'SAVELLI',
				'SCANDALE',
				'STRONGOLI',
				'UMBRIATICO',
				'VERZINO',
			),
			'VV' => array(
				'ACQUARO',
				'ARENA',
				'BRIATICO',
				'BROGNATURO',
				'CAPISTRANO',
				'CESSANITI',
				'DASA\'',
				'DINAMI',
				'DRAPIA',
				'FABRIZIA',
				'FILADELFIA',
				'FILANDARI',
				'FILOGASO',
				'FRANCAVILLA ANGITOLA',
				'FRANCICA',
				'GEROCARNE',
				'IONADI',
				'JOPPOLO',
				'LIMBADI',
				'MAIERATO',
				'MILETO',
				'MONGIANA',
				'MONTEROSSO CALABRO',
				'NARDODIPACE',
				'NICOTERA',
				'PARGHELIA',
				'PIZZO',
				'PIZZONI',
				'POLIA',
				'RICADI',
				'ROMBIOLO',
				'SAN CALOGERO',
				'SAN COSTANTINO CALABRO',
				'SAN GREGORIO D\'IPPONA',
				'SAN NICOLA DA CRISSA',
				'SANT\'ONOFRIO',
				'SERRA SAN BRUNO',
				'SIMBARIO',
				'SORIANELLO',
				'SORIANO CALABRO',
				'SPADOLA',
				'SPILINGA',
				'STEFANACONI',
				'TROPEA',
				'VALLELONGA',
				'VAZZANO',
				'VIBO VALENTIA',
				'ZACCANOPOLI',
				'ZAMBRONE',
				'ZUNGRI',
			),
			'TP' => array(
				'ALCAMO',
				'BUSETO PALIZZOLO',
				'CALATAFIMI',
				'CAMPOBELLO DI MAZARA',
				'CASTELLAMMARE DEL GOLFO',
				'CASTELVETRANO',
				'CUSTONACI',
				'ERICE',
				'FAVIGNANA',
				'GIBELLINA',
				'MARSALA',
				'MAZARA DEL VALLO',
				'PACECO',
				'PANTELLERIA',
				'PARTANNA',
				'POGGIOREALE',
				'SALAPARUTA',
				'SALEMI',
				'SANTA NINFA',
				'SAN VITO LO CAPO',
				'TRAPANI',
				'VALDERICE',
				'VITA',
				'PETROSINO',
				'XITTA',
				'CALATAFIMI SEGESTA',
			),
			'PA' => array(
				'ALIA',
				'ALIMENA',
				'ALIMINUSA',
				'ALTAVILLA MILICIA',
				'ALTOFONTE',
				'BAGHERIA',
				'BALESTRATE',
				'BAUCINA',
				'BELMONTE MEZZAGNO',
				'BISACQUINO',
				'BOLOGNETTA',
				'BOMPIETRO',
				'BORGETTO',
				'CACCAMO',
				'CALTAVUTURO',
				'CAMPOFELICE DI FITALIA',
				'CAMPOFELICE DI ROCCELLA',
				'CAMPOFIORITO',
				'CAMPOREALE',
				'CAPACI',
				'CARINI',
				'CASTELBUONO',
				'CASTELDACCIA',
				'CASTELLANA SICULA',
				'CASTRONOVO DI SICILIA',
				'CEFALA\' DIANA',
				'CEFALU\'',
				'CERDA',
				'CHIUSA SCLAFANI',
				'CIMINNA',
				'CINISI',
				'COLLESANO',
				'CONTESSA ENTELLINA',
				'CORLEONE',
				'FICARAZZI',
				'GANGI',
				'GERACI SICULO',
				'GIARDINELLO',
				'GIULIANA',
				'GODRANO',
				'GRATTERI',
				'ISNELLO',
				'ISOLA DELLE FEMMINE',
				'LASCARI',
				'LERCARA FRIDDI',
				'MARINEO',
				'MEZZOJUSO',
				'MISILMERI',
				'MONREALE',
				'MONTELEPRE',
				'MONTEMAGGIORE BELSITO',
				'PALAZZO ADRIANO',
				'PALERMO',
				'PARTINICO',
				'PETRALIA SOPRANA',
				'PETRALIA SOTTANA',
				'PIANA DEGLI ALBANESI',
				'POLIZZI GENEROSA',
				'POLLINA',
				'PRIZZI',
				'ROCCAMENA',
				'ROCCAPALUMBA',
				'SAN CIPIRELLO',
				'SAN GIUSEPPE IATO',
				'SAN MAURO CASTELVERDE',
				'SANTA CRISTINA GELA',
				'SANTA FLAVIA',
				'SCIARA',
				'SCLAFANI BAGNI',
				'TERMINI IMERESE',
				'TERRASINI',
				'TORRETTA',
				'TRABIA',
				'TRAPPETO',
				'USTICA',
				'VALLEDOLMO',
				'VENTIMIGLIA DI SICILIA',
				'VICARI',
				'VILLABATE',
				'VILLAFRATI',
				'SCILLATO',
				'BLUFI',
			),
			'ME' => array(
				'ALCARA LI FUSI',
				'ALI\'',
				'ALI\' TERME',
				'ANTILLO',
				'BARCELLONA POZZO DI GOTTO',
				'BASICO\'',
				'BROLO',
				'CAPIZZI',
				'CAPO D\'ORLANDO',
				'CAPRI LEONE',
				'CARONIA',
				'CASALVECCHIO SICULO',
				'CASTEL DI LUCIO',
				'CASTELL\'UMBERTO',
				'CASTELMOLA',
				'CASTROREALE',
				'CESARO\'',
				'CONDRO\'',
				'FALCONE',
				'FICARRA',
				'FIUMEDINISI',
				'FLORESTA',
				'FONDACHELLI-FANTINA',
				'FORZA D\'AGRO\'',
				'FRANCAVILLA DI SICILIA',
				'FRAZZANO\'',
				'FURCI SICULO',
				'FURNARI',
				'GAGGI',
				'GALATI MAMERTINO',
				'GALLODORO',
				'GIARDINI-NAXOS',
				'GIOIOSA MAREA',
				'GRANITI',
				'GUALTIERI SICAMINO\'',
				'ITALA',
				'LENI',
				'LETOJANNI',
				'LIBRIZZI',
				'LIMINA',
				'LIPARI',
				'LONGI',
				'MALFA',
				'MALVAGNA',
				'MANDANICI',
				'MAZZARRA\' SANT\'ANDREA',
				'MERI\'',
				'MESSINA',
				'MILAZZO',
				'MILITELLO ROSMARINO',
				'MIRTO',
				'MISTRETTA',
				'MOIO ALCANTARA',
				'MONFORTE SAN GIORGIO',
				'MONGIUFFI MELIA',
				'MONTAGNAREALE',
				'MONTALBANO ELICONA',
				'MOTTA CAMASTRA',
				'MOTTA D\'AFFERMO',
				'NASO',
				'NIZZA DI SICILIA',
				'NOVARA DI SICILIA',
				'OLIVERI',
				'PACE DEL MELA',
				'PAGLIARA',
				'PATTI',
				'PETTINEO',
				'PIRAINO',
				'RACCUJA',
				'REITANO',
				'ROCCAFIORITA',
				'ROCCALUMERA',
				'ROCCAVALDINA',
				'ROCCELLA VALDEMONE',
				'RODI\' MILICI',
				'ROMETTA',
				'SAN FILIPPO DEL MELA',
				'SAN FRATELLO',
				'SAN MARCO D\'ALUNZIO',
				'SAN PIER NICETO',
				'SAN PIERO PATTI',
				'SAN SALVATORE DI FITALIA',
				'SANTA DOMENICA VITTORIA',
				'SANT\'AGATA DI MILITELLO',
				'SANT\'ALESSIO SICULO',
				'SANTA LUCIA DEL MELA',
				'SANTA MARINA SALINA',
				'SANT\'ANGELO DI BROLO',
				'SANTA TERESA DI RIVA',
				'SAN TEODORO',
				'SANTO STEFANO DI CAMASTRA',
				'SAPONARA',
				'SAVOCA',
				'SCALETTA ZANCLEA',
				'SINAGRA',
				'SPADAFORA',
				'TAORMINA',
				'TORREGROTTA',
				'TORTORICI',
				'TRIPI',
				'TUSA',
				'UCRIA',
				'VALDINA',
				'VENETICO',
				'VILLAFRANCA TIRRENA',
				'TERME VIGLIATORE',
				'ACQUEDOLCI',
				'TORRENOVA',
				'BAUSO',
				'CALVARUSO',
				'GUIDOMANDRI',
				'LANZA',
				'LETOIANNI GALLODORO',
				'LOCADI',
				'SALINA',
				'SANTO STEFANO DI BRIGA',
				'SPADAFORA SAN MARTINO',
				'SPADAFORA SAN PIETRO',
			),
			'AG' => array(
				'AGRIGENTO',
				'ALESSANDRIA DELLA ROCCA',
				'ARAGONA',
				'BIVONA',
				'BURGIO',
				'CALAMONACI',
				'CALTABELLOTTA',
				'CAMASTRA',
				'CAMMARATA',
				'CAMPOBELLO DI LICATA',
				'CANICATTI\'',
				'CASTELTERMINI',
				'CASTROFILIPPO',
				'CATTOLICA ERACLEA',
				'CIANCIANA',
				'COMITINI',
				'FAVARA',
				'GROTTE',
				'JOPPOLO GIANCAXIO',
				'LAMPEDUSA E LINOSA',
				'LICATA',
				'LUCCA SICULA',
				'MENFI',
				'MONTALLEGRO',
				'MONTEVAGO',
				'NARO',
				'PALMA DI MONTECHIARO',
				'PORTO EMPEDOCLE',
				'RACALMUTO',
				'RAFFADALI',
				'RAVANUSA',
				'REALMONTE',
				'RIBERA',
				'SAMBUCA DI SICILIA',
				'SAN BIAGIO PLATANI',
				'SAN GIOVANNI GEMINI',
				'SANTA ELISABETTA',
				'SANTA MARGHERITA DI BELICE',
				'SANT\'ANGELO MUXARO',
				'SANTO STEFANO QUISQUINA',
				'SCIACCA',
				'SICULIANA',
				'VILLAFRANCA SICULA',
			),
			'CL' => array(
				'ACQUAVIVA PLATANI',
				'BOMPENSIERE',
				'BUTERA',
				'CALTANISSETTA',
				'CAMPOFRANCO',
				'DELIA',
				'GELA',
				'MARIANOPOLI',
				'MAZZARINO',
				'MILENA',
				'MONTEDORO',
				'MUSSOMELI',
				'NISCEMI',
				'RESUTTANO',
				'RIESI',
				'SAN CATALDO',
				'SANTA CATERINA VILLARMOSA',
				'SERRADIFALCO',
				'SOMMATINO',
				'SUTERA',
				'VALLELUNGA PRATAMENO',
				'VILLALBA',
			),
			'EN' => array(
				'AGIRA',
				'AIDONE',
				'ASSORO',
				'BARRAFRANCA',
				'CALASCIBETTA',
				'CATENANUOVA',
				'CENTURIPE',
				'CERAMI',
				'ENNA',
				'GAGLIANO CASTELFERRATO',
				'LEONFORTE',
				'NICOSIA',
				'NISSORIA',
				'PIAZZA ARMERINA',
				'PIETRAPERZIA',
				'REGALBUTO',
				'SPERLINGA',
				'TROINA',
				'VALGUARNERA CAROPEPE',
				'VILLAROSA',
				'CARCACI',
			),
			'CT' => array(
				'ACI BONACCORSI',
				'ACI CASTELLO',
				'ACI CATENA',
				'ACIREALE',
				'ACI SANT\'ANTONIO',
				'ADRANO',
				'BELPASSO',
				'BIANCAVILLA',
				'BRONTE',
				'CALATABIANO',
				'CALTAGIRONE',
				'CAMPOROTONDO ETNEO',
				'CASTEL DI IUDICA',
				'CASTIGLIONE DI SICILIA',
				'CATANIA',
				'FIUMEFREDDO DI SICILIA',
				'GIARRE',
				'GRAMMICHELE',
				'GRAVINA DI CATANIA',
				'LICODIA EUBEA',
				'LINGUAGLOSSA',
				'MALETTO',
				'MASCALI',
				'MASCALUCIA',
				'MILITELLO IN VAL DI CATANIA',
				'MILO',
				'MINEO',
				'MIRABELLA IMBACCARI',
				'MISTERBIANCO',
				'MOTTA SANT\'ANASTASIA',
				'NICOLOSI',
				'PALAGONIA',
				'PATERNO\'',
				'PEDARA',
				'PIEDIMONTE ETNEO',
				'RADDUSA',
				'RAMACCA',
				'RANDAZZO',
				'RIPOSTO',
				'SAN CONO',
				'SAN GIOVANNI LA PUNTA',
				'SAN GREGORIO DI CATANIA',
				'SAN MICHELE DI GANZARIA',
				'SAN PIETRO CLARENZA',
				'SANT\'AGATA LI BATTIATI',
				'SANT\'ALFIO',
				'SANTA MARIA DI LICODIA',
				'SANTA VENERINA',
				'SCORDIA',
				'TRECASTAGNI',
				'TREMESTIERI ETNEO',
				'VALVERDE',
				'VIAGRANDE',
				'VIZZINI',
				'ZAFFERANA ETNEA',
				'MAZZARRONE',
				'MANIACE',
				'RAGALNA',
				'IONIA',
				'SAN GIOVANNI DI GALERNO',
			),
			'RG' => array(
				'ACATE',
				'CHIARAMONTE GULFI',
				'COMISO',
				'GIARRATANA',
				'ISPICA',
				'MODICA',
				'MONTEROSSO ALMO',
				'POZZALLO',
				'RAGUSA',
				'SANTA CROCE CAMERINA',
				'SCICLI',
				'VITTORIA',
				'RAGUSA IBLA',
			),
			'SR' => array(
				'AUGUSTA',
				'AVOLA',
				'BUCCHERI',
				'BUSCEMI',
				'CANICATTINI BAGNI',
				'CARLENTINI',
				'CASSARO',
				'FERLA',
				'FLORIDIA',
				'FRANCOFONTE',
				'LENTINI',
				'MELILLI',
				'NOTO',
				'PACHINO',
				'PALAZZOLO ACREIDE',
				'ROSOLINI',
				'SIRACUSA',
				'SOLARINO',
				'SORTINO',
				'PORTOPALO DI CAPO PASSERO',
				'PRIOLO GARGALLO',
			),
			'SS' => array(
				'AGGIUS',
				'ALA\' DEI SARDI',
				'ALGHERO',
				'ANELA',
				'ARDARA',
				'ARZACHENA',
				'BANARI',
				'BENETUTTI',
				'BERCHIDDA',
				'BESSUDE',
				'BONNANARO',
				'BONO',
				'BONORVA',
				'BORTIGIADAS',
				'BORUTTA',
				'BOTTIDDA',
				'BUDDUSO\'',
				'BULTEI',
				'BULZI',
				'BURGOS',
				'CALANGIANUS',
				'CARGEGHE',
				'CASTELSARDO',
				'CHEREMULE',
				'CHIARAMONTI',
				'CODRONGIANOS',
				'COSSOINE',
				'ESPORLATU',
				'FLORINAS',
				'GIAVE',
				'ILLORAI',
				'ITTIREDDU',
				'ITTIRI',
				'LAERRU',
				'LA MADDALENA',
				'LUOGOSANTO',
				'LURAS',
				'MARA',
				'MARTIS',
				'MONTELEONE ROCCA DORIA',
				'MONTI',
				'MORES',
				'MUROS',
				'NUGHEDU DI SAN NICOLO\'',
				'NULE',
				'NULVI',
				'OLBIA',
				'OLMEDO',
				'OSCHIRI',
				'OSILO',
				'OSSI',
				'OZIERI',
				'PADRIA',
				'PALAU',
				'PATTADA',
				'PERFUGAS',
				'PLOAGHE',
				'PORTO TORRES',
				'POZZOMAGGIORE',
				'PUTIFIGARI',
				'ROMANA',
				'AGLIENTU',
				'SANTA TERESA GALLURA',
				'SASSARI',
				'SEDINI',
				'SEMESTENE',
				'SENNORI',
				'SILIGO',
				'SORSO',
				'TEMPIO PAUSANIA',
				'THIESI',
				'TISSI',
				'TORRALBA',
				'TRINITA\' D\'AGULTU E VIGNOLA',
				'TULA',
				'URI',
				'USINI',
				'VILLANOVA MONTELEONE',
				'VALLEDORIA',
				'TELTI',
				'BADESI',
				'VIDDALBA',
				'GOLFO ARANCI',
				'LOIRI PORTO SAN PAOLO',
				'SANT\'ANTONIO DI GALLURA',
				'TERGU',
				'SANTA MARIA COGHINAS',
				'ERULA',
				'STINTINO',
				'PADRU',
				'BANTINE',
				'GAROFAI',
				'NUCHIS',
				'REBECCU',
			),
			'NU' => array(
				'ARITZO',
				'ARZANA',
				'ATZARA',
				'AUSTIS',
				'BARI SARDO',
				'BAUNEI',
				'BELVI',
				'BIRORI',
				'BITTI',
				'BOLOTANA',
				'BORORE',
				'BORTIGALI',
				'BOSA',
				'BUDONI',
				'DESULO',
				'DORGALI',
				'DUALCHI',
				'ELINI',
				'ESCALAPLANO',
				'ESCOLCA',
				'ESTERZILI',
				'FLUSSIO',
				'FONNI',
				'GADONI',
				'GAIRO',
				'GALTELLI',
				'GAVOI',
				'GENONI',
				'GERGEI',
				'GIRASOLE',
				'ILBONO',
				'IRGOLI',
				'ISILI',
				'JERZU',
				'LACONI',
				'LANUSEI',
				'LEI',
				'LOCERI',
				'LOCULI',
				'LODE\'',
				'LOTZORAI',
				'LULA',
				'MACOMER',
				'MAGOMADAS',
				'MAMOIADA',
				'MEANA SARDO',
				'MODOLO',
				'MONTRESTA',
				'NORAGUGUME',
				'NUORO',
				'NURAGUS',
				'NURALLAO',
				'NURRI',
				'OLIENA',
				'OLLOLAI',
				'OLZAI',
				'ONANI',
				'ONIFAI',
				'ONIFERI',
				'ORANI',
				'ORGOSOLO',
				'OROSEI',
				'OROTELLI',
				'ORROLI',
				'ORTUERI',
				'ORUNE',
				'OSIDDA',
				'OSINI',
				'OTTANA',
				'OVODDA',
				'PERDASDEFOGU',
				'POSADA',
				'SADALI',
				'SAGAMA',
				'SAN TEODORO',
				'SARULE',
				'SERRI',
				'SEUI',
				'SEULO',
				'SILANUS',
				'SINDIA',
				'SINISCOLA',
				'SORGONO',
				'SUNI',
				'TALANA',
				'TERTENIA',
				'TETI',
				'TIANA',
				'TINNURA',
				'TONARA',
				'TORPE\'',
				'TORTOLI\'',
				'TRIEI',
				'ULASSAI',
				'URZULEI',
				'USSASSAI',
				'VILLAGRANDE STRISAILI',
				'VILLANOVA TULO',
				'CARDEDU',
				'LODINE',
				'IRGOLI DI GALTELLI',
				'MULARGIA',
				'CUGLIERI',
				'SCANO DI MONTIFERRO',
				'SENNARIOLO',
				'TRESNURAGHES',
			),
			'CA' => array(
				'ARBUS',
				'ARMUNGIA',
				'ASSEMINI',
				'BALLAO',
				'BARRALI',
				'BARUMINI',
				'BUGGERRU',
				'BURCEI',
				'CAGLIARI',
				'CALASETTA',
				'CAPOTERRA',
				'CARBONIA',
				'CARLOFORTE',
				'COLLINAS',
				'DECIMOMANNU',
				'DECIMOPUTZU',
				'DOLIANOVA',
				'DOMUS DE MARIA',
				'DOMUSNOVAS',
				'DONORI',
				'FLUMINIMAGGIORE',
				'FURTEI',
				'GENURI',
				'GESICO',
				'GESTURI',
				'GIBA',
				'GONI',
				'GONNESA',
				'GONNOSFANADIGA',
				'GUAMAGGIORE',
				'GUASILA',
				'GUSPINI',
				'IGLESIAS',
				'LAS PLASSAS',
				'LUNAMATRONA',
				'MANDAS',
				'MARACALAGONIS',
				'MONASTIR',
				'MURAVERA',
				'MUSEI',
				'NARCAO',
				'NURAMINIS',
				'NUXIS',
				'ORTACESUS',
				'PABILLONIS',
				'PAULI ARBAREI',
				'PERDAXIUS',
				'PIMENTEL',
				'PORTOSCUSO',
				'PULA',
				'QUARTU SANT\'ELENA',
				'SAMASSI',
				'SAMATZAI',
				'SAN BASILIO',
				'SAN GAVINO MONREALE',
				'SAN GIOVANNI SUERGIU',
				'SANLURI',
				'SAN NICOLO\' GERREI',
				'SAN SPERATE',
				'SANTADI',
				'SANT\'ANDREA FRIUS',
				'SANT\'ANNA ARRESI',
				'SANT\'ANTIOCO',
				'SAN VITO',
				'SARDARA',
				'SARROCH',
				'SEGARIU',
				'SELARGIUS',
				'SELEGAS',
				'SENORBI\'',
				'SERDIANA',
				'SERRAMANNA',
				'SERRENTI',
				'SESTU',
				'SETTIMO SAN PIETRO',
				'SETZU',
				'SIDDI',
				'SILIQUA',
				'SILIUS',
				'SINNAI',
				'SIURGUS DONIGALA',
				'SOLEMINIS',
				'SUELLI',
				'TEULADA',
				'TRATALIAS',
				'TUILI',
				'TURRI',
				'USSANA',
				'USSARAMANNA',
				'UTA',
				'VALLERMOSA',
				'VILLACIDRO',
				'VILLAMAR',
				'VILLAMASSARGIA',
				'VILLANOVAFORRU',
				'VILLANOVAFRANCA',
				'VILLAPUTZU',
				'VILLASALTO',
				'VILLA SAN PIETRO',
				'VILLASIMIUS',
				'VILLASOR',
				'VILLASPECIOSA',
				'MASAINAS',
				'VILLAPERUCCIO',
				'QUARTUCCIU',
				'CASTIADAS',
				'PISCINAS',
				'ELMAS',
				'MONSERRATO',
				'ISILI',
				'NURRI',
				'ORROLI',
				'SERRI',
				'ARIXI',
				'DONIGALA SIURGUS',
				'PIRRI',
				'SAN PANTALEO',
				'SERBARIU',
				'SEUNI',
				'SIAMANNA SIAPICCIA',
				'SICCI SAN BIAGIO',
				'SISINI',
				'SIURGUS',
				'VILLAGRECA',
				'ABBASANTA',
				'AIDOMAGGIORE',
				'ALBAGIARA',
				'ALES',
				'ALLAI',
				'ARBOREA',
				'ARDAULI',
				'ASSOLO',
				'ASUNI',
				'BARADILI',
				'BARATILI SAN PIETRO',
				'BARESSA',
				'BAULADU',
				'BIDONI\'',
				'BONARCADO',
				'BORONEDDU',
				'BUSACHI',
				'CABRAS',
				'CURCURIS',
				'DOMUSNOVAS CANALES',
				'DONIGALA FENUGHEDU',
				'ESCOVEDU',
				'FIGU',
				'FORDONGIANUS',
				'GHILARZA',
				'GHILARZA-ABBASANTA',
				'GONNOSCODINA',
				'GONNOSNO\'',
				'GONNOSTRAMATZA',
				'MARRUBIU',
				'MASSAMA',
				'MASULLAS',
				'MILIS',
				'MOGORELLA',
				'MOGORO',
				'MORGONGIORI',
				'NARBOLIA',
				'NEONELI',
				'NORBELLO',
				'NUGHEDU SANTA VITTORIA',
				'NURACHI',
				'NURAXINIEDDU',
				'NURECI',
				'ORISTANO',
				'PALMAS ARBOREA',
				'PAU',
				'PAULILATINO',
				'POMPU',
				'RIOLA SARDO',
				'RUINAS',
				'SAMUGHEO',
				'SAN NICOLO\' D\'ARCIDANO',
				'SAN VERO CONGIUS',
				'SAN VERO MILIS',
				'SANTA GIUSTA',
				'SANTU LUSSURGIU',
				'SEDILO',
				'SENEGHE',
				'SENIS',
				'SIAMAGGIORE',
				'SIAMANNA',
				'SIAPICCIA',
				'SILI',
				'SIMALA',
				'SIMAXIS',
				'SINI',
				'SIRIS',
				'SOLANAS',
				'SOLARUSSA',
				'SORRADILE',
				'TADASUNI',
				'TERRALBA',
				'TRAMATZA',
				'ULA\' TIRSO',
				'URAS',
				'USELLUS',
				'VILLA VERDE',
				'VILLANOVA TRUSCHEDU',
				'ZEDDIANI',
				'ZEPPARA',
				'ZERFALIU',
				'ZURI',
				'VILLAURBANA',
			),
			'OR' => array(
				'ABBASANTA',
				'AIDOMAGGIORE',
				'ALBAGIARA',
				'ALES',
				'ALLAI',
				'ARBOREA',
				'ARDAULI',
				'ASSOLO',
				'ASUNI',
				'BARADILI',
				'BARATILI SAN PIETRO',
				'BARESSA',
				'BAULADU',
				'BIDONI\'',
				'BONARCADO',
				'BORONEDDU',
				'BUSACHI',
				'CABRAS',
				'CUGLIERI',
				'FORDONGIANUS',
				'GHILARZA',
				'GONNOSCODINA',
				'GONNOSNO\'',
				'GONNOSTRAMATZA',
				'MARRUBIU',
				'MASULLAS',
				'MILIS',
				'MOGORELLA',
				'MOGORO',
				'MORGONGIORI',
				'NARBOLIA',
				'NEONELI',
				'NORBELLO',
				'NUGHEDU SANTA VITTORIA',
				'NURACHI',
				'NURECI',
				'OLLASTRA SIMAXIS',
				'ORISTANO',
				'PALMAS ARBOREA',
				'PAU',
				'PAULILATINO',
				'POMPU',
				'RIOLA SARDO',
				'RUINAS',
				'SAMUGHEO',
				'SAN NICOLO\' D\'ARCIDANO',
				'SANTA GIUSTA',
				'VILLA SANT\'ANTONIO',
				'SANTU LUSSURGIU',
				'SAN VERO MILIS',
				'SCANO DI MONTIFERRO',
				'SEDILO',
				'SENEGHE',
				'SENIS',
				'SENNARIOLO',
				'SIAMAGGIORE',
				'SIAMANNA',
				'SIMALA',
				'SIMAXIS',
				'SINI',
				'SIRIS',
				'SOLARUSSA',
				'SORRADILE',
				'TADASUNI',
				'TERRALBA',
				'TRAMATZA',
				'TRESNURAGHES',
				'ULA\' TIRSO',
				'URAS',
				'USELLUS',
				'VILLANOVA TRUSCHEDU',
				'VILLAURBANA',
				'VILLA VERDE',
				'ZEDDIANI',
				'ZERFALIU',
				'SIAPICCIA',
				'CURCURIS',
				'SODDI',
				'DOMUSNOVAS CANALES',
				'DONIGALA FENUGHEDU',
				'ESCOVEDU',
				'FIGU',
				'GHILARZA-ABBASANTA',
				'MASSAMA',
				'NURAXINIEDDU',
				'SAN VERO CONGIUS',
				'SILI',
				'SOLANAS',
				'ZEPPARA',
				'ZURI',
			),
			'FU' => array(
				'ABBAZIA',
				'APRIANO',
				'BERDO SAN GIOVANNI',
				'BESERZIO DEL CARNARO',
				'BISTERZA',
				'CASTEL IABLANIZZA',
				'CASTELNUOVO D\'ISTRIA',
				'CEGLIE',
				'CLANA',
				'ELSANE',
				'FIUME',
				'FONTANA DEL CONTE',
				'LAURANA',
				'MATTERIA',
				'MATTUGLIE',
				'MOSCHIENA',
				'PRIMANO',
				'RATECEVO IN MONTE',
				'SAGORIA',
				'SAN ROCCO LIGANI',
				'SMERIA',
				'TERRANOVA DI BISTERZA',
				'VILLA DEL NEVOSO',
				'VOLOSCA',
				'VAL SANTAMARINA',
			),
			'PL' => array(
				'ALBONA',
				'ANTIGNANA',
				'ARSIA',
				'BARBANA D\'ISTRIA',
				'BOGLIUNO',
				'BRIONI MAGGIORE',
				'BUIE D\'ISTRIA',
				'CANFANARO',
				'CAPODISTRIA',
				'CHERSO',
				'CITTANOVA D\'ISTRIA',
				'DIGNANO D\'ISTRIA',
				'DRAGUCCIO',
				'ERPELLE-COSINA',
				'FASANA',
				'FIANONA',
				'GIMINO',
				'GRISIGNANA',
				'ISOLA D\'ISTRIA',
				'LANISCHIE',
				'LUSSINGRANDE',
				'LUSSINPICCOLO',
				'MARESEGO',
				'MONTE DI CAPODISTRIA',
				'MONTONA',
				'NERESINE',
				'ORSERA',
				'OSSERO',
				'PARENZO',
				'PAUGNANO',
				'PINGUENTE',
				'PIRANO',
				'PISINO',
				'POLA',
				'PORTOLE',
				'ROVIGNO D\'ISTRIA',
				'ROZZO',
				'SAN MARTINO IN VALLE',
				'SANVINCENTI',
				'SILUM MONT\'AQUILA',
				'UMAGO',
				'VALDARSA',
				'VALLE D\'ISTRIA',
				'VERTENEGLIO',
				'VILLA DECANI',
				'VISIGNANO',
				'VISINADA',
			),
			'ZA' => array(
				'LAGOSTA',
				'ZARA',
			),
		);
	}
}