<?php
/**
 * Addons when Pro is disabled
 *
 * @package Tutor\Views
 * @subpackage Tutor\Addons
 * @author Themeum <support@themeum.com>
 * @link https://themeum.com
 * @since 2.0.0
 */

?>
<div class="tutor-admin-wrap">
	<div class="tutor-admin-body">
		<div class="tutor-backend-settings-addons-list tutor-dashboard-page">
			<div class="tutor-addons-list-body tutor-mt-24">
				<div class="tutor-mb-40">
					<div class="tutor-card tutor-card-md">
						<div class="tutor-card-body">
							<div class="tutor-row tutor-gx-xl-5 tutor-align-center">
								<div class="tutor-col-lg-auto tutor-mb-32 tutor-mb-lg-0">
									<div class="addon-pro-banner"> 
										<svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" width="423" height="268" fill="none"><defs><path id="reuse-0" fill="#F4F2F5" d="M196.08 138.43H19.92a13.05 13.05 0 0 0-13.05 13.05v101.54c0 7.21 5.84 13.05 13.05 13.05h176.16c7.22 0 13.06-5.84 13.06-13.05V151.48c0-7.2-5.84-13.05-13.06-13.05Z"/></defs><path fill="#FEEDF5" d="M409.16 267H232.98a13.05 13.05 0 0 1-13.05-13.05V152.4c0-7.21 5.84-13.05 13.06-13.05h176.15c7.22 0 13.06 5.84 13.06 13.05v101.54A13.04 13.04 0 0 1 409.16 267Z"/><use xlink:href="#reuse-0"/><path fill="#603D3D" d="M55.53 232.98s1.4 5.67-.24 8.46l10.36-1.07 1.09-5.8c.02 0-9.35.66-11.2-1.59Z"/><mask id="a" width="204" height="129" x="6" y="138" maskUnits="userSpaceOnUse" style="mask-type:alpha"><use xlink:href="#reuse-0"/></mask><g mask="url(#a)"><path fill="#B8E4FF" d="M51.4 240.5c-1.33.03-2.62.3-3.85.78-4.36 1.72-14.76 6.08-15.5 8.88-.92 3.58 6.05 26.23 7.3 27.94l-2.5 24.05s15.22 23.74 51.4 4.2l3.42-48.11 12.47-4.04-11.93-21.65-13.39 4.8c-1.47.53-2.98 1-4.5 1.36l-3.9.97c-.84.21-1.7.34-2.58.35l-16.44.47Z"/><path fill="#F9DD88" d="m65.77 239.99 6.2 72.79-19.56.7 3.33-73.1 10.03-.4Z"/><path fill="#B8E4FF" d="M34.22 247.7S3.94 269.33 6.98 278.2c3.03 8.85 15.6 15.6 16.3 15.13.7-.46 13.79-22.35 13.79-22.35l-2.85-23.29Z"/><path fill="#7F514B" d="M51.38 228.92c.51-.24 5.51 9.62 15.61 5.58 8.88-3.56.7-26.23.7-26.23s-4.03 8.54-12.27 7.3c-8.23-1.25-1.08-6.37-1.08-6.37s-5.91 1.08-4.82 9.94l2.95 7.75-1.4.16s-1.1-3.72-3.26-3.57c-2.17.16-.3 7.3 3.57 5.44Z"/><path fill="#181238" d="M67.7 208.27s-4.34 10.87-16.62 6.83c0 0-2.63-2.33 3.26-5.9 0 0-6.05 1.24-4.82 9.94l2.95 7.75-1.4.16s-1.25-3.65-3.12-3.18c-1.87.48-.25 6.08 3.48 5 0 0 4.65 4.66 5.73 5.28 1.09.62-4.55.5-4.55.5s-28.27-21.56-6.99-34.29 26.56 4.66 25.46 6.37c-1.1 1.7-3.38 1.54-3.38 1.54Z"/></g><path fill="#F9E07B" d="m162.9 229.59-46.82 27a9.15 9.15 0 0 1-12.48-3.33L61.7 180.77a9.14 9.14 0 0 1 3.34-12.47l46.81-27.01a9.15 9.15 0 0 1 12.49 3.33l41.88 72.5a9.14 9.14 0 0 1-3.33 12.47Z"/><path fill="#D28C35" d="M75.85 204.86s53.73 14.28 81.68-1.87l9.34 15.08a7.92 7.92 0 0 1-2.8 11.05l-49.32 28.27a7.93 7.93 0 0 1-10.83-2.97l-28.07-49.56Z" opacity=".34"/><path fill="#D85278" d="m145.58 215.1 10.7 6.77-2.78-7.7 5.58-2.08-11.24-2.75-2.26 5.76ZM133 215.8l-.7 12.35 6.5-3.97 5.61 5.13-.48-13.27-10.93-.24Z"/><path fill="#B73659" d="M139.05 218.13a8.8 8.8 0 1 0 0-17.58 8.8 8.8 0 0 0 0 17.58Z"/><path fill="#ECC058" d="M139.02 213.52a4.07 4.07 0 1 0 0-8.14 4.07 4.07 0 0 0 0 8.14Z"/><path fill="#7F514B" d="M138.35 160.75s-7.35-5.47-11.42 6.75c0 0-2.44 6.99 8.16-2.57 0 .02.92-3.72 3.26-4.18Z"/><path fill="#7F514B" d="M138.24 160.64s-3.5-1.28-7.92 15.01c0 0-4.66 15.6 12.11-.24 0 0 2.44-3.6 4.66-3.84-.01.01-.01-8.14-8.85-10.93Z"/><path fill="#7F514B" d="M149.46 176.02a5.49 5.49 0 0 0-.75-3.22c-1.1-1.76-3.48-2.97-8.03 4.37-7 11.3 1.05 7.34 4.66 4.66l3.5 5.11.62-10.92Z"/><path fill="#fff" d="M82.05 186.5c10.82-6.5 21.64-12.97 32.47-19.46 1.53-.93 3.06-1.84 4.6-2.76 2.2-1.33.18-4.77-2.02-3.45-10.82 6.5-21.64 12.97-32.47 19.46-1.53.93-3.06 1.84-4.6 2.76-2.2 1.33-.2 4.77 2.02 3.45ZM88.91 197.55l32.47-19.46 4.6-2.76c2.2-1.32.19-4.77-2.02-3.44L91.5 191.35c-1.53.92-3.07 1.83-4.6 2.76-2.2 1.32-.2 4.77 2.01 3.44ZM96.25 209.55l32.47-19.46c1.53-.93 3.06-1.84 4.6-2.76 2.2-1.33.19-4.77-2.01-3.45-10.83 6.5-21.65 12.97-32.47 19.47l-4.6 2.75c-2.2 1.33-.2 4.77 2.01 3.45ZM103 220.72c10.83-6.5 21.65-12.97 32.47-19.47l4.6-2.75c2.2-1.33.2-4.78-2.01-3.45-10.82 6.5-21.65 12.97-32.47 19.46-1.53.93-3.06 1.84-4.6 2.76-2.2 1.32-.2 4.77 2.02 3.45ZM108.83 233.29c5.72-3.42 11.41-6.85 17.13-10.26l2.42-1.45c2.2-1.33.2-4.77-2-3.45l-17.13 10.26-2.43 1.45c-2.2 1.32-.2 4.77 2.01 3.45Z"/><path fill="#E8B63E" d="M361.61 234.2c-.46-7-10.54-23.98-17.5-31.19a8 8 0 0 0-5.93-2.47l-10.9.19-11.3.03c-.25-.1-2.27-.01-4.31.11l-4.89-.1a8.04 8.04 0 0 0-5.94 2.48c-6.96 7.21-17.01 24.18-17.5 31.19-.34 5.21 9 16.94 15.64 24.56l-.25 8.43 47.01-.02-1.32-6.86c6.62-7.48 17.56-20.72 17.2-26.35Zm-57.48 5.8s-4.55-4.7-1.36-13.28c0 0 1.15-3.91 5.6-9.29L304.14 240Zm37.3-1.62-1 1.51-4.34-22.44c.01 0 10.44 11.47 5.34 20.93Z"/><path fill="#F9DD88" d="m315.97 200.76-.08 66.76 17.6.02-6.21-66.81-11.3.03Z"/><path fill="#E8B63E" d="m333.98 259.2-3.32-6.74 9.67-12.46-4.4 23.13-1.95-3.94Z"/><path fill="#000" d="M331.9 252.45c1.54-2.5 3.61-4.66 5.5-6.9 1.83-2.15 3.84-4.33 5.13-6.87.24-.46-.44-.86-.68-.4-1.33 2.59-3.4 4.82-5.27 7.02-1.85 2.17-3.86 4.3-5.36 6.75-.3.43.41.84.68.4Z"/><path fill="#7F514B" d="M314.62 170.96s-6.05 8.8-3.11 17.31c0 0 1.46 4.9 5.14 5.53 0 0 5.74 1.78 8.54-2.16 0 0-.51-.37-.16-.5s2.95-3.48 3.1-3.9c.15-.44 2.3 1.17 3.1-2.32.82-3.48-2.68-3.6-3.38-1.96 0 0-.22 2.58-.27 2.6-.05.01-1.48.32-1.61-.35-.13-.67 2-5.71 1.43-8.47-.54-2.76-2.2-4.04-2.2-4.04s-1.68 5.65-6.37 2.12c-4.7-3.52-4.21-3.86-4.21-3.86Z"/><path fill="#181238" d="M311.23 180.28s-2.09-1.79-1.1-4.85c0 0 .29-.51-.08-1.12-.38-.6-2.36-4.85-.84-6.47 1.51-1.65 6.01-5.28 15.62-4.36 0 0 5.9-.4 5.2 3.29 0 0 4.94-1.15 7.06 3.47 2.13 4.61.39 10.12-1.4 12.65-1.79 2.54-8.8 9.24-8.8 9.24l-1.7-.5s-.45-.23-.3-.36c.13-.13 1.48-1.39 3.23-4.04 0 0-.01-.2.67-.03.69.18 2.19-.25 2.52-2.77.32-2.56-1.85-2.44-1.85-2.44s-1.18.03-1.6.97c0 0-.14 2.55-.26 2.6-.15.05-1.46.33-1.62-.35-.17-.69 1.49-4.22 1.53-7.7 0 0-.14-2.67-2.3-4.81 0 0-1.29 4.77-5.2 2.87 0 0-4.16-2.02-5.36-4.48-.03 0-3.46 5.6-3.42 9.19Z"/><path fill="#7F514B" d="m316.64 193.8-.66 6.96 11.3-.03-2.1-9.11s-4.47 2.4-8.54 2.19Z"/><path fill="#5B3231" d="M316.64 193.8s2.37.2 3.6-.54c0 0-.87 2.06-3.76 2.17l.16-1.63Z"/><path fill="#0B4EDC" d="m353.96 236.73-36.47 20.04a4.99 4.99 0 0 1-6.77-1.96l-21.12-38.38a4.98 4.98 0 0 1 1.97-6.77l36.47-20.03a4.99 4.99 0 0 1 6.77 1.96l21.12 38.38a4.98 4.98 0 0 1-1.97 6.76Z"/><path fill="#8BD1FF" d="m352.77 237.44-36.48 20.03a4.99 4.99 0 0 1-6.77-1.96l-21.11-38.38a4.98 4.98 0 0 1 1.96-6.77l36.47-20.03a4.99 4.99 0 0 1 6.77 1.96l21.12 38.38a4.98 4.98 0 0 1-1.96 6.77Z"/><path fill="#F75E61" d="m333.17 204.82-33.49 15.88 10.71 22.55 33.49-15.88-10.71-22.55Z"/><path fill="#1E2E34" d="M333.44 205.04a71 71 0 0 0-.72 1.7l-2.06 4.61-6.93 15.19-.06.13-.13-.03c-.1-.04-.2-.05-.32-.08-6.42-1.54-12.23-2.9-16.47-3.91l-4.98-1.23-1.36-.35a2.1 2.1 0 0 1-.46-.15l.48.08 1.37.3 5.01 1.1c4.25 1 10.07 2.34 16.49 3.82l.32.08-.2.1 7.03-15.14 2.16-4.56c.25-.52.44-.93.6-1.23.13-.3.21-.43.23-.43Z"/><path fill="#1E2E34" d="M310.66 243.48c-.1-.01.96-4.3 2.34-9.57a160.4 160.4 0 0 1 2.67-9.5c.1.02-.96 4.31-2.35 9.58-1.37 5.26-2.57 9.52-2.66 9.5ZM326.67 218.85c.05-.08 3.99 1.8 8.8 4.23 4.83 2.4 8.7 4.43 8.68 4.51-.05.08-4-1.8-8.81-4.22-4.82-2.4-8.7-4.42-8.67-4.52Z"/><path fill="#366268" d="m386.22 214.43-32.75-9.46a4.98 4.98 0 0 1-3.4-6.17l10-34.54a4.98 4.98 0 0 1 6.17-3.4l32.75 9.46a4.98 4.98 0 0 1 3.4 6.18l-9.99 34.53a5 5 0 0 1-6.18 3.4Z"/><path fill="#52A7B4" d="m388.06 214.77-32.75-9.46a4.98 4.98 0 0 1-3.4-6.18l9.99-34.53a4.98 4.98 0 0 1 6.18-3.4l32.75 9.46a4.98 4.98 0 0 1 3.4 6.17l-10 34.54a4.98 4.98 0 0 1-6.17 3.4Z"/><path fill="#E5B795" d="m370.64 173.32-4.74 19.56.83.16.37.02 18.66 4.29 4.45-19.58-19.56-4.45Z"/><path fill="#F2DBC9" d="m388.5 178.3-19.55-6.92-5.98 16.83 1.9 3.73 16.7 5.92 6.94-19.56Z"/><path fill="#E5B795" d="m364.87 191.94-1.9-3.73 2.87 1.02-.97 2.7Z"/><path fill="#211F47" d="m387.3 177.12.38.1s.31-.53.19-1.01c0 0-.11-.86-.98-1.09a1.5 1.5 0 0 0-1.6.63l-1.75 2.63s-.33.5-.03.99a.92.92 0 0 0 1.56.03c.56-.73 1.66-2.58 1.66-2.58s.13-.47-.22-.16l-1.68 2.56s-.33.53-.9.18c-.53-.32.1-1.21.1-1.21l1.46-2.23s.41-.53.72-.6c.25-.04.9-.06 1.23.47.16.25.17.55.08.84-.07.16-.08.27-.21.45Z"/><path fill="#366268" d="m294.4 193.68-21.92 7.02a5 5 0 0 1-6.28-3.23l-7.44-23.24a4.99 4.99 0 0 1 3.23-6.27l21.91-7.02a5 5 0 0 1 6.28 3.23l7.44 23.24a5 5 0 0 1-3.23 6.27Z"/><path fill="#52A7B4" d="m295.67 193.12-21.92 7.02a5 5 0 0 1-6.27-3.22l-7.44-23.25a4.99 4.99 0 0 1 3.23-6.27l21.91-7.02a5 5 0 0 1 6.28 3.23l7.44 23.24a4.97 4.97 0 0 1-3.23 6.27Z"/><path fill="#F2DBC9" d="m287.37 185.9-13.47 4.16a1.3 1.3 0 0 1-1.63-.87l-3.37-10.94a1.3 1.3 0 0 1 .86-1.63l13.47-4.14a1.3 1.3 0 0 1 1.63.86l3.37 10.94a1.3 1.3 0 0 1-.86 1.63Z"/><path fill="#F2DBC9" d="m285.45 176.54 3.05-3.15a.6.6 0 0 1 1 .24l2.26 7.9c.1.4-.24.8-.66.73l-4.21-.7a.57.57 0 0 1-.46-.42l-1.12-4.05c-.05-.18 0-.4.14-.55Z"/><path fill="#7F514B" d="M303.54 248.46s11.92-1.15 12.75-.34c.83.8.93 1.65-2.4 3.26-3.34 1.6 5.58 6.65 6.09 8.3.51 1.64-1.58 2.6-12.13-2.02 0 0-5.65-2.36-6.39-2l2.08-7.2Z"/><path fill="#7F514B" d="M330.68 252.51s-10.7-1.66-11.53-.84c-.83.8-.93 1.64 2.41 3.25 3.34 1.61-5.59 6.65-6.1 8.3-.5 1.64 1.58 2.6 12.13-2.02 0 0 5.66-2.36 6.39-2l-3.3-6.69Z"/><path fill="#FED6E8" d="M195.43 129.17H19.25a13.05 13.05 0 0 1-13.06-13.05V14.6c0-7.21 5.85-13.05 13.06-13.05h176.16c7.22 0 13.06 5.84 13.06 13.05v101.53c0 7.2-5.84 13.04-13.04 13.04Z"/><path fill="#8888EA" d="M167.56 105.2H115.3a7.3 7.3 0 0 1-7.3-7.3V18.87a7.3 7.3 0 0 1 7.3-7.3h52.25a7.3 7.3 0 0 1 7.3 7.3V97.9a7.32 7.32 0 0 1-7.3 7.3Z"/><path fill="#C1C4F6" d="M165.96 105.2h-52.52a7.3 7.3 0 0 1-7.3-7.3V18.47a7.3 7.3 0 0 1 7.3-7.3h52.52a7.3 7.3 0 0 1 7.31 7.3V97.9a7.3 7.3 0 0 1-7.3 7.3Z"/><path fill="#171336" d="M42.5 73.35s-15.41-25.43-19.75-8.4C18.4 82 39.65 79.23 39.65 79.23s.29 1.3-.32 3.83c-1.26 5.37 3.03 10.7 8.56 10.32 1.77-.11 5.94-1.66 7.18-3.56 0 0-4.79-7.93.67-7.83 0 0 12.72-5.68 6.5-12.99-6.21-7.27-19.73-5.64-19.73 4.36Z"/><path fill="#8A5E5B" d="m45.9 93.29-4.19 6.24c6.77 5.3 13.36-.86 13.36-.86a12.99 12.99 0 0 1-1.23-6.21c2.05 1.08 6.45 2.09 7.4 1.45 1.68-1.15 2.63-4.74 2.63-4.74 3.01-7.62.1-16.38.1-16.38-.89 6.25-8.23 9.24-8.23 9.24s-2.66-.5-3.35 1.66c-.9 2.79.18 4.88 1.21 5.75.75.64 1.47.4 1.47.4s-3.33 3.85-9.16 3.45ZM12.53 167.32c-.57 0-.33 3.83-2.84 5.64 0 0-4.79 5.02-8.43 6.94-3.64 1.9 3.75 6.58 9.9.71 0 0 1.93-2.15 4.56.11 2.62 2.27 3.2 1.31 3.2 1.31s-2.51-6.1-2.62-7.91c-.11-1.79 2.73-6.94 2.73-6.94l-6.5.14Z"/><path fill="#479BD5" d="m41.8 131.37-.07-31.83-.26.2a46.72 46.72 0 0 0-12.15 14.02 90.85 90.85 0 0 1-2.36 3.98c-2.97 4.79-5.5 9.83-7.74 15L4.5 166.72s22.59 3.16 23.12 2.36"/><path fill="#3E8FCC" d="M20.8 168.31c6.39-32.46 18.44-54.84 18.44-54.84l-6.87 42.56-4.75 13.03c0 .02-6.84-.65-6.82-.75Z"/><path stroke="#000" stroke-miterlimit="10" d="M6.2 162.68s21.45 3.26 22.52 3.32"/><path fill="#50AAF7" d="M41.73 99.53s5.8-.34 13.5-1.02c0 0 6.2 1.35 11.7 2.58 5.32 1.2 18.79 6.94 24.23 7.05 12.47.27 12.47-.8 28.83-1.5l13.38 22.72s-18.86 2.4-64.1-9.51l10.34 49.87c-2.85 1.24-25.27-.21-49-1.55l11.12-68.64Z"/><path fill="#000" d="M61.09 111.59a20.51 20.51 0 0 0 4.65 6.14c1 .9 2.09 1.69 3.25 2.36.42.24.78-.4.37-.64a19.25 19.25 0 0 1-7.31-7.56c-.12-.22-.24-.45-.34-.67-.19-.43-.81-.06-.62.37Z"/><path stroke="#000" stroke-miterlimit="10" stroke-width=".75" d="m117.08 106.88 7.47 22.37"/><path fill="#8888EA" d="M154.04 95.08h-28.6a4.7 4.7 0 1 1 0-9.42h28.6a4.7 4.7 0 1 1 0 9.42Z"/><path fill="#6455D5" d="M154.15 93.64h-28.86a4.64 4.64 0 1 1 0-9.28h28.86a4.64 4.64 0 1 1 0 9.28Z"/><path fill="#E5E2F6" d="M145.93 46.82h-12.65a5.27 5.27 0 0 1-5.26-5.26V28.92c0-2.9 2.36-5.26 5.26-5.26h12.65c2.9 0 5.26 2.36 5.26 5.26v12.64c0 2.9-2.34 5.26-5.26 5.26Z"/><path fill="#6355D5" d="M139.81 35.77a3.54 3.54 0 1 0 0-7.1 3.54 3.54 0 0 0 0 7.1Z"/><path fill="#6455D5" d="M148.69 44.59c0-3.96-3.98-7.17-8.86-7.17-4.89 0-8.86 3.21-8.86 7.17v.03c0 1.35 1.18 2.4 2.52 2.4h12.68a2.47 2.47 0 0 0 2.52-2.4v-.03Z"/><path fill="#E5E2F6" d="M116.72 62.84h45.79c1.03 0 1.03-1.6 0-1.6h-45.79c-1.04 0-1.04 1.6 0 1.6ZM122.43 57.32H156.8c1.02 0 1.02-1.6 0-1.6H122.43c-1.02 0-1.02 1.6 0 1.6ZM123.87 68.52h31.49c1.02 0 1.02-1.6 0-1.6h-31.49c-1.02 0-1.02 1.6 0 1.6ZM123.87 74.96h31.49c1.02 0 1.02-1.6 0-1.6h-31.49c-1.02 0-1.02 1.6 0 1.6Z"/><path fill="#74473F" d="M135.95 88.36c3.74-1.87-2.06 8.42-2.06 8.42s8.97 2.64 6.67 6.3c-2.3 3.67-7.69 5.81-7.69 5.81-2.3 1.36-6.96 7.93-6.96 7.93l-5.94-10.16 4.8-3.24s8.55-13.74 11.18-15.06Z"/><path fill="#74473F" d="m129.45 97.13-4.67 6.29s.86-8.6 1.77-10.04c1.1-1.72 2.9 3.75 2.9 3.75Z"/><path stroke="#000" stroke-miterlimit="10" stroke-width=".5" d="M40.2 265.7s1.08-2.3.89-5.49"/><path stroke="#000" stroke-miterlimit="10" stroke-width=".25" d="M133.27 166.51s1.07-2.12 3.54-2.12M130.8 181.89s4.77-10.26 6.54-10.08"/><path stroke="#000" stroke-miterlimit="10" stroke-width=".5" d="M91.69 258.25s-4.77-2.61-7.07-10.22M55.74 240.42l-1.47 20.51"/><path fill="#C1C4F6" d="M409.16 129.17H232.98a13.05 13.05 0 0 1-13.05-13.05V14.6c0-7.21 5.84-13.05 13.06-13.05h176.15c7.22 0 13.06 5.84 13.06 13.05v101.53a13.03 13.03 0 0 1-13.04 13.04Z"/><path fill="#1C1C1B" d="M335.45 61.18c.25.1.54-.02.67-.27 1.05-2.32.46-4.68-1.77-7l-.93-.92a14.04 14.04 0 0 1-2.07-2.31c-1.14-1.72-1.33-3.62-1.52-5.63l-.16-1.5c-.27-2.2-1.74-4.3-4.1-5.92a74.27 74.27 0 0 0-8.2-4.6c-2.6-1.32-5.28-2.67-7.73-4.3a.52.52 0 0 0-.72.14c-.16.24-.1.56.14.72a75.92 75.92 0 0 0 7.86 4.37c2.7 1.37 5.52 2.8 8.07 4.53 1.23.83 3.34 2.62 3.66 5.19l.16 1.48c.19 2.06.4 4.18 1.67 6.11.63.94 1.44 1.74 2.22 2.49l.91.9c1.93 2 2.44 3.9 1.57 5.83-.12.26 0 .58.27.69Z"/><path fill="#1C1C1B" d="M333.45 61.15c-.9.9-1.61 1.99-2.26 3.09-.39.64-.85 1.21-1.22 1.87-.16.3-.37.7-.38 1.05-.05.81.5.54.94.2-.22.18-.14.79.06.95.3.2.77-.1 1.1.22.42.4.5 1.17 1.16.6 1.26-1.1 1.96-2.77 2.56-4.28.4-1.04 1.6-3.2.75-4.25-.36-.44-.87-.64-1.43-.44-.29.1-.54.28-.78.5-.16.15-.34.3-.5.49Z"/><path fill="#3D3C3C" d="m338.69 40.4-23.04-22.04a4.77 4.77 0 0 0-3.25-1.32l-31.91-.3a.69.69 0 0 0-.48 1.17l23.03 22.05c.88.85 2.05 1.3 3.26 1.32l31.9.3c.62 0 .93-.74.49-1.17Z"/><path fill="#1C1C1B" d="M290.58 28.78c1.58-3.88 10.13-4.07 19.09-.42 8.97 3.66 14.95 9.75 13.38 13.63l-3.44 8.42c-1.58 3.88-10.13 4.07-19.09.41-8.97-3.65-14.95-9.74-13.37-13.62.04-.13 3.36-8.28 3.43-8.42Z"/><path fill="#1C1C1B" d="M302.07 47.01c8.97 3.65 17.5 3.46 19.09-.41l-1.56 3.83c-1.59 3.87-10.14 4.06-19.1.41-8.97-3.65-14.95-9.75-13.37-13.62.03-.07.76-1.9 1.56-3.83-1.58 3.86 4.4 9.97 13.38 13.62Z"/><path fill="#3D3C3C" d="M319.24 48.58c1.04-2.56-4.95-7.42-13.38-10.85-8.44-3.43-16.12-4.14-17.16-1.57-1.05 2.56 4.94 7.42 13.38 10.85 8.43 3.43 16.12 4.13 17.16 1.57Z"/><path fill="#74473F" d="m368 67.88 2.75-6.13s-6.9 1.85-9.29.58c-2.39-1.28-1.77-4.31-1.72-7.44 0 0 1-10 6.4-15.42 0 0 5.01 3.3 8.48 3.54 0 0 .56-.55-1.4 6.36 0 0 2.1-2.68 4.68 1.31 2.69 4.1-3.86 5.5-3.86 5.5s-.68 2.44 4.04 6.96l-.22 7.02-9.85-2.28ZM320.71 102.33l-1.72-1.56s-3.83-.17-5.5-.86c-1.63-.69-2.48-2.9-8.58-8.6-6.1-5.7-6.8-2.77-6.88-1.56-.08 1.21 5.56 7.34-3.48 6.67-9.03-.67-11.24 1.18-9.2 3.2 2.05 2.03 9.97 5.23 17.55 6.6 7.6 1.38 16.33 6.36 16.33 6.36l1.48-10.25Z"/><path fill="#204DD3" d="M384.77 71.85S411 99.02 419.28 147.8l-29.47.15s.56-14.44-.84-19.35l-39.29.14 2.81-8.4s-18.8 11.35-36.76 6.87l3.37-26.5s22.03 3.08 33.1-7.7c0 0 8.67-6.24 14.23-26.12l18.34 4.95Z"/><path fill="#0F2D70" d="m366.44 66.87-13.95 53.46s-19.65 12.06-36.76 6.87l3.37-26.5c.02 0 36.12-.73 47.34-33.83Z"/><path fill="#171336" d="M366.16 39.47s-3.26-2.78-.72-7.18 10.98-3.54 10.63 4.67c0 0 13.55 1.39 13.15 10.86 0 0 10-2.55 16.29.72 6.29 3.27 6.19 9.59 2.23 13.95-3.96 4.35-10.82 4.06-14.8-3.56-3.97-7.63-4.42-6.75-4.42-6.75s-1.37 11.52-10.4 11c0 0-4.81-4.3-4.04-6.95 0 0 4.85-1.2 4.2-4.2-.66-3-3.74-4.06-5.05-2.61 0 0 1.74-5.87 1.28-6.19-.48-.35-2.17.37-8.35-3.76ZM389.32 128.08c-.05-2.82-.2-5.65-.42-8.47-.43-5.82-1.1-11.66-2.3-17.39a52.63 52.63 0 0 0-2.7-9.31c-.13-.3-.65-.18-.52.14 2.25 5.47 3.27 11.44 4.06 17.28a164.31 164.31 0 0 1 1.35 17.73c.02.36.53.36.53.02Z"/><path fill="#4380F6" fill-rule="evenodd" d="M294.47 36.91a30.45 30.45 0 0 1 30.46 30.44 30.45 30.45 0 0 1-30.46 30.44 30.43 30.43 0 1 1 0-60.87Z" clip-rule="evenodd"/><path fill="#B8E4FF" fill-rule="evenodd" d="M294.47 36.91c7.89 0 15.07 2.99 20.48 7.92l-1.12.44-.62.66.15.76.73.11.46 1.12 1.28-.51.2 1.5h-.38l-1.03-.16-1.17.2-1.13 1.59-1.62.24-.22 1.37.67.16-.19.88-1.6-.32-1.46.32-.32.8.27 1.72.84.4 1.46-.02.97-.1.3-.78 1.52-1.98 1 .21.98-.88.2.69 2.42 1.64-.29.38-1.1-.04.4.6.68.15.79-.34-.02-.94.35-.18-.29-.3-1.6-.9-.44-1.19h1.34l.43.43 1.17 1 .03 1.2 1.2 1.28.46-1.75.83-.47.16 1.44.81.9h.34c.33.84.64 1.7.88 2.6h-1.42l-1.52-1.14-1.6.16v.97h-.5l-.53-.38-2.77-.7V55.9l-3.5.27-1.08.59h-1.37l-.69-.07-1.67.95v1.75l-3.43 2.49.28 1.05h.69l-.18 1-.5.18v2.63l2.96 3.4h1.3l.06-.2h2.33l.67-.63h1.32l.72.72 1.97.2-.27 2.6 2.18 3.85-1.15 2.2.07 1.03.89.89v2.49l1.2 1.6v1.59a30.51 30.51 0 0 1-23.74 11.34 30.46 30.46 0 0 1-30.31-27.33l-.05-.71c-.06-.8-.1-1.6-.1-2.38v-1.04l.02-.44.02-.28c.01-.19.01-.38.03-.55l.01-.15c.28-3.41 1.1-6.65 2.38-9.65v1.66l1.3.62v2.47l1.23 2.11 1 .16.14-.72-1.2-1.83-.22-1.79h.7l.3 1.84 1.72 2.5-.45.81 1.09 1.66 2.71.69v-.45l1.1.16-.11.77.85.16 1.3.36 1.87 2.13 2.36.17.23 1.95-1.63 1.13-.06 1.72-.23 1.06 2.35 2.95.18 1s.84.22.95.22c.11 0 1.93 1.38 1.93 1.38v5.3l.64.18-.44 2.46 1.1 1.45-.21 2.44 1.45 2.5 1.84 1.62 1.83.03.2-.59-1.36-1.15.06-.56.26-.7.04-.7-.92-.02-.46-.59.76-.73.11-.56-.86-.22.05-.53 1.21-.17 1.85-.88.63-1.15 1.94-2.47-.44-1.95.59-1.02 1.79.05 1.2-.96.38-3.75 1.32-1.69.24-1.08-1.21-.39-.82-1.32-2.74-.02-2.16-.83-.1-1.54-.73-1.26-1.96-.04-1.15-1.78-1-.5-.05.55-1.84.1-.67-.93-1.91-.39-1.58 1.84-2.5-.43-.17-2.81-1.8-.3.71-1.38-.2-.78-2.38 1.6-1.49-.2-.54-1.16.34-1.2.83-1.51 1.88-.97h3.67l-.01 1.13 1.32.6-.11-1.9.96-.97 1.91-1.26.14-.87 1.92-2 2.03-1.13-.18-.14 1.38-1.3.49.13.22.29.53-.56.13-.06-.56-.07-.6-.19v-.56l.31-.25h.69l.3.13.29.54.32-.05v-.03l.11.01.96-.14.13-.46.54.13v.5l-.51.36h.01l.07.54 1.7.53.02.01.38-.01.04-.77-1.38-.62-.06-.37 1.13-.37.05-1.1-1.18-.71-.1-1.84-1.63.82h-.59l.15-1.4-2.2-.52-.93.69v2.12l-1.64.5-.68 1.38-.7.13v-1.8l-1.55-.21-.78-.51-.3-1.13 2.78-1.63 1.34-.43.14.92.77-.03.04-.46.8-.13.02-.16-.35-.14-.07-.48.98-.06.59-.63.03-.03h.02l.17-.19 2.03-.26.9.77-2.37 1.26 3 .72.4-1h1.31l.48-.88-.94-.23v-1.11l-2.92-1.3-2.02.23-1.14.59.1 1.45-1.2-.18-.18-.8 1.15-1.03-2.08-.11-.6.19-.28.68.79.15-.16.76-1.31.1-.21.51-1.91.05s-.05-1.09-.13-1.09l1.48-.03 1.15-1.12-.62-.31-.83.8-1.37-.05-.82-1.15h-1.77l-1.84 1.37h1.68l.16.48-.45.43 1.87.05.29.67-2.1-.1-.12-.51-1.31-.29-.7-.38-1.14.02a31.09 31.09 0 0 1 17.37-5.32Zm14.93 10.36.28-.43 1.02-.21.28 1.23.52.87.37.4.65.27-.62.74-1.2.11h-.89l.11-1.09.74-.14-.05-.5-.7-.46-.5-.33v-.46h-.01Zm-1.68 1.94.62-.99.85-.19.6.24-.06.69-1.28.9h-.71v-.65h-.02Zm-16.89 3.83-.65.05.03-.46.3-.35.39.3-.07.46Zm2.29-.78-.45.03-.1.43-.35.21-.54.05-.02-.23h-.2v-.46h.87l.18-.48h.35l.4.07-.14.38Z" clip-rule="evenodd"/><g filter="url(#b)"><path fill="url(#c)" d="M213.78 187.19a52 52 0 0 0 52.02-52 52 52 0 0 0-52.02-51.98 52 52 0 0 0-52.02 51.99 52 52 0 0 0 52.02 51.99Z"/></g><path fill="url(#d)" fill-rule="evenodd" d="M234.95 131.03H239c9.08 0 9.08 13.61 0 13.61h-4.06v10.99a5.4 5.4 0 0 1-5.5 5.49h-10.99v-4.06c0-9.07-13.62-9.07-13.62 0v4.06h-10.99a5.4 5.4 0 0 1-5.5-5.5v-10.98h4.07c9.08 0 9.08-13.6 0-13.6h-4.06v-11a5.4 5.4 0 0 1 5.5-5.48h10.98v-4.06c0-9.08 13.62-9.08 13.62 0v4.06h11a5.4 5.4 0 0 1 5.49 5.49v10.98Z" clip-rule="evenodd"/><defs><linearGradient id="c" x1="213.78" x2="213.78" y1="187.19" y2="83.21" gradientUnits="userSpaceOnUse"><stop stop-color="#C3CAEE"/><stop offset=".66" stop-color="#E9EBFA"/><stop offset="1" stop-color="#fff"/></linearGradient><linearGradient id="d" x1="217.09" x2="217.09" y1="103.69" y2="161.12" gradientUnits="userSpaceOnUse"><stop stop-color="#3E5CDE"/><stop offset="1" stop-color="#0028A8"/></linearGradient><filter id="b" width="160.04" height="159.98" x="133.76" y="59.21" filterUnits="userSpaceOnUse"><feFlood flood-opacity="0" result="BackgroundImageFix"/><feColorMatrix in="SourceAlpha" result="hardAlpha" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0"/><feOffset dy="4"/><feGaussianBlur stdDeviation="14"/><feComposite in2="hardAlpha" operator="out"/><feColorMatrix values="0 0 0 0 0.00885415 0 0 0 0 0.175312 0 0 0 0 0.425 0 0 0 0.2 0"/><feBlend in2="BackgroundImageFix" result="effect1_dropShadow_12122:207971"/><feBlend in="SourceGraphic" in2="effect1_dropShadow_12122:207971" result="shape"/></filter></defs></svg>
									</div>
								</div>

								<div class="tutor-col-lg">
									<div class="tutor-fs-4 tutor-fw-medium tutor-color-black tutor-mb-20"><?php esc_html_e( 'Get All of Our Addons for a Single Price', 'tutor' ); ?></div>
									<div class="tutor-d-flex tutor-align-center tutor-fs-6 tutor-color-secondary tutor-mb-12">
										<span class="tutor-icon-mark tutor-color-primary tutor-mr-8" area-hidden="true"></span>
										<?php esc_html_e( 'Enjoy all popular add-ons under a single price', 'tutor' ); ?>
									</div>

									<div class="tutor-d-flex tutor-align-center tutor-fs-6 tutor-color-secondary tutor-mb-12">
										<span class="tutor-icon-mark tutor-color-primary tutor-mr-8" area-hidden="true"></span>
										<?php esc_html_e( 'Easy enable options for the features you need', 'tutor' ); ?>
									</div>

									<div class="tutor-d-flex tutor-align-center tutor-fs-6 tutor-color-secondary tutor-mb-32">
										<span class="tutor-icon-mark tutor-color-primary tutor-mr-8" area-hidden="true"></span>
										<?php esc_html_e( 'Advanced customization options for each add-on', 'tutor' ); ?>
									</div>

									<a class="tutor-btn tutor-btn-primary tutor-btn-lg" href="<?php echo esc_url( 'https://www.themeum.com/product/tutor-lms/?utm_source=tutor&utm_medium=addons_lists&utm_campaign=tutor_addons_lists' ); ?>">
										<span class="tutor-icon-crown tutor-mr-8" area-hidden="true"></span>
										<?php esc_html_e( 'Buy Pro', 'tutor' ); ?>
									</a>
								</div>
							</div>
						</div>
					</div>
				</div>

				<div class="tutor-d-flex tutor-justify-between tutor-align-center tutor-mb-32">
					<div class="tutor-fs-5 tutor-fw-medium tutor-color-black"><?php esc_html_e( 'Add-ons', 'tutor' ); ?></div>
					<div class="tutor-addons-list-select-filter">
						<div class="tutor-form-wrap">
							<span class="tutor-icon-search tutor-form-icon" area-hidden="true"></span>
							<input id="free-addons-search" type="search" class="tutor-form-control" placeholder="<?php esc_attr_e( 'Search…', 'tutor' ); ?>" value="" />
						</div>
					</div>
				</div>

				<div id="tutor-free-addons" class="tutor-addons-list-items tutor-row tutor-gx-xxl-4"></div>
			</div>
		</div>
	</div>
</div>
