<?php
if ( is_admin() || isset( $_POST[ 'action' ] ) && 'heartbeat' == $_POST[ 'action' ] ) {
    // Do nothing to allow indexing to this content.

} else {

    // Prevent search engine to index order pages for security reasons
    add_action( 'wp_head', 'tc_no_index_no_follow' );

    global $wp, $tc;
    $order_id = ''; $order_key = '';

    // Collection of General Settings values
    $settings = get_option( 'tc_general_setting', false );

    // Retrieve Order ID
    if ( isset( $wp->query_vars[ 'tc_order' ] ) ) {
        $order_id = sanitize_text_field( $wp->query_vars[ 'tc_order' ] );
    } elseif ( isset( $_GET[ 'tc_order' ] ) ) {
        $order_id = sanitize_text_field( $_GET[ 'tc_order' ] );
    }

    // Retrieve Order Key
    if ( isset( $wp->query_vars[ 'tc_order_key' ] ) ) {
        $order_key = sanitize_text_field( $wp->query_vars[ 'tc_order_key' ] );
    } elseif ( isset( $_GET[ 'tc_order_key' ] ) ) {
        $order_key = sanitize_text_field( $_GET[ 'tc_order_key' ] );
    }

    // Order Object
    $order = tc_get_order_id_by_name( $order_id );

    // Remove associated order session data
    if ( $order ) {
        $tc->remove_order_session_data();
    }

    if ( $order_id && $order_key ) {

        if ( isset( $settings[ 'force_login' ] ) && 'yes' == $settings[ 'force_login' ] && ! is_user_logged_in() ) : ?>
            <div class="force_login_message"><?php printf( __( 'Please %s to see this page', 'tc' ), '<a href="' . esc_url( apply_filters( 'tc_force_login_url', wp_login_url( tc_current_url() ), tc_current_url() ) . '">' . __( 'Log In', 'tc' ) . '</a>' ) ); ?></div>
        <?php else : ?>
            <div class="tc-container">
                <?php if ( $order ) { ?>
                    <div class="tickera">
                        <?php echo tc_get_order_details_front( $order->ID, $order_key, true ); ?>
                    </div><!-- tickera --><?php
                } else {
                    _e( 'Order cannot be found.', 'tc' );
                } ?>
            </div>
        <?php endif;

    } else {
        _e( 'Order cannot be found.', 'tc' );
    }
}
