<?php
/**
 * Gutenberg blocks for Tickera
 * Adds Tickera Gutenberg blocks
 */

if ( ! defined( 'ABSPATH' ) )
    exit; // Exit if accessed directly

if ( ! class_exists( 'TC_tc_gutentick' ) ) {

    class TC_tc_gutentick {

        var $version = '0.1';
        var $title = 'Gutentick';
        var $name = 'tc_gutentick';
        var $dir_name = 'tc-gutentick';
        var $location = 'plugins';
        var $plugin_dir = '';
        var $plugin_url = '';

        function __construct() {

            global $pagenow;

            if ( function_exists( 'register_block_type' ) && 'widgets.php' != $pagenow ) {
                add_action( 'init', array( $this, 'register_gutenberg_blocks' ) );
                add_action( 'enqueue_block_editor_assets', array( $this, 'register_extra_scripts' ) );
            }

            add_action( 'admin_enqueue_scripts', array( $this, 'admin_scripts_styles' ) );
            add_action( 'wp_enqueue_scripts', array( $this, 'front_scripts_styles' ) );
        }

        /**
         *  Load CSS and JS in Admin pages
         */
        function admin_scripts_styles() {
            global $tc;
            if ( defined( 'TC_DEV' ) ) {
                wp_enqueue_style( $tc->name . '-common-admin', $tc->plugin_url . 'includes/addons/gutenberg/blocks-assets/blocks.css', array(), $tc->version );
            }
        }

        /**
         * Load CSS and JS in Frontend pages
         */
        function front_scripts_styles() {
            global $tc;
            if ( defined( 'TC_DEV' ) ) {
                wp_enqueue_style( $tc->name . '-common-front', $tc->plugin_url . 'includes/addons/gutenberg/blocks-assets/blocks.css', array(), $tc->version );
            }
        }

        function register_gutenberg_blocks() {

            // Only if Bridge is not active
            if ( apply_filters( 'tc_bridge_for_woocommerce_is_active', false ) == false ) {

                register_block_type( 'tickera/add-to-cart', array(
                    'editor_script' => 'tc_add_to_cart_block_editor',
                    'editor_style' => 'tc_add_to_cart_block_editor',
                    'render_callback' => array( $this, 'render_add_to_cart_shortcode' ),
                    'attributes' => array(
                        'ticket_type_id' => array( 'type' => 'string' ),
                        'soldout_message' => array( 'type' => 'string' ),
                        'show_price' => array( 'type' => 'boolean' ),
                        'price_position' => array( 'type' => 'string' ),
                        'quantity' => array( 'type' => 'boolean' ),
                        'link_type' => array( 'type' => 'string' ),
                        'className' => array( 'type' => 'string' ),
                        'textColor' => array( 'type' => 'string' ),
                        'backgroundColor' => array( 'type' => 'string' ),
                        'gradient' => array( 'type' => 'string' ),
                        'style' => array( 'type' => 'object' ),
                        'borderColor' => array( 'type' => 'string' ),
                        'fontSize' => array( 'type' => 'string' ),
                        'fontFamily' => array( 'type' => 'string' )
                    )
                ) );

                register_block_type( 'tickera/event-add-to-cart', array(
                    'editor_script' => 'tc_event_add_to_cart_block_editor',
                    'editor_style' => 'tc_event_add_to_cart_block_editor',
                    'render_callback' => array( $this, 'render_event_add_to_cart_shortcode' ),
                    'attributes' => array(
                        'event_id' => array( 'type' => 'string' ),
                        'display_type' => array( 'type' => 'string' ),
                        'button_title' => array( 'type' => 'string' ),
                        'link_type' => array( 'type' => 'string' ),
                        'ticket_type_title' => array( 'type' => 'string' ),
                        'price_title' => array( 'type' => 'string' ),
                        'cart_title' => array( 'type' => 'string' ),
                        'show_event_title' => array( 'type' => 'boolean' ),
                        'show_price' => array( 'type' => 'boolean' ),
                        'quantity' => array( 'type' => 'boolean' ),
                        'quantity_title' => array( 'type' => 'string' ),
                        'soldout_message' => array( 'type' => 'string' ),
                        'className' => array( 'type' => 'string' ),
                        'textColor' => array( 'type' => 'string' ),
                        'backgroundColor' => array( 'type' => 'string' ),
                        'gradient' => array( 'type' => 'string' ),
                        'style' => array( 'type' => 'object' ),
                        'borderColor' => array( 'type' => 'string' ),
                        'fontSize' => array( 'type' => 'string' ),
                        'fontFamily' => array( 'type' => 'string' )
                    )
                ) );

                register_block_type( 'tickera/event-tickets-sold', array(
                    'editor_script' => 'tc_event_tickets_sold_block_editor',
                    'editor_style' => 'tc_event_tickets_sold_block_editor',
                    'render_callback' => array( $this, 'render_event_tickets_sold_shortcode' ),
                    'attributes' => array(
                        'event_id' => array( 'type' => 'string' ),
                        'className' => array( 'type' => 'string' ),
                        'textColor' => array( 'type' => 'string' ),
                        'backgroundColor' => array( 'type' => 'string' ),
                        'gradient' => array( 'type' => 'string' ),
                        'style' => array( 'type' => 'object' ),
                        'borderColor' => array( 'type' => 'string' )
                    )
                ) );

                register_block_type( 'tickera/event-tickets-left', array(
                    'editor_script' => 'tc_event_tickets_left_block_editor',
                    'editor_style' => 'tc_event_tickets_left_block_editor',
                    'render_callback' => array( $this, 'render_event_tickets_left_shortcode' ),
                    'attributes' => array(
                        'event_id' => array( 'type' => 'string' ),
                        'className' => array( 'type' => 'string' ),
                        'textColor' => array( 'type' => 'string' ),
                        'backgroundColor' => array( 'type' => 'string' ),
                        'gradient' => array( 'type' => 'string' ),
                        'style' => array( 'type' => 'object' ),
                        'borderColor' => array( 'type' => 'string' ),
                        'fontSize' => array( 'type' => 'string' ),
                        'fontFamily' => array( 'type' => 'string' )
                    )
                ) );

                register_block_type( 'tickera/tickets-sold', array(
                    'editor_script' => 'tc_tickets_sold_block_editor',
                    'editor_style' => 'tc_tickets_sold_block_editor',
                    'render_callback' => array( $this, 'render_tickets_sold_shortcode' ),
                    'attributes' => array(
                        'ticket_type_id' => array( 'type' => 'string' ),
                        'className' => array( 'type' => 'string' ),
                        'textColor' => array( 'type' => 'string' ),
                        'backgroundColor' => array( 'type' => 'string' ),
                        'gradient' => array( 'type' => 'string' ),
                        'style' => array( 'type' => 'object' ),
                        'borderColor' => array( 'type' => 'string' ),
                        'fontSize' => array( 'type' => 'string' ),
                        'fontFamily' => array( 'type' => 'string' )
                    )
                ) );

                register_block_type( 'tickera/tickets-left', array(
                    'editor_script' => 'tc_tickets_left_block_editor',
                    'editor_style' => 'tc_tickets_left_block_editor',
                    'render_callback' => array( $this, 'render_tickets_left_shortcode' ),
                    'attributes' => array(
                        'ticket_type_id' => array( 'type' => 'string' ),
                        'className' => array( 'type' => 'string' ),
                        'textColor' => array( 'type' => 'string' ),
                        'backgroundColor' => array( 'type' => 'string' ),
                        'gradient' => array( 'type' => 'string' ),
                        'style' => array( 'type' => 'object' ),
                        'borderColor' => array( 'type' => 'string' ),
                        'fontSize' => array( 'type' => 'string' ),
                        'fontFamily' => array( 'type' => 'string' )
                    )
                ) );

                register_block_type( 'tickera/order-history', array(
                    'editor_script' => 'tc_order_history_block_editor',
                    'editor_style' => 'tc_order_history_block_editor',
                    'render_callback' => array( $this, 'render_order_history_shortcode' ),
                    'attributes' => array(
                        'className' => array( 'type' => 'string' ),
                        'textColor' => array( 'type' => 'string' ),
                        'backgroundColor' => array( 'type' => 'string' ),
                        'gradient' => array( 'type' => 'string' ),
                        'style' => array( 'type' => 'object' ),
                        'borderColor' => array( 'type' => 'string' ),
                        'fontSize' => array( 'type' => 'string' ),
                        'fontFamily' => array( 'type' => 'string' )
                    )
                ) );

            } else {

                // When bridge is active
                register_block_type( 'tickera/woo-add-to-cart', array(
                    'editor_script' => 'tc_woo_add_to_cart_block_editor',
                    'editor_style' => 'tc_woo_add_to_cart_block_editor',
                    'render_callback' => array( $this, 'render_woo_add_to_cart_shortcode' ),
                    'attributes' => array(
                        'id' => array( 'type' => 'string' ),
                        'show_price' => array( 'type' => 'boolean' ),
                        'className' => array( 'type' => 'string' ),
                        'textColor' => array( 'type' => 'string' ),
                        'backgroundColor' => array( 'type' => 'string' ),
                        'gradient' => array( 'type' => 'string' ),
                        'style' => array( 'type' => 'object' ),
                        'borderColor' => array( 'type' => 'string' ),
                        'fontSize' => array( 'type' => 'string' ),
                        'fontFamily' => array( 'type' => 'string' )
                    )
                ) );

                register_block_type( 'tickera/woo-event-add-to-cart', array(
                    'editor_script' => 'tc_woo_event_add_to_cart_block_editor',
                    'editor_style' => 'tc_woo_event_add_to_cart_block_editor',
                    'render_callback' => array( $this, 'render_woo_event_add_to_cart_shortcode' ),
                    'attributes' => array(
                        'id' => array( 'type' => 'string' ),
                        'display_type' => array( 'type' => 'string' ),
                        'show_event_title' => array( 'type' => 'boolean' ),
                        'show_price' => array( 'type' => 'boolean' ),
                        'ticket_type_title' => array( 'type' => 'string' ),
                        'price_title' => array( 'type' => 'string' ),
                        'cart_title' => array( 'type' => 'string' ),
                        'quantity' => array( 'type' => 'boolean' ),
                        'quantity_title' => array( 'type' => 'string' ),
                        'className' => array( 'type' => 'string' ),
                        'textColor' => array( 'type' => 'string' ),
                        'backgroundColor' => array( 'type' => 'string' ),
                        'gradient' => array( 'type' => 'string' ),
                        'style' => array( 'type' => 'object' ),
                        'borderColor' => array( 'type' => 'string' ),
                        'fontSize' => array( 'type' => 'string' ),
                        'fontFamily' => array( 'type' => 'string' )
                    )
                ) );
            }

            register_block_type( 'tickera/event-date', array(
                'editor_script' => 'tc_event_date_block_editor',
                'editor_style' => 'tc_event_date_block_editor',
                'render_callback' => array( $this, 'render_event_date_shortcode' ),
                'attributes' => array(
                    'event_id' => array( 'type' => 'string' ),
                    'className' => array( 'type' => 'string' ),
                    'textColor' => array( 'type' => 'string' ),
                    'backgroundColor' => array( 'type' => 'string' ),
                    'gradient' => array( 'type' => 'string' ),
                    'style' => array( 'type' => 'object' ),
                    'borderColor' => array( 'type' => 'string' ),
                    'fontSize' => array( 'type' => 'string' ),
                    'fontFamily' => array( 'type' => 'string' )
                )
            ) );

            register_block_type( 'tickera/event-location', array(
                'editor_script' => 'tc_event_location_block_editor',
                'editor_style' => 'tc_event_location_block_editor',
                'render_callback' => array( $this, 'render_event_location_shortcode' ),
                'attributes' => array(
                    'event_id' => array( 'type' => 'string' ),
                    'className' => array( 'type' => 'string' ),
                    'textColor' => array( 'type' => 'string' ),
                    'backgroundColor' => array( 'type' => 'string' ),
                    'gradient' => array( 'type' => 'string' ),
                    'style' => array( 'type' => 'object' ),
                    'borderColor' => array( 'type' => 'string' ),
                    'fontSize' => array( 'type' => 'string' ),
                    'fontFamily' => array( 'type' => 'string' )
                )
            ) );

            register_block_type( 'tickera/event-terms', array(
                'editor_script' => 'tc_event_terms_block_editor',
                'editor_style' => 'tc_event_terms_block_editor',
                'render_callback' => array( $this, 'render_event_terms_shortcode' ),
                'attributes' => array(
                    'event_id' => array( 'type' => 'string' ),
                    'className' => array( 'type' => 'string' ),
                    'textColor' => array( 'type' => 'string' ),
                    'backgroundColor' => array( 'type' => 'string' ),
                    'gradient' => array( 'type' => 'string' ),
                    'style' => array( 'type' => 'object' ),
                    'borderColor' => array( 'type' => 'string' ),
                    'fontSize' => array( 'type' => 'string' ),
                    'fontFamily' => array( 'type' => 'string' )
                )
            ) );

            register_block_type( 'tickera/event-logo', array(
                'editor_script' => 'tc_event_logo_block_editor',
                'editor_style' => 'tc_event_logo_block_editor',
                'render_callback' => array( $this, 'render_event_logo_shortcode' ),
                'attributes' => array(
                    'event_id' => array( 'type' => 'string' ),
                    'className' => array( 'type' => 'string' )
                )
            ) );

            register_block_type( 'tickera/event-sponsors-logo', array(
                'editor_script' => 'tc_event_sponsors_logo_block_editor',
                'editor_style' => 'tc_event_sponsors_logo_block_editor',
                'render_callback' => array( $this, 'render_event_sponsors_logo_shortcode' ),
                'attributes' => array(
                    'event_id' => array( 'type' => 'string' ),
                    'className' => array( 'type' => 'string' )
                )
            ) );

            if ( class_exists( 'TC_Seat_Chart' ) ) {
                register_block_type( 'tickera/seating-charts', array(
                    'editor_script' => 'tc_seating_charts_block_editor',
                    'editor_style' => 'tc_seating_charts_block_editor',
                    'render_callback' => array( $this, 'render_seating_charts_shortcode' ),
                    'attributes' => array(
                        'id' => array( 'type' => 'string' ),
                        'show_legend' => array( 'type' => 'string' ),
                        'button_title' => array( 'type' => 'string' ),
                        'subtotal_title' => array( 'type' => 'string' ),
                        'cart_title' => array( 'type' => 'string' ),
                        'className' => array( 'type' => 'string' ),
                        'textColor' => array( 'type' => 'string' ),
                        'backgroundColor' => array( 'type' => 'string' ),
                        'gradient' => array( 'type' => 'string' ),
                        'style' => array( 'type' => 'object' ),
                        'borderColor' => array( 'type' => 'string' ),
                        'fontSize' => array( 'type' => 'string' ),
                        'fontFamily' => array( 'type' => 'string' )
                    )
                ) );
            }
        }

        /**
         * Register extra scripts needed.
         */
        function register_extra_scripts() {

            global $post, $wp_version;

            $wp_tickets_search = new TC_Tickets_Search( '', '', -1 );
            $ticket_types = array();
            $ticket_types[] = array( 0, '' );

            foreach ( $wp_tickets_search->get_results() as $ticket_type ) {
                $ticket = new TC_Ticket( $ticket_type->ID );
                $ticket_types[] = array( $ticket_type->ID, $ticket->details->post_title );
            }

            $wp_events_search = new TC_Events_Search( '', '', -1 );
            $events = array();
            $events[] = array( 0, '' );

            foreach ( $wp_events_search->get_results() as $event_item ) {
                $event = new TC_Ticket( $event_item->ID );
                $events[] = array( $event_item->ID, $event->details->post_title );
            }

            $event = new TC_Event( (int) $post->ID );
            $event_ticket_types = $event->get_event_ticket_types();

            /**
             * Show notices in event gutenberg.
             * @since 3.5.1.2
             */
            if ( $post && isset( $post->post_type ) && 'tc_events' == $post->post_type ) {

                $creation_messages = TC_Better_Events::get_creation_messages();

                unset( $creation_messages[2] );
                unset( $creation_messages[3] );
                unset( $creation_messages[4] );
                unset( $creation_messages[7] );
                $creation_messages = array_values( $creation_messages );

                $ticket_type_admin_url = apply_filters( 'tc_ticket_type_admin_url', admin_url( 'edit.php?post_type=tc_tickets' ) );
                $random_creation_message = $creation_messages[ rand( 0, count( $creation_messages ) - 1 ) ];

                wp_enqueue_script( 'tc_gutenberg_notices', plugins_url( 'blocks-assets/notices.js', __FILE__ ), array( 'wp-data', 'utils', 'wp-edit-post' ) );
                wp_localize_script( 'tc_gutenberg_notices', 'tc_gutenberg', [
                    'no_ticket_types' => ( count( $event_ticket_types ) == 0 ) ? true : false,
                    'no_ticket_types_message' => strip_tags( $random_creation_message ),
                    'no_ticket_types_action_message' => __( 'Click here to create ticket types.', 'tc' ),
                    'no_ticket_types_action_url' => esc_url( $ticket_type_admin_url ),
                ] );
            }

            /**
             * wp_editor currently not working properly in post's meta box if gutenberg is enabled.
             * Issue: wp_editor TinyMce dependencies sometimes loaded late.
             *
             * Wordpress bug.
             * @version 6.2
             *
             * @since 3.5.1.2
             */
            $wp_scripts = wp_scripts();
            $wp_scripts->remove( 'wp-tinymce' );
            wp_register_tinymce_scripts( $wp_scripts, true );

            if ( apply_filters( 'tc_bridge_for_woocommerce_is_active', false ) == false ) {

                // Ticket add to cart block
                wp_register_script( 'tc_add_to_cart_block_editor', plugins_url( 'blocks-assets/add_to_cart/tc_add_to_cart_block_editor.js', __FILE__ ), array( 'wp-editor', 'wp-blocks', 'wp-i18n', 'wp-element', 'jquery' ), $this->version );
                wp_localize_script( 'tc_add_to_cart_block_editor', 'tc_add_to_cart_block_editor', array( 'tc_dev' => defined( 'TC_DEV' ) ? true : false, 'ticket_types' => json_encode( $ticket_types ), 'since_611' => version_compare( $wp_version, '6.1.1', '>=' ) ? true : false ) );
                wp_enqueue_script( 'tc_add_to_cart_block_editor' );
                wp_enqueue_style( 'tc_add_to_cart_block_editor', plugins_url( 'blocks-assets/add_to_cart/tc_add_to_cart_block_editor.css', __FILE__ ), array( 'wp-edit-blocks' ), $this->version );

                // Event tickets cart block
                wp_register_script( 'tc_event_add_to_cart_block_editor', plugins_url( 'blocks-assets/event_add_to_cart/tc_event_add_to_cart_block_editor.js', __FILE__ ), array( 'wp-editor', 'wp-blocks', 'wp-i18n', 'wp-element', 'jquery' ), $this->version );
                wp_localize_script( 'tc_event_add_to_cart_block_editor', 'tc_event_add_to_cart_block_editor', array( 'tc_dev' => defined( 'TC_DEV' ) ? true : false, 'events' => json_encode( $events ), 'since_611' => version_compare( $wp_version, '6.1.1', '>=' ) ? true : false ) );
                wp_enqueue_script( 'tc_event_add_to_cart_block_editor' );
                wp_enqueue_style( 'tc_event_add_to_cart_block_editor', plugins_url( 'blocks-assets/event_add_to_cart/tc_event_add_to_cart_block_editor.css', __FILE__ ), array( 'wp-edit-blocks' ), $this->version );

                // Event Tickets Sold block
                wp_register_script( 'tc_event_tickets_sold_block_editor', plugins_url( 'blocks-assets/event_tickets_sold/tc_event_tickets_sold_block_editor.js', __FILE__ ), array( 'wp-editor', 'wp-blocks', 'wp-i18n', 'wp-element', 'jquery' ), $this->version );
                wp_localize_script( 'tc_event_tickets_sold_block_editor', 'tc_event_tickets_sold_block_editor', array( 'tc_dev' => defined( 'TC_DEV' ) ? true : false, 'events' => json_encode( $events ), 'since_611' => version_compare( $wp_version, '6.1.1', '>=' ) ? true : false ) );
                wp_enqueue_script( 'tc_event_tickets_sold_block_editor' );
                wp_enqueue_style( 'tc_event_event_tickets_sold_block_editor', plugins_url( 'blocks-assets/event_tickets_sold/tc_event_tickets_sold_block_editor.css', __FILE__ ), array( 'wp-edit-blocks' ), $this->version );

                // Event Tickets Left block
                wp_register_script( 'tc_event_tickets_left_block_editor', plugins_url( 'blocks-assets/event_tickets_left/tc_event_tickets_left_block_editor.js', __FILE__ ), array( 'wp-editor', 'wp-blocks', 'wp-i18n', 'wp-element', 'jquery' ), $this->version );
                wp_localize_script( 'tc_event_tickets_left_block_editor', 'tc_event_tickets_left_block_editor', array( 'tc_dev' => defined( 'TC_DEV' ) ? true : false, 'events' => json_encode( $events ), 'since_611' => version_compare( $wp_version, '6.1.1', '>=' ) ? true : false ) );
                wp_enqueue_script( 'tc_event_tickets_left_block_editor' );
                wp_enqueue_style( 'tc_event_event_tickets_left_block_editor', plugins_url( 'blocks-assets/event_tickets_left/tc_event_tickets_left_block_editor.css', __FILE__ ), array( 'wp-edit-blocks' ), $this->version );

                // Tickets Sold block
                wp_register_script( 'tc_tickets_sold_block_editor', plugins_url( 'blocks-assets/tickets_sold/tc_tickets_sold_block_editor.js', __FILE__ ), array( 'wp-editor', 'wp-blocks', 'wp-i18n', 'wp-element', 'jquery' ), $this->version );
                wp_localize_script( 'tc_tickets_sold_block_editor', 'tc_tickets_sold_block_editor', array( 'tc_dev' => defined( 'TC_DEV' ) ? true : false, 'ticket_types' => json_encode( $ticket_types ), 'since_611' => version_compare( $wp_version, '6.1.1', '>=' ) ? true : false ) );
                wp_enqueue_script( 'tc_tickets_sold_block_editor' );
                wp_enqueue_style( 'tc_tickets_sold_block_editor', plugins_url( 'blocks-assets/tickets_sold/tc_tickets_sold_block_editor.css', __FILE__ ), array( 'wp-edit-blocks' ), $this->version );

                // Tickets Left block
                wp_register_script( 'tc_tickets_left_block_editor', plugins_url( 'blocks-assets/tickets_left/tc_tickets_left_block_editor.js', __FILE__ ), array( 'wp-editor', 'wp-blocks', 'wp-i18n', 'wp-element', 'jquery' ), $this->version );
                wp_localize_script( 'tc_tickets_left_block_editor', 'tc_tickets_left_block_editor', array( 'tc_dev' => defined( 'TC_DEV' ) ? true : false, 'ticket_types' => json_encode( $ticket_types ), 'since_611' => version_compare( $wp_version, '6.1.1', '>=' ) ? true : false ) );
                wp_enqueue_script( 'tc_tickets_left_block_editor' );
                wp_enqueue_style( 'tc_tickets_left_block_editor', plugins_url( 'blocks-assets/tickets_left/tc_tickets_left_block_editor.css', __FILE__ ), array( 'wp-edit-blocks' ), $this->version );

                // Order History block
                wp_register_script( 'tc_order_history_block_editor', plugins_url( 'blocks-assets/order_history/tc_order_history_block_editor.js', __FILE__ ), array( 'wp-editor', 'wp-blocks', 'wp-i18n', 'wp-element', 'jquery' ), $this->version );
                wp_localize_script( 'tc_tickets_sold_block_editor', 'tc_order_history_block_editor', array( 'tc_dev' => defined( 'TC_DEV' ) ? true : false, 'since_611' => version_compare( $wp_version, '6.1.1', '>=' ) ? true : false ) );
                wp_enqueue_script( 'tc_order_history_block_editor' );
                wp_enqueue_style( 'tc_order_history_block_editor', plugins_url( 'blocks-assets/order_history/tc_order_history_block_editor.css', __FILE__ ), array( 'wp-edit-blocks' ), $this->version );

            } else {

                // Show bridge blocks
                $args = array(
                    'post_type' => 'product',
                    'post_status' => 'publish',
                    'posts_per_page' => -1,
                    'meta_query' => array(
                        'relation' => 'OR',
                        array(
                            'key' => '_tc_is_ticket',
                            'compare' => '=',
                            'value' => 'yes'
                        ),
                    ),
                    'fields' => 'ids'
                );

                $product_ids = array();
                $product_ids[] = array( 0, '' );
                $products = get_posts( $args );

                foreach ( $products as $ticket_type_key => $ticket_type_id ) {
                    $post_title = get_the_title( $ticket_type_id );
                    $product_ids[] = array( $ticket_type_id, $post_title );
                }

                wp_register_script( 'tc_woo_add_to_cart_block_editor', plugins_url( 'blocks-assets/woo_add_to_cart/tc_woo_add_to_cart_block_editor.js', __FILE__ ), array( 'wp-editor', 'wp-blocks', 'wp-i18n', 'wp-element', 'jquery' ), $this->version );
                wp_localize_script( 'tc_woo_add_to_cart_block_editor', 'tc_woo_add_to_cart_block_editor', array( 'tc_dev' => defined( 'TC_DEV' ) ? true : false, 'ticket_types' => json_encode( $product_ids ), 'since_611' => version_compare( $wp_version, '6.1.1', '>=' ) ? true : false ) );
                wp_enqueue_script( 'tc_woo_add_to_cart_block_editor' );
                wp_enqueue_style( 'tc_woo_add_to_cart_block_editor', plugins_url( 'blocks-assets/woo_add_to_cart/tc_woo_add_to_cart_block_editor.css', __FILE__ ), array( 'wp-edit-blocks' ), $this->version );

                // Event tickets cart block
                wp_register_script( 'tc_woo_event_add_to_cart_block_editor', plugins_url( 'blocks-assets/woo_event_add_to_cart/tc_woo_event_add_to_cart_block_editor.js', __FILE__ ), array( 'wp-editor', 'wp-blocks', 'wp-i18n', 'wp-element', 'jquery' ), $this->version );
                wp_localize_script( 'tc_woo_event_add_to_cart_block_editor', 'tc_woo_event_add_to_cart_block_editor', array( 'tc_dev' => defined( 'TC_DEV' ) ? true : false, 'events' => json_encode( $events ), 'since_611' => version_compare( $wp_version, '6.1.1', '>=' ) ? true : false ) );
                wp_enqueue_script( 'tc_woo_event_add_to_cart_block_editor' );
                wp_enqueue_style( 'tc_woo_event_add_to_cart_block_editor', plugins_url( 'blocks-assets/woo_event_add_to_cart/tc_woo_event_add_to_cart_block_editor.css', __FILE__ ), array( 'wp-edit-blocks' ), $this->version );
            }

            // Event Date block
            wp_register_script( 'tc_event_date_block_editor', plugins_url( 'blocks-assets/event_date/tc_event_date_block_editor.js', __FILE__ ), array( 'wp-editor', 'wp-blocks', 'wp-i18n', 'wp-element', 'jquery' ), $this->version );
            wp_localize_script( 'tc_event_date_block_editor', 'tc_event_date_block_editor', array( 'tc_dev' => defined( 'TC_DEV' ) ? true : false, 'events' => json_encode( $events ), 'since_611' => version_compare( $wp_version, '6.1.1', '>=' ) ? true : false ) );
            wp_enqueue_script( 'tc_event_date_block_editor' );
            wp_enqueue_style( 'tc_event_event_date_block_editor', plugins_url( 'blocks-assets/event_date/tc_event_date_block_editor.css', __FILE__ ), array( 'wp-edit-blocks' ), $this->version );

            // Event Location block
            wp_register_script( 'tc_event_location_block_editor', plugins_url( 'blocks-assets/event_location/tc_event_location_block_editor.js', __FILE__ ), array( 'wp-editor', 'wp-blocks', 'wp-i18n', 'wp-element', 'jquery' ), $this->version );
            wp_localize_script( 'tc_event_location_block_editor', 'tc_event_location_block_editor', array( 'tc_dev' => defined( 'TC_DEV' ) ? true : false, 'events' => json_encode( $events ), 'since_611' => version_compare( $wp_version, '6.1.1', '>=' ) ? true : false ) );
            wp_enqueue_script( 'tc_event_location_block_editor' );
            wp_enqueue_style( 'tc_event_event_location_block_editor', plugins_url( 'blocks-assets/event_location/tc_event_location_block_editor.css', __FILE__ ), array( 'wp-edit-blocks' ), $this->version );

            // Event Terms & Conditions block
            wp_register_script( 'tc_event_terms_block_editor', plugins_url( 'blocks-assets/event_terms/tc_event_terms_block_editor.js', __FILE__ ), array( 'wp-editor', 'wp-blocks', 'wp-i18n', 'wp-element', 'jquery' ), $this->version );
            wp_localize_script( 'tc_event_terms_block_editor', 'tc_event_terms_block_editor', array( 'tc_dev' => defined( 'TC_DEV' ) ? true : false, 'events' => json_encode( $events ), 'since_611' => version_compare( $wp_version, '6.1.1', '>=' ) ? true : false ) );
            wp_enqueue_script( 'tc_event_terms_block_editor' );
            wp_enqueue_style( 'tc_event_event_terms_block_editor', plugins_url( 'blocks-assets/event_terms/tc_event_terms_block_editor.css', __FILE__ ), array( 'wp-edit-blocks' ), $this->version );

            // Event Logo block
            wp_register_script( 'tc_event_logo_block_editor', plugins_url( 'blocks-assets/event_logo/tc_event_logo_block_editor.js', __FILE__ ), array( 'wp-editor', 'wp-blocks', 'wp-i18n', 'wp-element', 'jquery' ), $this->version );
            wp_localize_script( 'tc_event_logo_block_editor', 'tc_event_logo_block_editor', array( 'tc_dev' => defined( 'TC_DEV' ) ? true : false, 'events' => json_encode( $events ), 'since_611' => version_compare( $wp_version, '6.1.1', '>=' ) ? true : false ) );
            wp_enqueue_script( 'tc_event_logo_block_editor' );
            wp_enqueue_style( 'tc_event_event_logo_block_editor', plugins_url( 'blocks-assets/event_logo/tc_event_logo_block_editor.css', __FILE__ ), array( 'wp-edit-blocks' ), $this->version );

            // Event Sponsors Logo block
            wp_register_script( 'tc_event_sponsors_logo_block_editor', plugins_url( 'blocks-assets/event_sponsors_logo/tc_event_sponsors_logo_block_editor.js', __FILE__ ), array( 'wp-editor', 'wp-blocks', 'wp-i18n', 'wp-element', 'jquery' ), $this->version );
            wp_localize_script( 'tc_event_sponsors_logo_block_editor', 'tc_event_sponsors_logo_block_editor', array( 'tc_dev' => defined( 'TC_DEV' ) ? true : false, 'events' => json_encode( $events ), 'since_611' => version_compare( $wp_version, '6.1.1', '>=' ) ? true : false ) );
            wp_enqueue_script( 'tc_event_sponsors_logo_block_editor' );
            wp_enqueue_style( 'tc_event_event_sponsors_logo_block_editor', plugins_url( 'blocks-assets/event_sponsors_logo/tc_event_sponsors_logo_block_editor.css', __FILE__ ), array( 'wp-edit-blocks' ), $this->version );

            if ( class_exists( 'TC_Seat_Chart' ) ) {

                // Seating chart block
                $seating_charts_ids = array();
                $seating_charts_ids[] = array( 0, '' );

                $args = array(
                    'post_type' => 'tc_seat_charts',
                    'post_status' => 'publish',
                    'posts_per_page' => -1,
                    'no_found_rows' => true
                );

                $seat_charts = get_posts( $args );

                foreach ( $seat_charts as $seat_chart ) {
                    $seating_charts_ids[] = array( $seat_chart->ID, $seat_chart->post_title );
                }

                wp_register_script( 'tc_seating_charts_block_editor', plugins_url( 'blocks-assets/seating_charts/tc_seating_charts_block_editor.js', __FILE__ ), array( 'wp-editor', 'wp-blocks', 'wp-i18n', 'wp-element', 'jquery' ), $this->version );
                wp_localize_script( 'tc_seating_charts_block_editor', 'tc_seating_charts_block_editor', array( 'tc_dev' => defined( 'TC_DEV' ) ? true : false, 'seating_charts' => json_encode( $seating_charts_ids ), 'since_611' => version_compare( $wp_version, '6.1.1', '>=' ) ? true : false ) );
                wp_enqueue_script( 'tc_seating_charts_block_editor' );
                wp_enqueue_style( 'tc_seating_charts_block_editor', plugins_url( 'blocks-assets/seating_charts/tc_seating_charts_block_editor.css', __FILE__ ), array( 'wp-edit-blocks' ), $this->version );
            }
        }

        function render_add_to_cart_shortcode( $attributes ) {

            ob_start();
            $styles_values = self::get_style_values( $attributes );
            $classes = isset( $styles_values[ 'classes' ] ) ? ' ' . sanitize_text_field( $styles_values[ 'classes' ] ) : '';
            $styles = isset( $styles_values[ 'styles' ] ) ? ' style="' . sanitize_text_field( $styles_values[ 'styles' ] ) . '"' : '';
            $additional_classes = isset( $attributes[ 'className' ] ) ? ' ' . sanitize_text_field( $attributes[ 'className' ] ) : '';
            ?>
            <div class="tc-add-to-car-wrap<?php echo $additional_classes . $classes; ?>"<?php echo $styles; ?>>
                <?php
                $show_price = ( isset( $attributes[ 'show_price' ] ) && ( true == $attributes[ 'show_price' ] || 1 == $attributes[ 'show_price' ] ) ) ? 'show_price="true"' : '';
                $quantity = ( isset( $attributes[ 'quantity' ] ) && ( true == $attributes[ 'quantity' ] || 1 == $attributes[ 'quantity' ] ) ) ? 'quantity="true"' : '';
                $price_position = ( isset( $attributes[ 'price_position' ] ) ) ? 'price_position="' . $attributes[ 'price_position' ] . '"' : '';
                $soldout_message = ( isset( $attributes[ 'soldout_message' ] ) && $attributes[ 'soldout_message' ] ) ? 'soldout_message="' . $attributes[ 'soldout_message' ] .'"' : '';
                $link_type = ( isset( $attributes[ 'link_type' ] ) ) ? 'type="' . $attributes[ 'link_type' ] . '"' : '';

                if ( isset( $attributes[ 'ticket_type_id' ] ) && $attributes[ 'ticket_type_id' ] ) {
                    echo tc_esc_html( do_shortcode( '[tc_ticket id="' . (int) $attributes[ 'ticket_type_id' ] . '" ' . $show_price . ' ' . $soldout_message . ' ' . $price_position . ' ' . $quantity . ' ' . $link_type . ']' ) );

                } else {
                    echo __( 'Please select a ticket type in the block settings box', 'tc' );
                }
                ?>
            </div>
            <?php return ob_get_clean();
        }

        function render_event_add_to_cart_shortcode( $attributes ) {

            ob_start();
            $styles_values = self::get_style_values( $attributes );
            $classes = isset( $styles_values[ 'classes' ] ) ? ' ' . sanitize_text_field( $styles_values[ 'classes' ] ) : '';
            $styles = isset( $styles_values[ 'styles' ] ) ? ' style="' . sanitize_text_field( $styles_values[ 'styles' ] ) . '"' : '';
            $additional_classes = isset( $attributes[ 'className' ] ) ? ' ' . sanitize_text_field( $attributes[ 'className' ] ) : '';
            $show_event_title = ( isset( $attributes[ 'show_event_title' ] ) && ( $attributes[ 'show_event_title' ] == true || $attributes[ 'show_event_title' ] == 1 ) ) ? 'show_event_title="true"' : '';
            $show_price = ( isset( $attributes[ 'show_price' ] ) && ( $attributes[ 'show_price' ] == true || $attributes[ 'show_price' ] == 1 ) ) ? 'show_price="true"' : '';
            $quantity = ( isset( $attributes[ 'quantity' ] ) && ( $attributes[ 'quantity' ] == true || $attributes[ 'quantity' ] == 1 ) ) ? 'quantity="true"' : '';
            ?>
            <div class="tc-event-add-to-cart-wrap<?php echo $additional_classes . $classes; ?>"<?php echo $styles; ?>>
            <?php
            if ( isset( $attributes[ 'event_id' ] ) && $attributes[ 'event_id' ] ) {

                $display_type = ( ! empty( $attributes[ 'display_type' ] ) ) ? 'display_type="' . sanitize_text_field( $attributes[ 'display_type' ] ) . '"' : '';
                $button_title = ( ! empty( $attributes[ 'button_title' ] ) ) ? 'title="' . sanitize_text_field( $attributes[ 'button_title' ] ) . '"' : '';
                $ticket_type_title = ( ! empty( $attributes[ 'ticket_type_title' ] ) ) ? 'ticket_type_title="' . sanitize_text_field( $attributes[ 'ticket_type_title' ] ) . '"' : '';
                $price_title = ( ! empty( $attributes[ 'price_title' ] ) ) ? 'price_title="' . sanitize_text_field( $attributes[ 'price_title' ] ) . '"' : '';
                $cart_title = ( ! empty( $attributes[ 'cart_title' ] ) ) ? 'cart_title="' . sanitize_text_field( $attributes[ 'cart_title' ] ) . '"' : '';
                $quantity_title = ( ! empty( $attributes[ 'quantity_title' ] ) ) ? 'quantity_title="' . sanitize_text_field( $attributes[ 'quantity_title' ] ) . '"' : '';
                $soldout_message = ( ! empty( $attributes[ 'soldout_message' ] ) ) ? 'soldout_message="' . sanitize_text_field( $attributes[ 'soldout_message' ] ) . '"' : '';
                $type = ( ! empty( $attributes[ 'link_type' ] ) ) ? 'type="' . sanitize_text_field( $attributes[ 'link_type' ] ) . '"' : '';

                $content = trim( tc_esc_html( do_shortcode( '[tc_event id="' . (int) $attributes[ 'event_id' ] . '" ' . $display_type . ' ' . $show_event_title . ' ' . $show_price . ' ' . $button_title . ' ' . $ticket_type_title . ' ' . $price_title . ' ' . $cart_title . ' ' . $quantity_title . ' ' . $soldout_message . '  ' . $type . ' ' . $quantity . ']' ) ) );

                if ( $content ) {
                    echo $content;

                } else {
                    echo __( 'No associated ticket types found. Try selecting another event.', 'tc' );
                }

            } else {
                echo __( 'Please select an event in the block settings box', 'tc' );
            }
            ?>
            </div>
            <?php return ob_get_clean();
        }

        function render_event_date_shortcode( $attributes ) {

            ob_start();
            $styles_values = self::get_style_values( $attributes );
            $classes = isset( $styles_values[ 'classes' ] ) ? ' ' . sanitize_text_field( $styles_values[ 'classes' ] ) : '';
            $styles = isset( $styles_values[ 'styles' ] ) ? ' style="' . sanitize_text_field( $styles_values[ 'styles' ] ) . '"' : '';
            $additional_classes = isset( $attributes[ 'className' ] ) ? sanitize_text_field( $attributes[ 'className' ] ) : '';
            ?>
            <div class="tc-event-date-wrap<?php echo $additional_classes . $classes; ?>"<?php echo $styles; ?>>
                <div class="tc-block-inner-wrapper">
                <?php

                if ( isset( $attributes[ 'event_id' ] ) && $attributes[ 'event_id' ] ) {

                    $content = trim( tc_esc_html( do_shortcode( '[tc_event_date event_id="' . (int) $attributes[ 'event_id' ] . '"]' ) ) );

                    if ( $content ) {
                        echo $content;

                    } else {
                        echo __( 'Event date is not set.', 'tc' );
                    }

                } else {
                    echo __( 'Please select an event in the block settings box', 'tc' );
                }
                ?>
                </div>
            </div>
            <?php return ob_get_clean();
        }

        function render_event_location_shortcode( $attributes ) {

            ob_start();
            $styles_values = self::get_style_values( $attributes );
            $classes = isset( $styles_values[ 'classes' ] ) ? ' ' . sanitize_text_field( $styles_values[ 'classes' ] ) : '';
            $styles = isset( $styles_values[ 'styles' ] ) ? ' style="' . sanitize_text_field( $styles_values[ 'styles' ] ) . '"' : '';
            $additional_classes = isset( $attributes[ 'className' ] ) ? sanitize_text_field( $attributes[ 'className' ] ) : '';
            ?>
            <div class="tc-event-location-wrap<?php echo $additional_classes . $classes; ?>"<?php echo $styles; ?>>
                <div class="tc-block-inner-wrapper">
                <?php

                if ( isset( $attributes[ 'event_id' ] ) && $attributes[ 'event_id' ] ) {

                    $content = trim( tc_esc_html( do_shortcode( '[tc_event_location id="' . (int) $attributes[ 'event_id' ] . '"]' ) ) );

                    if ( $content ) {
                        echo $content;

                    } else {
                        echo __( 'Event location is not set.', 'tc' );
                    }

                } else {
                    echo __( 'Please select an event in the block settings box', 'tc' );
                }
                ?>
                </div>
            </div>
            <?php return ob_get_clean();
        }

        function render_event_terms_shortcode( $attributes ) {

            ob_start();
            $styles_values = self::get_style_values( $attributes );
            $classes = isset( $styles_values[ 'classes' ] ) ? ' ' . sanitize_text_field( $styles_values[ 'classes' ] ) : '';
            $styles = isset( $styles_values[ 'styles' ] ) ? ' style="' . sanitize_text_field( $styles_values[ 'styles' ] ) . '"' : '';
            $additional_classes = isset( $attributes[ 'className' ] ) ? sanitize_text_field( $attributes[ 'className' ] ) : '';
            ?>
            <div class="tc-event-terms-wrap<?php echo $additional_classes . $classes; ?>"<?php echo $styles; ?>>
                <div class="tc-block-inner-wrapper">
                <?php
                if ( isset( $attributes[ 'event_id' ] ) && $attributes[ 'event_id' ] ) {

                    $content = trim( tc_esc_html( do_shortcode( '[tc_event_terms id="' . (int) $attributes[ 'event_id' ] . '"]' ) ) );

                    if ( $content ) {
                        echo $content;

                    } else {
                        echo __( 'Event Terms & Conditions are not set.', 'tc' );
                    }

                } else {
                    echo __( 'Please select an event in the block settings box', 'tc' );
                }
                ?>
                </div>
            </div>
            <?php return ob_get_clean();
        }

        function render_event_logo_shortcode( $attributes ) {

            ob_start();
            $styles_values = self::get_style_values( $attributes );
            $classes = isset( $styles_values[ 'classes' ] ) ? ' ' . sanitize_text_field( $styles_values[ 'classes' ] ) : '';
            $styles = isset( $styles_values[ 'styles' ] ) ? ' style="' . sanitize_text_field( $styles_values[ 'styles' ] ) . '"' : '';
            $additional_classes = isset( $attributes[ 'className' ] ) ? sanitize_text_field( $attributes[ 'className' ] ) : '';
            ?>
            <div class="tc-event-logo-wrap<?php echo $additional_classes . $classes; ?>"<?php echo $styles; ?>>
            <?php

            if ( isset( $attributes[ 'event_id' ] ) && $attributes[ 'event_id' ] ) {

                $content = trim( tc_esc_html( do_shortcode( '[tc_event_logo id="' . (int) $attributes[ 'event_id' ] . '"]' ) ) );

                if ( $content ) {
                    echo $content;

                } else {
                    echo __( 'Logo is not set for this event.', 'tc' );
                }

            } else {
                echo __( 'Please select an event in the block settings box', 'tc' );
            }
            ?>
            </div>
            <?php return ob_get_clean();
        }

        function render_event_sponsors_logo_shortcode( $attributes ) {

            ob_start();
            $styles_values = self::get_style_values( $attributes );
            $classes = isset( $styles_values[ 'classes' ] ) ? ' ' . sanitize_text_field( $styles_values[ 'classes' ] ) : '';
            $styles = isset( $styles_values[ 'styles' ] ) ? ' style="' . sanitize_text_field( $styles_values[ 'styles' ] ) . '"' : '';
            $additional_classes = isset( $attributes[ 'className' ] ) ? sanitize_text_field( $attributes[ 'className' ] ) : '';
            ?>
            <div class="tc-event-sponsors-logo-wrap<?php echo $additional_classes . $classes; ?>"<?php echo $styles; ?>>
            <?php

            if ( isset( $attributes[ 'event_id' ] ) && $attributes[ 'event_id' ] ) {

                $content = trim( tc_esc_html( do_shortcode( '[tc_event_sponsors_logo id="' . (int) $attributes[ 'event_id' ] . '"]' ) ) );

                if ( $content ) {
                    echo $content;

                } else {
                    echo __( 'Sponsors logo / image is not set for this event.', 'tc' );
                }

            } else {
                echo __( 'Please select an event in the block settings box', 'tc' );
            }
            ?>
            </div>
            <?php return ob_get_clean();
        }

        function render_event_tickets_sold_shortcode( $attributes ) {

            ob_start();
            $styles_values = self::get_style_values( $attributes );
            $classes = isset( $styles_values[ 'classes' ] ) ? ' ' . sanitize_text_field( $styles_values[ 'classes' ] ) : '';
            $styles = isset( $styles_values[ 'styles' ] ) ? ' style="' . sanitize_text_field( $styles_values[ 'styles' ] ) . '"' : '';
            $additional_classes = isset( $attributes[ 'className' ] ) ? ' ' . sanitize_text_field( $attributes[ 'className' ] ) : '';
            ?>
            <div class="tc-event-tickets-sold-wrap<?php echo $additional_classes . $classes; ?>"<?php echo $styles; ?>>
                <div class="tc-block-inner-wrapper">
                <?php

                if ( isset( $attributes[ 'event_id' ] ) && $attributes[ 'event_id' ] ) {

                    $content = trim( tc_esc_html( do_shortcode( '[event_tickets_sold event_id="' . (int) $attributes[ 'event_id' ] . '"]' ) ) );

                    if ( $content ) {
                        echo $content;

                    } else {
                        echo 0;
                    }

                } else {
                    echo __( 'Please select an event in the block settings box', 'tc' );
                }
                ?>
                </div>
            </div>
            <?php return ob_get_clean();
        }

        function render_event_tickets_left_shortcode( $attributes ) {

            ob_start();
            $styles_values = self::get_style_values( $attributes );
            $classes = isset( $styles_values[ 'classes' ] ) ? ' ' . sanitize_text_field( $styles_values[ 'classes' ] ) : '';
            $styles = isset( $styles_values[ 'styles' ] ) ? ' style="' . sanitize_text_field( $styles_values[ 'styles' ] ) . '"' : '';
            $additional_classes = isset( $attributes[ 'className' ] ) ? ' ' . sanitize_text_field( $attributes[ 'className' ] ) : '';
            ?>
            <div class="tc-event-tickets-left-wrap<?php echo $additional_classes . $classes; ?>"<?php echo $styles; ?>>
                <div class="tc-block-inner-wrapper">
                <?php

                if ( isset( $attributes[ 'event_id' ] ) && $attributes[ 'event_id' ] ) {

                    $content = trim( tc_esc_html( do_shortcode( '[event_tickets_left event_id="' . (int) $attributes[ 'event_id' ] . '"]' ) ) );

                    if ( $content ) {
                        echo $content;

                    } else {
                        echo 0;
                    }

                } else {
                    echo __( 'Please select an event in the block settings box', 'tc' );
                }
                ?>
                </div>
            </div>
            <?php return ob_get_clean();
        }

        function render_tickets_sold_shortcode( $attributes ) {

            ob_start();
            $styles_values = self::get_style_values( $attributes );
            $classes = isset( $styles_values[ 'classes' ] ) ? ' ' . sanitize_text_field( $styles_values[ 'classes' ] ) : '';
            $styles = isset( $styles_values[ 'styles' ] ) ? ' style="' . sanitize_text_field( $styles_values[ 'styles' ] ) . '"' : '';
            $additional_classes = isset( $attributes[ 'className' ] ) ? sanitize_text_field( $attributes[ 'className' ] ) : '';
            ?>
            <div class="tc-tickets-sold-wrap<?php echo $additional_classes . $classes; ?>"<?php echo $styles; ?>>
                <div class="tc-block-inner-wrapper">
                <?php
                if ( isset( $attributes[ 'ticket_type_id' ] ) && $attributes[ 'ticket_type_id' ] ) {

                    $content = trim( tc_esc_html( do_shortcode( '[tickets_sold ticket_type_id="' . (int) $attributes[ 'ticket_type_id' ] . '"]' ) ) );

                    if ( $content ) {
                        echo $content;

                    } else {
                        echo 0;
                    }

                } else {
                    echo __( 'Please select a ticket type in the block settings box', 'tc' );
                }
                ?>
                </div>
            </div>
            <?php return ob_get_clean();
        }

        function render_tickets_left_shortcode( $attributes ) {

            ob_start();
            $styles_values = self::get_style_values( $attributes );
            $classes = isset( $styles_values[ 'classes' ] ) ? ' ' . sanitize_text_field( $styles_values[ 'classes' ] ) : '';
            $styles = isset( $styles_values[ 'styles' ] ) ? ' style="' . sanitize_text_field( $styles_values[ 'styles' ] ) . '"' : '';
            $additional_classes = isset( $attributes[ 'className' ] ) ? sanitize_text_field( $attributes[ 'className' ] ) : '';
            ?>
            <div class="tc-tickets-left-wrap<?php echo $additional_classes . $classes; ?>"<?php echo $styles; ?>>
                <div class="tc-block-inner-wrapper">
                <?php
                if ( isset( $attributes[ 'ticket_type_id' ] ) && $attributes[ 'ticket_type_id' ] ) {

                    $content = trim( tc_esc_html( do_shortcode( '[tickets_left ticket_type_id="' . (int) $attributes[ 'ticket_type_id' ] . '"]' ) ) );

                    if ( $content ) {
                        echo $content;

                    } else {
                        echo 0;
                    }

                } else {
                    echo __( 'Please select a ticket type in the block settings box', 'tc' );
                }
                ?>
                </div>
            </div>
            <?php return ob_get_clean();
        }

        function render_order_history_shortcode( $attributes ) {

            ob_start();
            $styles_values = self::get_style_values( $attributes );
            $classes = isset( $styles_values[ 'classes' ] ) ? ' ' . sanitize_text_field( $styles_values[ 'classes' ] ) : '';
            $styles = isset( $styles_values[ 'styles' ] ) ? ' style="' . sanitize_text_field( $styles_values[ 'styles' ] ) . '"' : '';
            $additional_classes = isset( $attributes[ 'className' ] ) ? sanitize_text_field( $attributes[ 'className' ] ) : '';
            ?>
            <div class="tc-order-history-wrap<?php echo $additional_classes . $classes; ?>"<?php echo $styles; ?>>
            <?php

            $content = trim( tc_esc_html( do_shortcode( '[tc_order_history]' ) ) );

            if ( $content ) {
                echo $content;

            } else {
                echo __( 'Oops! You personally don\'t have anything in the order history so we can\'t show a preview here. Sorry :/' );
            }
            ?>
            </div>
            <?php return ob_get_clean();
        }

        /**
         * Bridge for Woocommerce Shortcodes
         *
         * @param $attributes
         * @return false|string|void
         */
        function render_woo_add_to_cart_shortcode( $attributes ) {

            ob_start();
            $styles_values = self::get_style_values( $attributes );
            $classes = isset( $styles_values[ 'classes' ] ) ? ' ' . sanitize_text_field( $styles_values[ 'classes' ] ) : '';
            $styles = isset( $styles_values[ 'styles' ] ) ? ' style="' . sanitize_text_field( $styles_values[ 'styles' ] ) . '"' : '';
            $additional_classes = isset( $attributes[ 'className' ] ) ? ' ' . sanitize_text_field( $attributes[ 'className' ] ) : '';
            ?>
            <div class="tc-woo-add-to-cart-wrap<?php echo $classes . $additional_classes; ?>"<?php echo $styles; ?>>
            <?php

            $show_price = ( isset( $attributes[ 'show_price' ] ) && ( $attributes[ 'show_price' ] == true || $attributes[ 'show_price' ] == 1 ) ) ? 'show_price="true"' : 'show_price=" false"';

            if ( isset( $attributes[ 'id' ] ) && $attributes[ 'id' ] ) {
                echo tc_esc_html( do_shortcode( '[add_to_cart id="' . (int) $attributes[ 'id' ] . '" ' . $show_price . ' style="border:none;"]' ) );

            } else {
                echo __( 'Please select a ticket type (product) in the block settings box', 'tc' );
            }
            ?>
            </div>
            <?php return ob_get_clean();
        }

        function render_woo_event_add_to_cart_shortcode( $attributes ) {

            ob_start();
            $styles_values = self::get_style_values( $attributes );
            $classes = isset( $styles_values[ 'classes' ] ) ? ' ' . sanitize_text_field( $styles_values[ 'classes' ] ) : '';
            $styles = isset( $styles_values[ 'styles' ] ) ? ' style="' . sanitize_text_field( $styles_values[ 'styles' ] ) . '"' : '';
            $additional_classes = isset( $attributes[ 'className' ] ) ? ' ' . sanitize_text_field( $attributes[ 'className' ] ) : '';
            ?>
            <div class="tc-woo-event-add-to-cart-wrap<?php echo $classes. $additional_classes; ?>"<?php echo $styles; ?>>
            <?php
            if ( isset( $attributes[ 'id' ] ) && $attributes[ 'id' ] ) {

                $display_type = ( ! empty( $attributes[ 'display_type' ] ) ) ? 'display_type="' . sanitize_text_field( $attributes[ 'display_type' ] ) . '"' : '';
                $ticket_type_title = ( ! empty( $attributes[ 'ticket_type_title' ] ) ) ? 'ticket_type_title="' . sanitize_text_field( $attributes[ 'ticket_type_title' ] ) . '"' : '';
                $price_title = ( ! empty( $attributes[ 'price_title' ] ) ) ? 'price_title="' . sanitize_text_field( $attributes[ 'price_title' ] ) . '"' : '';
                $cart_title = ( ! empty( $attributes[ 'cart_title' ] ) ) ? 'cart_title="' . sanitize_text_field( $attributes[ 'cart_title' ] ) . '"' : '';
                $quantity_title = ( ! empty( $attributes[ 'quantity_title' ] ) ) ? 'quantity_title="' . sanitize_text_field( $attributes[ 'quantity_title' ] ) . '"' : '';

                $show_event_title = ( isset( $attributes[ 'show_event_title' ] ) && ( $attributes[ 'show_event_title' ] == true || $attributes[ 'show_event_title' ] == 1 ) ) ? 'show_event_title="true"' : '';
                $show_price = ( isset( $attributes[ 'show_price' ] ) && ( $attributes[ 'show_price' ] == true || $attributes[ 'show_price' ] == 1 ) ) ? 'show_price="true"' : '';
                $quantity = ( isset( $attributes[ 'quantity' ] ) && ( true == $attributes[ 'quantity' ] || 1 == $attributes[ 'quantity' ] ) ) ? 'quantity="true"' : '';

                $content = trim( tc_esc_html( do_shortcode( '[tc_wb_event  id="' . (int) $attributes[ 'id' ] . '" ' . $display_type . ' ' . $show_event_title . ' ' . $show_price . ' ' . $quantity . ' ' . $ticket_type_title . ' ' . $price_title . ' ' . $cart_title . ' ' . $quantity_title . ']' ) ) );

                if ( $content ) {
                    echo $content;

                } else {
                    echo __( 'No assiciated ticket types (products) found. Try selecting another event.', 'tc' );
                }

            } else {
                echo __( 'Please select an event in the block settings box', 'tc' );
            }
            ?>
            </div>
            <?php return ob_get_clean();
        }

        /**
         * Render Seating Chart Shortcode
         *
         * @param $attributes
         * @return false|string|void
         */
        function render_seating_charts_shortcode( $attributes ) {

            ob_start();
            $styles_values = self::get_style_values( $attributes );
            $classes = isset( $styles_values[ 'classes' ] ) ? ' ' . sanitize_text_field( $styles_values[ 'classes' ] ) : '';
            $styles = isset( $styles_values[ 'styles' ] ) ? ' style="' . sanitize_text_field( $styles_values[ 'styles' ] ) . '"' : '';
            $additional_classes = isset( $attributes[ 'className' ] ) ? sanitize_text_field( $attributes[ 'className' ] ) : '';
            ?>
            <div class="tc-seating-charts-wrap<?php echo $classes. $additional_classes; ?>"<?php echo $styles; ?>>
            <?php

            if ( isset( $attributes[ 'id' ] ) && $attributes[ 'id' ] ) {

                $show_legend = ( isset( $attributes[ 'show_legend' ] ) && ( true == $attributes[ 'show_legend' ] || 1 == $attributes[ 'show_legend' ] ) ) ? 'show_legend="true"' : '';
                $button_title = ( isset( $attributes[ 'button_title' ] ) ) ? 'button_title="' . sanitize_text_field( $attributes[ 'button_title' ] ) . '"' : '';
                $subtotal_title = ( isset( $attributes[ 'subtotal_title' ] ) ) ? 'subtotal_title="' . sanitize_text_field( $attributes[ 'subtotal_title' ] ) . '"' : '';
                $cart_title = ( isset( $attributes[ 'cart_title' ] ) ) ? 'cart_title="' . sanitize_text_field( $attributes[ 'cart_title' ] ) . '"' : '';

                $content = trim( tc_esc_html( do_shortcode( '[tc_seat_chart id="' . (int) $attributes[ 'id' ] . '" ' . $button_title . ' ' . $subtotal_title . ' ' . $cart_title . ' ' . $show_legend . ']' ) ) );

                if ( $content ) {
                    echo $content;

                } else {
                    echo __( 'No seating charts found. Sorry :(', 'tc' );
                }

            } else {
                echo __( 'Please select a seating chart block settings box', 'tc' );
            }
            ?>
            </div>
            <?php return ob_get_clean();
        }

        function render_event_calendar_shortcode( $attributes ) {

            ob_start();

            $additional_classes = isset( $attributes[ 'className' ] ) ? sanitize_text_field( $attributes[ 'className' ] ) : '';

            // Wrap the content inside a div container if additional classes exists
            echo ( $additional_classes ) ? '<div class="' . esc_attr( $additional_classes ) . '">' : '';

            $show_past_events = ( $attributes[ 'show_past_events' ] == true || $attributes[ 'show_past_events' ] == 1 ) ? 'show_past_events="true"' : '';
            $color_scheme = ( ! empty( $attributes[ 'color_scheme' ] ) )
                ? 'color_scheme="' . sanitize_text_field( $attributes[ 'color_scheme' ] ) . '"'
                : 'color_scheme="default"';

            $lang = ( isset( $attributes[ 'lang' ] ) && $attributes[ 'lang' ] )
                ? 'lang="' . sanitize_text_field( $attributes[ 'lang' ] ) . '"'
                : 'lang="en"';

            $content = trim( tc_esc_html( do_shortcode( '[tc_calendar color_scheme="' . $color_scheme . '" lang="' . $lang . '" ' . $show_past_events . ']' ) ) );

            if ( $content ) {
                echo $content;

            } else {
                echo __( 'Something went wrong and we don\'t have a clue why the content is not shown :( Please contact support for futher assistance.', 'tc' );
            }

            // Wrap the content inside a div container if additional classes exists
            echo ( $additional_classes ) ? '</div>' : '';

            return ob_get_clean();
        }

        /**
         * Collect all styles from the gutenberg attributes.
         *
         * @param $attribute
         * @return array
         *
         * @since 3.5.1.3
         */
        function get_style_values( $attribute ) {

            // $referrer  = wp_get_referer();
            $styles = '';
            $classes = '';
            $attribute_styles = isset( $attribute[ 'style' ] ) ? $attribute[ 'style' ] : [];

            // Text Color
            if ( isset( $attribute[ 'textColor' ] ) ) {
                $classes .= ' tc-has-text-color';
                $styles .= '--tc-block-text-color:var(--wp--preset--color--' . $attribute[ 'textColor' ] . ');';
            }

            // Link Color
            $link = ( isset( $attribute_styles[ 'elements' ] ) && isset( $attribute_styles[ 'elements' ][ 'link' ] ) && isset( $attribute_styles[ 'elements' ][ 'link' ][ 'color' ] ) && isset( $attribute_styles[ 'elements' ][ 'link' ][ 'color' ][ 'text' ] ) ) ? $attribute_styles[ 'elements' ][ 'link' ][ 'color' ][ 'text' ] : '';
            if ( $link ) {
                if ( is_string( $link ) && str_contains( $link, 'var:preset|color|' ) ) {
                    $classes .= ' tc-has-link-color';
                    $value = str_replace( 'var:preset|color|', '', $link );
                    $styles .= '--tc-block-link-color:var(--wp--preset--color--' . $value . ');';
                }
            }

            // Typography: Font family
            if ( isset( $attribute[ 'fontFamily' ] ) ) {
                $classes .= ' tc-has-font-family';
                $styles .= sprintf( '--tc-block-font-family:%s;', $attribute[ 'fontFamily' ] );
            }

            // Typography: Font size
            if ( isset( $attribute[ 'fontSize' ] ) ) {
                $classes .= ' tc-has-font-size';
                $styles .= sprintf( '--tc-block-font-size:var(--wp--preset--font-size--%s);', $attribute[ 'fontSize' ] );
            }

            // Typography: Font style | Font weight
            $typography = isset( $attribute_styles[ 'typography' ] ) ? $attribute_styles[ 'typography' ] : [];
            foreach ( $typography as $key => $value ) {
                $classes .= sprintf( ' tc-has-%s', strtolower( $key ) );
                $styles .= sprintf( '--tc-block-%s:%s;', strtolower( $key ), $value );
            }

            // Spacing Margin | Padding
            $spacing = isset( $attribute_styles[ 'spacing' ] ) ? $attribute_styles[ 'spacing' ] : [];
            foreach ( $spacing as $key => $directions ) {
                if ( is_array( $directions ) ) {
                    foreach ( $directions as $direction => $value ) {

                        if ( is_string( $value ) && str_contains( $value, 'var:preset|spacing|' ) ) {
                            $value = str_replace( 'var:preset|spacing|', '', $value );
                            $value = sprintf( 'var(--wp--preset--spacing--%s);', $value );

                        } else {
                            $value .= ';';
                        }

                        $classes .= sprintf( ' tc-has-%s-%s', strtolower( $key ), strtolower( $direction ) );
                        $styles .= sprintf( '--tc-block-%s-%s:%s', $key, $direction, $value );
                    }
                }
            }

            // Border Width | Radius | Color | Style
            $border = isset( $attribute_styles[ 'border' ] ) ? $attribute_styles[ 'border' ] : [];
            foreach ( $border as $key => $value ) {
                if ( is_array( $value ) ) {
                    foreach ( $value as $_key => $_val ) {
                        if ( is_array( $_val ) ) {
                            foreach ( $_val as $__key => $__val ) {
                                $classes .= sprintf( ' tc-has-border-%s-%s-%s', strtolower( $key ), strtolower( $_key ), strtolower( $__key ) );
                                $styles .= '--tc-block-border-' . strtolower( $key ) . '-' . strtolower( $_key ) . '-' . strtolower( $__key ) . ':' . $__val . ';';
                            }

                        } elseif ( is_string( $_val ) && str_contains( $_val, 'var:preset|' . $_key . '|' )  ) {
                            $classes .= sprintf( ' tc-has-border-%s-%s', strtolower( $key ), strtolower( $_key ) );
                            $_val = str_replace( 'var:preset|' . $_key . '|', '', $_val );
                            $styles .= '--tc-block-border-' . strtolower( $key ) . '-' . strtolower( $_key ) . ':' . sprintf( 'var(--wp--preset--%s--%s);', $_key, $_val ) . ';';

                        } else {
                            $classes .= sprintf( ' tc-has-border-%s-%s', strtolower( $key ), strtolower( $_key ) );
                            $styles .= '--tc-block-border-' . strtolower( $key ) . '-' . strtolower( $_key ) . ':' . $_val . ';';
                        }
                    }

                } else {
                    $classes .= sprintf( ' tc-has-border-%s', strtolower( $key ) );
                    $styles .= '--tc-block-border-' . strtolower( $key ) . ':' . $value . ';';
                }
            }

            // Border Color
            if ( isset( $attribute[ 'borderColor' ] ) ) {
                $classes .= ' tc-has-border-color';
                $styles .= '--tc-block-border-color:var(--wp--preset--color--' . $attribute[ 'borderColor' ] . ');';
            }

            // Background Color | Mixed
            if ( isset( $attribute[ 'backgroundColor' ] ) ) {
                $classes .= ' tc-has-background-color';
                $styles .= '--tc-block-background-color:var(--wp--preset--color--' . $attribute[ 'backgroundColor' ] .');';

            } elseif ( isset( $attribute_styles[ 'color' ] ) && isset( $attribute_styles[ 'color' ][ 'background' ] ) ) {
                $classes .= ' tc-has-background-color';
                $styles .= '--tc-block-background-color:' . $attribute_styles[ 'color' ][ 'background' ] . ';';
            }

            // Background Gradient | Mixed
            if ( isset( $attribute[ 'gradient' ] ) ) {
                $classes .= ' tc-has-background-gradient';
                $styles .= '--tc-block-background-gradient:var(--wp--preset--gradient--' . $attribute[ 'gradient' ] . ');';

            } elseif ( isset( $attribute_styles[ 'color' ] ) && isset( $attribute_styles[ 'color' ][ 'gradient' ] ) ) {
                $classes .= ' tc-has-background-gradient';
                $styles .= '--tc-block-background-gradient:' . $attribute_styles[ 'color' ][ 'gradient' ] . ';';
            }

            return [ 'classes' => $classes, 'styles' => $styles ];
        }
    }
}

$TC_tc_gutentick = new TC_tc_gutentick();
