<?php self::view('components/navbar.php', ['title' => 'Help']); ?>

<div class="riddle-page">
    <h2 class="riddle-page-title mb-5">How can we help you with our plug-in?</h2>

    <div class="row">
        <div class="col-sm-12 col-md-10">
            <p>
                Big thanks for installing Riddle’s quiz maker plug-in! <br>
                You’re now using the same powerful quiz maker and lead generation tools as the BBC, the Chicago Bulls, Formula One, and Red Bull. 
                (Want inspiration? Check out our <a href="https://www.riddle.com/blog/showcase/" target="_blank" rel="noopener noreferrer" style="text-decoration: underline;">showcase</a> for live quiz examples.) <br><br>
                Riddle’s pretty intuitive - but  if you ever need help, please let us know at <a href="mailto:hello@riddle.com?Subject=Wordpress%20help" target="_top">hello@riddle.com</a> or our support chat on Riddle.com - we’re big customer service geeks, and race each other to respond first. :)
            </p>

            <h2 class="riddle-page-title mt-5 mb-4">Connect your Riddle account</h2>
            <p><ol>
                <li>Log in to your account on <a href="https://www.riddle.com" target="_blank">Riddle.com</a>.</li>
                <li>(No account yet? Just create an account - 14 day free trial, with no credit card required.)</li>
                <li>In the top-right menu on Riddle.com, go to the ‘API / Wordpress’ section.</li>
                <br><br>
                <img src="https://cdn.riddle.com/website/wp-plugin/account_menu.jpg" class="help-img" alt="Finding the account menu on riddle.com">
                <br><br>
                <li>
                    Copy your API token and key.
                    <br><br>
                    <img src="https://cdn.riddle.com/website/wp-plugin/api_token.jpg" class="help-img" alt="Generating the API Token">
                    <br><br>
                </li>
                <li>Head back to the Riddle plug-in in Wordpress.</li>
                <li>Paste the code into the token field (under account settings).</li>
                <li>Click on the "Update API token & key" button.</li>
            </ol></p>

            <h2 class="riddle-page-title mt-5 mb-4">Add your quizzes to any post or page</h2>
            <p><ol>
                <li>Create any of the 15 types of quizzes - using our quiz maker on Riddle.com.</li>
                <li>View your list of riddles in "My Riddles" of our plugin.
                    <br><br>
                    <img src="https://cdn.riddle.com/website/wp-plugin/my_riddles_list_of_quizzes.jpg" class="help-img" alt="Riddle Wordpress Plugin: My Riddles List">
                    <br><br>
                </li>
                <li>Click "Get shortcode" then "Copy to Clipboard" button to grab the short code for any quiz.
                    <br><br>
                    <img src="https://cdn.riddle.com/website/wp-plugin/riddle_shortcode_modal.jpg" class="help-img" alt="Riddle Wordpress Plugin: Copy Shortcode Modal for getting the shortcode to embed in WordPress">
                    <br><br>
                </li>
                <li>Paste the short code into text editor of any page or post.</li>
                <li>Publish your post - and you're all set!</li>
                
            </ol></p>

            <h2 class="riddle-page-title mt-5 mb-4">Additional publish settings</h2>
            <p><ol>
                <li>Your shortcode will copy the settings for your quiz from the 'Publish' step on Riddle.com.</li>
                <li>Choose options such as our SEO, auto-scrolling, and the custom width of your quiz.</li>
                <br><br>
                <img src="https://cdn.riddle.com/website/wp-plugin/publish.jpg" class="help-img" alt="publishing options on Riddle.com">
                <br><br>
                <li>All changes made on Riddle.com will automatically appear in your embedded quiz on your blog - once you press the green ‘Publish’ button.</li>
                <li>Except for changes in the ‘Publish’ section - these will change the embed code itself. Please delete the shortcode and re-generate it.</li>
            </ol></p>

            <h2 class="riddle-page-title mt-5 mb-4">Further support info</h2>
            <p>Check out our help resources below - if you want to indulge your inner quiz geek:</p>
            <p><ol>
                <li>Adding Riddles to Gutenberg Blocks: <a href="https://www.riddle.com/docs/creators/adding-a-quiz-to-a-gutenberg-block/" target="_blank">a must read for every Gutenberg user</a></li>
                <li><a href="https://www.riddle.com/blog" target="_blank">Riddle blog</a> - browse 200+ posts, full of quiz examples, tips and best practices about using quizzes for marketing and lead generation</li>
                <li><a href="https://www.riddle.com/docs" target="_blank">Riddle documentation</a> - explore our online knowledge base for questions about any of Riddle's features and quiz types</li>
                <li><a href="mailto:hello@riddle.com">Contact us</a> - you can <a href="mailto:hello@riddle.com?Subject=Wordpress%20help" target="_top">email us</a> or use our support chat on Riddle.com. We're lightning fast at responding - often in under 2 minutes flat. Boom!</li>
            </ol></p>
        </div>
    </div>
</div>