<?php

class TestApiVersion extends WP_UnitTestCase {

    public function testApiVersionMethod() {

        $request = wp_remote_get('http://localhost/wp-json/wpl_api/v1/version');
        $response = json_decode(wp_remote_retrieve_body($request) ?? '', true);

        $this->assertEquals(200, wp_remote_retrieve_response_code( $request ));
        $this->assertArrayHasKey('data', $response);
        $this->assertEquals($this->getJson(), wp_remote_retrieve_body($request));
    }

    protected function getJson() {
        return '{"success":true,"data":{"plugin_name":"WPL REST API","plugin_version":"1.0.0"}}';
    }
}
