<?php

class TestApiResetSmsOptions extends WP_UnitTestCase {

    public function testSmsResetOptions()
    {
        $token = 'eyJ0eXAiOiJKV1QiLCJhbGciOiJIUzI1NiJ9.eyJlbWFpbCI6ImFsYW5AcmVhbHR5bmEuY29tIn0.rEMxnT6YtgJBy2CBViOsdN9UGs6rkVrMWfd97JFA__01';
        $request = wp_remote_get('http://localhost/wp-json/wpl_api/v1/reset-sms-setting',
            array('headers' => array(
                    'Authorization' => 'Bearer ' . $token
            ))
        );
        $response = json_decode(wp_remote_retrieve_body($request) ?? '', true);

        try {

            switch ($response['success']) {
                case true:
                    $this->assertEquals(200, wp_remote_retrieve_response_code($response));
                    $this->assertEquals($this->getSuccessJson(), wp_remote_retrieve_body($request));
                    break;
                case false:
                    $this->assertEquals(200, wp_remote_retrieve_response_code($response));
                    $this->assertEquals($this->getErrorJson(), wp_remote_retrieve_body($request));
                    break;
            }

        } catch (\Exception $e) {
            $this->assertEquals(200, wp_remote_retrieve_response_code($request));
            $this->assertEquals($this->getAuthErrorJson(), wp_remote_retrieve_body($request));
        }
    }

    protected function getSuccessJson() {
        return '{"success":true,"data":{"message":"SMS settings are reset successfully."}}';
    }

    protected function getErrorJson() {
        return '{"success":false,"data":{"message":"Sms settings is not registered yet"}}';
    }

    protected function getAuthErrorJson() {
        return '{"success":false,"data":{"message":"Signature verification failed. Please generate token first."}}';
    }
}