<?php
require dirname(__FILE__) . "/functions.php";

use Api\Wpl\models\core\Auth\Auth;
use Api\Wpl\models\core\Database\Database as DB;

/**
 * Get Contact
 **/
register_rest_route( $this->namespace, '/get-contact', array(
        'methods'             => 'GET',
        'callback'            => function () {
            global $wpdb;
            $userId = (new Auth)->getUserIdByToken();
            $order_by = 'date_added';
            $order = 'DESC';
            $per_page = '100';
            if ($userId > 0) {
                $search = '';
                $search .= (is_multisite() AND isset($_REQUEST['blog_id']) AND !empty($_REQUEST['blog_id'])) ? " AND blog_id = '".intval($_REQUEST['blog_id'])."'" : '';
                $search .= (isset($_REQUEST['gender']) AND !empty($_REQUEST['gender'])) ? " AND gender = '".intval($_REQUEST['gender'])."'" : '';
                $search .= (isset($_REQUEST['private']) AND !empty($_REQUEST['private'])) ? " AND private = '".intval($_REQUEST['private'])."'" : '';
                $search .= (isset($_REQUEST['archive']) AND !empty($_REQUEST['archive'])) ? " AND archive = '".intval($_REQUEST['archive'])."'" : '';
                $search .= (isset($_REQUEST['owner']) AND !empty($_REQUEST['owner'])) ? " AND owner = '".intval($_REQUEST['owner'])."'" : '';
                $search .= (isset($_REQUEST['zip_name']) AND !empty($_REQUEST['zip_name'])) ? " AND zip_name = '".$_REQUEST['zip_name']."'" : '';
                /**
                 * Location1-7
                 **/
                $contacts = $wpdb->get_results("SELECT * FROM {$wpdb->base_prefix}wpl_addon_crm_contacts WHERE 1 $search ORDER BY `$order_by` $order LIMIT $per_page");
                return $contacts;
            } else {
                return [];
            }
        },
        'permission_callback' => array( $this, 'permissionCheck' )
    )
);

/**
 * Get Request
 **/
register_rest_route( $this->namespace, '/get-request', array(
        'methods'             => 'GET',
        'callback'            => function () {
            global $wpdb;
            $userId = (new Auth)->getUserIdByToken();
            $order_by = 'r.date_added';
            $order = 'DESC';
            $per_page = '100';
            if ($userId > 0) {
                $search = '';
                $search .= (isset($_REQUEST['type']) AND !empty($_REQUEST['type'])) ? " AND LOWER(type) LIKE '%".strtolower(trim($_REQUEST['type']))."%'" : '';
                $search .= (isset($_REQUEST['archive']) AND !empty($_REQUEST['archive'])) ? " AND archive = '".intval($_REQUEST['archive'])."'" : '';
                $search .= (isset($_REQUEST['owner']) AND !empty($_REQUEST['owner'])) ? " AND owner = '".intval($_REQUEST['owner'])."'" : '';
                $search .= (isset($_REQUEST['zip_name']) AND !empty($_REQUEST['zip_name'])) ? " AND zip_name = '".$_REQUEST['zip_name']."'" : '';

                $search .= (isset($_REQUEST['min_price']) AND !empty($_REQUEST['min_price'])) ? " AND min_price >= ".floatval(trim($_REQUEST['min_price'])) : '';
                $search .= (isset($_REQUEST['max_price']) AND !empty($_REQUEST['max_price'])) ? " AND max_price <= ".floatval(trim($_REQUEST['max_price'])) : '';

                $search .= (isset($_REQUEST['min_bedrooms']) AND !empty($_REQUEST['min_bedrooms'])) ? " AND min_bedrooms >= ".floatval(trim($_REQUEST['min_bedrooms'])) : '';
                $search .= (isset($_REQUEST['max_bedrooms']) AND !empty($_REQUEST['max_bedrooms'])) ? " AND max_bedrooms <= ".floatval(trim($_REQUEST['max_bedrooms'])) : '';

                $search .= (isset($_REQUEST['min_living_area']) AND !empty($_REQUEST['min_living_area'])) ? " AND min_living_area >= ".floatval(trim($_REQUEST['min_living_area'])) : '';
                $search .= (isset($_REQUEST['max_living_area']) AND !empty($_REQUEST['max_living_area'])) ? " AND max_living_area <= ".floatval(trim($_REQUEST['max_living_area'])) : '';

                $search .= (isset($_REQUEST['min_lot_area']) AND !empty($_REQUEST['min_lot_area'])) ? " AND min_lot_area >= ".floatval(trim($_REQUEST['min_lot_area'])) : '';
                $search .= (isset($_REQUEST['max_lot_area']) AND !empty($_REQUEST['max_lot_area'])) ? " AND max_lot_area <= ".floatval(trim($_REQUEST['max_lot_area'])) : '';
                /**
                 * Location1-7, Property Type, Request
                 **/
                
                $property_fields_query = "DESC {$wpdb->base_prefix}wpl_properties"; 
                $property_fields = $wpdb->get_col($property_fields_query,0);
                if (($key = array_search('id', $property_fields)) !== false) unset($property_fields[$key]);
                if (($key = array_search('field_42', $property_fields)) !== false) unset($property_fields[$key]);
                if (($key = array_search('field_312', $property_fields)) !== false) unset($property_fields[$key]);
                if (($key = array_search('field_313', $property_fields)) !== false) unset($property_fields[$key]);
                if (($key = array_search('field_308', $property_fields)) !== false) unset($property_fields[$key]);
                $property_fields_str = 'id pid, field_42 street, field_312 page_title, field_313 listing_title, field_308 listing_description,'.implode(',',$property_fields);
                
                $fields_raw = $wpdb->get_results("SELECT id, table_column, name, type, options FROM {$wpdb->base_prefix}wpl_dbst WHERE enabled IN (1,2) $search2", ARRAY_A);
                $fields = array();
                foreach ($fields_raw as $k => $field_raw) {
                    if (isset($field_raw['table_column']) AND !empty($field_raw['table_column'])) $fields[$field_raw['table_column']]=array('name'=>$field_raw['name'],'type'=>$field_raw['type'],'options'=>$field_raw['options']);
                }
                
                $query = "SELECT * FROM {$wpdb->base_prefix}wpl_addon_crm_requests r INNER JOIN {$wpdb->base_prefix}wpl_addon_crm_contacts c ON r.cid = c.id INNER JOIN (SELECT $property_fields_str FROM {$wpdb->base_prefix}wpl_properties WHERE 1) p ON (p.mls_id = REPLACE(LEFT(details,LOCATE('|',details)-2),'Listing ID: ','') OR p.mls_id_num = REPLACE(LEFT(details,LOCATE('|',details)-2),'Listing ID: ','')) WHERE 1 $search ORDER BY $order_by $order LIMIT $per_page";
                $requests = listingsFixFields($wpdb->get_results($query,ARRAY_A),$fields,false);
                
                foreach ($requests as $k1 => $request) {
                    foreach ($request as $k2 => $value) {
                        if (substr($k2,0,2)=='n_' OR substr($k2,0,2)=='f_' OR substr($k2,0,6)=='field_' OR $k2=='subdivision/complex') unset($requests[$k1][$k2]);
                    }
                }
                
                return $requests;
            } else {
                return [];
            }
        },
        'permission_callback' => array( $this, 'permissionCheck' )
    )
);

/**
 * Get Ticket
 **/
register_rest_route( $this->namespace, '/get-ticket', array(
        'methods'             => 'GET',
        'callback'            => function () {
            global $wpdb;
            $userId = (new Auth)->getUserIdByToken();
            $order_by = 't.date_added';
            $order = 'DESC';
            $per_page = '100';
            if ($userId > 0) {
                $search = '';
                $search .= (isset($_REQUEST['subject']) AND !empty($_REQUEST['subject'])) ? " AND LOWER(subject) LIKE '%".strtolower(trim($_REQUEST['subject']))."%'" : '';
                $search .= (isset($_REQUEST['archive']) AND !empty($_REQUEST['archive'])) ? " AND archive = '".intval($_REQUEST['archive'])."'" : '';
                $search .= (isset($_REQUEST['owner']) AND !empty($_REQUEST['owner'])) ? " AND owner = '".intval($_REQUEST['owner'])."'" : '';
                $search .= (isset($_REQUEST['status']) AND !empty($_REQUEST['status'])) ? " AND status = '".$_REQUEST['status']."'" : '';

                $search .= (isset($_REQUEST['min_priority']) AND !empty($_REQUEST['min_priority'])) ? " AND min_priority >= ".floatval(trim($_REQUEST['min_priority'])) : '';
                $search .= (isset($_REQUEST['max_priority']) AND !empty($_REQUEST['max_priority'])) ? " AND max_priority <= ".floatval(trim($_REQUEST['max_priority'])) : '';

                $tickets = $wpdb->get_results("SELECT * FROM {$wpdb->base_prefix}wpl_addon_crm_tickets t INNER JOIN {$wpdb->base_prefix}wpl_addon_crm_contacts c ON t.cid = c.id INNER JOIN {$wpdb->base_prefix}wpl_addon_crm_ticket_posts tp ON t.id = tp.id WHERE 1 $search ORDER BY $order_by $order LIMIT $per_page");
                return $tickets;
            } else {
                return [];
            }
        },
        'permission_callback' => array( $this, 'permissionCheck' )
    )
);

/**
 * Get User
 **/
register_rest_route( $this->namespace, '/get-user', array(
        'methods'             => 'GET',
        'callback'            => function () {
            global $wpdb;
            $userId = (new Auth)->getUserIdByToken();
            $order_by = 'last_modified_time_stamp';
            $order = 'DESC';
            $per_page = '100';
            if ($userId > 0) {
                $search = '';
                $search .= (isset($_REQUEST['membership_name']) AND !empty($_REQUEST['membership_name'])) ? " AND LOWER(membership_name) LIKE '%".strtolower(trim($_REQUEST['membership_name']))."%'" : '';
                $search .= (is_multisite() AND isset($_REQUEST['blog_id']) AND !empty($_REQUEST['blog_id'])) ? " AND blog_id = '".intval($_REQUEST['blog_id'])."'" : '';
                $search .= (isset($_REQUEST['sex']) AND !empty($_REQUEST['sex'])) ? " AND sex = '".intval($_REQUEST['sex'])."'" : '';
                $search .= (isset($_REQUEST['membership_type']) AND !empty($_REQUEST['membership_type'])) ? " AND membership_type = '".intval($_REQUEST['membership_type'])."'" : '';
                $search .= (isset($_REQUEST['tel']) AND !empty($_REQUEST['tel'])) ? " AND tel = '".intval($_REQUEST['tel'])."'" : '';
                $search .= (isset($_REQUEST['zip_name']) AND !empty($_REQUEST['zip_name'])) ? " AND zip_name = '".$_REQUEST['zip_name']."'" : '';
                /**
                 * Location1-7
                 **/
                if (is_multisite()) {
                    $users = $wpdb->get_results("SELECT *, GROUP_CONCAT(blog_id) blog_ids FROM (SELECT *, (SELECT membership_name FROM {$wpdb->base_prefix}wpl_users WHERE id < 0 AND id = wu.membership_id AND blog_id = wu.blog_id) membership_name_by_id, (SELECT meta_value FROM {$wpdb->base_prefix}usermeta um WHERE (um.user_id=wu.ID AND um.meta_key = 'primary_blog')) AS wp_blog_id FROM {$wpdb->base_prefix}wpl_users wu WHERE id > 0 AND id IN (SELECT ID FROM {$wpdb->base_prefix}users)) tbl GROUP BY id ORDER BY `$order_by` $order LIMIT $per_page", ARRAY_A);
                } else {
                    $users = $wpdb->get_results("SELECT * FROM (SELECT *, (SELECT membership_name FROM {$wpdb->base_prefix}wpl_users WHERE id < 0 AND id = wu.membership_id) membership_name_by_id FROM {$wpdb->base_prefix}wpl_users wu WHERE id > 0 AND id IN (SELECT ID FROM {$wpdb->base_prefix}users)) tbl GROUP BY id ORDER BY `$order_by` $order LIMIT $per_page", ARRAY_A);
                }

                return $users;
            } else {
                return [];
            }
        },
        'permission_callback' => array( $this, 'permissionCheck' )
    )
);

/**
 * Get WP User
 **/
register_rest_route( $this->namespace, '/get-wp-user', array(
        'methods'             => 'GET',
        'callback'            => function () {
            global $wpdb;
            $userId = (new Auth)->getUserIdByToken();
            $order_by = 'ID';
            $order = 'DESC';
            $per_page = '100';
            if ($userId > 0) {
                $search = '';
                /**
                 * Location1-7
                 **/
                if (is_multisite()) {
                    $users = $wpdb->get_results("SELECT u.*, (SELECT meta_value FROM {$wpdb->base_prefix}usermeta um WHERE (um.user_id=u.ID AND um.meta_key = 'primary_blog')) wp_blog_id, (SELECT meta_value FROM {$wpdb->base_prefix}usermeta um WHERE (um.user_id=u.ID AND um.meta_key = 'source_domain')) source_domain, (SELECT path FROM {$wpdb->base_prefix}blogs b WHERE b.blog_id = (SELECT meta_value FROM {$wpdb->base_prefix}usermeta um WHERE (um.user_id=u.ID AND um.meta_key = 'primary_blog'))) blog_path FROM {$wpdb->base_prefix}users u ORDER BY `$order_by` $order LIMIT $per_page", ARRAY_A);
                } else {
                    $users = $wpdb->get_results("SELECT u.* FROM {$wpdb->base_prefix}users u ORDER BY `$order_by` $order LIMIT $per_page", ARRAY_A);
                }

                return $users;
            } else {
                return [];
            }
        },
        'permission_callback' => array( $this, 'permissionCheck' )
    )
);

/**
 * Get Membership
 **/
register_rest_route( $this->namespace, '/get-membership', array(
        'methods'             => 'GET',
        'callback'            => function () {
            global $wpdb;
            $userId = (new Auth)->getUserIdByToken();
            $order_by = 'id';
            $order = 'DESC';
            $per_page = '100';
            if ($userId > 0) {
                $search = '';
                $search .= (is_multisite() AND isset($_REQUEST['blog_id']) AND !empty($_REQUEST['blog_id'])) ? " AND blog_id = '".intval($_REQUEST['blog_id'])."'" : '';
                $memberships = $wpdb->get_results("SELECT * FROM {$wpdb->base_prefix}wpl_users WHERE id < 0 $search ORDER BY `$order_by` $order LIMIT $per_page", ARRAY_A);

                return $memberships;
            } else {
                return [];
            }
        },
        'permission_callback' => array( $this, 'permissionCheck' )
    )
);

/**
 * Get Membership Type
 **/
register_rest_route( $this->namespace, '/get-membership-type', array(
        'methods'             => 'GET',
        'callback'            => function () {
            global $wpdb;
            $userId = (new Auth)->getUserIdByToken();
            $order_by = 'id';
            $order = 'DESC';
            $per_page = '100';
            if ($userId > 0) {
                $search = '';
                $search .= (is_multisite() AND isset($_REQUEST['blog_id']) AND !empty($_REQUEST['blog_id'])) ? " AND blog_id = '".intval($_REQUEST['blog_id'])."'" : '';
                $memberships = $wpdb->get_results("SELECT * FROM {$wpdb->base_prefix}wpl_user_group_types WHERE `enabled` = 1 $search ORDER BY `$order_by` $order LIMIT $per_page", ARRAY_A);

                return $memberships;
            } else {
                return [];
            }
        },
        'permission_callback' => array( $this, 'permissionCheck' )
    )
);

/**
 * Get Listing
 **/
register_rest_route( $this->namespace, '/get-listing', array(
        'methods'             => 'GET',
        'callback'            => function () {
            global $wpdb;
            $userId = (new Auth)->getUserIdByToken();
            $order_by = 'add_date';
            $order = 'DESC';
            $per_page = '100';
            if ($userId > 0) {
                $search = '';
                $search2 = '';

                $search2 .= isset($_REQUEST['kind']) ? " AND kind = '".intval($_REQUEST['kind'])."'" : '';
                $search2 .= (is_multisite() AND isset($_REQUEST['blog_id']) AND !empty($_REQUEST['blog_id'])) ? " AND blog_id = '".intval($_REQUEST['blog_id'])."'" : '';

                $fields_raw = $wpdb->get_results("SELECT id, table_column, name, type, options FROM {$wpdb->base_prefix}wpl_dbst WHERE enabled IN (1,2) $search2", ARRAY_A);
                $fields = array();
                foreach ($fields_raw as $k => $field_raw) {
                    if (isset($field_raw['table_column']) AND !empty($field_raw['table_column'])) $fields[$field_raw['table_column']]=array('name'=>$field_raw['name'],'type'=>$field_raw['type'],'options'=>$field_raw['options']);
                }

                // $search .= (isset($_REQUEST['subject']) AND !empty($_REQUEST['subject'])) ? " AND LOWER(subject) LIKE '%".strtolower(trim($_REQUEST['subject']))."%'" : '';
                $search .= (isset($_REQUEST['deleted']) AND !empty($_REQUEST['deleted'])) ? " AND p1.deleted = '".intval($_REQUEST['deleted'])."'" : '';
                $search .= (isset($_REQUEST['confirmed']) AND !empty($_REQUEST['confirmed'])) ? " AND p1.confirmed = '".intval($_REQUEST['confirmed'])."'" : '';
                $search .= (isset($_REQUEST['expired']) AND !empty($_REQUEST['expired'])) ? " AND p1.expired = '".intval($_REQUEST['expired'])."'" : '';
                $search .= (isset($_REQUEST['finalized']) AND !empty($_REQUEST['finalized'])) ? " AND p1.finalized = '".intval($_REQUEST['finalized'])."'" : '';

                $search .= isset($_REQUEST['kind']) ? " AND p1.kind = '".intval($_REQUEST['kind'])."'" : '';
                $search .= (is_multisite() AND isset($_REQUEST['blog_id']) AND !empty($_REQUEST['blog_id'])) ? " AND p1.blog_id = '".intval($_REQUEST['blog_id'])."'" : '';

                $search .= (isset($_REQUEST['id']) AND !empty($_REQUEST['id'])) ? " AND p1.id = '".$_REQUEST['id']."'" : '';
                $search .= (isset($_REQUEST['mls_id']) AND !empty($_REQUEST['mls_id'])) ? " AND (p1.mls_id = '".$_REQUEST['mls_id']."' OR p1.mls_id_num='".$_REQUEST['mls_id']."')" : '';
                $search .= (isset($_REQUEST['user_id']) AND !empty($_REQUEST['user_id'])) ? " AND p1.user_id = '".intval($_REQUEST['user_id'])."'" : '';
                $search .= (isset($_REQUEST['listing_type']) AND !empty($_REQUEST['listing_type'])) ? " AND p1.listing = '".intval($_REQUEST['listing_type'])."'" : '';
                $search .= (isset($_REQUEST['property_type']) AND !empty($_REQUEST['property_type'])) ? " AND p1.property_type = '".intval($_REQUEST['property_type'])."'" : '';
                $search .= (isset($_REQUEST['zip_name']) AND !empty($_REQUEST['zip_name'])) ? " AND p1.zip_name = '".$_REQUEST['zip_name']."'" : '';

                $search .= (isset($_REQUEST['min_price']) AND !empty($_REQUEST['min_price'])) ? " AND p1.price >= ".floatval(trim($_REQUEST['min_price'])) : '';
                $search .= (isset($_REQUEST['max_price']) AND !empty($_REQUEST['max_price'])) ? " AND p1.price <= ".floatval(trim($_REQUEST['max_price'])) : '';

                $search .= (isset($_REQUEST['min_bedrooms']) AND !empty($_REQUEST['min_bedrooms'])) ? " AND p1.bedrooms >= ".floatval(trim($_REQUEST['min_bedrooms'])) : '';
                $search .= (isset($_REQUEST['max_bedrooms']) AND !empty($_REQUEST['max_bedrooms'])) ? " AND p1.bedrooms <= ".floatval(trim($_REQUEST['max_bedrooms'])) : '';

                $search .= (isset($_REQUEST['min_half_bathrooms']) AND !empty($_REQUEST['min_half_bathrooms'])) ? " AND p1.half_bathrooms >= ".floatval(trim($_REQUEST['min_half_bathrooms'])) : '';
                $search .= (isset($_REQUEST['max_half_bathrooms']) AND !empty($_REQUEST['max_half_bathrooms'])) ? " AND p1.half_bathrooms <= ".floatval(trim($_REQUEST['max_half_bathrooms'])) : '';

                $search .= (isset($_REQUEST['min_rooms']) AND !empty($_REQUEST['min_rooms'])) ? " AND p1.rooms >= ".floatval(trim($_REQUEST['min_rooms'])) : '';
                $search .= (isset($_REQUEST['max_rooms']) AND !empty($_REQUEST['max_rooms'])) ? " AND p1.rooms <= ".floatval(trim($_REQUEST['max_rooms'])) : '';

                $search .= (isset($_REQUEST['min_bathrooms']) AND !empty($_REQUEST['min_bathrooms'])) ? " AND p1.bathrooms >= ".floatval(trim($_REQUEST['min_bathrooms'])) : '';
                $search .= (isset($_REQUEST['max_bathrooms']) AND !empty($_REQUEST['max_bathrooms'])) ? " AND p1.bathrooms <= ".floatval(trim($_REQUEST['max_bathrooms'])) : '';

                $search .= (isset($_REQUEST['min_living_area']) AND !empty($_REQUEST['min_living_area'])) ? " AND p1.living_area >= ".floatval(trim($_REQUEST['min_living_area'])) : '';
                $search .= (isset($_REQUEST['max_living_area']) AND !empty($_REQUEST['max_living_area'])) ? " AND p1.living_area <= ".floatval(trim($_REQUEST['max_living_area'])) : '';

                $search .= (isset($_REQUEST['min_lot_area']) AND !empty($_REQUEST['min_lot_area'])) ? " AND p1.lot_area >= ".floatval(trim($_REQUEST['min_lot_area'])) : '';
                $search .= (isset($_REQUEST['max_lot_area']) AND !empty($_REQUEST['max_lot_area'])) ? " AND p1.lot_area <= ".floatval(trim($_REQUEST['max_lot_area'])) : '';

                $search .= (isset($_REQUEST['min_latitude']) AND !empty($_REQUEST['min_latitude'])) ? " AND p1.latitude >= ".floatval(trim($_REQUEST['min_latitude'])) : '';
                $search .= (isset($_REQUEST['max_latitude']) AND !empty($_REQUEST['max_latitude'])) ? " AND p1.latitude <= ".floatval(trim($_REQUEST['max_latitude'])) : '';

                $search .= (isset($_REQUEST['min_longitude']) AND !empty($_REQUEST['min_longitude'])) ? " AND p1.longitude >= ".floatval(trim($_REQUEST['min_longitude'])) : '';
                $search .= (isset($_REQUEST['max_longitude']) AND !empty($_REQUEST['max_longitude'])) ? " AND p1.longitude <= ".floatval(trim($_REQUEST['max_longitude'])) : '';

                $search .= (isset($_REQUEST['min_build_year']) AND !empty($_REQUEST['min_build_year'])) ? " AND p1.build_year >= ".floatval(trim($_REQUEST['min_build_year'])) : '';
                $search .= (isset($_REQUEST['max_build_year']) AND !empty($_REQUEST['max_build_year'])) ? " AND p1.build_year <= ".floatval(trim($_REQUEST['max_build_year'])) : '';
                /**
                 * Location1-7
                 **/
                $listings = $wpdb->get_results("SELECT * FROM {$wpdb->base_prefix}wpl_properties p1 INNER JOIN {$wpdb->base_prefix}wpl_properties2 p2 ON p2.id = p1.id WHERE 1 $search ORDER BY `$order_by` $order LIMIT $per_page", ARRAY_A);
                
                $new_listings = [];
                foreach ($listings as $k => $listing) {
                    unset($listing['geopoints']);
                    $new_listings[]=$listing;
                }
                
                $listings = listingsFixFields($new_listings,$fields);
                return $listings;
            } else {
                return [];
            }
        },
        'permission_callback' => array( $this, 'permissionCheck' )
    )
);

/**
 * Get Favorite
 **/
register_rest_route( $this->namespace, '/get-favorite', array(
        'methods'             => 'GET',
        'callback'            => function () {
            global $wpdb;
            $userId = (new Auth)->getUserIdByToken();
            $order_by = 'fav.id';
            $order = 'DESC';
            $per_page = '100';
            if ($userId > 0) {
                $search = '';
                $search2 = '';

                $search2 .= isset($_REQUEST['kind']) ? " AND kind = '".intval($_REQUEST['kind'])."'" : '';
                $search2 .= (is_multisite() AND isset($_REQUEST['blog_id']) AND !empty($_REQUEST['blog_id'])) ? " AND blog_id = '".intval($_REQUEST['blog_id'])."'" : '';

                $fields_raw = $wpdb->get_results("SELECT id, table_column, name, type, options FROM {$wpdb->base_prefix}wpl_dbst WHERE enabled IN (1,2) $search2", ARRAY_A);
                $fields = array();
                foreach ($fields_raw as $k => $field_raw) {
                    if (isset($field_raw['table_column']) AND !empty($field_raw['table_column'])) $fields[$field_raw['table_column']]=array('name'=>$field_raw['name'],'type'=>$field_raw['type'],'options'=>$field_raw['options']);
                }

                $search .= (isset($_REQUEST['kind']) AND !empty($_REQUEST['kind'])) ? " AND p.kind = '".$_REQUEST['kind']."'" : '';
                $search .= (is_multisite() AND isset($_REQUEST['blog_id']) AND !empty($_REQUEST['blog_id'])) ? " AND p.blog_id = '".$_REQUEST['blog_id']."'" : '';
                $search .= (isset($_REQUEST['user_id']) AND !empty($_REQUEST['user_id'])) ? " AND u.user_id = '".$_REQUEST['user_id']."'" : '';

                $query = "SELECT fav.id, p.*, u.*, u.id as user_id FROM `{$wpdb->base_prefix}wpl_addon_pro_favorites` fav INNER JOIN (SELECT * FROM {$wpdb->base_prefix}wpl_properties WHERE confirmed = 1 AND finalized = 1 AND deleted = 0 AND expired = 0) p ON fav.property_id = p.id INNER JOIN (SELECT * FROM {$wpdb->base_prefix}wpl_users WHERE id IN (SELECT id FROM {$wpdb->base_prefix}users)) u ON fav.user_id = u.id WHERE 1 $search ORDER BY `$order_by` $order LIMIT $per_page";
                $favorites = $wpdb->get_results($query, ARRAY_A);
                $favorites = listingsFixFields($favorites,$fields);
                return $favorites;
            } else {
                return [];
            }
        },
        'permission_callback' => array( $this, 'permissionCheck' )
    )
);

/**
 * Get Listing Viewed
 **/
register_rest_route( $this->namespace, '/get-listing-viewed', array(
        'methods'             => 'GET',
        'callback'            => function () {
            global $wpdb;
            $userId = (new Auth)->getUserIdByToken();
            $order_by = 'l.id';
            $order = 'DESC';
            $per_page = '100';
            if ($userId > 0) {
                $search = '';
                $search2 = '';

                $search2 .= isset($_REQUEST['kind']) ? " AND kind = '".intval($_REQUEST['kind'])."'" : '';
                $search2 .= (is_multisite() AND isset($_REQUEST['blog_id']) AND !empty($_REQUEST['blog_id'])) ? " AND blog_id = '".intval($_REQUEST['blog_id'])."'" : '';

                $fields_raw = $wpdb->get_results("SELECT id, table_column, name, type, options FROM {$wpdb->base_prefix}wpl_dbst WHERE enabled IN (1,2) $search2", ARRAY_A);
                $fields = array();
                foreach ($fields_raw as $k => $field_raw) {
                    if (isset($field_raw['table_column']) AND !empty($field_raw['table_column'])) $fields[$field_raw['table_column']]=array('name'=>$field_raw['name'],'type'=>$field_raw['type'],'options'=>$field_raw['options']);
                }

                $search .= (isset($_REQUEST['kind']) AND !empty($_REQUEST['kind'])) ? " AND p.kind = '".$_REQUEST['kind']."'" : '';
                $search .= (is_multisite() AND isset($_REQUEST['blog_id']) AND !empty($_REQUEST['blog_id'])) ? " AND p.blog_id = '".$_REQUEST['blog_id']."'" : '';
                $search .= (isset($_REQUEST['user_id']) AND !empty($_REQUEST['user_id'])) ? " AND u.user_id = '".$_REQUEST['user_id']."'" : '';
                
                $search .= (isset($_REQUEST['membership_id']) AND !empty($_REQUEST['membership_id'])) ? " AND u.membership_id = '".$_REQUEST['membership_id']."'" : '';
                $search .= (isset($_REQUEST['membership_type']) AND !empty($_REQUEST['membership_type'])) ? " AND u.membership_type = '".$_REQUEST['membership_type']."'" : '';
                
                $search .= (isset($_REQUEST['user_email']) AND !empty($_REQUEST['user_email'])) ? " AND (u.main_email = '".$_REQUEST['secondary_email']."' OR u.main_email = '".$_REQUEST['user_email']."')" : '';
                
                $query = "SELECT l.id, p.*, u.* FROM {$wpdb->base_prefix}wpl_logs l INNER JOIN (SELECT * FROM {$wpdb->base_prefix}wpl_users WHERE id IN (SELECT ID FROM {$wpdb->base_prefix}users)) u ON l.user_id = u.id INNER JOIN (SELECT * FROM {$wpdb->base_prefix}wpl_properties WHERE confirmed=1 AND finalized=1 AND deleted=0 AND expired=0) p ON p.id = REPLACE(REPLACE(l.params,'{\"property_id\":\"',''),'\"}','') WHERE section = 'Property Viewed' AND `status` = 1 GROUP BY p.id, u.id ORDER BY $order_by $order LIMIT $per_page";
                $listings = $wpdb->get_results($query, ARRAY_A);
                
                $new_listings = [];
                foreach ($listings as $k => $listing) {
                    unset($listing['geopoints']);
                    $new_listings[]=$listing;
                }
                
                $listings = listingsFixFields($new_listings,$fields);
                return $listings;
            } else {
                return [];
            }
        },
        'permission_callback' => array( $this, 'permissionCheck' )
    )
);

/**
 * Get Save Search
 **/
register_rest_route( $this->namespace, '/get-saved-search', array(
        'methods'             => 'GET',
        'callback'            => function () {
            global $wpdb;
            $userId = (new Auth)->getUserIdByToken();
            $order_by = 'u.id';
            $order = 'DESC';
            $per_page = '100';
            if ($userId > 0) {
                $search = '';

                $search .= (isset($_REQUEST['enabled']) AND !empty($_REQUEST['enabled'])) ? " AND ss.enabled = '".$_REQUEST['enabled']."'" : '';
                $search .= (is_multisite() AND isset($_REQUEST['blog_id']) AND !empty($_REQUEST['blog_id'])) ? " AND ss.blog_id = '".$_REQUEST['blog_id']."'" : '';
                $search .= (isset($_REQUEST['user_id']) AND !empty($_REQUEST['user_id'])) ? " AND ss.user_id = '".$_REQUEST['user_id']."'" : '';

                $search .= (isset($_REQUEST['membership_id']) AND !empty($_REQUEST['membership_id'])) ? " AND u.membership_id = '".$_REQUEST['membership_id']."'" : '';
                $search .= (isset($_REQUEST['membership_type']) AND !empty($_REQUEST['membership_type'])) ? " AND u.membership_type = '".$_REQUEST['membership_type']."'" : '';

                $search .= (isset($_REQUEST['zip_name']) AND !empty($_REQUEST['zip_name'])) ? " AND u.zip_name = '".$_REQUEST['zip_name']."'" : '';

                $search .= (isset($_REQUEST['user_email']) AND !empty($_REQUEST['user_email'])) ? " AND (u.main_email = '".$_REQUEST['secondary_email']."' OR u.main_email = '".$_REQUEST['user_email']."')" : '';

                $query = "SELECT * FROM {$wpdb->base_prefix}wpl_addon_save_searches ss INNER JOIN (SELECT * FROM {$wpdb->base_prefix}wpl_users WHERE id IN (SELECT ID FROM {$wpdb->base_prefix}users)) u ON ss.user_id = u.id WHERE 1 $search ORDER BY $order_by $order LIMIT $per_page";
                $saved_searches = $wpdb->get_results($query,ARRAY_A);
                
                /*
                foreach ($saved_searches as $k1 => $saved_search) {
                    $saved_searches[$k1]['email_notification'] = $saved_search['email_notification']=='1' ? true : false;
                    $saved_searches[$k1]['sms_notification'] = $saved_search['sms_notification']=='1' ? true : false;
                    $saved_searches[$k1]['enabled'] = $saved_search['enabled']=='1' ? true : false;

                    foreach ($saved_search as $k2 => $attr) {
                        if (substr($k2,0,strlen('maccess_'))=='maccess_' or substr($k2,0,strlen('access_'))=='access_' or $k2 == 'rendered') {
                            unset($saved_searches[$k1][$k2]);
                        }
                    }
                }
                */
                
                return $saved_searches;
            } else {
                return [];
            }
        },
        'permission_callback' => array( $this, 'permissionCheck' )
    )
);

/**
 * Get Request Match
 **/
register_rest_route( $this->namespace, '/get-request-match', array(
        'methods'             => 'GET',
        'callback'            => function () {
            global $wpdb;
            $userId = (new Auth)->getUserIdByToken();
            if ($userId > 0) {
                if (isset($_REQUEST['request_id'])) {
                    $id = $_REQUEST['request_id'];
                    $request = new \wpl_addon_crm_request($id);
                    $data = $request->render_matches();
                    
                    $listings = [];
                    foreach ($data['values'] as $result) {
                        //unset($result['raw']['rendered'], $result['data']['rendered']);
                        $listings[]=array_merge($result['raw'],$result['data']);
                    }
                    
                    $fields_raw = $wpdb->get_results("SELECT id, table_column, name, type, options FROM {$wpdb->base_prefix}wpl_dbst WHERE enabled IN (1,2)", ARRAY_A);
                    $fields = array();
                    foreach ($fields_raw as $k => $field_raw) {
                        if (isset($field_raw['table_column']) AND !empty($field_raw['table_column'])) $fields[$field_raw['table_column']]=array('name'=>$field_raw['name'],'type'=>$field_raw['type'],'options'=>$field_raw['options']);
                    }
                    
                    $new_listings = [];
                    foreach ($listings as $k => $listing) {
                        unset($listing['geopoints']);
                        $new_listings[]=$listing;
                    }
                    
                    $listings = listingsFixFields($new_listings,$fields);
                    return $listings;
                } else {
                    return [];
                }
            } else {
                return [];
            }
        },
        'permission_callback' => array( $this, 'permissionCheck' )
    )
);

/**
 * Get Save Search Match
 **/
register_rest_route( $this->namespace, '/get-saved-search-match', array(
        'methods'             => 'GET',
        'callback'            => function () {
            global $wpdb;
            $userId = (new Auth)->getUserIdByToken();
            if ($userId > 0) {
                $fields_raw = $wpdb->get_results("SELECT id, table_column, name, type, options FROM {$wpdb->base_prefix}wpl_dbst WHERE enabled IN (1,2)", ARRAY_A);
                $fields = array();
                foreach ($fields_raw as $k => $field_raw) {
                    if (isset($field_raw['table_column']) AND !empty($field_raw['table_column'])) $fields[$field_raw['table_column']]=array('name'=>$field_raw['name'],'type'=>$field_raw['type'],'options'=>$field_raw['options']);
                }
                
                $saved_search_id = $_REQUEST['saved_search_id'];
                $save_searches = new \wpl_addon_save_searches();
                $save_search = $save_searches->get($saved_search_id);
                $where = json_decode($save_search['criteria'] ?? '',true);
                
                $model = new \wpl_property;
                
                $kind = $_REQUEST['kind'] ?? 0;
                $page_number = $_REQUEST['wplpage'] ?? 1;
        		$limit = $_REQUEST['limit'] ?? 100;
        		$start = $_REQUEST['start'] ?? (($page_number-1)*$limit);
        		$orderby = $_REQUEST['wplorderby'] ?? 'id';
        		$order = $_REQUEST['wplorder'] ?? 'DESC';
        		
                $model->start($start, $limit, $orderby, $order, $where, $kind);
                $model->query();
                $properties = $model->search();
                
                $listings=[];
                foreach ($properties as $property) {
                    $listings[]=\wpl_property::get_property_raw_data($property->id);
                }
                
                $listings = listingsFixFields($listings,$fields);
                
                return $listings;
            } else {
                return [];
            }
        },
        'permission_callback' => array( $this, 'permissionCheck' )
    )
);

/**
 * Get Log
 **/
register_rest_route( $this->namespace, '/get-log', array(
        'methods'             => 'GET',
        'callback'            => function () {
            global $wpdb;
            $userId = (new Auth)->getUserIdByToken();
            $order_by = 'id';
            $order = 'DESC';
            $per_page = '100';
            if ($userId > 0) {
                $search = '';
                $search .= (is_multisite() AND isset($_REQUEST['blog_id']) AND !empty($_REQUEST['blog_id'])) ? " AND blog_id = '".intval($_REQUEST['blog_id'])."'" : '';
                $search .= (isset($_REQUEST['section']) AND !empty($_REQUEST['section'])) ? " AND `section` = '".intval($_REQUEST['section'])."'" : '';
                $search .= (isset($_REQUEST['status']) AND !empty($_REQUEST['status'])) ? " AND `status` = '".intval($_REQUEST['status'])."'" : '';
                $search .= (isset($_REQUEST['priority']) AND !empty($_REQUEST['priority'])) ? " AND `priority` = '".intval($_REQUEST['priority'])."'" : '';
                $search .= (isset($_REQUEST['ip']) AND !empty($_REQUEST['ip'])) ? " AND `ip` = '".intval($_REQUEST['ip'])."'" : '';
                $logs = $wpdb->get_results("SELECT * FROM {$wpdb->base_prefix}wpl_logs WHERE 1 $search ORDER BY `$order_by` $order LIMIT $per_page", ARRAY_A);

                return $logs;
            } else {
                return [];
            }
        },
        'permission_callback' => array( $this, 'permissionCheck' )
    )
);