<?php
namespace Api\Wpl\routes;

use Api\Wpl\models\core\Auth\Auth;
use Api\Wpl\models\core\Database\Database as DB;

/**
 * Test Process
 **/
register_rest_route( $this->namespace, '/test', array(
        'methods'             => 'GET',
        'callback'            => function () {
            $userId = (new Auth)->getUserIdByToken();
            if ($userId > 0) {
                return array(
                    "success" => true,
                    "data" => array(
                        "message" => "test is ok."
                    )
                );
            } else {
                return array(
                    "success" => false,
                    "data" => array(
                        "message" => "authentication failed."
                    )
                );
            }
        },
        'permission_callback' => array( $this, 'permissionCheck' )
    )
);

//== Deprecated Triggers =======================================================

//== CRM Records
register_rest_route( $this->namespace, '/crm-records', array(
    'methods'             => 'GET',
    'callback'            => function () {
        $userId = (new Auth)->getUserIdByToken();
        if ($userId > 0) {
            global $wpdb;

            if (!isset($_GET['crm_record_type']) OR empty($_GET['crm_record_type'])) $_GET['crm_record_type'] = 'contacts';
            switch ($_GET['crm_record_type']) {
                case 'contacts':
                    
                    $table_name = $wpdb->base_prefix.'wpl_addon_crm_contacts';
                    $query = $wpdb->prepare( 'SHOW TABLES LIKE %s', $wpdb->esc_like( $table_name ) );
                    
                    if ( ! $wpdb->get_var( $query ) == $table_name ) {
                        return [];
                    }
                    
                    $users = DB::getRows("SELECT ID, user_login, user_nicename, user_email, user_url, user_status, display_name
                                            FROM ".$wpdb->prefix."users
                                            WHERE ".$wpdb->prefix."users.ID >= ?", array(0));
                                            
                    if (is_array($users)) {
                        $user_list = [];
                        foreach($users as $user) {
                            $user_list[$user['ID']] = $user;
                        }
                    }
            
                    $contacts = DB::getRows("   SELECT  {$wpdb->base_prefix}wpl_addon_crm_contacts.id,
                                                        {$wpdb->base_prefix}wpl_addon_crm_contacts.user_id,
                                                        {$wpdb->base_prefix}wpl_addon_crm_contacts.first_name,
                                                        {$wpdb->base_prefix}wpl_addon_crm_contacts.last_name,
                                                        {$wpdb->base_prefix}wpl_addon_crm_contacts.owner,
                                                        {$wpdb->base_prefix}wpl_addon_crm_contacts.type,
                                                        {$wpdb->base_prefix}wpl_addon_crm_contacts.private,
                                                        {$wpdb->base_prefix}wpl_addon_crm_contacts.archive,
                                                        {$wpdb->base_prefix}wpl_addon_crm_contacts.title,
                                                        {$wpdb->base_prefix}wpl_addon_crm_contacts.gender,
                                                        {$wpdb->base_prefix}wpl_addon_crm_contacts.birthday,
                                                        {$wpdb->base_prefix}wpl_addon_crm_contacts.marital,
                                                        {$wpdb->base_prefix}wpl_addon_crm_contacts.email,
                                                        {$wpdb->base_prefix}wpl_addon_crm_contacts.tel,
                                                        {$wpdb->base_prefix}wpl_addon_crm_contacts.mobile,
                                                        {$wpdb->base_prefix}wpl_addon_crm_contacts.location1_id,
                                                        {$wpdb->base_prefix}wpl_addon_crm_contacts.location2_id,
                                                        {$wpdb->base_prefix}wpl_addon_crm_contacts.location3_id,
                                                        {$wpdb->base_prefix}wpl_addon_crm_contacts.location4_id,
                                                        {$wpdb->base_prefix}wpl_addon_crm_contacts.location5_id,
                                                        {$wpdb->base_prefix}wpl_addon_crm_contacts.location6_id,
                                                        {$wpdb->base_prefix}wpl_addon_crm_contacts.location7_id,
                                                        {$wpdb->base_prefix}wpl_addon_crm_contacts.location1_name,
                                                        {$wpdb->base_prefix}wpl_addon_crm_contacts.location2_name,
                                                        {$wpdb->base_prefix}wpl_addon_crm_contacts.location3_name,
                                                        {$wpdb->base_prefix}wpl_addon_crm_contacts.location4_name,
                                                        {$wpdb->base_prefix}wpl_addon_crm_contacts.location5_name,
                                                        {$wpdb->base_prefix}wpl_addon_crm_contacts.location6_name,
                                                        {$wpdb->base_prefix}wpl_addon_crm_contacts.location7_name,
                                                        {$wpdb->base_prefix}wpl_addon_crm_contacts.zip_id,
                                                        {$wpdb->base_prefix}wpl_addon_crm_contacts.zip_name,
                                                        {$wpdb->base_prefix}wpl_addon_crm_contacts.rating,
                                                        {$wpdb->base_prefix}wpl_addon_crm_contacts.group,
                                                        {$wpdb->base_prefix}wpl_addon_crm_contacts.date_added,
                                                        {$wpdb->base_prefix}wpl_addon_crm_contacts.logins,
                                                        {$wpdb->base_prefix}wpl_addon_crm_contacts.saved_searches,
                                                        {$wpdb->base_prefix}wpl_addon_crm_contacts.listings_viewed,
                                                        {$wpdb->base_prefix}wpl_addon_crm_contacts.last_login_date,
                                                        {$wpdb->base_prefix}wpl_logs.params
                                                FROM {$wpdb->base_prefix}wpl_addon_crm_contacts
                                                LEFT JOIN {$wpdb->base_prefix}wpl_logs ON ({$wpdb->base_prefix}wpl_logs.user_id = {$wpdb->base_prefix}wpl_addon_crm_contacts.user_id AND {$wpdb->base_prefix}wpl_logs.section='Property Viewed')
                                                WHERE {$wpdb->base_prefix}wpl_addon_crm_contacts.id >= ?", array(0));
            
                    $requests = DB::getRows(" SELECT  reqs.id id, reqs.cid, reqs.type, ptypes.name, reqs.price, reqs.price_max, reqs.price_unit, reqs.price_period, reqs.bedrooms, reqs.bedrooms_max, reqs.bathrooms, reqs.bathrooms_max,
                                                      reqs.living_area, reqs.living_area_unit, reqs.living_area_si, reqs.living_area_max, reqs.living_area_max_si, reqs.lot_area, reqs.lot_area_unit, reqs.lot_area_si,
                                                      reqs.lot_area_max, reqs.lot_area_max_si, reqs.zip_name, reqs.details, contact.first_name contact_firstname, contact.last_name contact_last_name, contact.type contact_type,
                                                      contact.email contact_email, contact.tel contact_tel, contact.mobile contact_mobile, reqs.date_added
                                              FROM {$wpdb->base_prefix}wpl_addon_crm_requests reqs
                                              LEFT JOIN {$wpdb->base_prefix}wpl_property_types ptypes ON ptypes.id = reqs.property_type
                                              INNER JOIN {$wpdb->base_prefix}wpl_addon_crm_contacts contact ON contact.id = reqs.cid
                                              WHERE (reqs.details LIKE 'Listing ID:%|%|%http%://%') AND reqs.id >= ?", array(0));
            
                    $main_permalink = DB::getRows("	SELECT {$wpdb->prefix}posts.post_name FROM {$wpdb->base_prefix}wpl_settings
                                                    INNER JOIN {$wpdb->prefix}posts ON {$wpdb->prefix}posts.ID = {$wpdb->base_prefix}wpl_settings.setting_value
                                                    WHERE {$wpdb->base_prefix}wpl_settings.setting_name='main_permalink'")[0];
                    $domainLink=(strpos(strtolower($_SERVER['SERVER_PROTOCOL'] ?? ''),'https') === FALSE ? 'http' : 'https').'://'.$_SERVER['HTTP_HOST'];
            
                    if (is_array($contacts)) {
                        $contact_list = [];
                        foreach($contacts as $contact) {
                            $contact_request = [];
                            foreach($requests as $request) {
                                if ($request['cid']==$contact['id']) {
                                    $contact_request[] = $request;
                                }
                            }
                            
                            $newContact = $contact;
                            $newContact['id']='C'.$contact['id'];
                            $newContact['user_info'] = $user_list[$contact['user_id']];
                            unset($newContact['user_info']['ID']);
                            $newContact['user_info']['id'] = $contact['user_id'];
                            if (strpos($contact['params'] ?? '','property_id')) {
                                $pid = json_decode($contact['params'] ?? '',true)['property_id'];
                                if (strlen($pid)) {
                                    $url="$domainLink/$main_permalink[post_name]/$pid";
                                    $newContact2['contact_property_url'] = $url;
                                }
                            }
                            
                            foreach ($newContact as $k => $item) {
                                $newContact2["contacts_$k"] = $item;
                            }
                            
                            $newContact2['id'] = 'C'.$contact['id'];
                            if (count($contact_request))
                                $newContact2['requests'] = $contact_request;
                                
                            unset($newContact2['contacts_params']);
                            
                            $contact_list[] = $newContact2;
                        }
                    } else {
                        $contact_list = [];
                    }
                    return $contact_list;
                    break;
                case 'tickets':
                    $contacts = DB::getRows("SELECT ".$wpdb->prefix."wpl_addon_crm_contacts.*
                                            FROM ".$wpdb->prefix."wpl_addon_crm_contacts
                                            WHERE ".$wpdb->prefix."wpl_addon_crm_contacts.id >= ?", array(0));
                                            
                    if (is_array($contacts)) {
                        $contact_list = [];
                        foreach($contacts as $contact) {
                            $contact_list[$contact['id']] = $contact;
                        }
                    }
            
                    $users = DB::getRows("SELECT ID, user_login, user_nicename, user_email, user_url, user_status, display_name
                                            FROM ".$wpdb->prefix."users
                                            WHERE ".$wpdb->prefix."users.ID >= ?", array(0));
                                            
                    if (is_array($users)) {
                        $user_list = [];
                        foreach($users as $user) {
                            $user_list[$user['ID']] = $user;
                        }
                    }
            
                    $tickets = DB::getRows("SELECT ".$wpdb->prefix."wpl_addon_crm_tickets.*
                                            FROM ".$wpdb->prefix."wpl_addon_crm_tickets
                                            WHERE ".$wpdb->prefix."wpl_addon_crm_tickets.id >= ?", array(0));
                                            
                    if (is_array($tickets)) {
                        $ticket_list = [];
                        foreach($tickets as $ticket) {
                            $newTicket = $ticket;
                            $newTicket['id'] = 'T'.$ticket['tid'];
                            $newTicket['contact_info'] = $contact_list[$ticket['cid']];
                            $newTicket['owner_info'] = $user_list[$ticket['owner']];
                            unset($newTicket['owner_info']['ID']);
                            $newTicket['owner_info']['id'] = $ticket['owner'];
                            
                            foreach ($newTicket as $k => $item) {
                                $newTicket2["tickets_$k"] = $item;
                            }
                            
                            $newTicket2['id'] = 'T'.$ticket['id'];
                            
                            $ticket_list[] = $newTicket2;
                        }
                    } else {
                        $ticket_list = [];
                    }
                    return $ticket_list;
                    break;
            }
        } else {
            return array(
                "success" => false,
                "data" => array(
                    "message" => "authentication failed."
                )
            );
        }
    },
    'permission_callback' => array( $this, 'permissionCheck' )
 )
);
//== CRM Requests
register_rest_route( $this->namespace, '/crm-requests', array(
    'methods'             => 'GET',
    'callback'            => function () {
        
        $table_name = $wpdb->base_prefix.'wpl_addon_crm_requests';
        $query = $wpdb->prepare( 'SHOW TABLES LIKE %s', $wpdb->esc_like( $table_name ) );
        
        if ( ! $wpdb->get_var( $query ) == $table_name ) {
            return [];
        }
        
        $userId = (new Auth)->getUserIdByToken();
        if ($userId > 0) {
            global $wpdb;
            $filter = @$_GET['request_filter'];
            switch ($filter) {
                case '':
                case 'show_all':
                    $requests = DB::getRows(" SELECT  reqs.id id, reqs.type, ptypes.name, reqs.price, reqs.price_max, reqs.price_unit, reqs.price_period, reqs.bedrooms, reqs.bedrooms_max, reqs.bathrooms, reqs.bathrooms_max,
                                                      reqs.living_area, reqs.living_area_unit, reqs.living_area_si, reqs.living_area_max, reqs.living_area_max_si, reqs.lot_area, reqs.lot_area_unit, reqs.lot_area_si,
                                                      reqs.lot_area_max, reqs.lot_area_max_si, reqs.zip_name, reqs.details, contact.first_name contact_firstname, contact.last_name contact_last_name, contact.type contact_type,
                                                      contact.email contact_email, contact.tel contact_tel, contact.mobile contact_mobile, reqs.date_added
                                              FROM {$wpdb->base_prefix}wpl_addon_crm_requests reqs
                                              LEFT JOIN {$wpdb->base_prefix}wpl_property_types ptypes ON ptypes.id = reqs.property_type
                                              INNER JOIN {$wpdb->base_prefix}wpl_addon_crm_contacts contact ON contact.id = reqs.cid
                                              WHERE reqs.id >= ? ORDER BY reqs.id DESC LIMIT 50", array(0));
                    break;
                case 'only_requests_for_visiting':
                    $requests = DB::getRows(" SELECT  reqs.id id, reqs.type, ptypes.name, reqs.price, reqs.price_max, reqs.price_unit, reqs.price_period, reqs.bedrooms, reqs.bedrooms_max, reqs.bathrooms, reqs.bathrooms_max,
                                                      reqs.living_area, reqs.living_area_unit, reqs.living_area_si, reqs.living_area_max, reqs.living_area_max_si, reqs.lot_area, reqs.lot_area_unit, reqs.lot_area_si,
                                                      reqs.lot_area_max, reqs.lot_area_max_si, reqs.zip_name, reqs.details, contact.first_name contact_firstname, contact.last_name contact_last_name, contact.type contact_type,
                                                      contact.email contact_email, contact.tel contact_tel, contact.mobile contact_mobile, reqs.date_added, props.mls_id,
                                                      props.listing,
                                                      props.location1_name ,
                                                      props.location2_name ,
                                                      props.location3_name ,
                                                      props.location4_name ,
                                                      props.location5_name ,
                                                      props.location6_name ,
                                                      props.location7_name ,
                                                      props.price ,
                                                      props.bathrooms ,
                                                      props.bathrooms_max ,
                                                      props.living_area ,
                                                      props.living_area_max ,
                                                      props.lot_area ,
                                                      props.parkings ,
                                                      props.googlemap_lt ,
                                                      props.googlemap_ln ,
                                                      props.build_year ,
                                                      props.zip_name ,
                                                      props.street ,
                                                      props.street_no
                                              FROM {$wpdb->base_prefix}wpl_addon_crm_requests reqs
                                              LEFT JOIN {$wpdb->base_prefix}wpl_property_types ptypes ON ptypes.id = reqs.property_type
                                              INNER JOIN {$wpdb->base_prefix}wpl_addon_crm_contacts contact ON contact.id = reqs.cid
                                              INNER JOIN {$wpdb->base_prefix}wpl_properties props ON (props.mls_id = REPLACE(LEFT(reqs.details,LOCATE(' |',reqs.details)),'Listing ID: ','') OR props.mls_id_num = REPLACE(LEFT(reqs.details,LOCATE(' |',reqs.details)),'Listing ID: ',''))
                                              WHERE (reqs.details LIKE 'Listing ID:%|%|%http%://%') AND reqs.id >= ? ORDER BY reqs.id DESC LIMIT 50", array(0));
                    break;
                case 'only_general_requests':
                    $requests = DB::getRows(" SELECT  reqs.id id, reqs.type, ptypes.name, reqs.price, reqs.price_max, reqs.price_unit, reqs.price_period, reqs.bedrooms, reqs.bedrooms_max, reqs.bathrooms, reqs.bathrooms_max,
                                                      reqs.living_area, reqs.living_area_unit, reqs.living_area_si, reqs.living_area_max, reqs.living_area_max_si, reqs.lot_area, reqs.lot_area_unit, reqs.lot_area_si,
                                                      reqs.lot_area_max, reqs.lot_area_max_si, reqs.zip_name, reqs.details, contact.first_name contact_firstname, contact.last_name contact_last_name, contact.type contact_type,
                                                      contact.email contact_email, contact.tel contact_tel, contact.mobile contact_mobile, reqs.date_added
                                              FROM {$wpdb->base_prefix}wpl_addon_crm_requests reqs
                                              LEFT JOIN {$wpdb->base_prefix}wpl_property_types ptypes ON ptypes.id = reqs.property_type
                                              INNER JOIN {$wpdb->base_prefix}wpl_addon_crm_contacts contact ON contact.id = reqs.cid
                                              WHERE (reqs.details NOT LIKE 'Listing ID:%|%|%http%://%') AND reqs.id >= ? ORDER BY reqs.id DESC LIMIT 50", array(0));
                    break;
            }
            
            if (is_array($requests)) {
                foreach ($requests as $k => $request) {
                    if (strlen($request['details']) > 2 AND substr_count($request['details'],'|') > 1) {
                        $request['details'] = str_replace('Listing ID: ','',$request['details']);
                        $req_items = explode('|', $request['details']);
                        $requests[$k]['request_mls_id'] = trim($req_items[0] ?? '');
                        $requests[$k]['request_message'] = trim($req_items[1] ?? '');
                        $requests[$k]['request_url'] = trim($req_items[2] ?? '');
                        //unset($requests[$k]['details']);

                        foreach ($request as $ukey => $uval) {
                            if (empty(trim($uval ?? '')) OR $uval === null OR $uval === '0') unset($requests[$k][$ukey]);
                        }
                    }
                }
                return $requests;
            } else {
                return array();
            }
        } else {
            return array(
                "success" => false,
                "data" => array(
                    "message" => "authentication failed."
                )
            );
        }
    },
    'permission_callback' => array( $this, 'permissionCheck' )
)
);
//== WPL USER
register_rest_route( $this->namespace, '/wpl-users', array(
    'methods'             => 'GET',
    'callback'            => function () {
        $userId = (new Auth)->getUserIdByToken();
        if ($userId > 0) {
            global $wpdb;
            switch ($_GET['user_type']) {
                case 'agents':
                    $users = DB::getRows("  SELECT {$wpdb->prefix}users.ID id, {$wpdb->prefix}users.user_login, user_email, user_status, display_name, first_name, last_name, type, private, archive, title, gender, birthday, marital, email, tel, mobile, location1_name, location2_name, location3_name, location4_name, location5_name, location6_name, location7_name, zip_id, zip_name, saved_searches, listings_viewed, last_login_date FROM {$wpdb->prefix}users
                                            INNER JOIN {$wpdb->prefix}wpl_addon_crm_contacts ON {$wpdb->prefix}wpl_addon_crm_contacts.user_id = {$wpdb->prefix}users.ID
                                            WHERE {$wpdb->prefix}users.ID >=0 AND {$wpdb->prefix}users.ID IN (
                                                SELECT user_id FROM {$wpdb->prefix}usermeta WHERE {$wpdb->prefix}usermeta.meta_key = '{$wpdb->prefix}capabilities' AND {$wpdb->prefix}usermeta.meta_value LIKE '%subscriber%'
                                            )", array(0));
                                           
                    $ids = "";
                    foreach ($users as $k => $user) {
                        $ids .= $user['id'] .',';
                        unset($users[$k]['rendered'], $users[$k]['user_pass']);
                        $users[$k]['id'] = 'A'.$user['id'];
                        $users[$k]['user_id'] = $user['id'];
                        foreach ($user as $ukey => $uval) {
                            if (empty(trim($uval ?? ''))) unset($users[$k][$ukey]);
                        }
                    }
                    
                    /*$ids = substr($ids,0,strlen($ids)-1);
                    $listing_viewed = DB::getRows(" SELECT id, user_id, addon_id, section, status, log_text, log_date, priority, params, ip
                                                    FROM `{$wpdb->base_prefix}wpl_logs`
                                                    WHERE user_id IN ($ids) AND section='Property Viewed' AND id > ?", array(0));
                                                    
                    $logins = DB::getRows(" SELECT id, user_id, addon_id, section, status, log_text, log_date, priority, params, ip
                                            FROM `{$wpdb->base_prefix}wpl_logs`
                                            WHERE user_id IN ($ids) AND section='User Login' AND id > ?", array(0));
                                            
                    $favorites = DB::getRows(" SELECT *
                                               FROM `{$wpdb->base_prefix}wpl_addon_pro_favorites`
                                               WHERE user_id IN ($ids) AND id > ?", array(0));*/
                    
                    $main_permalink = DB::getRows("	SELECT {$wpdb->prefix}posts.post_name FROM {$wpdb->base_prefix}wpl_settings
                                                    INNER JOIN {$wpdb->prefix}posts ON {$wpdb->prefix}posts.ID = {$wpdb->base_prefix}wpl_settings.setting_value
                                                    WHERE {$wpdb->base_prefix}wpl_settings.setting_name='main_permalink'")[0];
                    $domainLink=(strpos(strtolower($_SERVER['SERVER_PROTOCOL'] ?? ''),'https') === FALSE ? 'http' : 'https').'://'.$_SERVER['HTTP_HOST'];
                    
                    foreach ($users as $k => $user) {
                        $lv = [];
                        $li = [];
                        $fv = [];
                        
                        /*foreach ($listing_viewed as $listing) {
                            if ($listing['user_id']==$user['user_id']) {
                                // $pstart = strpos($listing['log_text'] ?? '',' #')+2;
                                // $pend = strpos($listing['log_text'] ?? '',' ',$pstart);
                                // $pid = substr($listing['log_text'],$pstart,$pend-$pstart);
                                
                                if (strpos($listing['params'] ?? '','property_id')) {
                                    $pid = json_decode($listing['params'] ?? '')->property_id;
                                    $listing['url']="$domainLink/$main_permalink[post_name]/$pid";
                                    unset($listing['params']);
                                }
                                $lv[]=$listing;
                            }
                        }
                        
                        foreach ($logins as $login) {
                            if ($login['user_id']==$user['user_id']) {
                                $li[]=$login;
                            }
                        }
                        
                        foreach ($favorites as $favorite) {
                            if ($favorite['user_id']==$user['user_id']) {
                                $favorite['url']="$domainLink/$main_permalink[post_name]/".$favorite['property_id'];
                                $fv[]=$favorite;
                            }
                        }
                        
                        $users[$k]['listing_viewed']=$lv;
                        $users[$k]['logins']=$lv;
                        $users[$k]['favorites']=$fv;*/
                    }

                    return $users;
                    break;
                case 'regular_users':
                    $users = DB::getRows(" SELECT {$wpdb->prefix}users.ID id, {$wpdb->prefix}users.user_login, user_email, user_status, display_name, first_name, last_name, type, private, archive, title, gender, birthday, marital, email, tel, mobile, location1_id, location2_id, location3_id,location4_id, location5_id, location6_id, location7_id, location1_name, location2_name, location3_name, location4_name, location5_name, location6_name, location7_name, zip_id, zip_name, saved_searches, listings_viewed, last_login_date
                                           FROM {$wpdb->prefix}users
                                           INNER JOIN {$wpdb->prefix}usermeta ON ({$wpdb->prefix}usermeta.meta_key = '{$wpdb->prefix}capabilities' AND {$wpdb->prefix}usermeta.meta_value LIKE '%subscriber%')
                                           INNER JOIN {$wpdb->base_prefix}wpl_addon_crm_contacts ON {$wpdb->base_prefix}wpl_addon_crm_contacts.user_id = {$wpdb->prefix}users.ID
                                           WHERE {$wpdb->prefix}users.ID >= ? AND {$wpdb->prefix}usermeta.meta_value LIKE '%subscriber%'", array(0));
                    
                    $ids = '';
                    foreach ($users as $k => $user) {
                        $ids .= $user['id'] .',';
                        $users[$k]['user_id'] = $user['id'];
                        $users[$k]['id'] = 'U'.$user['id'];
                    }
                    
                    $ids = substr($ids,0,strlen($ids)-1);
                    $listing_viewed = DB::getRows(" SELECT id, user_id, addon_id, section, status, log_text, log_date, priority, params, ip
                                                    FROM `{$wpdb->base_prefix}wpl_logs`
                                                    WHERE user_id IN ($ids) AND section='Property Viewed' AND id > ? ORDER BY id DESC LIMIT 10", array(0));
                                                    
                    $logins = DB::getRows(" SELECT id, user_id, addon_id, section, status, log_text, log_date, priority, params, ip
                                            FROM `{$wpdb->base_prefix}wpl_logs`
                                            WHERE user_id IN ($ids) AND section='User Login' AND id > ?", array(0));
                                            
                    $favorites = DB::getRows(" SELECT *
                                               FROM `{$wpdb->base_prefix}wpl_addon_pro_favorites`
                                               WHERE user_id IN ($ids) AND id > ?", array(0));
                    
                    $main_permalink = DB::getRows("	SELECT {$wpdb->prefix}posts.post_name FROM {$wpdb->base_prefix}wpl_settings
                                                    INNER JOIN {$wpdb->prefix}posts ON {$wpdb->prefix}posts.ID = {$wpdb->base_prefix}wpl_settings.setting_value
                                                    WHERE {$wpdb->base_prefix}wpl_settings.setting_name='main_permalink'")[0];
                    $domainLink=(strpos(strtolower($_SERVER['SERVER_PROTOCOL'] ?? ''),'https') === FALSE ? 'http' : 'https').'://'.$_SERVER['HTTP_HOST'];
                    foreach ($users as $k => $user) {
                        $lv = [];
                        $li = [];
                        $fv = [];
                        
                        foreach ($listing_viewed as $listing) {
                            if ($listing['user_id']==$user['user_id']) {
                                /*$pstart = strpos($listing['log_text'] ?? '',' #')+2;
                                $pend = strpos($listing['log_text'] ?? '',' ',$pstart);
                                $pid = substr($listing['log_text'],$pstart,$pend-$pstart);*/
                                $listing['url'] = '';
                                if (strpos($listing['params'] ?? '','property_id')) {
                                    $pid = json_decode($listing['params'] ?? '')->property_id;
                                    $listing['url']="$domainLink/$main_permalink[post_name]/$pid";
                                    unset($listing['params']);
                                }
                                if ($listing['url'] != '')
                                    $lv[]=$listing;
                            }
                        }
                        
                        foreach ($logins as $login) {
                            if ($login['user_id']==$user['user_id']) {
                                $li[]=$login;
                            }
                        }
                        
                        foreach ($favorites as $favorite) {
                            if ($favorite['user_id']==$user['user_id']) {
                                $favorite['url']="$domainLink/$main_permalink[post_name]/".$favorite['property_id'];
                                $fv[]=$favorite;
                            }
                        }
                        
                        if (isset($lv) AND !empty($lv) AND count($lv))
                            $users[$k]['listing_viewed']=$lv;
                        if (isset($li) AND !empty($li) AND count($li))
                            $users[$k]['logins']=$li;
                        if (isset($fv) AND !empty($fv) AND count($fv))
                            $users[$k]['favorites']=$fv;
                    }
                    
                    return $users;
                    break;
            }
        } else {
            return array(
                "success" => false,
                "data" => array(
                    "message" => "authentication failed."
                )
            );
        }
    },
    'permission_callback' => array( $this, 'permissionCheck' )
)
);

//== Triggers ==================================================================
require_once dirname(__FILE__) . "/zapier/triggers.php";
//== Actions ===================================================================
require_once dirname(__FILE__) . "/zapier/actions.php";
//== Dynamic Fields ============================================================
require_once dirname(__FILE__) . "/zapier/dynamic_fields.php";