<?php


namespace Api\Wpl\routes\api;


use Api\Wpl\routes\libs\Auth;
use Api\Wpl\routes\libs\AuthRequired;
use Api\Wpl\routes\libs\Html2Text;

class PropertiesApi extends Api
{

    public function listingsAction(Auth $auth, \WP_REST_Request $request)
    {
        if (empty($_POST['limit'])) {
            $_POST['limit'] = 500;
        }
        $_REQUEST['limit'] = $_POST['limit'];
        $result = $this->getListProperties($auth, $request, true);
        unset($result['info']);
        return $result;
    }

    public function listingsV3Action(Auth $auth, \WP_REST_Request $request)
    {
        if (empty($_POST['limit'])) {
            $_POST['limit'] = 500;
        }
        $_REQUEST['limit'] = $_POST['limit'];
        $result = $this->getListProperties($auth, $request, true, true);
        unset($result['info']);
        return $result;
    }

    public function listPropertiesAction(Auth $auth, \WP_REST_Request $request) {
        return $this->getListProperties($auth, $request);
    }

    public function listPropertiesDynamicAction(Auth $auth, \WP_REST_Request $request)
    {
        return $this->getListPropertiesDynamic($auth, $request);
    }

    public function getListProperties(Auth $auth, \WP_REST_Request $request, $firstImage = false, $minimal = false)
    {
        if($auth->isLoggedIn()) {
            $myListings = $request->get_param('my_listings');
            if(!empty($myListings)) {
                $_POST['sf_select_user_id'] = $auth->getUserId();
            }
        }

        if(!empty($_POST['just_coordinates'])) {
            putenv('DISABLED=1');
            $model = new \wpl_property();
            $where = array('sf_select_confirmed' => 1, 'sf_select_finalized' => 1, 'sf_select_deleted' => 0, 'sf_select_expired' => 0, 'sf_select_kind' => 0);
            $vars = array_merge(\wpl_request::get('POST'), \wpl_request::get('GET'));
            $where = array_merge($vars, $where);
            $model->start(0, 20, 'p.id', 'ASC', $where, 0);
            $model->select = 'min(p.googlemap_lt) as min_lat ,max(p.googlemap_lt) as max_lat, min(p.googlemap_ln) as min_long,max(p.googlemap_ln) as max_long';
            $model->where .= " AND googlemap_lt != '0.00000000' and googlemap_ln != '0.00000000'";
            $model->query();
            $info = $model->search();
            $info = array_shift($info);
            if($info->max_lat == $info->min_lat && $info->max_long == $info->min_long) {
                wp_send_json_success([
                    'geometry' => [
                        'location' => ['lat' => $info->max_lat, 'lon' => $info->max_long]
                    ],
                ]);
                die;
            }
            wp_send_json_success([
                'geometry' => [
                    'bounds' => [
                        'northeast' => ['lat' => $info->max_lat, 'lon' => $info->max_long],
                        'southwest' => ['lat' => $info->min_lat, 'lon' => $info->min_long],
                    ],
                ],
            ]);
            die;
        }
        if(!$minimal) {
            $property_types = \wpl_global::get_property_types();
            $property_type_names = [];
            foreach($property_types as $property_type) {
                $property_type_names[$property_type['id']] = $property_type['name'];
            }
            $listing_types = \wpl_global::get_listings();
            $listing_type_icons = [];
            $listing_type_names = [];
            foreach($listing_types as $listing_type) {
                $listing_type_names[$listing_type['id']] = $listing_type['name'];
                $listing_type_icons[$listing_type['id']] = \wpl_global::get_wpl_url() . 'assets/img/listing_types/gicon/' . $listing_type['gicon'];
            }
        }

        $model = new \wpl_property();
        $where = array('sf_select_confirmed'=>1, 'sf_select_finalized'=>1, 'sf_select_deleted'=>0, 'sf_select_expired'=>0, 'sf_select_kind'=> 0);
        $vars = array_merge(\wpl_request::get('POST'), \wpl_request::get('GET'));
        $where = array_merge($vars, $where);
        $settings = \wpl_settings::get_settings();
        $page_number = \wpl_request::getVar('wplpage', 1, '', true);
        $limit = \wpl_request::getVar('limit', $settings['default_page_size']);
        $start = \wpl_request::getVar('start', (($page_number-1)*$limit), '', true);
        $orderby = \wpl_request::getVar('wplorderby', $settings['default_orderby'], '', true);
        $order = \wpl_request::getVar('wplorder', $settings['default_order'], '', true);
        $model->start($start, $limit, $orderby, $order, $where, 0);
        $model->select = '*';
        $model->query();
        $properties = $model->search();
        if(!$minimal) {
            $total = $model->get_properties_count();

            _wpl_import('libraries.pagination');
            $pagination = \wpl_pagination::get_pagination($total, $limit, true, 1);
        }

        $return = [];
        $userId = $auth->getUserId();

        foreach ($properties as $property) {
            $price_formatted = $this->_formatPrice([
                'raw' => $property->price,
                'price_only' => \wpl_render::render_price($property->price, $property->price_unit),
                'price_period' => '',
            ]);
            if($minimal) {
                $return[] = [
                    "id" =>  $property->id,
                    "longitude" => !empty($property->geopoint) ? $property->geopoint['lon'] : $property->googlemap_ln,
                    "latitude" => !empty($property->geopoint) ? $property->geopoint['lat'] : $property->googlemap_lt,
                    "price" => $price_formatted,
                ];
                continue;
            }
            $images = [];
            $items = \wpl_items::get_items($property->id, '', $property->kind, '', 1);
            $blog_id = \wpl_property::get_blog_id($property->id);
            foreach ($items['gallery'] as $image) {
                if($image->item_cat == 'external') {
                    $images[] = $image->item_extra3;
                } else {
                    $images[] = \wpl_items::get_folder($image->parent_id, $image->parent_kind, $blog_id) . $image->item_name;
                }
            }
            $propertyInfo = [
                "id" =>  $property->id,
                "location_text" => $property->location_text,
                "property_title" => $property->field_313,
                "property_type_id" => $property->property_type,
                "property_type_title" => $property_type_names[$property->property_type],
                "listing_type_title" => $listing_type_names[$property->listing],
                "listing_type_icon" => $listing_type_icons[$property->listing],
                "is_favorite" => FavoriteApi::isFavorite($property->id, $userId),
                "bathrooms" => intval($property->bathrooms),
                "bedrooms" => intval($property->bedrooms),
                "price" => $price_formatted,
                "price_numeric" => $property->price,
                "area" => number_format($property->living_area) . ' ' . \wpl_units::get_unit($property->living_area_unit)['name'],
                "images" => $images,
                "image_count" => intval($property->pic_numb),
                "longitude" => !empty($property->geopoint) ? $property->geopoint['lon'] : $property->googlemap_ln,
                "latitude" => !empty($property->geopoint) ? $property->geopoint['lat'] : $property->googlemap_lt,
                "user_id" => $property->user_id,
            ];
            if($firstImage) {
                unset($propertyInfo['images']);
                $propertyInfo['image'] = '';
                if(!empty($images[0])) {
                    $propertyInfo['image'] = $images[0];
                }
            }
            $return[] = $propertyInfo;
        }

        if($minimal) {
            return [
                'properties' => $return,
            ];
        }
        return [
            'properties' => $return,
            'info' => [
                'current_page' => $pagination->page,
                'next_page' => $pagination->page == $pagination->total_pages ? $pagination->total_pages : $pagination->page + 1,
                'previous_page' => $pagination->page == 1 ? 1 : $pagination->page - 1,
                'total_page' => $pagination->total_pages,
            ],
        ];
    }
    public function getListPropertiesOld(Auth $auth, \WP_REST_Request $request, $firstImage = false) {
        if($auth->isLoggedIn()) {
            $myListings = $request->get_param('my_listings');
            if (!empty($myListings)) {
                $_POST['sf_select_user_id'] = $auth->getUserId();
            }
        }

        \_wpl_import('views.frontend.property_listing.wpl_raw');
        $raw = new \wpl_property_listing_controller();
        $raw->return_listings = true;
        $_REQUEST['wplmethod'] = 'get_listings';
        $raw->wplraw = true;

        $just_coordinates = !empty($_POST['just_coordinates']) ? $_POST['just_coordinates'] : '';
        if ($just_coordinates == 1) {
            $model = new \wpl_property();
            $where = array('sf_select_confirmed' => 1, 'sf_select_finalized' => 1, 'sf_select_deleted' => 0, 'sf_select_expired' => 0, 'sf_select_kind' => 0);
            $vars = array_merge(\wpl_request::get('POST'), \wpl_request::get('GET'));
            $where = array_merge($vars, $where);
            $model->start(0, 20, 'p.id', 'ASC', $where, 0);
            $model->select = 'min(p.googlemap_lt) as min_lat ,max(p.googlemap_lt) as max_lat, min(p.googlemap_ln) as min_long,max(p.googlemap_ln) as max_long';
            $model->where .= " AND googlemap_lt != '0.00000000' and googlemap_ln != '0.00000000'";
            $model->query();
            $info = $model->search();
            $info = array_shift($info);
            if ($info->max_lat == $info->min_lat && $info->max_long == $info->min_long) {
                wp_send_json_success([
                    'geometry' => [
                        'location' => ['lat' => $info->max_lat, 'lon' => $info->max_long]
                    ],
                ]);
                die;
            }
            wp_send_json_success([
                'geometry' => [
                    'bounds' => [
                        'northeast' => ['lat' => $info->max_lat, 'lon' => $info->max_long],
                        'southwest' => ['lat' => $info->min_lat, 'lon' => $info->min_long],
                    ],
                ],
            ]);
            die;
        }

        $listing_types = \wpl_global::get_listings();
        $listing_type_icons = [];
        foreach ($listing_types as $listing_type) {
            $listing_type_icons[$listing_type['id']] = \wpl_global::get_wpl_url() . 'assets/img/listing_types/gicon/' . $listing_type['gicon'];
        }
        $properties = $raw->display();

        $return = [];
        $userId = $auth->getUserId();
        foreach ($properties as $property) {

            if (!empty($property['data']['id'])) {

                $images = [];
                $blog_id = \wpl_property::get_blog_id($property['data']['id']);
                $gallery = !empty($property['items']['gallery']) ? $property['items']['gallery'] : '';

                if (!empty($gallery)) {
                    foreach ($property['items']['gallery'] as $image) {
                        if ($image->item_cat == 'external') {
                            $images[] = $image->item_extra3;
                        } else {
                            $images[] = \wpl_items::get_folder($image->parent_id, $image->parent_kind, $blog_id) . $image->item_name;
                        }
                    }
                }

                $price_formatted = $this->_formatPrice($property['materials']['price']);

                $bedroom = !empty($property['materials']['bedrooms']['value']) ? $property['materials']['bedrooms']['value'] : '';

                $propertyInfo = [
                    "id" => $property['data']['id'],
                    "location_text" => $property['data']['location_text'],
                    "property_title" => $property['data']['field_313'],
                    "property_type_id" => $property['data']['property_type'],
                    "property_type_title" => $property['materials']['property_type']['value'],
                    "listing_type" => $property['materials']['listing']['value'],
                    "listing_type_icon" => $listing_type_icons[$property['raw']['listing']],
                    "is_favorite" => (\wpl_global::check_addon('PRO')) ? FavoriteApi::isFavorite($property['data']['id'], $userId) : '',
                    "bathrooms" => isset($property['materials']['bathrooms']['value']) ? intval($property['materials']['bathrooms']['value']) : '',
                    "bedrooms" => intval($bedroom),
                    "price" => $price_formatted,
                    "price_numeric" => $property['materials']['price']['raw'],
                    "living_area" => isset($property['materials']['living_area']['value']) ? $property['materials']['living_area']['value'] : '',
                    "images" => $images,
                    "image_count" => intval($property['data']['pic_numb']),
                    "longitude" => $property['raw']['googlemap_ln'],
                    "latitude" => $property['raw']['googlemap_lt'],
                    "user_id" => $property['raw']['user_id'],
                ];
                if ($firstImage) {
                    unset($propertyInfo['images']);
                    $propertyInfo['image'] = '';
                    if (!empty($images[0])) {
                        $propertyInfo['image'] = $images[0];
                    }
                }
                $return[] = $propertyInfo;
            }
        }
        $pages = ceil($raw->pagination->total_pages / $raw->pagination->limit);
        return [
            'properties' => $return,
            'info' => [
                'current_page' => $raw->pagination->page,
                'next_page' => $raw->pagination->page == $pages ? $pages : $raw->pagination->page + 1,
                'previous_page' => $raw->pagination->page == 1 ? 1 : $raw->pagination->page - 1,
                'total_page' => $pages,
            ],
        ];
    }

    public function previewAction(Auth $auth, int $listing_id) {
        $property = \wpl_property::get_property_raw_data($listing_id);
        if (!$property) {
            throw new \Exception('listing not found.');
        }
        $price_formatted = $this->_formatPrice([
            'raw' => $property['price'],
            'price_only' => \wpl_render::render_price($property['price'], $property['price_unit']),
            'price_period' => '',
        ]);
        $userId = $auth->getUserId();
        $property_types = \wpl_global::get_property_types();
        $property_type_names = [];
        foreach($property_types as $property_type) {
            $property_type_names[$property_type['id']] = $property_type['name'];
        }
        $listing_types = \wpl_global::get_listings();
        $listing_type_names = [];
        foreach($listing_types as $listing_type) {
            $listing_type_names[$listing_type['id']] = $listing_type['name'];
        }

        $images = [];
        $items = \wpl_items::get_items($property['id'], '', $property['kind'], '', 1);
        $blog_id = \wpl_property::get_blog_id($property['id']);
        foreach ($items['gallery'] as $image) {
            if($image->item_cat == 'external') {
                $images[] = $image->item_extra3;
            } else {
                $images[] = \wpl_items::get_folder($image->parent_id, $image->parent_kind, $blog_id) . $image->item_name;
            }
        }
        $agent = \wpl_users::full_render($property['user_id'], \wpl_users::get_pshow_fields(), NULL, array(), true);
        return [
            "id" => $property['id'],
            "location_text" => $property['location_text'],
            "property_title" => $property['field_313'],
            "property_type_id" => $property['property_type'],
            "property_type_title" => $property_type_names['property_type'],
            "listing_type" => $listing_type_names[$property['listing']],
            "is_favorite" => FavoriteApi::isFavorite($property['id'], $userId),
            "bathrooms" => isset($property['bathrooms']) ? intval($property['bathrooms']) : '',
            "bedrooms" => intval($property['bedrooms']),
            "price" => $price_formatted,
            "price_numeric" => $property['price'],
            "living_area" => empty($property['living_area']) ? '' : number_format($property['living_area']) . ' ' . \wpl_units::get_unit($property['living_area_unit'])['name'],
            "images" => $images,
            //"image_count" => intval($property['pic_numb']),
            "longitude" => $property['googlemap_ln'],
            "latitude" => $property['googlemap_lt'],
            "user_id" => $property['user_id'],
            "agent_id" => $property['user_id'],
            'agent_first_name' => isset($agent['materials']['first_name']['value']) ? $agent['materials']['first_name']['value'] : '',
            'agent_last_name' => isset($agent['materials']['last_name']['value']) ? $agent['materials']['last_name']['value'] : '',
            'agent_avatar' => isset($agent['profile_picture']['url']) ? $agent['profile_picture']['url'] : '',
        ];
    }

    public function getListPropertiesDynamic(Auth $auth, \WP_REST_Request $request, $firstImage = false)
    {

        if ($auth->isLoggedIn()) {
            $myListings = $request->get_param('my_listings');
            if (!empty($myListings)) {
                $_POST['sf_select_user_id'] = $auth->getUserId();
            }
        }

        _wpl_import('libraries.pagination');

        $settings = \wpl_settings::get_settings();
        $attributes = $request->get_param('attributes');
        if (!empty($attributes['wplpage'])) \wpl_request::setVar('wplpage', $attributes['wplpage']);
        $limit = !empty($attributes['limit']) ? $attributes['limit'] : 8;
        $orderBy = !empty($attributes['wplorderby']) ? substr($attributes['wplorderby'], 2) : "price";
        $order = !empty($attributes['wplorder']) ? $attributes['wplorder'] : "asc";
        $extraAttributes = array('sf_select_confirmed' => 1, 'sf_select_finalized' => 1, 'sf_select_deleted' => 0, 'sf_select_expired' => 0);
        $attributes = array_merge($attributes, $extraAttributes);

        $where = \wpl_db::create_query($attributes);
        $query = "FROM `#__wpl_properties` WHERE 1 {$where} ORDER BY {$orderBy} {$order} ";

        $total = \wpl_db::select("SELECT count(*) $query", 'loadResult');
        $pagination = \wpl_pagination::get_pagination($total, $limit);
        $query .= $pagination->limit_query;
        $properties = \wpl_db::select("SELECT * {$query}");

        $listing_types = \wpl_global::get_listings();
        $listing_type_icons = [];
        foreach ($listing_types as $listing_type) {
            $listing_type_icons[$listing_type['id']] = \wpl_global::get_wpl_url() . 'assets/img/listing_types/gicon/' . $listing_type['gicon'];
        }

        $return = [];

        if (\wpl_global::check_addon('neighborhoods')) {
            _wpl_import('libraries.addon_neighborhoods');
            $neghborhoods_addon = new \wpl_addon_neighborhoods();
        }

        foreach ($properties as $property) {

            // Get the property image
            $image = $this->getTheImageProperty($request, $property->id, $attributes['sizes']);

            // Set the property price format
            $price['raw'] = $property->price;
            $price['price_only'] = $property->price;
            $price_formatted = $this->_formatPrice($price);

            $listing_type = \wpl_global::get_listings($property->listing);
            $listing_type = !empty($listing_type->name) ? $listing_type->name : '';

            $price_unit = $property->price_unit;
            $query_price_unit = "SELECT name FROM `#__wpl_units` WHERE `id` = {$price_unit}";
            $price_unit_symbol = \wpl_db::select($query_price_unit, 'loadAssocList');
            $price_unit_symbol = !empty($price_unit_symbol[0]['name']) ? $price_unit_symbol[0]['name'] : '';

            $propertyInfo = [
                "id" => isset($property->id) ? $property->id : '',
                "location_text" => isset($property->location_text) ? $property->location_text : '',
                "property_title" => isset($property->field_313) ? $property->field_313 : '',
                "property_type_id" => isset($property->property_type) ? $property->property_type : '',
                "property_type_title" => isset($property->property_type) ? $property->property_type : '',
                "listing_type" => isset($listing_type) ? $listing_type : '',
                "listing_type_icon" => isset($listing_type_icons[$property->listing]) ? $listing_type_icons[$property->listing] : '',
                "is_favorite" => (\wpl_global::check_addon('PRO')) ? FavoriteApi::isFavorite($property->id, $auth->getUserId()) : '',
                'property_link' => \wpl_property::get_property_link(null, $property->id),
                "bathrooms" => intval($property->bathrooms),
                "bedrooms" => intval($property->bedrooms),
                "price" => isset($price_formatted) ? $price_formatted : '',
                "price_numeric" => isset($property->price) ? $property->price : '',
                "price_unit"  => isset($price_unit_symbol) ? $price_unit_symbol : '',
                "living_area" => isset($property->living_area) ? $property->living_area : '',
                "image" => isset($image) ? $image : '',
                "image_count" => intval($property->pic_numb),
                "longitude" => isset($property->googlemap_ln) ? $property->googlemap_ln : '',
                "latitude" => isset($property->googlemap_lt) ? $property->googlemap_lt : '',
                "user_id" => isset($property->user_id) ? $property->user_id : '',
                'description' => $this->_fixQuotes(Html2Text::convert($property->field_308)),
                'total_properties' => '0',
            ];

            if ($attributes['sf_select_kind'] == '4' && \wpl_global::check_addon('neighborhoods')) {
                $propertyInfo['total_properties'] = $neghborhoods_addon->get_property_count($property->id, $settings['neighborhood_listings_mode']);
            }

            $return[] = $propertyInfo;
        }

        $total_pages = !empty($properties) ? count($properties) : 0;

        $pages = ceil($pagination->total_pages / $pagination->limit);

        return [
            'properties' => $return,
            'pagination' => $pagination,
            'info' => [
                'current_page' => $pagination->page,
                'next_page' => $pagination->page == $pages ? $pages : $pagination->page + 1,
                'previous_page' => $pagination->page == 1 ? 1 : $pagination->page - 1,
                'total_page' => $pages,
            ],
        ];
    }

    public function getAgentAction(\WP_REST_Request $request)
    {
        $propertyId = $request['id'];
        $property = \wpl_property::get_property_raw_data($propertyId);

        if (empty($property)) {
            throw new \Exception('No property could be found.');
        }

        $agent = \wpl_users::full_render($property['user_id'], \wpl_users::get_pshow_fields(), NULL, array(), true);

        if (empty($agent['raw'])) {
            throw new \Exception('Agent not found!');
        }
        return [
            'id' => $property['user_id'],
            'first_name' => isset($agent['materials']['first_name']['value']) ? $agent['materials']['first_name']['value'] : '',
            'last_name' => isset($agent['materials']['last_name']['value']) ? $agent['materials']['last_name']['value'] : '',
            'email' => isset($agent['materials']['main_email']['value']) ? $agent['materials']['main_email']['value'] : '',
            'tel' => isset($agent['materials']['tel']['value']) ? $agent['materials']['tel']['value'] : '',
            'fax' => isset($agent['materials']['fax']['value']) ? $agent['materials']['fax']['value'] : '',
            'mobile' => isset($agent['materials']['mobile']['value']) ? $agent['materials']['mobile']['value'] : '',
            'profile_picture' => isset($agent['profile_picture']['url']) ? $agent['profile_picture']['url'] : '',
            'company_name' => isset($agent['materials']['company_name']['value']) ? $agent['materials']['company_name']['value'] : '',
            'company_address' => isset($agent['materials']['company_address']['value']) ? $agent['materials']['company_address']['value'] : '',
            'website' => isset($agent['materials']['website']['value']) ? $agent['materials']['website']['value'] : '',
            'profile_link' => \wpl_users::get_profile_link($property['user_id']) != '' ? \wpl_users::get_profile_link($property['user_id']) : '',
        ];
    }

    public function getMultiAgentsAction(\WP_REST_Request $request)
    {
        $propertyId = $request['id'];
        $property = \wpl_property::get_property_raw_data($propertyId);

        if (empty($property)) {
            throw new \Exception('No property could be found.');
        }

        $user_ids = array();
        $user_ids[] = $property['user_id'];

        if (\wpl_global::check_addon('multi_agents')) {
            _wpl_import('libraries.addon_multi_agents');

            $multi = new \wpl_addon_multi_agents($property['id']);
            $additional_agents = $multi->get_agents();

            foreach ($additional_agents as $additional_agent) $user_ids[] = $additional_agent;
            $user_ids = array_unique($user_ids);
        }

        @extract(\wpl_filters::apply('wpl_property_agent_user_ids', array('user_ids' => $user_ids, 'property_id' => $property['id'], 'pdf' => false)));

        $pshow_fields = \wpl_users::get_pshow_fields();
        $users_data = array();
        foreach ($user_ids as $user_id) {
            // User is not exists
            if (!\wpl_users::is_wpl_user($user_id)) continue;

            $wpl_user = \wpl_users::full_render($user_id, $pshow_fields, NULL, array(), true);

            $users_data[] = [
                'id' => $user_id,
                'first_name' => isset($wpl_user['materials']['first_name']['value']) ? $wpl_user['materials']['first_name']['value'] : '',
                'last_name' => isset($wpl_user['materials']['last_name']['value']) ? $wpl_user['materials']['last_name']['value'] : '',
                'email' => isset($wpl_user['materials']['main_email']['value']) ? $wpl_user['materials']['main_email']['value'] : '',
                'tel' => isset($wpl_user['materials']['tel']['value']) ? $wpl_user['materials']['tel']['value'] : '',
                'fax' => isset($wpl_user['materials']['fax']['value']) ? $wpl_user['materials']['fax']['value'] : '',
                'mobile' => isset($wpl_user['materials']['mobile']['value']) ? $wpl_user['materials']['mobile']['value'] : '',
                'profile_picture' => isset($wpl_user['profile_picture']['url']) ? $wpl_user['profile_picture']['url'] : '',
                'company_name' => isset($wpl_user['materials']['company_name']['value']) ? $wpl_user['materials']['company_name']['value'] : '',
                'company_address' => isset($wpl_user['materials']['company_address']['value']) ? $wpl_user['materials']['company_address']['value'] : '',
                'website' => isset($wpl_user['materials']['website']['value']) ? $wpl_user['materials']['website']['value'] : '',
                'profile_link' => \wpl_users::get_profile_link($user_id) != '' ? \wpl_users::get_profile_link($user_id) : '',
            ];
        }

        return $users_data;
    }

    public function getItemsAction(\WP_REST_Request $request)
    {

        $propertyId = $request['id'];
        $kind = !empty($propertyId) ? \wpl_property::get_property_kind($propertyId) : '';
        $itemType = $request['item_type'];
        $itemCat = $request['item_cat'];
        $items = \wpl_items::get_items($propertyId, $itemType, $kind);
        $blog_id = \wpl_property::get_blog_id($propertyId);
        $path = \wpl_items::get_path($propertyId, $kind, $blog_id);
        $url = \wpl_items::get_folder($propertyId, $kind, $blog_id);
        $result = [];
        foreach ($items as $key => $item) {
            $itemUrl = $url . $item->item_name;
            if ($item->item_cat == 'external') {
                $itemUrl = $item->item_extra3;
                $item->item_path = '';
            } else {
                $item->item_path = $path . $item->item_name;
            }
            $item->link = $itemUrl;
            if (empty($itemCat) || $item->item_cat == $itemCat) {
                $result[$key] = $item;
            }
        }

        return $result;
    }

    public function getPrevNextAction(\WP_REST_Request $request)
    {

        //TODO: implement
        $propertyId = $request['id'];
        $kind = !empty($propertyId) ? \wpl_property::get_property_kind($propertyId) : '';
        $property = \wpl_property::get_property_raw_data($propertyId);
        $settings = \wpl_settings::get_settings();
        $orderby = \wpl_request::getVar('wplorderby', $settings['default_orderby'], '', true);
        $order = \wpl_request::getVar('wplorder', $settings['default_order'], '', true);
        $where = array('sf_select_confirmed' => 1, 'sf_select_finalized' => 1, 'sf_select_deleted' => 0, 'sf_select_expired' => 0, 'sf_select_kind' => $kind);
        $column = str_replace('p.', '', str_replace('`', '', $orderby));
        $where["sf_notselect_id"] = $property['id'];
        $limit = 1;
        $page = 1;
        $next_condition = "sf_tmin_$column";
        $prev_condition = "sf_tmax_$column";
        $prev_order = 'DESC';
        if ($order == 'DESC') {
            $prev_condition = "sf_tmin_$column";
            $next_condition = "sf_tmax_$column";
            $prev_order = 'ASC';
        }

        $modelNext = new \wpl_property();
        $where[$next_condition] = $property[$column];
        $modelNext->start(0, 1, $orderby, $order, $where);
        $next = $modelNext->search($modelNext->query(false));

        $modelPrev = new \wpl_property();
        unset($where[$next_condition]);
        $where[$prev_condition] = $property[$column];
        $modelPrev->start(0, 1, $orderby, $prev_order, $where);
        $prev = $modelPrev->search($modelPrev->query(false));



        if (!empty($next)) {
            $propertyId = array_pop($next)->id;
            $property = \wpl_property::get_property_raw_data($propertyId);
            $next = [
                'id' => $propertyId,
                'property_title' => \wpl_property::update_property_title($property),
                'location_text' => \wpl_property::generate_location_text((array)$property),
                'property_link' => \wpl_property::get_property_link($property),
                'next_img' => $this->getTheImageProperty($request, $propertyId)
            ];
        }
        if (!empty($prev)) {
            $propertyId = array_pop($prev)->id;
            $property = \wpl_property::get_property_raw_data($propertyId);
            $prev = [
                'id' => $propertyId,
                'property_title' => \wpl_property::update_property_title($property),
                'location_text' => \wpl_property::generate_location_text((array)$property),
                'property_link' => \wpl_property::get_property_link($property),
                'prev_img' => $this->getTheImageProperty($request, $propertyId)
            ];
        }

        return [
            'prev' => $prev,
            'next' => $next,
        ];
    }

    public function getUnitName($unitId)
    {
        if (empty($this->units)) {
            $this->units = [];
        }
        if (empty($this->units[$unitId])) {
            $this->units[$unitId] = \wpl_units::get_unit($unitId);
        }
        $unit_name = isset($this->units[$unitId]) ? $this->units[$unitId]['name'] : '';
        return $unit_name;
    }

    public function getRawInfoAction(\WP_REST_Request $request)
    {
        $propertyId = $request['id'];
        $property = \wpl_property::get_property_raw_data($propertyId);
        if (empty($property)) {
            throw new \Exception('No property could be found.');
        }
        unset($property['geopoints']);
        foreach ($property as $key => $value) {
            if (strpos($key ?? '', '_unit') > 0) {
                $property[$key] = $this->getUnitName($value);
            }
        }
        return $property;
    }

    public function editProperty($property_id, $params, $mode = 'edit')
    {
        $fields = $params['fields'];
        $location = $params['location'];
        foreach ($fields as $field) {
            $result = $this->saveField($field['table_name'], $field['table_column'], $field['value'], $property_id);
            if (!empty($field['unit'])) {
                $result = $this->saveField($field['table_name'], $field['table_column'] . '_unit', $field['unit'], $property_id);
            }
        }
        $this->saveField('wpl_properties', 'googlemap_lt', $location['latitude'], $property_id);
        $this->saveField('wpl_properties', 'googlemap_ln', $location['longitude'], $property_id);
        $this->saveField('wpl_properties', 'location1_id', '254', $property_id);
        //                $this->saveField('wpl_properties', 'location2_id', '254', $property_id);
        $this->saveField('wpl_properties', 'location3_id', $location['state'], $property_id);
        $this->saveField('wpl_properties', 'location4_id', $location['city'], $property_id);
        $this->saveField('wpl_properties', 'zip_id', $location['zipcode'], $property_id);
        $this->saveField('wpl_properties', 'field_42', $location['street'], $property_id);
        $this->saveField('wpl_properties', 'street_no', $location['streetNumber'], $property_id);


        \wpl_property::finalize($property_id, $mode);

        $author_obj = get_user_by('ID', $params['user_id']);
        if ($author_obj->allcaps['administrator'] || \wpl_users::check_access('confirm', $params['user_id'], $params['user_id'])) {
            \wpl_property::confirm($property_id);
        } else {
            \wpl_property::confirm($property_id, 0);
        }
        return true;
    }

    public function addListingAction(AuthRequired $auth, \WP_REST_Request $request)
    {
        $params = $request->get_params();
        $params['user_id'] = $auth->getUserId();
        $property_id = \wpl_property::create_property_default($params['user_id']);
        $this->editProperty($property_id, $params, 'add');
        return array(
            'message' => __('Property successfully added.', 'wpl-api'),
            'listing_id' => $property_id
        );
    }

    public function editListingAction(AuthRequired $auth, \WP_REST_Request $request)
    {
        $params = $request->get_params();
        $property_id = $params['id'];
        $userId = \wpl_property::get_property_user($property_id);
        if ($auth->getUserId() != $userId && \wpl_global::check_access('edit', $auth->getUserId()) == false) {
            throw new \Exception('Can not edit listing');
        }
        $this->editProperty($property_id, $params);
        return array(
            'message' => __('Property successfully edited.', 'wpl-api'),
            'listing_id' => $property_id
        );
    }

    public function detailedAction(Auth $auth, \WP_REST_Request $request)
    {
        $listing_id = absint($request->get_param('listing_id'));
        return $this->getProperty($listing_id, $auth->getUserId());
    }

    public function deleteListingsAction(AuthRequired $auth, int $listing_id)
    {
        $property = \wpl_property::get_property_raw_data($listing_id);
        if (!$property) {
            throw new \Exception('listing not found.');
        }

        $userId = \wpl_property::get_property_user($listing_id);
        if ($auth->getUserId() != $userId && \wpl_global::check_access('delete', $auth->getUserId()) == false) {
            throw new \Exception('Can not delete listing');
        }
        \wpl_property::purge($listing_id);
        return array(
            'message' => __('Properties deleted successfully', 'wpl-api')
        );
    }

    public function removeFileAction(AuthRequired $auth, int $listing_id, string $url)
    {
        $property = \wpl_property::get_property_raw_data($listing_id);
        if (!$property || $property['user_id'] != $auth->getUserId()) {
            throw new \Exception('listing not found.');
        }
        \wpl_db::q("UPDATE `#__wpl_items` set enabled = 0 where parent_id = $listing_id and item_extra3 = '$url'");

        return array('message' => 'the file successfully deleted.');
    }

    public function addFileAction(AuthRequired $auth, \WP_REST_Request $request, int $listing_id)
    {
        $fileParams = $request->get_file_params();
        $allowedMimeTypes = array(
            "image/png",
            "image/jpg",
            "image/jpeg",
            "video/mp4",
            "video/x-flv",
            "video/webm",
            "video/ogg",
            "video/quicktime",
            "png",
            "jpg",
            "jpeg",
            "mp4",
            "x-flv",
            "webm",
            "ogg",
            "mov"
        );

        if (!function_exists('wp_handle_upload')) {
            require_once(ABSPATH . 'wp-admin/includes/file.php');
        }
        $property = \wpl_property::get_property_raw_data($listing_id);
        if (!$property || $property['user_id'] != $auth->getUserId()) {
            throw new \Exception("Listing with this ID: $listing_id could not be found.");
        }

        foreach ($fileParams as $param) {
            switch ($param['error']) {
                case UPLOAD_ERR_OK:
                    break;
                case UPLOAD_ERR_NO_FILE:
                    throw new \RuntimeException('No file sent.');
                case UPLOAD_ERR_INI_SIZE:
                case UPLOAD_ERR_FORM_SIZE:
                    throw new \RuntimeException('Exceeded filesize limit.');
                default:
                    throw new \RuntimeException('Unknown errors.');
            }
            if (function_exists('mime_content_type')) {
                $mimeType = \mime_content_type($param['tmp_name']);
            } else {
                $mimeType = pathinfo($param['name'], PATHINFO_EXTENSION);
            }
            if (!in_array($mimeType, $allowedMimeTypes)) {
                throw new \Exception('File type must be image or video');
            }

            $moveFile = \wp_handle_upload($param, array(
                'test_form' => false
            ));

            if (!$moveFile || isset($moveFile['error'])) {
                throw new \Exception($moveFile['error']);
            }

            $data = [];
            switch ($mimeType) {
                case 'image/png':
                case 'image/jpg':
                case 'image/jpeg':
                case 'png':
                case 'jpg':
                case 'jpeg':
                    $data = array(
                        'parent_id' => $listing_id,
                        'creation_date' => date("Y-m-d H:i:s"),
                        'item_type' => 'gallery',
                        'item_cat' => 'external',
                        'item_name' => 'external_image' . $listing_id,
                        'item_extra3' => $moveFile['url']
                    );
                    break;
                case 'video/mp4':
                case 'video/x-flv':
                case 'video/webm':
                case 'video/ogg':
                case 'video/quicktime':
                case 'mp4':
                case 'x-flv':
                case 'webm':
                case 'ogg':
                case 'mov':
                    $data = array(
                        'parent_id' => $listing_id,
                        'creation_date' => date("Y-m-d H:i:s"),
                        'item_type' => 'video',
                        'item_cat' => 'video_embed',
                        'item_name' => 'external_image' . $listing_id,
                        'item_extra2' => '<iframe src="' . $moveFile['url'] . '"></iframe>',
                        'item_extra3' => $moveFile['url']
                    );
                    break;
            }
            if (!empty($data)) {
                \wpl_items::save($data);
            }
        }
        return array(
            'message' => __('File saved successfully.', 'wpl-api')
        );
    }

    private function saveField($table_name, $table_column, $value, $item_id)
    {
        $field_type = \wpl_global::get_db_field_type($table_name, $table_column);
        if ($field_type == 'datetime' or $field_type == 'date') $value = \wpl_render::derender_date($value);
        else $value = \wpl_db::escape($value);

        $res = \wpl_db::set($table_name, $item_id, $table_column, $value, 'id');

        if ($res and $table_name == 'wpl_properties') \wpl_events::trigger('edit_property_field', array('id' => $item_id, 'table_column' => $table_column, 'value' => $value));

        $res = (int)$res;
        $message = $res ? __('Saved.', 'real-estate-listing-realtyna-wpl') : __('Error Occured.', 'real-estate-listing-realtyna-wpl');
        $data = NULL;

        return array('success' => $res, 'message' => $message, 'data' => $data);
    }

    public function getPricePeriodTitle($pricePeriodId)
    {
        $id = \wpl_flex::get_dbst_id('price_period', 0);
        $options = \wpl_flex::get_field_options($id);
        foreach ($options['params'] as $option) {
            if ($option['key'] == $pricePeriodId) {
                return __($option['value'], 'wpl-api');
            }
        }
        return '';
    }

    private function _fixQuotes($text)
    {
        $text = str_replace('\n', "\n", $text ?? '');
        return stripslashes($text);
    }

    public function getLastIdAction()
    {
        $id = \wpl_db::select("SELECT MAX(id) from `#__wpl_properties`", 'loadResult');
        return ['id' => $id];
    }

    public function getCategoriesAction($kind = 0)
    {
        $categories = \wpl_flex::get_categories('', '', " AND `enabled`>='1' AND `kind`='$kind' AND `pshow`='1'");
        $return = [];
        foreach ($categories as $category) {
            $return[] = [
                'id' => $category->id,
                'name' => $category->name,
            ];
        }
        return $return;
    }

    public function getKindsAction($table = 'wpl_properties')
    {
        $kinds = \wpl_flex::get_kinds($table);
        $return = [];
        foreach ($kinds as $kind) {
            $return[] = [
                'id' => $kind['id'],
                'name' => $kind['name'],
            ];
        }
        return $return;
    }

    public function getProperty($propertyId, $userId)
    {
        $property = \wpl_property::get_property_raw_data($propertyId);
        if (empty($property)) {
            throw new \Exception('No property could be found.');
        }
        $categories = \wpl_flex::get_categories('', '', " AND `enabled`>='1' AND `kind`='" . $property['kind'] . "' AND `pshow`='1'");
        global $wpdb;
        $visits = $wpdb->get_row("SELECT * FROM {$wpdb->base_prefix}wpl_properties2 WHERE id = $property[id]")->visit_time;
        if (empty($visits)) {
            $visits = '0';
        }
        $return = [
            'agent' => [],
            'id' => $property['id'],
            'user_id' => $property['user_id'],
            'categories' => [],
            'properties' => [],
            'property_title' => \wpl_property::update_property_title($property),
            'location_text' => \wpl_property::generate_location_text((array)$property),
            'description' => $this->_fixQuotes(Html2Text::convert($property['field_308'])),
            'latitude' => $property['googlemap_lt'],
            'longitude' => $property['googlemap_ln'],
            'is_favorite' => (\wpl_global::check_addon('PRO')) ? FavoriteApi::isFavorite($property['id'], $userId) : '',
            'share_link' => \wpl_property::get_property_link(null, $property['id']),
            'pdf_link' => \wpl_property::get_property_pdf_link($property['id']),
            'price_period_title' => $this->getPricePeriodTitle($property['price_period']),
            'listing_type_parent_id' => \wpl_listing_types::get_parent($property['listing']),
            'visits' => $visits,
            'likes' => (\wpl_global::check_addon('PRO')) ? $wpdb->get_row("SELECT COUNT(1) cnt FROM `{$wpdb->base_prefix}wpl_addon_pro_favorites` WHERE `property_id` = '{$property['id']}'")->cnt : '',
            'gallery' => [],
            'similar' => [],
            'nearby' => [],
        ];
        // removes escaped quotes
        $return['description'] = stripslashes(str_replace('\n', "\n", $return['description'] ?? ''));
        foreach ($categories as $category) {
            $return['categories'][] = [
                'id' => $category->id,
                'name' => $category->name,
            ];
            $categoryFields = \wpl_property::get_pshow_fields($category->id, $property['kind']);
            $find_files = null;
            $fields = \wpl_property::render_property($property, $categoryFields, $find_files, true);

            if (!empty($fields['columns'])) {
                foreach ($fields['columns'] as $key => $field) {
                    if (!empty($field['values'])) {
                        $field['value'] = implode(', ', $field['values']);
                        unset($field['values']);
                    }
                    if (!empty($field['raw']) && is_array($field['raw'])) {
                        unset($field['raw']);
                    }
                    if (!empty($field['unit_id'])) {
                        $field['unit_name'] = $this->getUnitName($field['unit_id']);
                    }
                    $field['category_id'] = $category->id;
                    $field['field_name'] = $key;
                    $return['properties'][] = $field;
                }
            }
        }

        $items = \wpl_items::get_items($property['id'], '', $property['kind'], '', 1);

        $blog_id = \wpl_property::get_blog_id($property['id']);
        $url = \wpl_items::get_folder($property['id'], $property['kind'], $blog_id);
        foreach ($items['gallery'] as $image) {
            $image_url = $url . $image->item_name;
            if ($image->item_cat == 'external') {
                $image_url = $image->item_extra3;
            }
            $return['gallery'][] = array(
                'type' => 'image',
                'title' => $image->item_name,
                'url' => $image_url,
            );
        }
        if (!empty($items['video'])) {
            foreach ($items['video'] as $video) {
                $re = '/src(.*)(?<link>http([^ \'"]*))/m';
                $str = $video->item_extra2;
                preg_match_all($re, $str, $matches, PREG_SET_ORDER, 0);
                $return['gallery'][] = array(
                    'type' => 'video',
                    'title' => $video->item_name,
                    'url' => isset($matches[0]) ? $matches[0]['link'] : '',
                );
            }
        }
        $agentUserId = $property['user_id'];

        $agent = \wpl_users::full_render($agentUserId, \wpl_users::get_pshow_fields(), NULL, array(), true);
        if (!empty($agent)) {
            $return['agent'] = [
                'id' => $agentUserId,
                'first_name' => isset($agent['materials']['first_name']['value']) ? $agent['materials']['first_name']['value'] : '',
                'last_name' => isset($agent['materials']['last_name']['value']) ? $agent['materials']['last_name']['value'] : '',
                'main_email' => isset($agent['materials']['main_email']['value']) ? $agent['materials']['main_email']['value'] : '',
                'tel' => isset($agent['materials']['tel']['value']) ? $agent['materials']['tel']['value'] : '',
                'profile_picture' => isset($agent['profile_picture']['url']) ? $agent['profile_picture']['url'] : '',
            ];
        }
        if (!empty($userId) && \wpl_global::check_addon('crm')) {
            \wp_set_current_user($userId);
            \_wpl_import('libraries.event_handlers.addon_crm');
            \wpl_events_crm::property_show(array(
                array(
                    'id' => $propertyId,
                    'user_id' => $userId,
                    'params' => array('device' => 'mobile')
                ),
            ));
        }
        $return['similar'] = $this->_getSimilar($property);
        $return['nearby'] = $this->_getNearby($property);
        return $return;
    }

    public function getSimilarAction(\WP_REST_Request $request)
    {
        $propertyId = $request['id'];
        $property = \wpl_property::get_property_raw_data($propertyId);
        if (empty($property)) {
            throw new \Exception('No property could be found.');
        }
        $items = \wpl_items::get_items($propertyId, 'gallery', 0);
        $blog_id = \wpl_property::get_blog_id($propertyId);
        $url = \wpl_items::get_folder($propertyId, 0, $blog_id);
        foreach ($items as $key => $item) {
            $url = $url . $item->item_name;
            if ($item->item_cat == 'external') {
                $url = $item->item_extra3;
            }
            $items[$key]->link = $url;
        }
        return $this->_getSimilar($property);
    }

    private function _getSimilar($property)
    {

        $similar_where = [
            'sf_select_confirmed' => 1, 'sf_select_finalized' => 1, 'sf_select_deleted' => 0, 'sf_select_expired' => 0,
            'sf_notselect_id' => $property['id'],
            'sf_select_kind' => $property['kind'],
            'sf_select_listing' => $property['listing'],
            'sf_select_property_type' => $property['property_type'],
        ];
        $model = new \wpl_property();
        $model->start(0, 5, 'p.id', 'DESC', $similar_where);
        $similar_properties = $model->search($model->query());
        $similar = [];
        $units = [];
        if(!empty($similar_properties)) {
            $plisting_fields = $model->get_plisting_fields();
            foreach ($similar_properties as $similar_property) {
                $property_info = $model->full_render($similar_property->id, $plisting_fields, $similar_property, ['wpltarget' => 0]);
                $price_formatted = $this->_formatPrice($property_info['materials']['price']);
                $image_item = '';
                if (!empty($property_info['items']['gallery'])) {
                    $image = $property_info['items']['gallery'][0];
                    $blog_id = \wpl_property::get_blog_id($similar_property->id);
                    $url = \wpl_items::get_folder($similar_property->id, $similar_property->kind, $blog_id);
                    if (!empty($image)) {
                        if ($image->item_cat == 'external') {
                            $image_item = $image->item_extra3;
                        } else {
                            $image_item = $url . $image->item_name;
                        }
                    }
                }
                $area_unit_id = $property_info['raw']['living_area_unit'];
                if (empty($units[$area_unit_id])) {
                    $units[$area_unit_id] = \wpl_units::get_unit($area_unit_id);
                }
                $price_unit_id = $property_info['data']['price_unit'];
                if (empty($units[$price_unit_id])) {
                    $units[$price_unit_id] = \wpl_units::get_unit($price_unit_id);
                }
                $similar[] = [
                    'id' => $similar_property->id,
                    'location_text' => $property_info['location_text'],
                    'property_title' => $property_info['property_title'],
                    "property_type_id" => $property_info['data']['property_type'],
                    "property_type_title" => $property_info['materials']['property_type']['value'],
                    "price" => $price_formatted,
                    "price_unit" => isset($units[$price_unit_id]) ? $units[$price_unit_id]['name'] : '',
                    "price_numeric" => $property_info['materials']['price']['raw'],
                    "listing_type" => $property_info['materials']['listing']['value'],
                    "show_address" => $property_info['raw']['show_address'] == '1',
                    "visit_time" => $property_info['raw']['visit_time'],
                    "rooms" => $property_info['raw']['rooms'],
                    "bedrooms" => $property_info['raw']['bedrooms'],
                    "bathrooms" => $property_info['raw']['bathrooms'],
                    "build_year" => $property_info['raw']['build_year'],
                    "living_area" => $property_info['raw']['living_area'],
                    "living_area_unit" => isset($units[$area_unit_id]) ? $units[$area_unit_id]['name'] : '',
                    "area" => isset($property_info['materials']['living_area']) ? $property_info['materials']['living_area']['value'] : '',
                    "image" => $image_item,
                ];
            }
        }
        return $similar;
    }

    private function _getNearby($property)
    {
        $lon = $property['googlemap_ln'];
        $lat = $property['googlemap_lt'];

        if (class_exists('wpl_sql_parser')) {
            $sqlParser = \wpl_sql_parser::getInstance();
            $sqlParser->enabled = false;
        }

        $distance_in_miles = '200';
        $query = "SELECT id, kind, (3959 * acos (cos ( radians($lat) ) * cos( radians( googlemap_lt ) ) * cos( radians( googlemap_ln ) - radians($lon) ) + sin ( radians($lat) ) * sin( radians( googlemap_lt ) ))) AS distance FROM `#__wpl_properties` where id != '{$property['id']}' and confirmed = 1 and finalized = 1 and deleted = 0 and expired = 0 HAVING distance < $distance_in_miles ORDER BY distance LIMIT 0 , 5;";

        $nearby_properties_raw = \wpl_db::select($query);

        $nearby_properties = [];
        if (!empty($nearby_properties_raw)) {
            $model = new \wpl_property();
            $plisting_fields = $model->get_plisting_fields();
            foreach ($nearby_properties_raw as $nearby_property) {
                $property_info = $model->full_render($nearby_property->id, $plisting_fields, null, ['wpltarget' => 0]);
                $price_formatted = $this->_formatPrice($property_info['materials']['price']);
                $image = $property_info['items']['gallery'][0];
                $image_item = '';
                $blog_id = \wpl_property::get_blog_id($nearby_property->id);
                $url = \wpl_items::get_folder($nearby_property->id, $nearby_property->kind, $blog_id);
                if (!empty($image)) {
                    if ($image->item_cat == 'external') {
                        $image_item = $image->item_extra3;
                    } else {
                        $image_item = $url . $image->item_name;
                    }
                }
                $nearby_properties[] = [
                    'id' => $nearby_property->id,
                    'location_text' => $property_info['location_text'],
                    'property_title' => $property_info['property_title'],
                    "property_type_id" => $property_info['data']['property_type'],
                    "property_type_title" => $property_info['materials']['property_type']['value'],
                    "price" => $price_formatted,
                    "price_numeric" => $property_info['materials']['price']['raw'],
                    "area" => isset($property_info['materials']['living_area']) ? $property_info['materials']['living_area']['value'] : '',
                    "image" => $image_item,
                    "distance" => intval($nearby_property->distance) . ' mi',
                ];
            }
        }
        return $nearby_properties;
    }

    private function _formatPrice($property_price)
    {

        $price = $property_price['raw'];
        $formatted = number_format($property_price['raw']);
        $price_unit = str_replace($formatted, '', $property_price['price_only']);
        if ($price_unit == $property_price['price_only']) {
            $price_unit = str_replace($price, '', $property_price['price_only']);
        }

        $price_formatted = $property_price['price_only'];

        if ($price >= 1000) {
            $p = floor($price / 1000);
            $p2 = floor((($price / 1000) - $p) * 1000);
            if ($p2 > 0) {
                $price_formatted = $price_unit . number_format($p . '.' . $p2, 1) . 'K';
            } else {
                $price_formatted = $price_unit . $p . 'K';
            }
        }
        if ($price >= 1000000) {
            $p = floor($price / 1000000);
            $p2 = floor((($price / 1000000) - $p) * 1000);
            if ($p2 > 0) {
                $price_formatted = $price_unit . number_format($p . '.' . $p2, 2) . 'M';
            } else {
                $price_formatted = $price_unit . $p . 'M';
            }
        }

        if (!empty($property_price['price_period'])) {
            $price_formatted .= ' ' . $property_price['price_period'];
        }
        return $price_formatted;
    }

    public function getTheImageProperty(\WP_REST_Request $request, $propertyId, $sizes = '150*150')
    {
        // Get the property image
        if (empty($sizes)) {
            $sizes = '150*150';
        }

        $image = \wpl_property::get_property_image($propertyId, $sizes);

        return $image;
    }

    public function getPropertyImage(\WP_REST_Request $request)
    {
        $property_id = $request->get_param('property_id');
        $sizes       = $request->get_param('sizes') ? $request->get_param('sizes') : '150*150';

        $image = \wpl_property::get_property_image($property_id, $sizes);

        return $image;
    }

    public function propertyVisitedAction(\WP_REST_Request $request)
    {
        $propertyId = $request->get_param('id');
        return \wpl_property::property_visited($propertyId);
    }

    public function getPropertyQRCodeAction(\WP_REST_Request $request)
    {

        _wpl_import('libraries.qrcode');

        $propertyId = $request->get_param('property_id');
        $outer_margin = $request->get_param('outer_margin');
        $outer_margin = !empty($outer_margin) ? $outer_margin : 2;
        $qrfile_prefix = $request->get_param('qrfile_prefix');
        $qrfile_prefix = !empty($qrfile_prefix) ? $qrfile_prefix : 'qr_';
        $size = $request->get_param('size');
        $size = (!empty($size) and in_array($size, array(1, 2, 3, 4, 5, 6, 7, 8, 9, 10))) ? $size : 4;

        $propertyLink = \wpl_property::get_property_link('', $propertyId);

        $file_name = $qrfile_prefix . md5($propertyLink) . '.png';
        $file_path = \wpl_global::get_upload_base_path() . 'qrcode' . DS . $file_name;

        if (!\wpl_file::exists($file_path)) {
            if (!\wpl_file::exists(dirname($file_path))) \wpl_folder::create(dirname($file_path));

            $QRcode = new \QRcode();
            $QRcode->png($propertyLink, $file_path, 'L', $size, $outer_margin);
        }

        return \wpl_global::get_upload_base_url() . 'qrcode/' . $file_name;
    }

    public function getKindAction(\WP_REST_Request $request)
    {

        $propertyId = $request->get_param('id');
        $property_kind = !empty($propertyId) ? \wpl_property::get_property_kind($propertyId) : '';
        if (is_null($property_kind)) return "Your property not found.";

        $query  = "SELECT `plural` FROM `#__wpl_kinds` WHERE `id` = '{$property_kind}'";
        $plural = \wpl_db::select($query, 'loadResult');

        return $plural;
    }

    public function getListingLinkAction()
    {
        $target_id = 0;
        if ($target_id) $url = \wpl_sef::get_page_link($target_id);
        else $url = \wpl_sef::get_wpl_permalink(true);

        return $url;
    }

    public function getLocationAction(\WP_REST_Request $request)
    {
        $type           = $request->get_param('type');
        $locations      = \wpl_db::select("SELECT `$type` FROM `#__wpl_properties`", 'loadAssocList');
        $location_list  = array();

        foreach ($locations as $locationkey => $location) {
            if ($location[$type] !== null) {
                $location_list[$location[$type]] = $location[$type];
            }
        }

        $location_list = array_unique($location_list);

        return $location_list;
    }

    public function getPropertiesCountAction(\WP_REST_Request $request)
    {
        $attributes = $request->get_param('attributes');
        $extraAttributes = array('sf_select_confirmed' => 1, 'sf_select_finalized' => 1, 'sf_select_deleted' => 0, 'sf_select_expired' => 0, 'sf_select_kind' => 0);
        $attributes = array_merge($attributes, $extraAttributes);
        $where = \wpl_db::create_query($attributes);

        $query = "SELECT COUNT(*) AS count FROM `#__wpl_properties` WHERE 1 " . $where;

        return \wpl_db::select($query, 'loadResult');
    }
}
