<?php


namespace Api\Wpl\routes\api;

use Api\Wpl\models\imported\Email\Email;
use Api\Wpl\models\imported\Notifications\CronManager;
use \Firebase\JWT\JWT;

class FlexApi extends Api
{
    public function listingTypesAction()
    {
        $listingTypes = \wpl_global::get_listings();
        $return = [];
        foreach ($listingTypes as $type) {
            $return[] = [
                'id' => $type['id'],
                'parent' => $type['parent'],
                'name' => __($type['name'], 'wpl-api')
            ];
        }
        return [
            'types' => $return,
        ];
    }
    public function propertyTypesAction()
    {
        $propertyTypes = \wpl_global::get_property_types();
        $return = [];
        foreach ($propertyTypes as $type) {
            $return[] = [
                'id' => $type['id'],
                'name' => __($type['name'], 'wpl-api')
            ];
        }
        return [
            'types' => $return,
        ];
    }

    public function getFlexFieldsAction(\WP_REST_Request $request) {
        $kind = $request['kind'];
        $type = $request['type'];
        $tags = \wpl_flex::get_fields(NULL, NULL, NULL, NULL, NULL, "AND `type`='$type' AND `enabled`>='1' AND `kind`='$kind'");

        if ($type == 'tag') {
            $conditions = array('sf_select_confirmed' => 1, 'sf_select_finalized' => 1, 'sf_select_deleted' => 0, 'sf_select_expired' => 0, 'sf_select_kind' => $kind);
            $where = \wpl_db::create_query($conditions);

            foreach ($tags as $tag) {
                $query = "SELECT COUNT(`id`) FROM `#__wpl_properties` WHERE 1 " . $where . " AND `" . $tag->table_column . "`='1'";
                $tags[$tag->id]->count = \wpl_db::select($query, 'loadResult');
            }
        }

        return $tags;
    }

    public function getFieldsAction($id)
    {
        $kind = 0;
        $property = \wpl_property::get_property_raw_data($id);
        $categories = \wpl_flex::get_categories(1, $kind);
        $return = [];
        $items = [];
        if (!empty($id)) {
            $items = \wpl_items::get_items($property['id'], '', $property['kind'], '', 1);
        }

        foreach ($categories as $category) {
            if (in_array($category->id, [9, 11, 31])) {
                continue;
            }
            $fields = \wpl_property::get_pwizard_fields($category->id, $kind, 1);
            if (!empty($fields)) {
                $filtered = [];
                foreach ($fields as $field) {
                    if ($field->id >= 3000) {
                        continue;
                    }
                    if (in_array($field->id, [4, 5, 310, 311, 312, 405, 171, 41, 42, 43, 45, 51, 52, 56, 57])) {
                        continue;
                    }

                    if (in_array($field->table_column, ['shared'])) {
                        continue;
                    }
                    if ($field->type == 'separator') {
                        continue;
                    }
                    $units = [];
                    if (in_array($field->type, array('price', 'volume', 'area', 'length'))) {
                        if ($field->type == 'price') $units = \wpl_units::get_units(4, 1, " AND `type`='4' AND `enabled`>='1'");
                        if ($field->type == 'volume') $units = \wpl_units::get_units(3, 1, " AND `type`='3' AND `enabled`>='1'");
                        if ($field->type == 'area') $units = \wpl_units::get_units(2, 1, " AND `type`='2' AND `enabled`>='1'");
                        if ($field->type == 'length') $units = \wpl_units::get_units(1, 1, " AND `type`='1' AND `enabled`>='1'");
                    }
                    $filteredUnits = [];
                    foreach ($units as $unit) {
                        $filteredUnits[] = [
                            'id' => $unit['id'],
                            'name' => $unit['name'],
                            'add_before' => empty($unit['add_before']) ? false : true,
                        ];
                    }
                    if ($field->type == 'rooms') {
                        $rooms = \wpl_room_types::get_room_types();
                        $field->options = ['values' => []];
                        foreach ($rooms as $room) {
                            $field->options['values'][] = [
                                'key' => $room['id'],
                                'value' => $room['name'],
                                'enabled' => $room['enabled'],
                            ];
                        }
                    }
                    $field->options = is_array($field->options) ? $field->options : json_decode($field->options ?? '', true);
                    if (in_array($field->type, ['textarea']) || array_key_exists('if_zero', $field->options)) {
                        $field->options = null;
                    }
                    if (in_array($field->type, ['select'])) {
                        $field->options = [
                            'values' => array_values($field->options['params']),
                        ];
                    }
                    if ($field->type == 'listings') {
                        $listings = \wpl_global::get_listings();
                        $field->options = ['values' => []];
                        foreach ($listings as $listing) {
                            $field->options['values'][] = [
                                'value' => __($listing['name'], 'real-estate-listing-realtyna-wpl'),
                                'key' => $listing['id'],
                            ];
                        }
                    }
                    if ($field->type == 'property_types') {
                        $property_types = \wpl_global::get_property_types();
                        $field->options = ['values' => []];
                        foreach ($property_types as $property_type) {
                            $field->options['values'][] = [
                                'value' => __($property_type['name'], 'real-estate-listing-realtyna-wpl'),
                                'key' => $property_type['id'],
                            ];
                        }
                    }
                    if ($field->type == 'feature') {
                        $field->options['values'] = array_values($field->options['values']);
                    }
                    $value = $property[$field->table_column];
                    if ($field->id == 53) {
                        $value = $property['googlemap_lt'] . ',' . $property['googlemap_ln'];
                    }
                    $gallery = [];
                    if ($field->id == 300 && !empty($items['gallery'])) {
                        $base = wp_upload_dir();
                        $url = $base['baseurl'] . '/WPL/' . $property['id'] . '/';
                        foreach ($items['gallery'] as $image) {
                            $image_url = $url . $image->item_name;
                            if ($image->item_cat == 'external') {
                                $image_url = $image->item_extra3;
                            }
                            $gallery[] = array(
                                'type' => 'image',
                                'title' => $image->item_name,
                                'url' => $image_url,
                            );
                        }
                        foreach ($items['video'] as $video) {
                            $re = '/src(.*)(?<link>http([^ \'"]*))/m';
                            $str = $video->item_extra2;
                            preg_match_all($re, $str, $matches, PREG_SET_ORDER, 0);
                            $gallery[] = array(
                                'type' => 'video',
                                'title' => $video->item_name,
                                'url' => $matches[0]['link'],
                            );
                        }
                    }
                    /*if($field->id == 567 && !empty($items['video'])){

                    }*/
                    if(array_key_exists('values' , $field->options) && empty($field->options['values'])) {
                        $field->options['values'] = [];
                    }
                    $filtered[] = [
                        'id' => $field->id,
                        'mandatory' => $field->mandatory,
                        'name' => $field->name,
                        'type' => $field->type,
                        'units' => $filteredUnits,
                        'options' => $field->options ? $field->options : (object) null,
                        'table_name' => $field->table_name,
                        'table_column' => $field->table_column,
                        'listing_specific' => $field->listing_specific,
                        'property_type_specific' => $field->property_type_specific,
                        'value' => $value,
                        'value_unit' => $property[$field->table_column . '_unit'] == null ? '' : $property[$field->table_column . '_unit'],
                        'gallery' => $gallery,
                    ];
                }
                $return[] = [
                    'category' => $category,
                    'fields' => $filtered,
                ];
            }

        }
        return $return;
    }

    public function sortOptionsAction()
    {
        $sortQuery = "SELECT * FROM #__wpl_sort_options as sort ";
        $sortQuery .= "WHERE sort.enabled >= 1 AND sort.kind LIKE '%[0]%' ORDER BY sort.index ASC";
        $sortOptions = \wpl_db::select($sortQuery);
        if (!$sortOptions) {
            throw new \Exception('No Sort Options could be found.');
        }
        $types = array();
        //take types one by one
        foreach ($sortOptions as $type) {
            $types['options'][] = ['id' => $type->field_name, 'name' => __($type->name, 'wpl-api')];
        }
        return $types;
    }

    public function listCurrencyAction()
    {
        global $wpdb;
        $res = $wpdb->get_results("SELECT * FROM `{$wpdb->base_prefix}wpl_units` WHERE `type` = 4 and enabled = 1;", ARRAY_A);
        $ret = array('success' => true, 'data' => $res);
        return $ret;
    }

    public function listAreaUnitAction()
    {
        global $wpdb;
        $res = $wpdb->get_results("SELECT * FROM `{$wpdb->base_prefix}wpl_units` WHERE `type` = 2;", ARRAY_A);

        foreach ($res as $k => $item) {
            $res[$k]['name'] = __(html_entity_decode($item['name']), 'wpl-api');
        }

        $ret = array('success' => true, 'data' => $res);
        return $ret;
    }

    public function getFilterFieldsAction()
    {
        global $wpdb;
        $res = $wpdb->get_results("SELECT * FROM `{$wpdb->base_prefix}wpl_dbst` WHERE 1 AND `enabled`>='1' AND `kind`='0' AND `type` IN ('select','feature','text','number','area','length','price','boolean','checkbox') AND `table_column`!='' ORDER BY `category` ASC, `index` ASC", OBJECT_K);

        return $res;
    }

    public function getFilterFieldsOptionsAction(\WP_REST_Request $request)
    {
        $id = $request['id'];

        $field = (array) \wpl_flex::get_field($id);

        $data = array();
        $data['field'] = $field;
        $data['operators'] = array();
        $data['options'] = array();

        if (isset($field['type']) && in_array($field['type'], array('select', 'feature'))) {
            $data['operators'] = array(array('name' => __('Include', 'wpl-api'), 'key' => 'sf_multiple_' . $field['table_column']), array('name' => __('Exclude', 'wpl-api'), 'key' => 'sf_notmultiple_' . $field['table_column']));

            $options = json_decode($field['options'] ?? '', true);
            $params = array();

            if ($field['type'] == 'select') {
                foreach ($options['params'] as $param) $params[] = array('key' => $param['key'], 'name' => __($param['value'], 'wpl-api'));
            } elseif ($field['type'] == 'feature') {
                if (isset($options['values'])) foreach ($options['values'] as $param) $params[] = array('key' => $param['key'], 'name' => __($param['value'], 'wpl-api'));

                if (count($params)) $data['operators'] = array(array('name' => __('Include', 'wpl-api'), 'key' => 'sf_feature_' . $field['table_column']));
                else $data['operators'] = array(array('name' => __('Select', 'wpl-api'), 'key' => 'sf_select_' . $field['table_column']));
            }

            $data['options'] = $params;
        } elseif (isset($field['type']) && in_array($field['type'], array('number', 'area', 'price', 'length', 'volume'))) $data['operators'] = array(array('name' => __('Greater', 'wpl-api'), 'key' => 'sf_tmin_' . $field['table_column']), array('name' => __('Smaller', 'wpl-api'), 'key' => 'sf_tmax_' . $field['table_column']), array('name' => __('Include', 'wpl-api'), 'key' => 'sf_multiple_' . $field['table_column']), array('name' => __('Exclude', 'wpl-api'), 'key' => 'sf_notmultiple_' . $field['table_column']));
        else isset($field['table_column']) && $data['operators'] = array(array('name' => __('Contains', 'wpl-api'), 'key' => 'sf_text_' . $field['table_column']), array('name' => __('Include', 'wpl-api'), 'key' => 'sf_multiple_' . $field['table_column']), array('name' => __('Exclude', 'wpl-api'), 'key' => 'sf_notmultiple_' . $field['table_column']), array('name' => __('Exactly', 'wpl-api'), 'key' => 'sf_select_' . $field['table_column']));

        return $data;
    }

    public function getUserFieldsAction()
    {
        return \wpl_flex::get_fields(null, 1, 2);
    }

    public function getSortOptionsAction(\WP_REST_Request $request)
    {
        _wpl_import('libraries.sort_options');
        $kind = $request->get_param('kind');

        return \wpl_sort_options::render(\wpl_sort_options::get_sort_options($kind));
    }
}
