<?php


namespace Api\Wpl\routes\api;


use Api\Wpl\routes\libs\AuthRequired;

class FavoriteApi extends Api
{

    public function addFavoriteAction(AuthRequired $auth, int $listing_id)
    {
        $result = $this->addOrRemove($auth->getUserId(), $listing_id, 'add');
        if (!$result) {
            throw new \Exception('Error occurred.');
        }
        return array(
            'message' => __('Property added in favorite list successfully.', 'wpl-api')
        );
    }

    public function removeFavoriteAction(AuthRequired $auth, int $listing_id)
    {
        $result = $this->addOrRemove($auth->getUserId(), $listing_id, 'remove');
        if (!$result) {
            throw new \Exception('Error occurred.');
        }
        return array(
            'message' => __('The listing is removed from Favorites successfully.', 'wpl-api')
        );
    }

    private function addOrRemove($user_id, $listing_id, $mode)
    {
        $user = \wpl_users::get_user_by('id', $user_id);
        if (!$user) {
            throw new \Exception('User id does not exist.');
        }
        return \wpl_addon_pro::favorite_add_remove($listing_id, $mode, $user_id);
    }

    public function favoriteListAction(AuthRequired $auth, \WP_REST_Request $request)
    {
        $pids = \wpl_addon_pro::favorite_get_pids(false, $auth->getUserId());
        if (empty($pids)) {
            return ['properties' => []];
        }
        $_POST['sf_multiple_id'] = implode(',', $pids);
        return (new PropertiesApi())->getListProperties($auth, $request, true);
    }

    public function favoriteGetPidsAction(\WP_REST_Request $request)
    {
        $user_id = $request['id'];
        $pids = \wpl_addon_pro::favorite_get_pids(false, $user_id);

        if (empty($pids)) {
            return [];
        }

        return $pids;
    }

    public function compareListAction()
    {
        _wpl_import('views.frontend.addon_pro.wpl_compare_input');

        $property_title = 'field_313';

        // Compare Kind
        $kind       = \wpl_compare_input::get_kind();
        $properties = \wpl_addon_pro::compare_get_properties(null, $kind);

        $minimal_fields = \wpl_addon_pro::compare_get_minimal_fields($properties, array(), $kind);
        if (!is_array($minimal_fields)) $minimal_fields = array();

        $categorized_fields = \wpl_addon_pro::compare_get_fields(true, $minimal_fields, $kind);
        $compare_rendered   = \wpl_addon_pro::compare_render($properties, $minimal_fields);

        $fields         = $categorized_fields;
        $properties     = $properties;
        $values         = $compare_rendered->values;
        $compare_row    = $compare_rendered->compare_row;

        $fields_list = array_map(array($this, '_map_table_column'), $minimal_fields);

        return array(
            'compare_row'               => $compare_row,
            'fields'                    => $fields,
            'values'                    => $values,
            'properties'                => $properties,
            'property_title'            => $property_title,
            'fields_list'               => $fields_list,
        );
    }

    public function isFavoriteFindAction(\WP_REST_Request $request)
    {
        $pid = $request['id'];
        $favorites = \wpl_addon_pro::favorite_get_pids();
        $find_favorite_item = in_array($pid, $favorites);

        return $find_favorite_item;
    }

    public static function isFavorite($propertyId, $userId)
    {
        if (empty($propertyId) or empty($userId)) {
            return false;
        }
        $favorite = \wpl_db::select("SELECT property_id FROM #__wpl_addon_pro_favorites WHERE user_id = $userId and property_id = $propertyId", 'loadObject');
        if (!empty($favorite)) {
            return true;
        }
        return false;
    }

    private function _map_table_column($element)
    {
        if (isset($element->table_column)) return $element->table_column;
        return NULL;
    }
}
