<?php

namespace Api\Wpl\models\imported\Twilio;

class Twilio {

    /**
     * Adds the Twilio Settings into the option table
     * @param $request
     */
    static public function save($request) {
        $settings = new Settings();
        $settings->setAccountSID($request->get_param('AccountSID'));
        $settings->setTokenID($request->get_param('TokenID'));
        $settings->setSenderNumber($request->get_param('SenderNumber'));
        $settings->save();
    }

    /**
     * Deletes the twilio settings into the option table
     */
    static public function delete() {
        $settings = new Settings();
        $settings->delete();
    }

    /**
     * Get The sms Settings from option table
     */
    static public function getSettings() {

        $settings = get_option('wpl_api_sms_settings');
        ($settings)
            ? wp_send_json_success($settings)
            : wp_send_json_error(array('message' => 'First you should add sms settings.'));
    }
}