<?php

namespace Api\Wpl\models\imported\Map;

class Map {

    /**
     * Save the map settings into the option table
     * @param $request
     */
    static public function saveMapSettings($request) {

        $mapSettings = new Settings();
        $mapSettings->setLatitude( $request->get_param('latitude'));
        $mapSettings->setLongitude( $request->get_param('longitude'));
        $mapSettings->setZoom( $request->get_param('zoom'));
        $mapSettings->save();
    }

    /**
     *  Get the map settings from option table
     */
    static public function getMapSetting() {

        $settings = get_option('wpl_api_map_options');
        ($settings)
            ? wp_send_json_success($settings)
            : wp_send_json_error(array('message' => 'First you should save map settings.'));
    }
}