<?php

namespace Api\Wpl\models\core\User;

use Api\Wpl\models\imported\Twilio\Sms;

class UserPasswordReset {

    /**
     * @var string
     */
    private $phone;

    /**
     * @var string
     */
    private $email;

    public function __construct(array $request) {
        $this->phone = $request['phone'];
        $this->email = $request['email'];
    }

    public function validateEmail() {
        if (email_exists($this->email) == false ) {
            wp_send_json_error(array(
                'message' => __('Some or all of required filed entries are invalid.', 'wpl-api')
            ));
        }
    }

    public function validatePhoneNumbers() {

        if ($this->getUserPhoneNumber() == false ||
            $this->getUserPhoneNumber() != $this->phone
        ) {
            wp_send_json_error(array(
                'message' => __('Phone number is wrong.', 'wpl-api')
            ));
        }
    }

    public function sendSmsCode() {
        
        $sms = new Sms();
        $sms->SetUserId($this->getUserIdByEmail());
        $sms->SetPhoneNumber($this->phone);

        $data = array(
            'sms_code' => substr(uniqid(rand(), true), 4, 4),
            'user_id'  => $this->getUserIdByEmail()
        );

        if(add_option( "sms_code_{$this->getUserIdByEmail()}", $data, '', 'yes')) {
            $sms->send();
        } else {
            delete_option("sms_code_{$this->getUserIdByEmail()}");
        }
    }
    
    public function sendEmailCode() {
        $data = array(
            'sms_code' => substr(uniqid(rand(), true), 4, 4),
            'user_id'  => $this->getUserIdByEmail()
        );

        if(add_option( "sms_code_{$this->getUserIdByEmail()}", $data, '', 'yes')) {
            $to = $this->email;
            $subject = 'Reset Password';
            $body = 'Your code is '.$data['sms_code'];
            $headers = array('Content-Type: text/html; charset=UTF-8');
             
            wp_mail( $to, $subject, $body, $headers );
            wp_send_json_success(array(
                'message' => 'Code has been sent successfully.'
            ));
        } else {
            delete_option("sms_code_{$this->getUserIdByEmail()}");
            wp_send_json_error(array(
                'message' => 'Sending the code has been failed.'
            ));
        }
    }

    public function updatePassword() {

        wp_set_password( $request->get_param('password'), $user->ID);
        // delete sms code
        delete_option("sms_code_{$user->ID}");
        wp_send_json_success(array(
            'message' => __('Password changed successfully.', 'wpl-api')
        ));
    }

    protected function getUserPhoneNumber() {
        return (get_user_meta($this->getUserIdByEmail(), 'phone_number', true))
            ? get_user_meta($this->getUserIdByEmail(), 'phone_number', true)
            : false;
    }

    protected function getUserIdByEmail() {
        $user = get_user_by( 'email', $this->email );
        return $user->ID;
    }
}