<?php

namespace Api\Wpl\models\core\User;

class UserMapper {

    /**
     * @var array
     */
    private $data = [];

    public function __construct(array $data) {
        $this->data = $data;
    }

    public function validateEmail() {

        if ( email_exists($this->data['email']) ) {
            // Stuff to do when email address exists
            wp_send_json_error(array(
                'message' => __('The Email is already registered. Try a different Email address.', 'wpl-api')
            ));
        }
    }

    public function createUser() {
        $membership_id = -1;
        $user_type = 3;
        $email = $this->data['email'];
        $username = $this->data['username'];
        $first_name = $this->data['first_name'];
        $last_name = $this->data['last_name'];
        $mobile = '';

        if(\wpl_users::username_exists($username)) {
            wp_send_json_error(array(
                'message' => __('Username already exists.', 'wpl-api')
            ));
            return;
        }
        if(\wpl_users::email_exists($email)) {
            wp_send_json_error(array(
                'message' => __('Email exists.', 'wpl-api')
            ));
            return;
        }
        $errors = new \WP_Error();

        /**
         * Fires before errors are returned from a register request.
         */
        do_action('register_post', $username, $email, $errors);

        if($errors->get_error_code()) {
            wp_send_json_error(array(
                'message' => $errors->get_error_message()
            ));
            return;
        }

        $membership_data = \wpl_users::get_membership($membership_id);
        $user_type_data = \wpl_users::get_user_type($user_type);
        $password = \wpl_global::generate_password(8);
        $result = \wpl_users::insert_user(array('user_login'=>$username, 'user_email'=>$email, 'user_pass'=>$password, 'first_name'=>$first_name, 'last_name'=>$last_name));
        if(is_wp_error($result))
        {
            wp_send_json_error(array(
                'message' => __($result->get_error_message(), 'wpl-api')
            ));
            return;
        }

        $user_id = $result;

        // Trigger event for sending notification
        \wpl_events::trigger('user_registered', array('password'=>$password, 'user_id'=>$user_id, 'mobile'=>$mobile));

        // If default membership is paid don't assign user to that membership
        $default_membership_id = !trim($membership_data->maccess_price ?? '') ? $membership_id : $user_type_data->default_membership_id;

        $default_membership_data = \wpl_users::get_membership($default_membership_id);
        if(trim($default_membership_data->maccess_price ?? '')) $default_membership_id = -1;

        // change membership of user to default membership
        \wpl_users::change_membership($user_id, $default_membership_id);

        // Update User
        \wpl_users::update('wpl_users', $user_id, 'mobile', $mobile);

        // Trigger event
        \wpl_events::trigger('after_user_registered', array('id'=>$user_id));

        wp_send_json_success(array(
            'message' => __('User registered. Please check your email for password.', 'wpl-api')
        ));
    }
}