<?php

namespace Api\Wpl\models\core\Properties;

use Api\Wpl\models\core\Database\Database;
use Api\Wpl\models\AbstractModel;

class PropertiesSaveSearch extends AbstractModel {

    /**
     * Set the User Id
     * @param $userId
     * @return $this
     */
    public function SetUserId($userId) {
        $this->UserId = $userId;
        return $this;
    }

    /**
     * Get the User Id
     * @return mixed
     */
    public function GetUserId() {
        return $this->UserId;
    }

    /**
     * Set the zomm level
     * @param $zoom
     */
    public function SetZoom($zoom) {
        $this->zoom = $zoom;
    }

    /**
     * Get the zoom level
     * @return mixed
     */
    public function GetZoom() {
        return $this->zoom;
    }

    /**
     * Set the save search name
     * @param $name
     * @return $this
     */
    public function SetSearchName($name) {
        $this->name = $name;
        return $this;
    }

    /**
     * Get the Save Search name
     * @return mixed
     */
    public function GetSearchName() {
        return $this->name;
    }

    /**
     * Set the Latitude
     * @param $latitude
     * @return $this
     */
    public function SetLatitude($latitude) {
        $this->latitude = $latitude;
        return $this;
    }

    /**
     * Get the Latitude
     * @return mixed
     */
    public function GetLatitude() {
        return $this->latitude;
    }

    /**
     * Set the Longitude
     * @param $longitude
     * @return $this
     */
    public function SetLongitude($longitude) {
        $this->longitude = $longitude;
        return $this;
    }
    public function SetCriteria($criteria) {
        $this->criteria = $criteria;
        return $this;
    }
    public function GetCriteria() {
        return $this->criteria;
    }

    /**
     * Get the Longitude
     * @return mixed
     */
    public function GetLongitude() {
        return $this->longitude;
    }

    /**
     * Add the Save search into the option table
     */
    public function add() {

        if ( $this->isUserValid() != false ) {
            //user id exists
            $data = array(
                'user_id'   => $this->GetUserId(),
                'zoom'      => $this->GetZoom(),
                'name'      => $this->GetSearchName(),
                'latitude'  => $this->GetLatitude(),
                'longitude' => $this->GetLongitude(),
                'criteria' => $this->GetCriteria(),
            );
            $status = add_option(
                "wpl_api_save_search.{$this->GetUserId()}.{$this->GetSearchName()}",
                $data,
                '',
                'yes'
            );
            ($status == true)
                ? wp_send_json_success(array(
                    'message' => __('The search is saved successfully.', 'wpl-api')
                ))
                : AbstractModel::respondError(sprintf(
                    __('The entered name %s already exists.', 'wpl-api'), $this->GetSearchName()
                ));
        }
        AbstractModel::respondError(__('User id does not exist.', 'wpl-api') );
    }

    /**
     * Deletes the save search into the option table
     */
    public function delete() {

        if ( $this->isUserValid() != false ) {
            // delete option by userId and Save Search Name
            $status = delete_option(
                "wpl_api_save_search.{$this->GetUserId()}.{$this->GetSearchName()}"
            );
            ($status == true)
                ? wp_send_json_success(array(
                    'message' => __('Saved search is removed successfully.', 'wpl-api')
                ))
                : AbstractModel::respondError(
                    __('Save search could be found.', 'wpl-api')
                );
        }
        AbstractModel::respondError(__('User id does not exist.', 'wpl-api'));
    }

    /**
     * Get the list of save search
     */
    public function searchList() {

        if ( $this->isUserValid() != false ) {
            
            $query  = "SELECT option_value FROM {$this->wpdb->prefix}options ";
            $query .= "WHERE option_name LIKE ?";

            $save_searches = Database::getRows($query, array(
                "wpl_api_save_search.{$this->GetUserId()}%"
            ));

            if ($save_searches != false) {
                // removing slashes
                $values = stripslashes_deep($save_searches);
                $response = array();
                foreach ($values as $key => $value) {
                    // we should now have the serialized data in $value['option_value'].
                    $data = unserialize($value['option_value']);
                    // create array
                    $response [] = array(
                        'name'      => $data['name'],
                        'zoom'      => $data['zoom'],
                        'latitude'  => $data['latitude'],
                        'longitude' => $data['longitude'],
                        'criteria' => $data['criteria'] ? json_decode($data['criteria'] ?? '', true) : '',
                    );
                    // check if value is null
                    if (is_null($response[$key]['name'])) {
                        unset($response[$key]);
                    }
                }
                // check if a variable is set
                isset($response)
                    ? wp_send_json_success($response)
                    : AbstractModel::respondError(
                        __('No property could be found.', 'wpl-api')
                );
            }
            AbstractModel::respondError(__('No property could be found.', 'wpl-api'));
        }
        AbstractModel::respondError(__('User id does not exist.', 'wpl-api'));
    }

    /**
     * Check if the user Id is valid
     * @return bool
     */
    protected function isUserValid() {
        $user = get_userdata($this->GetUserId());
        return ($user) ? true : false;
    }
}