<?php

namespace Api\Wpl\models\core\Properties;

class PropertiesMapper {

	/**
	 * @var string
	 */
	protected $listing_type;

	/**
	 * @var string
	 */
	protected $property_type;

	/**
	 * @var string
	 */
	protected $listing_id;

	/**
     * @var string
     */
    protected $mls_id;

	/**
	 * @var string
	 */
	protected $description;

	/**
	 * @var string
	 */
	protected $price;

	/**
	 * @var
	 */
	protected $price_unit;

	/**
	 * @var string
	 */
	protected $price_period = null;

	/**
	 * @var float
	 */
	protected $bedrooms;

	/**
	 * @var float
	 */
	protected $bathrooms;

	/**
	 * @var float
	 */
	protected $half_bathrooms = null;

	/**
	 * @var float
	 */
	protected $square_footage = null;

	/**
	 * @var string
	 */
	protected $square_footage_unit = null;

	/**
	 * @var float
	 */
	protected $lot_area;

	/**
	 * @var string
	 */
	protected $lot_area_unit;

	/**
	 * @var int
	 */
	protected $year_built = null;

	/**
	 * @var array
	 */
	protected $address = array();

	/**
	 * @var array
	 */
	protected $features = array();
	
	/**
	 * @var array
	 */
	protected $appliances = array();
	
	/**
	 * @var array
	 */
	protected $neighborhoods = array();

	/**
	 * @var array
	 */
	protected $image = array();

	/**
	 * Allow to quickly define values with constructor
	 *
	 * @param array $data
	 *
	 * @return void
	 */
	public function __construct( array $data ) {
		$this->listing_type        = $data['listing_type'];
		$this->property_type       = $data['property_type'];
		$this->description         = $data['description'];
		$this->price               = $data['price'];
		$this->price_unit          = $data['price_unit'];
		$this->price_period        = $data['price_period'];
		$this->bedrooms            = $data['bedrooms'];
		$this->bathrooms           = $data['bathrooms'];
		$this->half_bathrooms      = $data['half_bathrooms'];
		$this->square_footage      = $data['square_footage'];
		$this->square_footage_unit = $data['square_footage_unit'];
		$this->lot_area            = $data['lot_area'];
		$this->lot_area_unit       = $data['lot_area_unit'];
		$this->year_built          = empty($data['year_built']) ? 0 : $data['year_built'];
		$this->address             = $data['address'];
		$this->image               = $data['image'];
		$this->features            = $data['features'];
		$this->appliances          = explode(',',$data['appliances']);
		$this->neighborhoods       = explode(',',$data['neighborhoods']);
		$this->listing_id          = $data['listing_id'];
		$this->mls_id              = $data['mls_id'];
	}

	/**
	 * @return string
	 */
	public function getListingType() {
		return $this->listing_type;
	}

	/**
	 * @return string
	 */
	public function getPropertyType() {
		return $this->property_type;
	}

	/**
	 * @return string
	 */
	public function getListingId() {
		return $this->listing_id;
	}

	/**
     * @return string
     */
    public function getMlsId(){
        return $this->mls_id;
    }

	/**
	 * @return string
	 */
	public function getDescription() {
		return $this->description;
	}

	/**
	 * @return string
	 */
	public function getPrice() {
		return $this->price;
	}

	/**
	 * @return string
	 */
	public function getPriceUnit() {
		return $this->price_unit;
	}

	/**
	 * @return string
	 */
	public function getPricePeriod() {
		return $this->price_period;
	}

	/**
	 * @return float
	 */
	public function getBedrooms() {
		return $this->bedrooms;
	}

	/**
	 * @return float
	 */
	public function getBathrooms() {
		return $this->bathrooms;
	}

	/**
	 * @return float
	 */
	public function getHalfBathrooms() {
		return $this->half_bathrooms;
	}

	/**
	 * @return float|mixed
	 */
	public function getSquareFootage() {
		return $this->square_footage;
	}

	/**
	 * @return mixed|string
	 */
	public function getSquareFootageUnit() {
		return $this->square_footage_unit;
	}

	/**
	 * @return float
	 */
	public function getLotArea() {
		return $this->lot_area;
	}

	/**
	 * @return string
	 */
	public function getLotAreaUnit() {
		return $this->lot_area_unit;
	}

	/**
	 * @return int|mixed
	 */
	public function getYearBuilt() {
		return $this->year_built;
	}

	/**
	 * @return array
	 */
	public function getAddress() {
		return $this->address;
	}

	/**
	 * @return array
	 */
	public function getImage() {
		return $this->image;
	}

	/**
	 * @return array|mixed
	 */
	public function getFeatures() {
		return $this->features;
	}
	
	/**
	 * @return array|mixed
	 */
	public function getAppliances() {
		return $this->appliances;
	}
	
	/**
	 * @return array|mixed
	 */
	public function getNeighborhoods() {
		return $this->neighborhoods;
	}

}