<?php

namespace Api\Wpl\models\core\Properties;

use Api\Wpl\models\AbstractModel;
use Api\Wpl\models\core\Database\Database;

class PropertiesListFavorite extends AbstractModel {

    /**
     * Get the Target Table Name
     * @return string
     */
    public function getTargetTableName() {
        return "wpl_properties";
    }

    /**
     * Set the User ID
     * @param $UserId
     * @return $this
     */
    public function SetUserId($UserId) {
        $this->UserId = $UserId;
        return $this;
    }

    /**
     * Get The User ID
     * @return int
     */
    public function GetUserId() {
        return $this->UserId;
    }

    /**
     * Set The page value
     * @param $page
     * @return $this
     */
    public function SetPage($page) {
        $this->page = $page;
        return $this;
    }

    /**
     * Get The Page value
     * @return int
     */
    public function GetPage() {
        return $this->page;
    }

    /**
     * Set the Properties Id
     * @param $PropertyIds
     * @return $this
     */
    public function SetList($list) {
        $this->list = $list;
        return $this;
    }

    /**
     * Get The Where condition
     */
    public function GetWhere() {
        return "id IN (".$this->GetPropertiesId().")";
    }

    /**
     * @return PropertiesListFavorite
     */
    public function GetByUserId() {
        $list = Database::getRows(
            "SELECT property_id
               FROM {$this->wpdb->base_prefix}wpl_addon_pro_favorites 
             WHERE user_id = ?", array(
                 $this->GetUserId()
            )
        );
        return $this->SetList($list);
    }

    /**
     * Get the list of Properties Id
     * @return string
     */
    protected function GetPropertiesId() {
        if ($this->list) {
            $list = array_map(function($row) {
                return $row['property_id'];
            }, $this->list);
            return (isset($list))
                ? implode(",", $list)
                : AbstractModel::respondError(
                    __('No property could be found.', 'wpl-api')
                );
        }
        AbstractModel::respondError(
            __('No property could be found.', 'wpl-api')
        );
    }
}