<?php

namespace Api\Wpl\models\core\Properties;

use Api\Wpl\models\core\Database\Database;
use Api\Wpl\models\AbstractModel;

class PropertiesImages extends AbstractModel {
	
    /**  @var string Image Type */
    protected $itemType = 'gallery';

    /** @var string */
    protected $type = 'external';
	
	/**
	 * Get an array containing the current upload directory’s path and url.
	 */
	protected function GetBaseUrl() {
		$base = wp_upload_dir();
		return $base['baseurl'];
	}
	
	/**
	 * Set The Item Category
	 * @param $cat
	 * @return $this
	 */
	protected function SetItemCategory($cat) {
		$this->ItemCategory = $cat;
		return $this;
	}
	
	/**
	 * Set The external image url
	 * @param $url
	 */
	protected function SetExternalImage($url) {
		$this->ExtraImgUrl = $url;
		return $this;
	}
	
	/**
	 * Set the Image name
	 * @param $image
	 * @return $this
	 */
	protected function SetImage($image) {
		$this->image = $image;
		return $this;
	}
	
	/**
	 * Set The Property Id
	 * @param $listingId
	 * @return $this
	 */
    public function SetListingId($listingId) {
    	$this->id = $listingId;
    	return $this;
    }

    /**
     * Set The images count
     * @param $count
     * @return $this
     */
    public function SetImagesCount($count) {
        $this->count = $count;
        return $this;
    }

    /**
     * Get the image by listing Id
     * @return array
     */
    public function GetImageByListingId() {
    	
        $query  = "SELECT * FROM {$this->wpdb->base_prefix}wpl_items ";
        $query .= "WHERE parent_id = ? AND item_type = ? ";
        $query .= "ORDER BY id ASC";

        $image = Database::getRow($query,
            array(
	            $this->id,
                $this->itemType
            )
        );

        $this->SetItemCategory($image['item_cat']);
        $this->SetExternalImage($image['item_extra3']);
        $this->SetImage($image['item_name']);
        
        if (false == $this->image) {
	        return array();
        }

        if ($this->ItemCategory == $this->type) {
	        return array($this->ExtraImgUrl);
        }

        return array(
        	$this->GetBaseUrl().'/WPL/'.$this->id.'/'.$this->image
        );
    }

    /**
     * Get The images by listing Id
     * @return array
     */
    public function GetImagesByListingId() {
    	
        $query  = "SELECT * FROM {$this->wpdb->base_prefix}wpl_items ";
        $query .= "WHERE parent_id = ? AND item_type = ? AND enabled = ?";
        $query .= "ORDER BY id ASC LIMIT {$this->count}";

        $response = Database::getRows($query,
            array(
	            $this->id,
                $this->itemType,
                1
            )
        );

        $images = array_map(function($n) {

            $this->SetItemCategory($n['item_cat']);
            $this->SetExternalImage($n['item_extra3']);
            $this->SetImage($n['item_name']);

            if ($this->ItemCategory == $this->type) {
	            return $this->ExtraImgUrl;
            }

            return $this->GetBaseUrl().'/WPL/'.$this->id.'/'.$this->image;

        },(array) $response);
        
        if (false == $this->image) {
	        return array();
        }

        return $images;
    }
}