<?php

namespace Api\Wpl\models\core\Properties;

use Api\Wpl\models\core\Database\Database;
use Api\Wpl\models\AbstractModel;

class PropertiesImageUpload extends AbstractModel {

	/**
	 * @var array
	 */
	protected $allowedMimeTypes = array(
		"image/png",
		"image/jpg",
		"image/jpeg",
		"video/mp4",
		"video/x-flv",
		"video/webm",
		"video/ogg",
		"video/quicktime"
	);

	public function uploadImages(array $fileParams,$listingId) {

		if (!function_exists( 'wp_handle_upload')) {
			require_once( ABSPATH . 'wp-admin/includes/file.php');
		}

		// check listing by id
		if (!$this->checkListingById($listingId)) {
			wp_send_json_error(array(
				'message' => "Listing with this ID: $listingId could not be found."
			));
		}

		foreach ($fileParams as $param) {
			// get mime type
			$mimetype = mime_content_type($param['tmp_name']);
			// check mime type
			if (!in_array($mimetype,$this->allowedMimeTypes)) {
				wp_send_json_error(array(
					'message' => 'File type must be: image'
				));
			}

			$movefile = wp_handle_upload( $param, array(
				'test_form' => false
			));

			if ($movefile && ! isset( $movefile['error'])) {

            switch ($mimetype) {
                case 'image/png':
                case 'image/jpg':
                case 'image/jpeg':
    				$data = array(
    					'parent_id'     => $listingId,
    					'creation_date' => date("Y-m-d H:i:s"),
    					'item_type'     => 'gallery',
    					'item_cat'      => 'external',
    					'item_name'     => 'external_image'.$listingId,
    					'item_extra3'   => $movefile['url']
    				);
                    break;
                case 'video/mp4':
                case 'video/x-flv':
                case 'video/webm':
                case 'video/ogg':
                case 'video/quicktime':
    				$data = array(
    					'parent_id'     => $listingId,
    					'creation_date' => date("Y-m-d H:i:s"),
    					'item_type'     => 'video',
    					'item_cat'      => 'video_embed',
    					'item_name'     => 'external_image'.$listingId,
    					'item_extra2'   => '<iframe src="'.$movefile['url'].'"></iframe>',
    					'item_extra3'   => $movefile['url']
    				);
                    break;
            }
				Database::insert("{$this->wpdb->base_prefix}wpl_items", $data);

			} else {
				wp_send_json_error(array(
					'message' => $movefile['error']
				));
			}
		}
		
		wp_send_json_success();
	}

	protected function checkListingById($id) {

        $listing = Database::getRow(
            "SELECT id 
                FROM {$this->wpdb->base_prefix}wpl_properties
             WHERE id = ?",array($id)
        );

        return ($listing) ? true : false;
	}
}