<?php

namespace Api\Wpl\models\core\Properties;

use Api\Wpl\managers\AbstractManager;
use Api\Wpl\managers\ListingManager;
use Api\Wpl\models\AbstractModel;
use Api\Wpl\models\core\Database\Database;

class Properties extends AbstractModel {

    /** @var string */
    private $polygon;

    /** @var bool */
    private $pointOnVertex = true;

    /** @var array */
    private $results = array();

    /** @var array */
    private $polygons = array();

    /**
     * Using this method you will recieve information about the properties
     * @return array
     * @since 1.0.0
     */
    public function select(
        $search = false,
        $request = "",
        $listing_type = false,
        $polygon = false
    ) {
        try {
            $rs_data = json_decode(file_get_contents('php://input') ?? '', true);
            if (isset($rs_data['user_id']) AND !empty($rs_data['user_id'])) $_REQUEST['user_id'] = $rs_data['user_id'];
            $user_id = (isset($_REQUEST['user_id']) and !empty($_REQUEST['user_id'])) ? $_REQUEST['user_id'] : null;

            /*$rs_data = json_decode(file_get_contents('php://input') ?? '', true);
    		$user_id = (isset($rs_data['user_id']) and !empty($rs_data['user_id'])) ? $rs_data['user_id'] : null;
    		$user = get_userdata( $user_id );
    		if ( $user === false ) {
    			return false;
    		}*/

            if ($search == false) {
//				$coordinate = new Coordinate($request);

                /*if (!isset($coordinate->swLongitude) or empty($coordinate->swLongitude)) $coordinate->swLongitude = $rs_data['swlng'];
                if (!isset($coordinate->swLatitude) or empty($coordinate->swLatitude)) $coordinate->swLatitude = $rs_data['swlat'];
                if (!isset($coordinate->neLatitude) or empty($coordinate->neLatitude)) $coordinate->neLatitude = $rs_data['nelat'];
                if (!isset($coordinate->neLongitude) or empty($coordinate->neLongitude)) $coordinate->neLongitude = $rs_data['nelng'];*/

                /*				$query = "
                                    SELECT *
                                        FROM {$this->wpdb->base_prefix}wpl_properties
                                      WHERE ".($listing_type == -1 ? '1' : "listing = {$listing_type}")." AND googlemap_lt BETWEEN {$coordinate->swLatitude} AND {$coordinate->neLatitude}
                                          AND googlemap_ln BETWEEN {$coordinate->swLongitude} AND {$coordinate->neLongitude}
                                          AND finalized = ? AND confirmed = ? ".((isset($user_id) AND !empty($user_id)) ? ' AND user_id = '.$user_id : '')."
                                      ORDER BY add_date DESC LIMIT $this->limit";*/

                $list = new PropertiesList();
                $where = $list->GetWhere($request);

                if(empty($where)){
                    $query = "
					SELECT *
                    	FROM {$this->wpdb->base_prefix}wpl_properties 
                  	WHERE finalized = ? AND confirmed = ? ".((isset($user_id) AND !empty($user_id)) ? ' AND user_id = '.$user_id : '')."
                  	ORDER BY add_date DESC LIMIT $this->limit";
                }else{
                    $query = "
					SELECT *
                    	FROM {$this->wpdb->base_prefix}wpl_properties 
                  	WHERE ".implode(' AND ', $where)." AND finalized = ? AND confirmed = ? ".((isset($user_id) AND !empty($user_id)) ? ' AND user_id = '.$user_id : '')."
                  	ORDER BY add_date DESC LIMIT $this->limit";
                }


            } else {
                $query = "
					SELECT *
                    	FROM {$this->wpdb->base_prefix}wpl_properties 
                  	WHERE ".implode(' AND ', $search)." AND finalized = ? AND confirmed = ? ".((isset($user_id) AND !empty($user_id)) ? ' AND user_id = '.$user_id : '')."
                  		ORDER BY add_date DESC LIMIT $this->limit";
            }
            $listings = Database::getRows(
                $query, array(true, true)
            );
            // Polygon search result
            if (!is_null($polygon) and
                $polygon != false and
                $listings != false
            ) {
                preg_match_all('/\"(.*?)\"/', $polygon, $matches);
                foreach ($listings as $key => $value) {
                    $this->polygons = sprintf(
                        "%s %s", $value['googlemap_lt'], $value['googlemap_ln']
                    );
                    if ($this->is_property_in_polygon($matches[1], $this->polygons)) {
                        $this->results[] = $value;
                    }
                }
                if (empty($this->results)) {
                    return AbstractModel::respondError(
                        __('No property could be found.', 'wpl-api')
                    );
                }
                return $this->results;
            }
            return ($listings != false) ? $listings : AbstractModel::respondError(
                __('No property could be found.', 'wpl-api')
            );
        } catch ( \PDOException $e ) {
            AbstractModel::respondError(
                __('No property could be found.', 'wpl-api'),
                $e->getMessage()
            );
        }
    }

    /**
     * Using this method you get all the active listing types
     * @since 1.0.0
     */
    public function getPropertiesTypes() {
        try {
            $listingTypes = Database::getRows(
                "SELECT * 
                   FROM {$this->wpdb->base_prefix}wpl_listing_types
                 WHERE  enabled = ? AND `name`!=''", true
            );
            if ( $listingTypes ) {
                //so first, this array will hold list of types
                $types = array();
                //take types one by one
                foreach ( $listingTypes as $type ) {
                    $types['types'][] = [ 'id' => $type['id'], 'parent' => $type['parent'], 'name' => __($type['name'], 'wpl-api') ];
                }
                wp_send_json_success($types);
            }
            AbstractModel::respondError(
                __('No property types could be found.', 'wpl-api')
            );
        } catch ( \PDOException $e ) {
            AbstractModel::respondError(
                __('No property types could be found.', 'wpl-api'),
                $e->getMessage()
            );
        }
    }

    /**
     * Using this method you get all the active sort options
     * @since 1.0.0
     */
    public function getSortOptions() {
        try {
            $sortQuery = "SELECT * FROM {$this->wpdb->base_prefix}wpl_sort_options as sort ";
            $sortQuery .= "WHERE sort.enabled >= ? AND sort.kind LIKE '%[0]%' ORDER BY sort.index ASC";
            $sortOptions = Database::getRows(
                $sortQuery,
                true
            );
            if ( $sortOptions ) {
                //so first, this array will hold list of types
                $types = array();
                //take types one by one
                foreach ( $sortOptions as $type ) {
                    $types['options'][] = [ 'id' => $type['field_name'], 'name' => __($type['name'],'wpl-api') ];
                }
                wp_send_json_success($types);
            }
            AbstractModel::respondError(
                __('No Sort Options could be found.', 'wpl-api')
            );
        } catch ( \PDOException $e ) {
            AbstractModel::respondError(
                __('No Sort Options could be found.', 'wpl-api'),
                $e->getMessage()
            );
        }
    }

    /**
     * @param $request
     */
    public function sortListings( $request ) {

        try {
            $sort = new PropertiesSort();
            $sort->SetSortId($request->get_param('sort_id'));
            $paginator = new Paginator(
                $request, $this->inPage
            );
            $paginator->setTotal(0);
            if (!empty($sort->GetWhere($request))) {
                $query = "
                    SELECT *
                        FROM {$this->wpdb->base_prefix}wpl_properties
                    WHERE ".implode(' AND ', $sort->GetWhere($request))." AND finalized = ? 
                    	AND confirmed = ?
                      	ORDER BY {$sort->GetSortFieldName()} DESC 
                    LIMIT {$paginator->getOffset()},{$paginator->getInPage()}";
            } else {
                $query = "
                    SELECT *
                        FROM {$this->wpdb->base_prefix}wpl_properties
                    WHERE finalized = ? AND confirmed = ?
                      ORDER BY {$sort->GetSortFieldName()} DESC 
                    LIMIT {$paginator->getOffset()},{$paginator->getInPage()}";
            }
            $listings = Database::getRows($query, array(true,true));
            // Polygon search results
            if (!is_null($request->get_param('points')) and
                $listings != false
            ) {
                preg_match_all('/\"(.*?)\"/', $request['points'], $matches);
                foreach ($listings as $key => $value) {
                    $this->polygons = sprintf(
                        "%s %s", $value['googlemap_lt'], $value['googlemap_ln']
                    );
                    if ($this->is_property_in_polygon($matches[1], $this->polygons)) {
                        $this->results[] = $value;
                    }
                }
                if (empty($this->results)) {
                    return AbstractModel::respondError(
                        __('No property could be found.', 'wpl-api')
                    );
                }
                $listings = $this->results;
            }
            if ($listings) {
                $listing = new ListingManager($this);
                $rows = $listing->GetPropertyData(
                    $listings, true
                );
                if (!empty($sort->GetWhere($request))) {
                    $total = PropertiesManager::getTotalCount(
                        $this->wpdb->prefix,
                        "".implode(' AND ', $sort->GetWhere(
                            $request
                        ))." AND finalized = 1 AND confirmed = 1"
                    );
                } else {
                    $total = PropertiesManager::getTotalCount(
                        $this->wpdb->prefix,
                        "finalized = 1 AND confirmed = 1"
                    );
                }
                $paginator->setTotal($total);
                $rows['info'] = PropertiesManager::getPaginationPayload(
                    $paginator
                );
                ($paginator->getPages() < $request->get_param('page'))
                    ? AbstractModel::respondError(
                    __('No property could be found.', 'wpl-api')
                ) : wp_send_json_success($rows);
            }
            AbstractModel::respondError(
                __('No property could be found.', 'wpl-api')
            );
        } catch ( \Exception $e ) {
            AbstractModel::respondError(
                __('No property could be found.', 'wpl-api')
            );
        }
    }

    /**
     * Get properties by listing type
     * @access public
     * @since 1.0.0
     */
    public function getPropertiesList($request) {
        try {
            $rs_data = json_decode(file_get_contents('php://input') ?? '', true);
            if (isset($rs_data['user_id']) AND !empty($rs_data['user_id'])) $_REQUEST['user_id'] = $rs_data['user_id'];

            $list = new PropertiesList();
            $paginator = new Paginator($request, $this->inPage);
            $sort = new PropertiesSort();
            $sort->SetSortId($request->get_param('sort_id'));
            $paginator->setTotal(0);
            $sortString = 'add_date DESC, id';
            if($sort->GetSortFieldName()) {
                $sortString = $sort->GetSortFieldName();
            }
            if (!empty($list->GetWhere($request))) {
                $query = "
                    SELECT *
                        FROM {$this->wpdb->base_prefix}wpl_properties
                    WHERE ".implode(' AND ', $list->GetWhere($request))." AND finalized = 1 
                    	AND confirmed = 1 ".((isset($_REQUEST['user_id']) AND !empty($_REQUEST['user_id']) AND intval($_REQUEST['user_id'])) ? ' AND user_id = '.$_REQUEST['user_id'] : '')."
                    ORDER BY {$sortString} DESC LIMIT {$paginator->getOffset()},{$paginator->getInPage()}";
            } else {
                $query = "
                    SELECT *
                        FROM {$this->wpdb->base_prefix}wpl_properties
                    WHERE finalized = 1 AND confirmed = 1 ".((isset($_REQUEST['user_id']) AND !empty($_REQUEST['user_id']) AND intval($_REQUEST['user_id'])) ? ' AND user_id = '.$_REQUEST['user_id'] : '')."
                        ORDER BY {$sortString} DESC LIMIT {$paginator->getOffset()},{$paginator->getInPage()}";
            }
            file_put_contents(__DIR__ . '/query.txt', $query . "\n", FILE_APPEND);
            $listings = Database::getRows(
                $query
            );
            // Polygon search results
            if (!is_null($request->get_param('points')) and
                $listings != false
            ) {
                preg_match_all('/\"(.*?)\"/', $request['points'], $matches);
                foreach ($listings as $key => $value) {
                    $this->polygons = sprintf(
                        "%s %s", $value['googlemap_lt'], $value['googlemap_ln']
                    );
                    if ($this->is_property_in_polygon($matches[1], $this->polygons)) {
                        $this->results[] = $value;
                    }
                }
                if (empty($this->results)) {
                    return AbstractModel::respondError(
                        __('No property could be found.', 'wpl-api')
                    );
                }
                $listings = $this->results;
            }
            if ($listings) {
                $listing = new ListingManager($this);
                $rows = $listing->GetPropertyData(
                    $listings, true, $_REQUEST['fav_user_id']
                );
                if (!empty($list->GetWhere($request))) {
                    $total = PropertiesManager::getTotalCount(
                        $this->wpdb->prefix,
                        "".implode(' AND ', $list->GetWhere(
                            $request
                        ))." AND finalized = 1 AND confirmed = 1 ORDER BY add_date DESC"
                    );
                } else {
                    $total = PropertiesManager::getTotalCount(
                        $this->wpdb->prefix,
                        "finalized = 1 AND confirmed = 1 ORDER BY add_date DESC, id DESC"
                    );
                }
                $paginator->setTotal($total);
                $rows['info'] = PropertiesManager::getPaginationPayload(
                    $paginator
                );
                ($paginator->getPages() < $request->get_param('page'))
                    ? AbstractModel::respondError(
                    __('No property could be found.', 'wpl-api')
                ) : wp_send_json_success($rows);
            }
            AbstractModel::respondError(
                __('No property could be found.', 'wpl-api')
            );
        } catch ( \Exception $e ) {
            AbstractModel::respondError(
                __($e, 'wpl-api')
            );
        }
    }

    /**
     * Using this method, you can add the respective property to the favorites.
     *
     * @param $request
     *
     * @since 1.0.0
     */
    public function AddFavorite( $request ) {

        try {
            $favorite = new PropertiesFavorite();
            $favorite->SetUserId( $request->get_param( 'user_id' ) );
            $favorite->SetListingId( $request->get_param( 'listing_id' ) );
            $favorite->add();
        } catch ( \Exception $e ) {
            AbstractModel::respondError(
                __("The entered listing already exists in favorite list", 'wpl-api')
            );
        }
    }

    /**
     * Using this method, you can remove property from the favorite list.
     * @access public
     *
     * @param $request
     *
     * @since 1.0.0
     */
    public function removeFavorite( $request ) {

        try {
            $favorite = new PropertiesFavorite();
            $favorite->SetUserId( $request->get_param( 'user_id' ) );
            $favorite->SetListingId( $request->get_param( 'listing_id' ) );
            $favorite->delete();
        } catch ( \Exception $e ) {
            AbstractModel::respondError(sprintf(
                __('Property with this id %s could be found in favorite list.', 'wpl-api'),
                $request->get_param('listing_id')
            ));
        }
    }

    /**
     * Using this method, you can get the list of favorites by user id and page number.
     * Also, you can get information about current page number, number of records in page, and number of total pages.
     * @access public
     *
     * @param $request
     *
     * @since 1.0.0
     */
    public function GetFavoriteList($request) {
        try {
            $favoriteList = new PropertiesListFavorite();
            $favoriteList->SetUserId($request->get_param('user_id'));
            $favoriteList->SetPage($request->get_param('page'));

            $favoriteList->GetByUserId();
            $paginator = new Paginator(
                $request,
                $this->inPage
            );
            $paginator->setTotal(0);

            $query = "
			 	SELECT * 
                    FROM {$this->wpdb->base_prefix}wpl_properties
               	WHERE finalized = 1 AND confirmed = 1 AND {$favoriteList->GetWhere()}
                    ORDER BY add_date DESC LIMIT {$paginator->getOffset()},{$paginator->getInPage()}";

            $listings = Database::getRows($query);

            if ($listings) {
                $listing = new ListingManager($this);
                $rows = $listing->GetPropertyData($listings, true, $request->get_param('user_id'));
                $total = PropertiesManager::getTotalCount(
                    $this->wpdb->prefix,
                    "finalized = 1 AND confirmed = 1 AND {$favoriteList->GetWhere()} ORDER BY add_date DESC"
                );
                $paginator->setTotal($total);
                $rows['info'] = PropertiesManager::getPaginationPayload(
                    $paginator
                );
                ($paginator->getPages() < $request->get_param('page'))
                    ? AbstractModel::respondError(__('No property could be found.', 'wpl-api'))
                    : wp_send_json_success(
                    $rows
                );
            }
            AbstractModel::respondError(
                __('No property could be found.', 'wpl-api')
            );
        } catch ( \Exception $e ) {
            AbstractModel::respondError(
                __('No property could be found.', 'wpl-api')
            );
        }
    }

    /**
     * Using this method, you can save the performed search parameters, like: map zoom level,search name,latitude and longitude.
     * @access public
     *
     * @param $request
     *
     * @since 1.0.0
     */
    public function AddSaveSearch( $request ) {
        try {
            $search = new PropertiesSaveSearch();
            $search->SetUserId( $request->get_param( 'user_id' ) );
            $search->SetZoom( $request->get_param( 'zoom' ) );
            $search->SetSearchName( $request->get_param( 'name' ) );
            $search->SetLatitude( $request->get_param( 'latitude' ) );
            $search->SetLongitude( $request->get_param( 'longitude' ) );
            $search->SetCriteria( $request->get_param( 'criteria' ) );
            $search->add();
        } catch ( \Exception $e ) {
            AbstractModel::respondError(sprintf(
                __('The entered name %s already exists.', 'wpl-api'), $request->get_param('name')
            ));
        }
    }

    /**
     * Using this method, you can get the saved search data using user id.
     * @return array of saved options
     * @since 1.0.0
     */
    public function ListSaveSearch( $request ) {
        try {
            $search = new PropertiesSaveSearch();
            $search->SetUserId( $request->get_param( 'user_id' ) );
            $search->searchList();
        } catch ( \Exception $e ) {
            AbstractModel::respondError(
                __('No saved search could be found.', 'wpl-api')
            );
        }
    }

    /**
     * Using this method, you can remove save search information by user id and search name.
     *
     * @param $request
     *
     * @access public
     * @since 1.0.0
     */
    public function RemoveSaveSearch( $request ) {
        try {
            $search = new PropertiesSaveSearch();
            $search->SetUserId( $request->get_param( 'user_id' ) );
            $search->SetSearchName( $request->get_param( 'name' ) );
            $search->delete();
        } catch ( \Exception $e ) {
            AbstractModel::respondError(
                __('Sorry something went wrong.', 'wpl-api')
            );
        }
    }

    public function getBylistingId( $request, $return=false ) {
        global $wpdb;
        try {
            $detailed = Database::getRow(
                "SELECT * 
                   FROM {$this->wpdb->base_prefix}wpl_properties
                 WHERE id = ?", array( $request->get_param( 'listing_id' ) )
            );
            if ( $detailed != false ) {
                // create listing object
                $prop_infs = $wpdb->get_row("SELECT price FROM {$wpdb->base_prefix}wpl_properties WHERE id = ".$request->get_param( 'listing_id' ),ARRAY_A);
                $response = new ListingManager( $this );
                $listing = $response->GetDetailedData( $detailed , $_REQUEST['fav_user_id']);
                if (!isset($listing['images_count']) OR empty($listing['images_count'])) $listing['images_count'] = 0;
                $listing = array_merge($listing,array('price_numeric'=>$prop_infs['price']));
                if (!$return) {
                    if(!empty($_REQUEST['fav_user_id'])) {
                        wp_set_current_user($_REQUEST['fav_user_id']);
                        \_wpl_import('libraries.event_handlers.addon_crm');
                        \wpl_events_crm::property_show(array(
                            array(
                                'id' => $request->get_param( 'listing_id' ),
                                'user_id' => $_REQUEST['fav_user_id'],
                                'params' => array('device' => 'mobile')
                            ),
                        ));
                    }

                    // return json response
                    wp_send_json_success(
                    //$response->GetDetailedData( $detailed )
                        array_merge($response->GetDetailedData( $detailed, $_REQUEST['fav_user_id'] ),array('price_numeric'=>$prop_infs['price']))
                    );
                } else {
                    return $listing;
                }
            } else {
                AbstractModel::respondError(
                    sprintf(__('Listing with this ID: %s could not be found.', 'wpl-api'), $request->get_param('listing_id'))
                );
            }
        } catch ( \Exception $e ) {
            AbstractModel::respondError(
                __('No property could be found.', 'wpl-api')
            );
        }
    }

    public function getByMlsId( $request ) {
        try {
            $detailed = Database::getRow(
                "SELECT * 
                   FROM {$this->wpdb->base_prefix}wpl_properties
                 WHERE mls_id = ?", array( $request->get_param( 'id' ) )
            );
            if ( $detailed != false ) {
                // create listing object
                $response = new ListingManager( $this );
                // return json response
                wp_send_json_success(
                    $response->GetDetailedData( $detailed )
                );
            } else {
                AbstractModel::respondError(
                    sprintf(__('Listing with this MLS ID: %s could not be found.', 'wpl-api'), $request->get_param('id'))
                );
            }
        } catch ( \Exception $e ) {
            AbstractModel::respondError(
                'No property could be found.'
            );
        }
    }

    public function getImageByListingId( $listingId ) {
        $image = new PropertiesImages();
        $image->SetListingId( $listingId );
        return $image->GetImageByListingId();
    }

    public function getImagesByListingId( $listingId, $count=1000 ) {

        $images = new PropertiesImages();
        $images->SetListingId( $listingId );
        $images->SetImagesCount( $count );
        return $images->GetImagesByListingId();
    }

    public function getNeighborhood(array $properties) {

        $response = [];
        $neighborhoods = Database::getRows(
            "SELECT id, table_column,name
                FROM {$this->wpdb->base_prefix}wpl_dbst	
             WHERE type = ?", array(
                'neighborhood'
            )
        );
        if ($neighborhoods) {
            $distance_by = array('walk' => 1,'car' => 2, 'train' => 3);
            foreach ( $neighborhoods as $neighborhood ) {
                if ($properties[$neighborhood['table_column']] == 1) {
                    $minutes = sprintf("%s_%s", $neighborhood['table_column'], "distance");
                    $minutes_by = sprintf("%s_%s_%s",$neighborhood['table_column'], "distance",'by');
                    $response[] = array(
                        'id'=>$neighborhood['id'],
                        'title'=>$neighborhood['name'],
                        $neighborhood['name'] => true,
                        'by' => array_search($properties[$minutes_by], $distance_by),
                        'minutes' => $properties[$minutes]
                    );
                }
            }
            return $response;
        }
        return $response;
    }

    public function getAppliances(array $properties) {

        $response = [];
        $appliances = Database::getRows(
            "SELECT id, table_column,name
                FROM {$this->wpdb->base_prefix}wpl_dbst	
             WHERE type = ? and category = ?", array(
                'feature', 5
            )
        );
        if ($appliances) {
            foreach ( $appliances as $appliance ) {
                if ($properties[$appliance['table_column']] == 1) {
                    $response[] = array(
                        'id'=>$appliance['id'],
                        'title'=>$appliance['name'],
                        $appliance['name'] => true
                    );
                }
            }
            return $response;
        }
        return $response;
    }

    public function getFeatures(array $properties) {

        $response = [];
        $features = Database::getRows(
            "SELECT id, table_column,name,options
                FROM {$this->wpdb->base_prefix}wpl_dbst	
             WHERE type = ? and category = ?", array(
                'feature',
                4
            )
        );
        if ($features) {
            foreach ($features as $feature) {
                if ($properties[$feature['table_column']] == 1) {

                    $options = json_decode($feature['options'] ?? '', true);
                    $str = $properties[sprintf("%s_%s", $feature['table_column'], "options")] ?? '';

                    $fixed_str=trim($str, ',');
                    $keys = explode(',', $fixed_str);

                    $features = [];
                    if (is_array($keys)) {
                        foreach ($keys as $key) {
                            $f = $this->get_feature($options['values'], $key);
                            if (is_array($f)) {
                                if (sizeof($f) != false) {
                                    $features[] = $f;
                                }
                            }
                        }
                    }

                    $response[] = array(
                        'id' => $feature['id'],
                        'name' => $feature['name'],
                        'features' => $features
                    );
                }
            }
            return $response;
        }
        return $response;
    }


    ############################# protected methods #############################

    protected function get_feature($options, $key) {
        $data = array();
        foreach ($options as $option) {
            if ($option['key'] == $key) {
                $data= $option['value'];
            }
        }
        return $data;
    }
    /**
     * Check if property is inside of a polygon
     * @param $latitude
     * @param $longitude
     * @return bool
     */
    protected function is_property_in_polygon($polygon, $points) {
        $myPolygon = $polygon;
        $test_points = array($points);
        foreach ($test_points as $apoint) {
            if (!$this->is_within_boundary($apoint,$myPolygon)) {
                return false;
            }
            return true;
        }
    }

    /**
     * Pointing a string to coordinates
     * @param $pointString
     * @return array
     */
    protected function pointStringToCoordinates($pointString) {
        $coordinates = explode(" ", $pointString);
        return array("x" => trim($coordinates[0] ?? ''), "y" => trim($coordinates[1] ?? ''));
    }

    /**
     * Check if point in boundary
     * @param $point
     * @param $polygon
     * @return bool
     */
    protected function is_within_boundary($point, $polygon) {
        $result = false;
        $point = $this->pointStringToCoordinates($point);
        $vertices = array();
        foreach ($polygon as $vertex) {
            $vertices[] = $this->pointStringToCoordinates(
                $vertex
            );
        }
        // Check if the point is inside the polygon or on the boundary
        $intersections = 0;
        $vertices_count = count($vertices);
        for ($i=1; $i < $vertices_count; $i++)
        {
            $vertex1 = $vertices[$i-1];
            $vertex2 = $vertices[$i];
            if ($vertex1['y'] == $vertex2['y'] and
                $vertex1['y'] == $point['y'] and
                $point['x'] > min($vertex1['x'], $vertex2['x']) and
                $point['x'] < max($vertex1['x'], $vertex2['x'])
            ){
                // This point is on an horizontal polygon boundary
                $result = true;
                // set $i = $vertices_count so that loop exits as we have a boundary point
                $i = $vertices_count;
            }
            if ($point['y'] > min($vertex1['y'], $vertex2['y']) and
                $point['y'] <= max($vertex1['y'], $vertex2['y']) and
                $point['x'] <= max($vertex1['x'], $vertex2['x']) and
                $vertex1['y'] != $vertex2['y']
            ){
                $xinters = ($point['y'] - $vertex1['y']) * ($vertex2['x'] - $vertex1['x']) / ($vertex2['y'] - $vertex1['y']) + $vertex1['x'];
                if ($xinters == $point['x']) {
                    // This point is on the polygon boundary (other than horizontal)
                    $result = true;
                    // set $i = $vertices_count so that loop exits as we have a boundary point
                    $i = $vertices_count;
                }
                if ($vertex1['x'] == $vertex2['x'] || $point['x'] <= $xinters) {
                    $intersections++;
                }
            }
        }
        // If the number of edges we passed through is even, then it in the polygon.
        // Have to check here also to make sure that we haven't already determined that a point is on a boundary line
        if ($intersections % 2 != 0) {
            $result = true;
        } else {
            $result = false;
        }
        return $result;
    }
}