<?php

namespace Api\Wpl\models\core\Properties;

class Paginator {

    /*################################################### PROTECTED PROPERTIES ###################################################*/

    /* @var this will hold value how much records were returned totally */
    public $totalCount = 0;

    /* @var this will be variable user set or from config with how much records should be in one page */
    public $inPage = 0;

    /* @var indicates what is the current page */
    public $page = 0;

    /* @var indicates how much pages are total */
    public $pages = 0;

    /* @var holds how many from beginning should records start */
    public $offset = 0;

    /**
     * @param Request $request this is request object
     * @param int $inPage number of records per page
     * @return void
     */
    public function __construct($request, $inPage = false) {
        if ($request instanceof \WP_REST_Request) {
                //extract the page from request
            if ($request->get_param('page') != false)
                $this->page = $request->get_param('page');
            else
                $this->page = 1; 
        }
        //if no page count is specified, then use default given in config
        if (!$inPage)
            $inPage = 20;
        //keep it in local variable
        $this->inPage = $inPage;

    }

    /**
     * Sets the total count, meaning that now	it can calculate all other variables.
     * Which it will.
     *
     * @param int $totalCount how many records were found totally
     * @return void
     */
    public function setTotal($totalCount) {
        //first sets the local variable
        $this->totalCount = $totalCount;
        //next calculates how much pages should be
        $this->pages = ceil($totalCount / $this->inPage);
        //calculate offset, that will be needed by select query
        $this->offset = ($this->page - 1) * $this->inPage;
    }

    public function getTotal() {
        return $this->totalCount;
    }

    /**
     * Returns current page number
     *
     * @return int page like 1
     */
    public function getPage() {
        //return from local variable
        return $this->page;
    }

    /**
     * Returns current offset number
     *
     * @return int offset like 100
     */
    public function getOffset() {
        //return from local variable
        return $this->offset;

    }

    /**
     * Returns number of records in page
     *
     * @return int number like 20
     */
    public function getInPage() {
        //return from local variable
        return $this->inPage;

    }

    /**
     * Returns number of pages
     *
     * @return int number of pages
     */
    public function getPages() {

        //return from local variable
        return $this->pages;

    }
}