<?php

namespace Api\Wpl\models\core\Format;

use Api\Wpl\models\core\Database\Database;

class Format {

    /**
     * @param $n
     * @return bool|string
     * Outputs a human readable number.
     */
    static public function GetNumberFormat($n) {

        // first strip any formatting;
        $n = (str_replace(",","",$n));
        // is this a number?
        if(!is_numeric($n)) return false;

        // now filter it;
        if($n>1000000000000) return round(($n/1000000000000),1).'T';
        else if($n>1000000000) return round(($n/1000000000),1).'B';
        else if($n>1000000) return round(($n/1000000),1).'M';
        else if($n>1000) return round(($n/1000),1).'K';

        return number_format($n);
    }

    /**
     * Function Coverts integer to unit name
     * @param $unit
     * @return mixed
     */
    static public function GetUnit($unit,$key='name') {

        global $wpdb;

        $unitQuery  = "SELECT $key FROM {$wpdb->base_prefix}wpl_units ";
        $unitQuery .= "WHERE id = ?";

        $unit = Database::getRow($unitQuery, array($unit));
        // return unit name
        return $unit[$key];
    }

    /**
     * Function Returns part of a Description
     * @param $value
     * @return bool|string
     */
    static public function GetDescription($value) {
		$value = $value ?? '';
        return (strlen($value) > 25)
            ? substr(strip_tags($value), 0, 25)
            : strip_tags($value);
    }

    /**
     * Function converts integer timestamp to datetime format
     *
     * @param int $int any integer datetime value
     * @return datetime
     */
    static public function int2date($int) {
        //do date conversion and return
        return date("Y-m-d H:i:s", $int);
    }
}