<?php

namespace  Api\Wpl\models\business;

use Api\Wpl\models\business\loader;
use Api\Wpl\models\business\i18n;

class wplApi {

    /**
     * The loader that's responsible for maintaining and registering all hooks that power
     * the plugin.
     */
    protected $loader;

    /**
     * The unique identifier of this plugin
     * @since    1.0.0
     */
    protected $plugin_name = 'wpl-api';

    /**
     * The current version of the plugin.
     * @since    1.0.0
     */
    protected $version;

    /**
     * @var
     */
    protected $settings;


    /**
     * @var
     */
    protected $lang;

    /**
     * Define the core functionality of the plugin.
     * @since    1.0.0
     */
    public function __construct($lang = "") {
        $this->version = WPLAPI_VERSION;
        $this->lang = $lang;
        $this->load_dependencies();
        $this->set_locale();
//        $this->define_public_hooks();
    }

    private function load_dependencies() {
        $this->loader = new loader();
    }

    private function set_locale() {
        $plugin_i18n = new i18n();
        $plugin_i18n->set_lang( $this->lang);

        //commented because not needed in wpl itself
//        $plugin_i18n->set_domain( $this->get_plugin_name());
        $this->loader->add_action('plugins_loaded', $plugin_i18n, 'load_plugin_textdomain');

    }

    //commented because not needed in wpl itself
//    private function define_public_hooks() {
//        $plugin_public = Admin_Controller::get_instance();
//        $plugin_public->init( $this->get_plugin_name(), $this->get_version() );
//        $this->loader->add_action( 'admin_enqueue_scripts', $plugin_public, 'enqueue_styles' );
//        $this->loader->add_action( 'admin_enqueue_scripts', $plugin_public, 'enqueue_scripts' );
//    }

    public function run() {
        $this->loader->run();
    }

    public function get_plugin_name() {
        return $this->plugin_name;
    }

    public function get_loader() {
        return $this->loader;
    }

    public function get_version() {
        return $this->version;
    }

    /**
     * Get the value of a settings field
     *
     * @param string  $option  settings field name
     * @param string  $section the section name this field belongs to
     * @param string  $default default text if it's not found
     * @return string
     */
    public static function get_option( $option, $section, $default = '' ) {
        $options = get_option( $section );
        (isset($options[$option]))
            ? $options[$option]
            : $default;
    }
}