<?php

namespace Api\Wpl\managers;

use Api\Wpl\models\core\User\UserMapper;
use Api\Wpl\models\core\User\UserAuth;
use Api\Wpl\models\core\User\UserPasswordReset;
use Api\Wpl\models\core\User\UserChangePassword;

class UserManager {
	
	/**
     * Create user accounts in the application
     * @param $request
     */
    public function registration($request) {

        // create user mapper object
        $User = new UserMapper(
            $request->get_params()
        );
        $User->validateEmail();
        $User->createUser();

    }

    public function login($request) {

        $auth = new UserAuth(
            $request->get_params()
        );

        $auth->signOn();
    }

    public function resetPassword($request) {

        $reset = new UserPasswordReset(
            $request->get_params()
        );

        $reset->validateEmail();
        $reset->validatePhoneNumbers();
        $reset->sendSmsCode();
    }
    
    public function changePassword($request) {

        $passworChange = new UserChangePassword(
            $request->get_params()
        );

        if ($passworChange->validateData()) {
            $passworChange->updatePassword();
        }
    }
    
        public function getUserInfoById($userId)
    {
        global $wpdb;
        $user = get_user_by('ID', $userId);
        if (!$user) {
            return null;
        }
        $wpl_user = $wpdb->get_row("SELECT * FROM {$wpdb->base_prefix}wpl_users WHERE id = '" . $user->ID . "'", ARRAY_A);

        $first_name = (isset($wpl_user['first_name']) and !empty(isset($wpl_user['first_name']))) ? $wpl_user['first_name'] : get_user_meta($user->ID, 'first_name', true);
        $last_name = (isset($wpl_user['last_name']) and !empty(isset($wpl_user['last_name']))) ? $wpl_user['last_name'] : get_user_meta($user->ID, 'last_name', true);
        $tel = (isset($wpl_user['tel']) and !empty(isset($wpl_user['tel']))) ? $wpl_user['tel'] : get_user_meta($user->ID, 'phone_number', true);

        return array(
            'user_id' => $user->ID,
            'profile_image' => $wpl_user['profile_picture'] ? get_site_url() . "/wp-content/uploads/WPL/users/" . $wpl_user['id'] . "/" . $wpl_user['profile_picture'] : '',
            'name' => $first_name . ($last_name ? ' ' . $last_name : ''),
            'first_name'  => $first_name,
            'last_name'  => $last_name,
            'email' => $user->user_email,
            'username' => $user->user_login,
            'phone' => $tel,
            'is_admin' => ($user->allcaps['administrator']) ? true : false
        );
    }
}