<?php

namespace Api\Wpl\managers;

class AboutManager {

    /**
     * Update the map settings into the option table
     * @param $request
     */
    public function update($request) {

        $about = array(
            'company_name'    => $request->get_param('company_name'),
            'company_address' => $request->get_param('company_address'),
            'company_phone'   => $request->get_param('company_phone'),
            'company_about'   => $request->get_param('company_about'),
        );

        if (update_option('wpl_api_about',$about,'yes')) {
            wp_send_json_success(array(
                'message' => 'About is created successfully.')
            );
        }

        wp_send_json_error(array(
            'message' => 'The record already exists. Please modify your entry.')
        );
    }

    /**
     * Get the map settings from option table
     */
    public function getAbout() {

        $about = get_option('wpl_api_about');
        return ($about)
            ?  wp_send_json_success($about)
            : wp_send_json_error(array('message' => 'The record is not found.'));
    }
}