<?php
/*
 * Plugin Name: Point of Sale POS for WooCommerce
 * Plugin URI: https://www.bizswoop.com/wp/pos
 * Description: A Point of Sale (POS) plugin for the WooCommerce e-commerce toolkit. Sell everywhere.
 * Version: 2.2.2
 * Text Domain: point-of-sale-pos-woocommerce
 * Domain Path: /lang
 * WC requires at least: 2.4.0
 * WC tested up to: 5.0.0
 * Author: BizSwoop a CPF Concepts, LLC Brand
 * Author URI: http://www.bizswoop.com
 */

namespace ZPOS;

const ACTIVE = true;
const PLUGIN_NAME = 'pos';
const TEXTDOMAIN = 'point-of-sale-pos-woocommerce';
const PLUGIN_ROOT = __DIR__;
const PLUGIN_ROOT_FILE = __FILE__;
const PLUGIN_VERSION = '2.2.2';
const REST_NAMESPACE = 'wc-pos';

remove_filter('template_redirect', 'redirect_canonical');

spl_autoload_register(function ($name) {
	$raw_name = $name;
	$name = explode('\\', $name);
	if ($name[0] === 'ZPOS') {
		$name[0] = 'includes';
	} else {
		return false;
	}

	$path = __DIR__ . DIRECTORY_SEPARATOR . implode(DIRECTORY_SEPARATOR, $name) . '.php';

	$path = apply_filters('zpos_autoload_path', $path, $name, $raw_name, PLUGIN_VERSION);

	if (file_exists($path)) {
		return require_once $path;
	}
}, false);

if (!function_exists('get_plugins')) {
	require_once ABSPATH . 'wp-admin/includes/plugin.php';
}

new Setup();
