<?php
namespace ZPOS\Structure;
trait ProductResponse
{
	public function prepare_object_for_response($object, $request)
	{
		$context = !empty($request['context']) ? $request['context'] : 'view';
		$data = $this->get_product_data($object, $context);

		// Add variations to variable products.
		if ($object->is_type('variable') && $object->has_child()) {
			$data['variations'] = $object->get_children();
		}

		// Add grouped products data.
		if ($object->is_type('grouped') && $object->has_child()) {
			$data['grouped_products'] = $object->get_children();
		}

		//$data = $this->add_additional_fields_to_object($data, $request);
		$data = $this->filter_response_by_context($data, $context);
		$response = rest_ensure_response($data);

		/**
		 * Filter the data for a response.
		 *
		 * The dynamic portion of the hook name, $this->post_type,
		 * refers to object type being prepared for the response.
		 *
		 * @param WP_REST_Response $response The response object.
		 * @param WC_Data $object Object data.
		 * @param WP_REST_Request $request Request object.
		 */
		return apply_filters(
			"woocommerce_rest_prepare_{$this->post_type}_object",
			$response,
			$object,
			$request
		);
	}

	public function get_product_data($product, $context = 'view')
	{
		$result = parent::get_product_data($product, ($context = 'view'));
		$result['pos_barcode'] = $this->get_barcode($product->get_id());
		$result['in_stock'] = $product->is_in_stock();
		unset($result['permalink']);
		unset($result['date_created']);
		unset($result['date_created_gmt']);
		unset($result['date_modified']);
		unset($result['date_modified_gmt']);
		unset($result['catalog_visibility']);
		unset($result['description']);
		unset($result['short_description']);
		unset($result['regular_price']);
		unset($result['sale_price']);
		unset($result['date_on_sale_from']);
		unset($result['date_on_sale_from_gmt']);
		unset($result['date_on_sale_to']);
		unset($result['date_on_sale_to_gmt']);
		unset($result['price_html']);
		unset($result['purchasable']);
		unset($result['total_sales']);
		unset($result['virtual']);
		unset($result['downloadable']);
		unset($result['downloads']);
		unset($result['download_limit']);
		unset($result['download_expiry']);
		unset($result['external_url']);
		unset($result['button_text']);
		unset($result['backorders']);
		unset($result['backorders_allowed']);
		unset($result['backordered']);
		unset($result['sold_individually']);
		unset($result['weight']);
		unset($result['dimensions']);
		unset($result['reviews_allowed']);
		unset($result['average_rating']);
		unset($result['rating_count']);
		unset($result['related_ids']);
		unset($result['upsell_ids']);
		unset($result['cross_sell_ids']);
		unset($result['purchase_note']);
		unset($result['default_attributes']);
		unset($result['grouped_products']);
		unset($result['menu_order']);
		return $result;
	}

	private function get_barcode($product_id)
	{
		$variation_barcode = get_post_meta($product_id, 'pos_variation_barcode', true);
		return $variation_barcode
			? $variation_barcode
			: get_post_meta($product_id, 'pos_barcode', true);
	}

	public function get_item_schema()
	{
		$weight_unit = get_option('woocommerce_weight_unit');
		$dimension_unit = get_option('woocommerce_dimension_unit');
		$schema = array(
			'$schema' => 'http://json-schema.org/draft-04/schema#',
			'title' => $this->post_type,
			'type' => 'object',
			'properties' => array(
				'id' => array(
					'description' => __('Unique identifier for the resource.', 'woocommerce'),
					'type' => 'integer',
					'context' => array('view', 'edit'),
					'readonly' => true,
				),
				'name' => array(
					'description' => __('Product name.', 'woocommerce'),
					'type' => 'string',
					'context' => array('view', 'edit'),
				),
				'slug' => array(
					'description' => __('Product slug.', 'woocommerce'),
					'type' => 'string',
					'context' => array('view', 'edit'),
				),
				'type' => array(
					'description' => __('Product type.', 'woocommerce'),
					'type' => 'string',
					'default' => 'simple',
					'enum' => array_keys(wc_get_product_types()),
					'context' => array('view', 'edit'),
				),
				'status' => array(
					'description' => __('Product status (post status).', 'woocommerce'),
					'type' => 'string',
					'default' => 'publish',
					'enum' => array_keys(get_post_statuses()),
					'context' => array('view', 'edit'),
				),
				'featured' => array(
					'description' => __('Featured product.', 'woocommerce'),
					'type' => 'boolean',
					'default' => false,
					'context' => array('view', 'edit'),
				),
				'sku' => array(
					'description' => __('Unique identifier.', 'woocommerce'),
					'type' => 'string',
					'context' => array('view', 'edit'),
				),
				'price' => array(
					'description' => __('Current product price.', 'woocommerce'),
					'type' => 'string',
					'context' => array('view', 'edit'),
					'readonly' => true,
				),

				'on_sale' => array(
					'description' => __('Shows if the product is on sale.', 'woocommerce'),
					'type' => 'boolean',
					'context' => array('view', 'edit'),
					'readonly' => true,
				),
				'tax_status' => array(
					'description' => __('Tax status.', 'woocommerce'),
					'type' => 'string',
					'default' => 'taxable',
					'enum' => array('taxable', 'shipping', 'none'),
					'context' => array('view', 'edit'),
				),
				'tax_class' => array(
					'description' => __('Tax class.', 'woocommerce'),
					'type' => 'string',
					'context' => array('view', 'edit'),
				),
				'manage_stock' => array(
					'description' => __('Stock management at product level.', 'woocommerce'),
					'type' => 'boolean',
					'default' => false,
					'context' => array('view', 'edit'),
				),
				'stock_quantity' => array(
					'description' => __('Stock quantity.', 'woocommerce'),
					'type' => 'integer',
					'context' => array('view', 'edit'),
				),
				'in_stock' => array(
					'description' => __(
						'Controls whether or not the product is listed as "in stock" or "out of stock" on the frontend.',
						'woocommerce'
					),
					'type' => 'boolean',
					'default' => true,
					'context' => array('view', 'edit'),
				),
				'shipping_required' => array(
					'description' => __('Shows if the product need to be shipped.', 'woocommerce'),
					'type' => 'boolean',
					'context' => array('view', 'edit'),
					'readonly' => true,
				),
				'shipping_taxable' => array(
					'description' => __(
						'Shows whether or not the product shipping is taxable.',
						'woocommerce'
					),
					'type' => 'boolean',
					'context' => array('view', 'edit'),
					'readonly' => true,
				),
				'shipping_class' => array(
					'description' => __('Shipping class slug.', 'woocommerce'),
					'type' => 'string',
					'context' => array('view', 'edit'),
				),
				'shipping_class_id' => array(
					'description' => __('Shipping class ID.', 'woocommerce'),
					'type' => 'integer',
					'context' => array('view', 'edit'),
					'readonly' => true,
				),
				'parent_id' => array(
					'description' => __('Product parent ID.', 'woocommerce'),
					'type' => 'integer',
					'context' => array('view', 'edit'),
				),
				'purchase_note' => array(
					'description' => __('Optional note to send the customer after purchase.', 'woocommerce'),
					'type' => 'string',
					'context' => array('view', 'edit'),
				),
				'categories' => array(
					'description' => __('List of categories.', 'woocommerce'),
					'type' => 'array',
					'context' => array('view', 'edit'),
					'items' => array(
						'type' => 'object',
						'properties' => array(
							'id' => array(
								'description' => __('Category ID.', 'woocommerce'),
								'type' => 'integer',
								'context' => array('view', 'edit'),
							),
							'name' => array(
								'description' => __('Category name.', 'woocommerce'),
								'type' => 'string',
								'context' => array('view', 'edit'),
								'readonly' => true,
							),
							'slug' => array(
								'description' => __('Category slug.', 'woocommerce'),
								'type' => 'string',
								'context' => array('view', 'edit'),
								'readonly' => true,
							),
						),
					),
				),
				'tags' => array(
					'description' => __('List of tags.', 'woocommerce'),
					'type' => 'array',
					'context' => array('view', 'edit'),
					'items' => array(
						'type' => 'object',
						'properties' => array(
							'id' => array(
								'description' => __('Tag ID.', 'woocommerce'),
								'type' => 'integer',
								'context' => array('view', 'edit'),
							),
							'name' => array(
								'description' => __('Tag name.', 'woocommerce'),
								'type' => 'string',
								'context' => array('view', 'edit'),
								'readonly' => true,
							),
							'slug' => array(
								'description' => __('Tag slug.', 'woocommerce'),
								'type' => 'string',
								'context' => array('view', 'edit'),
								'readonly' => true,
							),
						),
					),
				),
				'images' => array(
					'description' => __('List of images.', 'woocommerce'),
					'type' => 'array',
					'context' => array('view', 'edit'),
					'items' => array(
						'type' => 'object',
						'properties' => array(
							'id' => array(
								'description' => __('Image ID.', 'woocommerce'),
								'type' => 'integer',
								'context' => array('view', 'edit'),
							),
							'date_created' => array(
								'description' => __(
									"The date the image was created, in the site's timezone.",
									'woocommerce'
								),
								'type' => 'date-time',
								'context' => array('view', 'edit'),
								'readonly' => true,
							),
							'date_created_gmt' => array(
								'description' => __('The date the image was created, as GMT.', 'woocommerce'),
								'type' => 'date-time',
								'context' => array('view', 'edit'),
								'readonly' => true,
							),
							'date_modified' => array(
								'description' => __(
									"The date the image was last modified, in the site's timezone.",
									'woocommerce'
								),
								'type' => 'date-time',
								'context' => array('view', 'edit'),
								'readonly' => true,
							),
							'date_modified_gmt' => array(
								'description' => __('The date the image was last modified, as GMT.', 'woocommerce'),
								'type' => 'date-time',
								'context' => array('view', 'edit'),
								'readonly' => true,
							),
							'src' => array(
								'description' => __('Image URL.', 'woocommerce'),
								'type' => 'string',
								'format' => 'uri',
								'context' => array('view', 'edit'),
							),
							'name' => array(
								'description' => __('Image name.', 'woocommerce'),
								'type' => 'string',
								'context' => array('view', 'edit'),
							),
							'alt' => array(
								'description' => __('Image alternative text.', 'woocommerce'),
								'type' => 'string',
								'context' => array('view', 'edit'),
							),
							'position' => array(
								'description' => __(
									'Image position. 0 means that the image is featured.',
									'woocommerce'
								),
								'type' => 'integer',
								'context' => array('view', 'edit'),
							),
						),
					),
				),
				'attributes' => array(
					'description' => __('List of attributes.', 'woocommerce'),
					'type' => 'array',
					'context' => array('view', 'edit'),
					'items' => array(
						'type' => 'object',
						'properties' => array(
							'id' => array(
								'description' => __('Attribute ID.', 'woocommerce'),
								'type' => 'integer',
								'context' => array('view', 'edit'),
							),
							'name' => array(
								'description' => __('Attribute name.', 'woocommerce'),
								'type' => 'string',
								'context' => array('view', 'edit'),
							),
							'position' => array(
								'description' => __('Attribute position.', 'woocommerce'),
								'type' => 'integer',
								'context' => array('view', 'edit'),
							),
							'visible' => array(
								'description' => __(
									"Define if the attribute is visible on the \"Additional information\" tab in the product's page.",
									'woocommerce'
								),
								'type' => 'boolean',
								'default' => false,
								'context' => array('view', 'edit'),
							),
							'variation' => array(
								'description' => __(
									'Define if the attribute can be used as variation.',
									'woocommerce'
								),
								'type' => 'boolean',
								'default' => false,
								'context' => array('view', 'edit'),
							),
							'options' => array(
								'description' => __(
									'List of available term names of the attribute.',
									'woocommerce'
								),
								'type' => 'array',
								'context' => array('view', 'edit'),
								'items' => array(
									'type' => 'string',
								),
							),
						),
					),
				),
				'variations' => array(
					'description' => __('List of variations IDs.', 'woocommerce'),
					'type' => 'array',
					'context' => array('view', 'edit'),
					'items' => array(
						'type' => 'integer',
					),
					'readonly' => true,
				),
				'meta_data' => array(
					'description' => __('Meta data.', 'woocommerce'),
					'type' => 'array',
					'context' => array('view', 'edit'),
					'items' => array(
						'type' => 'object',
						'properties' => array(
							'id' => array(
								'description' => __('Meta ID.', 'woocommerce'),
								'type' => 'integer',
								'context' => array('view', 'edit'),
								'readonly' => true,
							),
							'key' => array(
								'description' => __('Meta key.', 'woocommerce'),
								'type' => 'string',
								'context' => array('view', 'edit'),
							),
							'value' => array(
								'description' => __('Meta value.', 'woocommerce'),
								'type' => 'mixed',
								'context' => array('view', 'edit'),
							),
						),
					),
				),
			),
		);

		return $this->add_additional_fields_schema($schema);
	}
}
