<?php

namespace ZPOS;

class Setup
{
	public function __construct()
	{
		new Activate();
		new Deactivate();

		add_action('woocommerce_init', [$this, 'init']);
		add_action('plugins_loaded', [$this, 'checkVersion']);
	}

	public function checkVersion()
	{
		if (!class_exists('WooCommerce')) {
			add_action('admin_notices', [$this, 'requireWCNotice']);
		}
	}

	public function requireWCNotice()
	{
		echo '<div class="notice notice-error is-dismissible"><p>';
		_e('Point of Sale (POS) for WooCommerce require WooCommerce', 'point-of-sale-pos-woocommerce');
		echo '</p></div>';
	}

	public function init()
	{
		if (!class_exists('WooCommerce')) {
			return;
		}
		new Frontend();
		new Model();
		new Emails();
		new API();
		new Admin();
		new Translation();
	}
}
