<?php

namespace ZPOS\Gateway;

use WC_Order;
use ZPOS\API;

class EPD extends Base
{
	public $id = 'pos_epd';
	public $method_title = 'Other Payments';
	public $method_description = 'Use for checks, external payment devices & etc';
	public $has_fields = true;
	public $supports = array('products', 'pos');

	public function __construct()
	{
		parent::__construct();

		$this->title = $this->get_option('title');
		$this->description = $this->get_option('description');

		// Actions
		add_action('woocommerce_pos_update_options_payment_gateways_' . $this->id, array(
			$this,
			'process_admin_options',
		));
	}

	public function process_payment($order_id)
	{
		// get order object
		$order = new WC_Order($order_id);

		// payment complete
		$order->update_status('processing');
		// success
		return array(
			'result' => 'success',
		);
	}
}
