<?php

namespace ZPOS\Admin\Woocommerce;

class Products
{
	public function __construct()
	{
		add_action('woocommerce_product_options_inventory_product_data', [
			$this,
			'add_fields_to_simple_product',
		]);

		add_action('woocommerce_variation_options', [$this, 'add_fields_to_variable_product'], 1, 3);

		add_action('woocommerce_process_product_meta', [$this, 'process_product_meta']);

		add_action('woocommerce_save_product_variation', [$this, 'save_product_variation'], 10, 2);
	}

	public function add_fields_to_simple_product()
	{
		$this->show_barcode_field();
	}

	public function add_fields_to_variable_product($loop, $variation_data, $variation)
	{
		$this->show_barcode_field($loop, $variation->ID);
	}

	public function process_product_meta($post_id)
	{
		if (!isset($_POST['pos_barcode'])) {
			return;
		}

		update_post_meta($post_id, 'pos_barcode', esc_attr($_POST['pos_barcode']));
	}

	public function save_product_variation($variation_id, $id)
	{
		$barcode = $_POST['pos_variation_barcode'][$id];
		if (isset($barcode)) {
			update_post_meta($variation_id, 'pos_variation_barcode', esc_attr($barcode));
		}
	}

	public function show_barcode_field($loop_id = null, $variation_id = null)
	{
		$barcode_field = array(
			'id' => $loop_id !== null ? 'pos_variation_barcode[' . $loop_id . ']' : 'pos_barcode',
			'label' => __('Barcode', 'point-of-sale-pos-woocommerce'),
			'description' => __(
				'The barcode refers to numbers and letters assigned to products as a means of identification by the POS using a barcode reader.',
				'point-of-sale-pos-woocommerce'
			),
			'desc_tip' => true,
		);

		if ($variation_id !== null) {
			$barcode_field['value'] = get_post_meta($variation_id, 'pos_variation_barcode', true);
			$barcode_field['style'] = 'width: 100%';
		}
		woocommerce_wp_text_input($barcode_field);
	}
}
