<?php

namespace ZPOS\Admin\Tabs\Users;

use ZPOS\Admin\Setting\CoreBox;
use ZPOS\Admin\Setting\Input\UserRights;

if (!function_exists('get_editable_roles')) {
	require_once ABSPATH . '/wp-admin/includes/user.php';
}

class Access extends CoreBox
{
	protected $label;

	private static $user_manage_rights = [
		'manage_woocommerce_pos',
		'delete_woocommerce_pos',
		'access_woocommerce_pos',
		'access_woocommerce_pos_addons',
		'read_woocommerce_pos_setting',
		'read_woocommerce_pos_categories',
		'read_woocommerce_pos_gateways',
		'read_private_products',
		'read_private_shop_orders',
		'publish_shop_orders',
		'list_users',
		'edit_product',
		'edit_published_products',
		'edit_others_products',
		'edit_users',
		'promote_users',
		'read_private_shop_coupons',
		'pay_for_order',
	];

	public function __construct($parent)
	{
		$this->label = __('User Access', 'point-of-sale-pos-woocommerce');

		parent::__construct(
			$parent,
			$this->label,
			null,
			new UserRights(null, 'pos_user_rights', [$this, 'getUserRights'])
		);
	}

	public function getUserRights()
	{
		return get_option('pos_user_rights');
	}

	public static function init($path)
	{
		register_setting('pos' . $path, 'pos_user_rights', [
			'sanitize_callback' => function ($data) {
				$user_roles = array_keys(\get_editable_roles());

				$data = array_filter(
					$data,
					function ($key) use ($user_roles) {
						return in_array($key, $user_roles);
					},
					ARRAY_FILTER_USE_KEY
				);

				foreach ($user_roles as $role) {
					if (!array_key_exists($role, $data)) {
						$data[$role] = [];
					}
				}

				$data = array_map(function ($role_right) {
					$role_right_default = static::get_default_value();
					$role_right = array_filter(
						$role_right,
						function ($key) {
							return in_array($key, static::$user_manage_rights);
						},
						ARRAY_FILTER_USE_KEY
					);
					$role_right = array_map('__return_true', $role_right);

					return array_merge($role_right_default, $role_right);
				}, $data);

				foreach ($data as $role => $role_rights) {
					$role = get_role($role);
					foreach ($role_rights as $role_right => $value) {
						if ($value) {
							$role->add_cap($role_right);
						} else {
							$role->remove_cap($role_right);
						}
					}
				}

				return false;
			},
		]);

		add_filter('pre_option_pos_user_rights', [static::class, 'get_value']);
	}

	public static function get_value()
	{
		$roles = array_keys(\get_editable_roles());

		$roles = array_combine(
			$roles,
			array_map(function ($role) {
				$role = get_role($role);

				$capabilities = $role->capabilities;
				$name = ucwords(str_replace('_', ' ', $role->name));
				$default = static::get_default_value();

				$capabilities = array_filter(
					$capabilities,
					function ($cap) {
						return in_array($cap, static::$user_manage_rights);
					},
					ARRAY_FILTER_USE_KEY
				);

				$capabilities = array_merge($default, $capabilities);

				return compact('capabilities', 'name');
			}, $roles)
		);

		return $roles;
	}

	public static function get_default_value()
	{
		return array_combine(
			static::$user_manage_rights,
			array_fill(0, count(static::$user_manage_rights), false)
		);
	}
}
