<?php

namespace ZPOS\API;

use WP_REST_Server;
use WC_REST_Products_Controller;
use ZPOS\Structure\AddDefaultImage;
use ZPOS\Structure\ProductIds;
use ZPOS\Structure\ProductResponse;
use const ZPOS\REST_NAMESPACE;

class Products extends WC_REST_Products_Controller
{
	use AddDefaultImage, ProductResponse, ProductIds;

	protected $namespace = REST_NAMESPACE;
	protected $rest_base = 'products';

	public function __construct()
	{
		parent::__construct();
		do_action(__METHOD__, $this, $this->namespace, $this->rest_base);
		add_filter(
			'woocommerce_rest_check_permissions',
			function ($permission, $context, $object_id, $post_type) {
				if (is_array($post_type)) {
					$permissions = array_map(function ($type) use ($context, $object_id) {
						return wc_rest_check_post_permissions($type, $context, $object_id);
					}, $post_type);

					$permission = array_reduce(
						$permissions,
						function ($a, $b) {
							return $a && $b;
						},
						true
					);
				}
				return $permission;
			},
			10,
			4
		);

		add_filter(
			"woocommerce_rest_prepare_{$this->post_type}_object",
			[$this, 'add_default_images'],
			1000
		);
	}

	public function get_collection_params()
	{
		$params = parent::get_collection_params();

		$params['orderby']['enum'][] = 'parent_id';

		return $params;
	}

	public function get_items($request)
	{
		$response = parent::get_items($request);

		$count_query = new \WP_Query();
		$count_query->query(['post_type' => ['product_variation', 'product']]);
		$total = $count_query->found_posts;

		$response->header('X-WP-Total-All', $total);

		return $response;
	}

	public function register_routes()
	{
		parent::register_routes();
		do_action(__METHOD__, $this, $this->namespace, $this->rest_base);
		register_rest_route($this->namespace, '/' . $this->rest_base . '/ids', [
			'methods' => WP_REST_Server::READABLE,
			'callback' => [$this, 'get_all_ids'],
			'permission_callback' => [$this, 'get_items_permissions_check'],
		]);
	}
}
