<?php

namespace ZPOS\API;

use WP_REST_Server, WC_REST_Controller;
use const ZPOS\REST_NAMESPACE;

class Groups extends WC_REST_Controller
{
	protected $namespace = REST_NAMESPACE;
	protected $rest_base = 'groups';

	public function __construct()
	{
		do_action(__METHOD__, $this, $this->namespace, $this->rest_base);
	}

	public function register_routes()
	{
		do_action(__METHOD__, $this, $this->namespace, $this->rest_base);
		register_rest_route($this->namespace, '/' . $this->rest_base . '/', array(
			'methods' => WP_REST_Server::READABLE,
			'callback' => array($this, 'get_all'),
		));
		register_rest_route($this->namespace, '/' . $this->rest_base . '/ids', array(
			'methods' => WP_REST_Server::READABLE,
			'callback' => array($this, 'get_all_ids'),
		));

		register_rest_route($this->namespace, '/' . $this->rest_base . '/(?P<id>[\d]+)', array(
			'methods' => WP_REST_Server::READABLE,
			'callback' => array($this, 'get_item'),
		));
	}

	public function get_all()
	{
		if (!class_exists('\ZAddons\Model\Group')) {
			return [];
		}
		$groups = \ZAddons\Model\Group::getAll();
		return array_map(function (\ZAddons\Model\Group $group) {
			return $group->getDataAPI();
		}, $groups);
	}

	public function get_all_ids()
	{
		if (!class_exists('\ZAddons\Model\Group')) {
			return [];
		}
		$groups = \ZAddons\Model\Group::getAll();
		return array_map(function (\ZAddons\Model\Group $group) {
			return $group->getID();
		}, $groups);
	}

	public function get_item($request)
	{
		$id = $request['id'];

		return \ZAddons\Model\Group::getByID($id)->getDataAPI();
	}
}
