<?php
/**                
 * Cron
 v2.0.0a
*/

// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) exit;

//*****************************
//v1.1.6.1 Refactored
//*****************************

class VTMIN_Cron {

	public function __construct() {

    add_filter( 'cron_schedules', array( &$this, 'vtmin_add_schedules'   ) ); 
     
    // https://wordpress.stackexchange.com/questions/179694/wp-schedule-event-every-day-at-specific-time
    
    //AS the CLASS is instantiated in the INIT hook, you can't use that hook or an earlier one here.
    // wp_loaded follows INIT but is still early enough to be useful!
		
    //v2.0.0.2  added the IF - once this is scheduled, no reason to do this again.
    if ( ! wp_next_scheduled( 'vtmin_twice_daily_scheduled_events' ) ) {
      add_action( 'wp_loaded', array( &$this, 'vtmin_schedule_events' ) );
    }
    
 
  //  add_action( 'init', array( &$this, 'vtmin_schedule_events' ) ); //does not work
  //  add_action( 'admin_init', array( &$this, 'vtmin_schedule_events' ) );  //WORKS, but only on the admin side
  //  add_action( 'wp', array( &$this, 'vtmin_schedule_events' ) ); //does not work
 
	}


	public function vtmin_add_schedules( $schedules = array() ) {
 //error_log( print_r(  'BEGIN vtmin_add_schedules' , true ) ); 	
  	// Adds to the existing schedules.
/* v2.0.0.2
		$schedules['vtmin_thrice_daily'] = array(
			'interval' => 28800,
			'display'  => __( 'Every Eight Hours', 'vtmin' )
		);
 */   
    //v1.1.6.1 added
		$schedules['vtmin_twice_daily'] = array(
			'interval' => 43200,
			'display'  => __( 'Every 12 Hours', 'vtmin' )
		);    
		return $schedules;
	}


	public function vtmin_schedule_events() {
 //error_log( print_r(  'BEGIN vtmin_schedule_events' , true ) ); 
	//	$this->vtmin_thrice_daily(); v2.0.0.2
		$this->vtmin_twice_daily();
 
	}


	private function vtmin_twice_daily() {
 //error_log( print_r(  'BEGIN vtmin_twice_daily' , true ) );
		//v1.1.6.1 added
    if ( ! wp_next_scheduled( 'vtmin_twice_daily_scheduled_events' ) ) {
			wp_schedule_event( current_time( 'timestamp' ), 'vtmin_twice_daily', 'vtmin_twice_daily_scheduled_events' );
 //error_log( print_r(  'Scheduled vtmin_twice_daily' , true ) );      
		}
	}  
   

}
$vtmin_cron = new VTMIN_Cron;

//cron job run out of license-options.php
// add_action( 'vtmin_thrice_daily_scheduled_events', 'vtmin_maybe_recheck_license_activation' );
