<?php
if ( !defined( 'ABSPATH' ) ) exit;

if ( !class_exists( 'grfwpReviewAsk' ) ) {
/**
 * Class to handle plugin review ask
 *
 * @since 1.2.3
 */
class grfwpReviewAsk {

	public function __construct() {
		add_action( 'admin_notices', array( $this, 'maybe_add_review_ask' ) );

		add_action( 'wp_ajax_grfwp_hide_review_ask', array( $this, 'hide_review_ask' ) );
		add_action( 'wp_ajax_grfwp_send_feedback', array( $this, 'send_feedback' ) );

		add_action( 'admin_enqueue_scripts', array( $this, 'enqueue_review_ask_scripts') );
	}

	public function maybe_add_review_ask() {
		$ask_review_time = get_option( 'grfwp-review-ask-time' );

		$install_time = get_option( 'grfwp-installation-time' );
		if ( ! $install_time ) { update_option( 'grfwp-installation-time', time() ); }

		$ask_review_time = $ask_review_time != '' ? $ask_review_time : $install_time + 3600*24*4;

		if ($ask_review_time < time() and $install_time != '' and $install_time < time() - 3600*24*4) {
			
			global $pagenow;

			if ( $pagenow != 'post.php' && $pagenow != 'post-new.php' ) { ?>
	
				<div class='notice notice-info is-dismissible grfwp-main-dashboard-review-ask' style='display:none'>
					<div class='grfwp-review-ask-plugin-icon'></div>
					<div class='grfwp-review-ask-text'>
						<p class='grfwp-review-ask-starting-text'>Enjoying using the Five-Star Restaurant Reviews?</p>
						<p class='grfwp-review-ask-feedback-text grfwp-hidden'>Help us make the plugin better! Please take a minute to rate the plugin. Thanks!</p>
						<p class='grfwp-review-ask-review-text grfwp-hidden'>Please let us know what we could do to make the plugin better!<br /><span>(If you would like a response, please include your email address.)</span></p>
						<p class='grfwp-review-ask-thank-you-text grfwp-hidden'>Thank you for taking the time to help us!</p>
					</div>
					<div class='grfwp-review-ask-actions'>
						<div class='grfwp-review-ask-action grfwp-review-ask-not-really grfwp-review-ask-white'>Not Really</div>
						<div class='grfwp-review-ask-action grfwp-review-ask-yes grfwp-review-ask-green'>Yes!</div>
						<div class='grfwp-review-ask-action grfwp-review-ask-no-thanks grfwp-review-ask-white grfwp-hidden'>No Thanks</div>
						<a href='https://wordpress.org/support/plugin/good-reviews-wp/reviews/' target='_blank'>
							<div class='grfwp-review-ask-action grfwp-review-ask-review grfwp-review-ask-green grfwp-hidden'>OK, Sure</div>
						</a>
					</div>
					<div class='grfwp-review-ask-feedback-form grfwp-hidden'>
						<div class='grfwp-review-ask-feedback-explanation'>
							<textarea></textarea>
							<br>
							<input type="email" name="feedback_email_address" placeholder="<?php _e('Email Address', 'good-reviews-wp'); ?>">
						</div>
						<div class='grfwp-review-ask-send-feedback grfwp-review-ask-action grfwp-review-ask-green'>Send Feedback</div>
					</div>
					<div class='grfwp-clear'></div>
				</div>

			<?php
			}
		}
		else {
			wp_dequeue_script( 'grfwp-review-ask-js' );
		}
	}

	public function enqueue_review_ask_scripts() {

		wp_enqueue_style( 'grfwp-review-ask-css', GRFWP_PLUGIN_URL . '/assets/css/dashboard-review-ask.css' );
		wp_enqueue_script( 'grfwp-review-ask-js', GRFWP_PLUGIN_URL . '/assets/js/dashboard-review-ask.js', array( 'jquery' ), GRFWP_VERSION, true  );

		wp_localize_script(
			'grfwp-review-ask-js',
			'grfwp_review_ask',
			array(
				'nonce' => wp_create_nonce( 'grfwp-review-ask-js' )
			)
		);
	}

	public function hide_review_ask() {

		// Authenticate request
		if ( ! check_ajax_referer( 'grfwp-review-ask-js', 'nonce' ) ) {
			
			grfwpHelper::admin_nopriv_ajax();
		}

		$ask_review_time = intval( $_POST['ask_review_time'] );

    	if ( get_option( 'grfwp-review-ask-time' ) < time() + 3600*24 * $ask_review_time ) {
    		update_option( 'grfwp-review-ask-time', time() + 3600*24 * $ask_review_time );
    	}

    	die();
	}

	public function send_feedback() {

		// Authenticate request
		if ( ! check_ajax_referer( 'grfwp-review-ask-js', 'nonce' ) ) {
			
			grfwpHelper::admin_nopriv_ajax();
		}

		$headers = 'Content-type: text/html;charset=utf-8' . "\r\n";  
	    $feedback = sanitize_text_field($_POST['feedback']);
 		$feedback .= '<br /><br />Email Address: ';
    	$feedback .= sanitize_text_field($_POST['email_address']);

    	wp_mail('contact@fivestarplugins.com', 'GRFWP Feedback - Dashboard Form', $feedback, $headers);

    	die();
	} 
}

}