<?php
if ( ! defined( 'ABSPATH' ) )
	exit;

if ( !class_exists( 'grfwpExportHandler' ) ) {
class grfwpExportHandler {

	/**
	 * Registered exports
	 *
	 * @since 2.1.0
	 */
	public $export_types;


	/**
	 * Initialize the class and register hooks
	 */
	public function __construct() {

		// Register available exports
		add_action( 'admin_init', array( $this, 'register_exports' ) );

		// Load an export file
		add_action( 'admin_init', array( $this, 'load_export' ) );

		// Load bookings page and assets
		add_action( 'manage_posts_extra_tablenav', array( $this, 'print_button' ), 10, 1 );

	}

	/**
	 * Register supported exports
	 *
	 * @since 2.1.0
	 * @todo implement a way to switch between types
	 */
	public function register_exports() {

		// Array of export types and the class which should be used
		// to generate them. All classes should extend contain a deliver method
		// @todo Excel
		$this->export_types = apply_filters(
			'grfwp_export_types',
			array(
				//'pdf'	=> array(
				//	'label'	=> __( 'PDF', 'good-reviews-wp' ),
				//	'class' => 'ebfrtbExportPDF',
				//),
				'csv'	=> array(
					'label'	=> __( 'Excel/CSV', 'good-reviews-wp' ),
					'class' => 'grfwpExportCSV',
				),
			)
		);

	}

	/**
	 * Load the requested export
	 *
	 * @since 2.1.0
	 */
	public function load_export() {
		global $grfwp_controller; 

		if ( ! isset( $_GET['grfwp_export'] ) ) {
			return;
		}

		if ( ! current_user_can( 'edit_posts' ) ) {
			wp_die( __( 'You do not have the required permissions to export reviews.', 'good-reviews-wp' ) );
		}

		if ( isset( $_GET['type'] ) && !empty( $this->export_types[ $_GET['type'] ] ) ) {

			$type = sanitize_text_field( $_GET['type'] );
			
			$export_class = $this->export_types[ $type ]['class'];
		}

		require_once( GRFWP_PLUGIN_DIR . '/includes/Export.CSV.class.php' );

		if ( !isset( $export_class ) || !class_exists( $export_class ) ) {
			wp_die( __( 'Unable to create export to match your request.', 'good-reviews-wp' ) );
		}

		$export = new $export_class();
		$export->deliver(); // calls wp_die()
	}

	/**
	 * Print the export button above and below the table
	 *
	 * @since 2.1.0
	 */
	public function print_button( $pos ) {
		global $current_screen;
		global $grfwp_controller;

		if ( $current_screen->post_type != GRFWP_REVIEW_POST_TYPE or ! current_user_can( 'edit_posts' ) ) { return; }
		
		?>

		<div class="alignleft actions grfwp-actions button grwfp-export-button">
			<span class="dashicons dashicons-media-spreadsheet"></span>
			<input type='hidden' name='grfwp_export_action' value='grfwp-export' />
			<input type='hidden' name='type' value='csv' />
			<input type='submit' name='grfwp_export' value='<?php esc_html_e( 'Export Reviews', 'good-reviews-wp' ); ?>' />
		</div>

		<?php
	}

}
} // endif;
