<?php
if ( ! defined( 'ABSPATH' ) ) exit;

if ( ! class_exists( 'grfwpBlocks' ) ) {
/**
 * Class to handle plugin Gutenberg blocks
 *
 * @since 2.0.0
 */
class grfwpBlocks {

	public function __construct() {

		add_action( 'init', array( $this, 'add_blocks' ) );
		
		add_filter( 'block_categories_all', array( $this, 'add_block_category' ) );
	}

	/**
	 * Add the Gutenberg block to the list of available blocks
	 * @since 2.0.0
	 */
	public function add_blocks() {

		if ( ! function_exists( 'render_block_core_block' ) ) { return; }

		$this->enqueue_assets();   

		$args = array(
            'attributes' => array(
                'review' => array(
                    'type' => 'string',
                ),
                'category' => array(
                    'type' => 'string',
                ),
                'random' => array(
                    'type' => 'string',
                ),
                'limit' => array(
                    'type' => 'string',
                ),
                'excerpt' => array(
                    'type' => 'string',
                ),
            ),
            'editor_script'   => 'fsp-grfwp-blocks-js',
            'editor_style'  => 'fsp-grfwp-blocks-css',
            'render_callback' => 'grfwp_reviews_shortcode',
		);

		register_block_type( 'good-reviews-wp/grfwp-display-reviews-block', $args );

		$args = array(
            'editor_script'   => 'fsp-grfwp-blocks-js',
            'editor_style'  => 'fsp-grfwp-blocks-css',
            'render_callback' => 'grfwp_submit_reviews_shortcode',
		);

		register_block_type( 'good-reviews-wp/grfwp-submit-review-block', $args );
	}

	/**
	 * Create a new category of blocks to hold our block
	 * @since 2.0.0
	 */
	public function add_block_category( $categories ) {
		
		$categories[] = array(
			'slug'  => 'grfwp-blocks',
			'title' => __( 'Five Star Restaurant Reviews', 'good-reviews-wp' ),
		);

		return $categories;
	}

	/**
	 * Register the necessary JS and CSS to display the block in the editor
	 * @since 2.0.0
	 */
	public function enqueue_assets() {

		wp_register_script( 'fsp-grfwp-blocks-js', GRFWP_PLUGIN_URL . '/assets/js/fsp-grfwp-blocks.js', array( 'wp-blocks', 'wp-element', 'wp-components', 'wp-editor' ), GRFWP_VERSION );
		wp_register_style( 'fsp-grfwp-blocks-css', GRFWP_PLUGIN_URL . '/assets/css/fsp-grfwp-blocks.css', array( 'wp-edit-blocks' ), GRFWP_VERSION );
	}
}

}