jQuery(document).ready(function($) {

	// Fetch and display additional reviews
	$( '#grfwp-pagination-load-more' ).on( 'click', function() {

		var next_page = $( this ).data( 'next_page' );

		var data = {
			next_page: next_page, 
			action: 'grfwp_ajax_load_reviews'
		};

		// Shortcode
		var shortcode_arg = {};
		Object
			.entries( grfwp_reviews_shortcode_args )
			.filter(arg => arg[1] && ('paged' != arg[0]))
			.map( x => {
				shortcode_arg = Object.assign( shortcode_arg, {[x[0]]: x[1]} );
			} );

		data = Object.assign( 
			data, 
			{shortcode_arg: shortcode_arg}
		);

		$.post(ajaxurl, data, function(response) {

			if (response.success) {
				
				$( '#grfwp-pagination-controls' ).before( response.data.output );

				if ( response.data.more_pages == false ) { $( '#grfwp-pagination-load-more' ).addClass( 'grfwp-hidden' ); }
				else { $( '#grfwp-pagination-load-more' ).data( 'next_page', next_page + 1 ); }
			}
		});
	});

	 
});