var el = wp.element.createElement,
	registerBlockType = wp.blocks.registerBlockType,
	ServerSideRender = wp.serverSideRender,
	TextControl = wp.components.TextControl,
	SelectControl = wp.components.SelectControl,
	InspectorControls = wp.blockEditor.InspectorControls;

registerBlockType( 'good-reviews-wp/grfwp-display-reviews-block', {
	title: 'Display Reviews',
	icon: 'star-empty',
	category: 'grfwp-blocks',
	attributes: {
		review: { type: 'string' },
		category: { type: 'string' },
		random: { type: 'string' },
		limit: { type: 'string' },
		excerpt: { type: 'string' },
	},

	edit: function( props ) {
		var returnString = [];
		returnString.push(
			el( InspectorControls, {},
				el( TextControl, {
					label: 'Review ID',
					value: props.attributes.review,
					onChange: ( value ) => { props.setAttributes( { review: value } ); },
				} ),
				el( TextControl, {
					label: 'Category Slug',
					value: props.attributes.category,
					onChange: ( value ) => { props.setAttributes( { category: value } ); },
				} ),
				el( SelectControl, {
					label: 'Random Review',
					value: props.attributes.random,
					options: [ {value: '0', label: 'No'}, {value: '1', label: 'Yes'} ],
					onChange: ( value ) => { props.setAttributes( { random: value } ); },
				} ),
				el( TextControl, {
					label: 'Number of Random Reviews',
					value: props.attributes.limit,
					onChange: ( value ) => { props.setAttributes( { limit: value } ); },
				} ),
				el( SelectControl, {
					label: 'Excerpt',
					value: props.attributes.excerpt,
					options: [ {value: '0', label: 'No'}, {value: '1', label: 'Yes'} ],
					onChange: ( value ) => { props.setAttributes( { excerpt: value } ); },
				} ),
			),
		);
		returnString.push( el( 'div', { class: 'grfwp-admin-block grfwp-admin-block-display-reviews' }, 'Display Reviews' ) );
		return returnString;
	},

	save: function() {
		return null;
	},
} );

registerBlockType( 'good-reviews-wp/grfwp-submit-review-block', {
	title: 'Submit Review',
	icon: 'star-empty',
	category: 'grfwp-blocks',
	attributes: {
	},

	edit: function( props ) {
		var returnString = [];
		returnString.push( el( 'div', { class: 'grfwp-admin-block grfwp-admin-block-submit-review' }, 'Submit Review' ) );
		return returnString;
	},

	save: function() {
		return null;
	},
} );


