<?php
/**
 * The template for displaying product content in the single-product.php template
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/content-single-product.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see     https://docs.woocommerce.com/document/template-structure/
 * @package WooCommerce/Templates
 * @version 3.4.0
 */

defined( 'ABSPATH' ) || exit;

if(get_option('fdoe_product_popup_content') == 'style-1' ){

	?>
<div id="product-<?php the_ID(); ?>" <?php wc_product_class($class = 'fdoe-single-product'); ?>>

	<?php
	do_action('fdoe-content-single-product-clean');
	?>
	<div class="summary entry-summary fdoe_summary_class">
		<?php

	do_action('fdoe-content-single-product-summary');


	?>
	</div>
	</div>
	<?php

}else{


?>
<div id="product-<?php the_ID(); ?>" <?php wc_product_class($class = 'fdoe-single-product'); ?>>

	<?php
		/**
		 * Hook: woocommerce_before_single_product_summary.
		 *
		 * @hooked woocommerce_show_product_sale_flash - 10
		 * @hooked woocommerce_show_product_images - 20
		 */
		do_action( 'woocommerce_before_single_product_summary' );
	?>

	<div class="summary entry-summary fdoe_summary_class">
		<?php
			/**
			 * Hook: woocommerce_single_product_summary.
			 *
			 * @hooked woocommerce_template_single_title - 5
			 * @hooked woocommerce_template_single_rating - 10
			 * @hooked woocommerce_template_single_price - 10
			 * @hooked woocommerce_template_single_excerpt - 20
			 * @hooked woocommerce_template_single_add_to_cart - 30
			 * @hooked woocommerce_template_single_meta - 40
			 * @hooked woocommerce_template_single_sharing - 50
			 * @hooked WC_Structured_Data::generate_product_data() - 60
			 */
			do_action( 'woocommerce_single_product_summary' );
	?>
	<span class="fdoe-product-image-wrapper">
	<?php
			do_action( 'woocommerce_single_product_summary_image_fdoe' );
		?>
		</span>
	<span class="fdoe-product-price-wrapper">
	<?php
			do_action( 'woocommerce_single_product_summary_price_fdoe' );
		?>
		</span>
	<span class="fdoe-product-add-wrapper">
	<?php
			do_action( 'woocommerce_single_product_summary_add_fdoe' );
		?>
		</span>
	</div>


</div>

<?php
}
//do_action( 'woocommerce_after_single_product_summary_2' );
//do_action( 'woocommerce_after_single_product' ); ?>
