<?php
if (!defined('ABSPATH')) {
    exit;
}
?> <table class="wc-shipping-classes widefat">
	<thead>
		<tr> <?php foreach ($settings_columns as $class => $heading): ?> <th class="<?php echo esc_attr($class); ?>"><?php echo esc_html($heading); ?></th> <?php
endforeach; ?> </tr>
	</thead>
	<tfoot>
		<tr>
			<td colspan="<?php echo absint(count($settings_columns)); ?>"> <a class="button button-secondary wc-shipping-class-add" href="#"><?php esc_html_e('Add location', 'fdoep'); ?></a> <input type="hidden" class="insert" id="fdoelocation" name="fdoe_pickup_locations" value=""> </td>
		</tr>
	</tfoot>
	<tbody class="wc-shipping-class-rows"></tbody>
</table>
<script type="text/html" id="tmpl-wc-shipping-class-row-blank">
	<tr>
		<td class="wc-shipping-classes-blank-state" colspan="1">
			<p><?php esc_html_e('No location have been created.', 'fdoep'); ?></p>
		</td>
	</tr>
</script>
<script type="text/html" id="tmpl-wc-shipping-class-row">
	<tr   data-id="{{ data.term_id }}"> 

    <?php
foreach ($settings_columns as $class => $heading) {
    echo '<td class="' . esc_attr($class) . '">';
    switch ($class) {
        case 'wc-shipping-class-title':
?> <div ><input required type="text" name="title[{{ data.term_id }}]" data-attribute="title" value="{{ data.title }}" placeholder="<?php esc_attr_e('Title', 'fdoep'); ?>" /></div> 
        
        <div class="row-actions"> <a href="#" class="wc-shipping-class-delete"><?php esc_html_e('Remove', 'fdoep'); ?></a> </div> <?php
        
        
        break;
        case 'wc-shipping-class-recipient':
?> <div ><input  type="email" name="email[{{ data.term_id }}]" data-attribute="email" value="{{ data.email }}"  /></div> 
        
        <?php
        
        
        break;case 'wc-shipping-class-address_1':
?> <div ><input required type="text" name="address_1[{{ data.term_id }}]" data-attribute="address_1" value="{{ data.address_1 }}" placeholder="<?php esc_attr_e('Address', 'fdoep'); ?>" /></div> 
        
        <?php
        
        
        break;
        case 'wc-shipping-class-city':
?> <div ><input required type="text" name="city[{{ data.term_id }}]" data-attribute="city" value="{{ data.city }}" placeholder="<?php esc_attr_e('City', 'fdoep'); ?>" /></div> <?php
        break;
      case 'wc-shipping-class-postcode':
?> <div ><input  type="text" name="postcode[{{ data.term_id }}]" data-attribute="postcode" value="{{ data.postcode }}" placeholder="<?php esc_attr_e('Postcode', 'fdoep'); ?>" /></div> <?php
        break;
  case 'wc-shipping-class-country':
?> <div><select required   name="country[{{ data.term_id }}]" data-attribute="country" value="{{ data.country }}" placeholder="<?php esc_attr_e('Country', 'fdoep'); ?>" >
<?php

WC()->countries->country_dropdown_options(); ?>

</select>
</div>


<?php
        
        break;  
    
   
    
    case 'wc-shipping-class-id':
?> <div class=""><p  name="id[{{ data.term_id }}]" data-attribute="id"  >{{ data.term_id }}</p></div> <?php
        break;
       
        default:
        break;
    }
    echo '</td>';
}
?>


	</tr>
</script>
