<?php


if ( ! defined( 'ABSPATH' ) ) {
	exit;
}
?>



<table class="wc-shipping-classes widefat">
	<thead>
		<tr>
			<?php foreach ( $settings_columns as $class => $heading ) : ?>
				<th class="<?php echo esc_attr( $class ); ?>"><?php echo esc_html( $heading ); ?></th>
			<?php endforeach; ?>
		</tr>
	</thead>
	<tfoot>
		<tr>
			<td colspan="<?php echo absint( count( $settings_columns ) ); ?>">

				<a class="button button-secondary wc-shipping-class-add" href="#"><?php esc_html_e( 'Add row', 'food-online-for-woocommerce' ); ?></a>

                <input type="hidden" class="insert"  id="fdoeava" name="fdoe_ava_schedule" value="" >
			</td>
		</tr>
	</tfoot>
	<tbody class="wc-shipping-class-rows"></tbody>
</table>

<script type="text/html" id="tmpl-wc-shipping-class-row-blank">
	<tr>
		<td class="wc-shipping-classes-blank-state" colspan="<?php echo absint( count( $settings_columns ) ); ?>"><p><?php esc_html_e( 'No schedules have been created.', 'food-online-for-woocommerce' ); ?></p></td>
	</tr>
</script>

<script type="text/html" id="tmpl-wc-shipping-class-row">
	<tr data-id="{{ data.term_id }}">
		<?php
		foreach ( $settings_columns as $class => $heading ) {
			echo '<td class="' . esc_attr( $class ) . '">';
			switch ( $class ) {

                case 'wc-shipping-class-time_from':
					?>

					<div class="edit"><input required type="time" name="time_from[{{ data.term_id }}]" data-attribute="time_from" value="{{ data.time_from }}" placeholder="<?php esc_attr_e( 'hh:mm', 'food-online-for-woocommerce' ); ?>" /></div>
					<?php
					break;
				case 'wc-shipping-class-time_to':
					?>

					<div class="edit"><input required type="time" name="time_to[{{ data.term_id }}]" data-attribute="time_to" value="{{ data.time_to }}" placeholder="<?php esc_attr_e( 'hh:mm', 'food-online-for-woocommerce' ); ?>" /></div>
					<?php
					break;
				 case 'wc-shipping-class-date':
					?>

					<div class="edit"><input  type="date" name="date[{{ data.term_id }}]" data-attribute="date" value="{{ data.date }}"  /></div>
					<?php
					break;
				case 'wc-shipping-class-mode':
					?>

					<div class="edit">
						<select multiple  class="wc-enhanced-select fdoe-multiple-select fdoe-ava-mode"  name="mode[{{ data.term_id }}]" data-attribute="mode" value="{{ data.mode }}"  >
                        <option  value="default"><?php esc_html_e( 'Default', 'food-online-for-woocommerce' ); ?></option>
						 <option disabled="disabled" value="pickup"><?php esc_html_e( 'Pickup', 'food-online-for-woocommerce' ); ?> (Premium)</option>
                         <option disabled="disabled" value="del"><?php esc_html_e( 'Delivery', 'food-online-for-woocommerce' ); ?> (Premium)</option>
						 <option disabled="disabled" value="eathere"><?php esc_html_e( 'Eat at Restaurant', 'food-online-for-woocommerce' ); ?> (Premium)</option>



                        </select>

					</div>
					<?php
					break;
				case 'wc-shipping-class-pickuplocation':
?> <select multiple class="wc-enhanced-select fdoe-multiple-select" name="pickuplocation[{{ data.term_id }}]" data-attribute="pickuplocation" value="{{ data.pickuplocation }}">
		</select> <?php
        break;

                case 'wc-shipping-class-application':
					?>

					<select  class="fdoe-ava-appli" name="application[{{ data.term_id }}]" data-attribute="application" value="{{ data.application }}" >
						<option value="placeorder"><?php esc_html_e( 'Place Order', 'food-online-for-woocommerce' ); ?></option>

						<option disabled="disabled" value="timepicker"><?php esc_html_e( 'Time Picker Slots', 'food-online-for-woocommerce' ); ?> (Premium)</option>
						<option disabled="disabled" value="dropdownselector"><?php esc_html_e( 'Dropdown Selector', 'food-online-for-woocommerce' ); ?> (Premium)</option>


					</select>
					<?php
					break;
                 case 'wc-shipping-class-cats':
					?>

					<select multiple  class="wc-enhanced-select fdoe-multiple-select" name="cats[{{ data.term_id }}]" data-attribute="cats" value="{{ data.cats }}" >
						<option  value="fdoeallcategories"><?php esc_html_e( 'All Categories', 'food-online-for-woocommerce' ); ?></option>


					</select>
					<?php
					break;
                 case 'wc-shipping-class-tags':
					?>

					<select multiple  class="wc-enhanced-select fdoe-multiple-select" name="tags[{{ data.term_id }}]" data-attribute="tags" value="{{ data.tags }}" >


					</select>
                    <div class="row-actions">
							<a href="#" class="wc-shipping-class-delete"><?php esc_html_e( 'Remove', 'food-online-for-woocommerce' ); ?></a>
						</div>
					<?php
					break;

				case 'wc-shipping-class-weekday':
					?>
					<select multiple  class="wc-enhanced-select fdoe-multiple-select" name="weekday[{{ data.term_id }}]" data-attribute="weekday" value="{{ data.weekday }}" >


	<option value="1" ><?php esc_html_e( 'Monday', 'food-online-for-woocommerce' ); ?></option>
	<option value="2"><?php esc_html_e( 'Tuesday', 'food-online-for-woocommerce' ); ?></option>
	<option value="3"><?php esc_html_e( 'Wednesday', 'food-online-for-woocommerce' ); ?></option>
	<option value="4"><?php esc_html_e( 'Thursday', 'food-online-for-woocommerce' ); ?></option>
	<option value="5"><?php esc_html_e( 'Friday', 'food-online-for-woocommerce' ); ?></option>
	<option value="6"><?php esc_html_e( 'Saturday', 'food-online-for-woocommerce' ); ?></option>
	<option value="0"><?php esc_html_e( 'Sunday', 'food-online-for-woocommerce' ); ?></option>
					</select>
					<?php
					break;
				default:

					break;
			}
			echo '</td>';
		}
		?>
	</tr>
</script>
