<?php

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

class Food_Online_Shortcode2 {

	protected static $_instance = null;

	protected $is_active = false;

	public static $categories_raw;

	public function __construct() {

		add_shortcode( 'foodonline2', array( $this, 'shortcode' ) );

	}

	public static function instance() {
		if ( is_null( self::$_instance ) ) {
			self::$_instance = new self();
		}

		return self::$_instance;
	}

public function shortcode( $atts ) {

if ( ($this->is_active && get_option('fdoe_force_shortcode','no') == 'no') || is_admin() ) {
			return;
		}
		if (is_admin() || (is_user_logged_in() && !isset(WC()->session))) {
			return;
		}

		$this->is_active = true;

		$options = shortcode_atts( array(
			'categories'         => null,
			'tags'               => null,
			'orderby'               => null,
			'order'               => null,
			'ids'               => null,


		), $atts );
		$pp  = 999;
		$l = 'limit='.$pp;
		$args = array(
			'status' => 'publish',
			'limit' => $pp,

					  );


		$args += empty($options['ids']) ? [] : ['include' => explode(",", $options['ids']) ]  ;
		$args += empty($options['order']) ? ['order' => 'ASC'] : ['order' => $options['order'] ];
		$args += empty($options['tags']) ? []: ['tag' => explode(",", $options['ids']) ] ;


		if(wc_clean($options['orderby']) == 'price'){

		$args += [ 'orderby' => 'meta_value_num'];
		$args += [ 'meta_key' => '_price'];
		}else{
			$args += empty($options['orderby'])  ? ['orderby' => 'menu_order' ] :  ['orderby' => $options['orderby'] ];
		}

$cats = empty($options['categories']) ? false : true ;
		$cats_array = [];
		$cats_array_slug = [];
		if(class_exists('Food_Online_Del') && get_option('fdoe_menu_by_mode','no') == 'yes'){

			$cats_array = Food_Online_Del::get_cats_by_mode();
			if(!empty($cats_array)){
			self::set_category_objects($cats_array);
			$cats2 = self::get_category_objects();
					$cats_array_slug = array_column($cats2,'slug');

			$args += empty($cats_array) ? [] : ['category' =>  $cats_array_slug ] ;
			}else{
				self::set_category_objects();
				$args +=  ['limit' =>  1 ] ;
			}


		}
			else if($cats){
		$pieces = explode(",", $options['categories']);

		foreach ($pieces as $piece ){

			$category = get_term_by( 'name', $piece, 'product_cat' );
			if($category !== false){
			$cat_id = $category->term_id;
			$cats_array[] = $cat_id;
			$cats_array_slug[] = $category->slug;
			}else{
				$piece = str_replace(' ', '', $piece);
				$category = get_term_by( 'slug', $piece, 'product_cat' );
				$cat_id = $category->term_id;
			$cats_array[] = $cat_id;
			$cats_array_slug[] = $category->slug;
			}

		}
	$cats_array = empty($cats_array) ? false : $cats_array;
self::set_category_objects($cats_array);
$args += empty($cats_array) ? [] : ['category' =>  $cats_array_slug ] ;
		}else{

				self::set_category_objects();
		}

		$locs = array(
					  'cats' => self::get_category_objects(),
					  );

		wp_localize_script( 'fdoe-order', 'fdoe_short', $locs );



        $products = wc_get_products( $args );



		ob_start();
do_action('fdoe_loop_start');
$fdoe_color= get_option('fdoe_color','inherit');
$menu_color = $fdoe_color == '' ? 'inherit' : $fdoe_color ;
$fdoe_color_back = get_option('fdoe_color_back','inherit');
$menu_color_back = $fdoe_color_back == '' ? 'inherit' : $fdoe_color_back  ;

$fdoe_border_color = get_option('fdoe_border_color','#ddd');
$menu_border_color = $fdoe_border_color == '' ? '#ddd' : $fdoe_border_color  ;
$display_top_cat_menu = get_option('fdoe_cat_top_menu','no') == 'yes' ? 'flex' : 'none';
$show_right = get_option('fdoe_hide_minicart', 'no') == 'yes' &&
										(get_option('fdoe_enable_delivery_switcher','no') == 'no' ||
										(get_option('fdoe_enable_delivery_switcher','no') != 'no' && get_option('fdoe_top_bar','no') == 'yes') ||
										get_option('fdoe_enable_delivery_switcher','no') == 'only_pickup' ||
										get_option('fdoe_is_prem', 'no') == 'no'
										) ? false :true;
$left_container_classes_index_right = !$show_right ? 0 :-3;
$left_container_classes_index_left = get_option('fdoe_left_menu', 'no') == 'yes' ? -2 :0;
$class_index = 12 + $left_container_classes_index_right + $left_container_classes_index_left;



$original_link = wc_get_checkout_url();


?>

<style>
.woocommerce-pagination {
	display: none;
}

.woocommerce-result-count {
	display: none;
}

#the_menu,
#menu_headings,
div.fdoe-item:hover {
	background-color: <?php echo $menu_color_back;
	?>;
}

#the_menu .fdoe-item {
	border-right-color: <?php echo $menu_border_color;
	?>;
	border-bottom-color: <?php echo $menu_border_color;
	?>;
}

#the_main_container h5 {
	margin-top: 1rem;
	margin-bottom: 1rem;
	margin-left: .2rem;
	margin-right: .2rem;
}

#menu_headings {
	display: <?php echo $display_top_cat_menu;
	?>;
}
.fdoe-dropdown-icon {
	color: <?php echo $menu_color
	?>;

}

</style>

<!-- Main container of the Menu -->

<?php


echo '<div class="container-fluid fdoe_main_container" id="the_main_container">
	  <div class="arorow" id="fdoe-menu-wrapper">
		<div class="arocol-xs-12 arocol-sm-12 arocol-lg-12">

			<div class="arorow fdoe-flex-1">
			<div id="fdoe-top-element"></div>
			';
			do_action( 'fdoe_loop_start_2');
			if(get_option('fdoe_left_menu', 'no')== 'yes'){

				echo '<div class="hidden-xs arocol-sm-2 fdoe-less-gut" id="fdoe-left-left-container">';
				if(get_option('fdoe_loading_overlay','no') == 'yes'){
					echo fdoe_output_leftbar_pre();
					}
					$is_sticky = get_option('fdoe_sticky_bar','no') == 'yes' ? 'fdoe-sticky' : '';

					echo '<div class="'.$is_sticky.'" id="menu_headings_2">
						<h4 class="Category_heading">';
						echo __( 'Menu', 'fdoep' );
						echo '</h4>
					</div>
				</div>';
				}

				echo '<div class="arocol-xs-12 arocol-sm-'. $class_index . ' arocol-lg-'. $class_index .' fdoe-less-gut" id="fdoe-left-container">';
				if(get_option('fdoe_loading_overlay','no') == 'yes'){
					echo fdoe_get_menu_pre();
					}

					echo '<div class="fdoe">
							<div class="fdoe-products flex-container-column" id="the_menu">';

								if( get_option( 'fdoe_cat_top_menu_mobile','yes') == 'collapsed' ){
									$is_top = get_option('fdoe_cat_top_menu','no') !== 'yes' ? 'hidden-sm hidden-md hidden-lg' : '';
 echo '<nav class="navbar navbar-default fdoe-top-sticky fdoe-sticky-mobile '. $is_top .'">
	<div class="navbar-header fdoe-nav-header hidden-sm hidden-md hidden-lg">
	<span class="arocollapsed fdoe-collapse-button" data-toggle="arocollapse" data-target="#fdoe_products_id" aria-expanded="false">

	    <span class="fdoe-dropdown-title" >';
		echo __( 'Menu', 'fdoep' ) ;
		echo '</span> <i class="fdoe-dropdown-icon fas fa-caret-down fa-3x"></i> </span>
	</div>
	<div class="fdoe_menu_header arocollapse navbar-arocollapse" id="fdoe_products_id">
		<ul class="navbar-nav nav nav-tabs fdoe-menu-2" id="menu_headings">
		 <li id="fdoemenuNext" ><i class="fas fa-2x fa-chevron-circle-right"></i></li>
  <li id="fdoemenuPrev" ><i class="fas fa-2x fa-chevron-circle-left"></i></li>
              
		</ul>
	</div>
</nav>';

							 }else{

								echo '<div id="fdoe_products_id" class="fdoe_menu_header fdoe-top-sticky fdoe-sticky-mobile">
								<ul class="nav nav-tabs fdoe-menu-2  " id="menu_headings">
								 <li id="fdoemenuNext" ><i class="fas fa-2x fa-chevron-circle-right"></i></li>
         <li id="fdoemenuPrev" ><i class="fas fa-2x fa-chevron-circle-left"></i></li>
              
								</ul>
								</div>';

				 }



				echo	'</div></div></div>
				<div class="fdoe_extra_checkout" style="display:none">';

				if(!$show_right && get_option('fdoe_top_bar','no') == 'no') {
		do_action('fdoe_loop_end_3');
	}
				echo '<a href="' . esc_url( $original_link ) . '" class="button checkout from_menu" id="checkout_button_1">' . esc_html__( 'Go to Checkout', 'fdoep' ) . '</a></div>';
				if ($show_right){
					do_action('fdoe_output_rightbar');
					if(get_option('fdoe_loading_overlay','no') == 'yes'){
						echo fdoe_output_rightbar_pre();
						}
					}
		echo '</div>
		</div>
	</div>
</div>';

$content = ob_get_clean();
$the_products = array();

do_action('fdoe_before_foodonline2_loop');
foreach($products as $i){

    $the_products[] =  Food_Online_Product2::the_product($i);
}

?>

<script>

	// Collect the products into a javascript array

	var Food_Online_Items = <?php echo json_encode(array(
                                                         'products' => $the_products,
                                                         ),JSON_HEX_QUOT | JSON_HEX_TAG) ?>;



</script>

<?php

do_action('fdoe_loop_end_2');









		return ($content);
	}

public static function set_category_objects($cats_array = false) {
			if (!isset(self::$categories_raw)) {


				$taxonomy       = 'product_cat';
				$orderby        = 'include';//'name';
				$show_count     = 0; // 1 for yes, 0 for no
				$pad_counts     = 0; // 1 for yes, 0 for no
				$hierarchical   = 1; // 1 for yes, 0 for no
				$title          = '';
				$empty          = 0;
				$fields         = 'all';
				$includes = $cats_array;
				$args           = array(
					'taxonomy'                => $taxonomy,
				
					'show_count'                => $show_count,
					'pad_counts'                => $pad_counts,
					'hierarchical'                => $hierarchical,
					'title_li'                => $title,
					'hide_empty'                => $empty,
					'fields'                => $fields,
				
				);
				
				 if($cats_array == false){
               $args['menu_order'] = 'asc';
            }else{
                $args['orderby'] = $orderby;
                 $args['include'] = $includes;
            }
				self::$categories_raw = get_categories($args);


				$do_image = ( get_option('fdoe_cat_image', 'no') == 'yes') ? true : false;
					$i = 1;
					foreach (self::$categories_raw as $fdoe_cat) {
						$fdoe_cat->sortIndex    = $i;
						$i++;
						$fdoe_cat->id = $fdoe_cat->cat_ID;
						$term_children  = get_term_children(filter_var($fdoe_cat->term_id, FILTER_VALIDATE_INT) , filter_var('product_cat', FILTER_SANITIZE_STRING));
						$parent_count       = 0;
						$fdoe_cat->image    = false;

						$has_sub        = true;
						if (empty($term_children) || is_wp_error($term_children)) {
							$has_sub        = false;

						}else{
							foreach ($term_children as $child_cat) {
								$child = get_term($child_cat, 'product_cat');
							$parent_count       = $parent_count + $child ->count;

						}

						}
						$fdoe_cat->category_count_not_children = $fdoe_cat->category_count - $parent_count ;
						$fdoe_cat->has_sub         = $has_sub;

						if ($do_image){
							$thumbnail_id   = get_term_meta($fdoe_cat->term_id, 'thumbnail_id', true);
						$image          = wp_get_attachment_url($thumbnail_id);
						$fdoe_cat->image           = $image;
						}
					}

			}
			return;
		}
		// Return product categories
		public static function get_category_objects() {
			return self::$categories_raw;
		}

}
